/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.documentation.CornerAwareScrollPaneLayout;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.DocumentationActionProvider;
import com.intellij.codeInsight.documentation.DocumentationComponentListener;
import com.intellij.codeInsight.documentation.DocumentationHintEditorPane;
import com.intellij.codeInsight.documentation.DocumentationLinkHandler;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationScrollPane;
import com.intellij.codeInsight.documentation.FontSizeMouseWheelListener;
import com.intellij.codeInsight.documentation.PopupDragListener;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.documentation.ToggleShowDocsOnHoverAction;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.ide.actions.WindowAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ide.DocumentationUtil;
import com.intellij.lang.documentation.impl.DocumentationRequest;
import com.intellij.lang.documentation.impl.ImplKt;
import com.intellij.lang.documentation.psi.PsiElementDocumentationTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationComponent
extends JPanel
implements Disposable,
DataProvider,
WidthBasedLayout {
    private static final Logger LOG = Logger.getInstance(DocumentationComponent.class);
    static final DataProvider HELP_DATA_PROVIDER = dataId -> PlatformCoreDataKeys.HELP_ID.is(dataId) ? "reference.toolWindows.Documentation" : null;
    public static final ColorKey COLOR_KEY = EditorColors.DOCUMENTATION_COLOR;
    public static final Color SECTION_COLOR = Gray.get((int)144);
    private static final int PREFERRED_HEIGHT_MAX_EM = 10;
    static final JBDimension MIN_DEFAULT = new JBDimension(300, 36);
    static final JBDimension MAX_DEFAULT = new JBDimension(950, 500);
    private final ExternalDocAction myExternalDocAction;
    private DocumentationManager myManager;
    private SmartPsiElementPointer<PsiElement> myElement;
    private long myModificationCount;
    private static final String QUICK_DOC_FONT_SIZE_V1_PROPERTY = "quick.doc.font.size";
    private static final String QUICK_DOC_FONT_SIZE_V2_PROPERTY = "quick.doc.font.size.v2";
    private static final String QUICK_DOC_FONT_SIZE_V3_PROPERTY = "quick.doc.font.size.v3";
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private final List<? extends AnAction> myNavigationActions;
    private final ActionToolbarImpl myToolBar;
    private volatile boolean myIsEmpty;
    private boolean mySizeTrackerRegistered;
    private String myExternalUrl;
    private DocumentationProvider myProvider;
    private Reference<Component> myReferenceComponent;
    private Runnable myToolwindowCallback;
    private final ActionButton myCorner;
    private final JScrollPane myScrollPane;
    private final DocumentationHintEditorPane myEditorPane;
    private final JComponent myControlPanel;
    private boolean myControlPanelVisible;
    private final DocumentationLinkHandler myLinkHandler;
    private final boolean myStoreSize;
    private boolean myManuallyResized;
    private AbstractPopup myHint;

    @Deprecated
    @NotNull
    public static JComponent createAndFetch(@NotNull Project project, @NotNull PsiElement element2, @NotNull Disposable disposable2) {
        if (project == null) {
            DocumentationComponent.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DocumentationComponent.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            DocumentationComponent.$$$reportNull$$$0(2);
        }
        if (QuickDocUtil.isDocumentationV2Enabled() && Registry.is((String)"documentation.v2.component")) {
            DocumentationRequest request2;
            try (AccessToken ignored = SlowOperations.allowSlowOperations((String)"old API fallback");){
                request2 = ImplKt.documentationRequest(new PsiElementDocumentationTarget(project, element2));
            }
            JComponent jComponent = DocumentationUtil.documentationComponent(project, request2, disposable2);
            if (jComponent == null) {
                DocumentationComponent.$$$reportNull$$$0(3);
            }
            return jComponent;
        }
        DocumentationManager manager2 = DocumentationManager.getInstance(project);
        DocumentationComponent component2 = new DocumentationComponent(manager2);
        Disposer.register((Disposable)disposable2, (Disposable)component2);
        manager2.fetchDocInfo(element2, component2);
        DocumentationComponent documentationComponent = component2;
        if (documentationComponent == null) {
            DocumentationComponent.$$$reportNull$$$0(4);
        }
        return documentationComponent;
    }

    public DocumentationComponent(DocumentationManager manager2) {
        this(manager2, true);
    }

    /*
     * WARNING - void declaration
     */
    public DocumentationComponent(DocumentationManager manager2, boolean storeSize) {
        void var9_13;
        this.myManager = manager2;
        this.myIsEmpty = true;
        this.myStoreSize = storeSize;
        this.myScrollPane = new DocumentationScrollPane();
        this.myEditorPane = new DocumentationHintEditorPane(manager2.getProject(), DocumentationScrollPane.keyboardActions(this.myScrollPane), this::getElementImage);
        this.myScrollPane.setViewportView(this.myEditorPane);
        this.myScrollPane.addMouseWheelListener(new FontSizeMouseWheelListener(this.myEditorPane::applyFontProps));
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        BackAction back = new BackAction();
        ForwardAction forward = new ForwardAction();
        EditDocumentationSourceAction edit = new EditDocumentationSourceAction();
        this.myNavigationActions = List.of(back, forward, edit);
        final ArrayList<? extends AnAction> navigationAndAdditionalActions = new ArrayList<AnAction>(this.myNavigationActions);
        DocumentationActionProvider[] documentationActionProviderArray = (DocumentationActionProvider[])DocumentationActionProvider.EP_NAME.getExtensions();
        int n = documentationActionProviderArray.length;
        boolean bl = false;
        while (var9_13 < n) {
            DocumentationActionProvider provider2 = documentationActionProviderArray[var9_13];
            navigationAndAdditionalActions.addAll(provider2.additionalActions(this));
            ++var9_13;
        }
        try {
            String backKey = ScreenReader.isActive() ? "alt LEFT" : "LEFT";
            CustomShortcutSet backShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)backKey), KeymapUtil.parseMouseShortcut((String)"button4")});
            String string = ScreenReader.isActive() ? "alt RIGHT" : "RIGHT";
            CustomShortcutSet forwardShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)string), KeymapUtil.parseMouseShortcut((String)"button5")});
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this);
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this.myEditorPane);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this.myEditorPane);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        this.myExternalDocAction = new ExternalDocAction();
        this.myExternalDocAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"UP"}), this);
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        edit.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        PopupHandler popupHandler2 = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu contextMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("JavadocToolbar", (ActionGroup)new DefaultActionGroup(navigationAndAdditionalActions), new MenuItemPresentationFactory(true));
                contextMenu.getComponent().show(comp, x, y);
            }
        };
        this.myEditorPane.addMouseListener((MouseListener)popupHandler2);
        Disposer.register((Disposable)this, () -> this.myEditorPane.removeMouseListener((MouseListener)popupHandler2));
        this.myLinkHandler = DocumentationLinkHandler.createAndRegister(this.myEditorPane, this, href -> manager2.navigateByLink(this, null, (String)href));
        for (AnAction anAction2 : this.myLinkHandler.createLinkActions()) {
            anAction2.registerCustomShortcutSet((JComponent)this, (Disposable)this);
        }
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.addAll(navigationAndAdditionalActions);
        toolbarActions.addAction((AnAction)new ShowAsToolwindowAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ToggleShowDocsOnHoverAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new MyShowSettingsAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ShowToolbarAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ShowPopupAutomaticallyAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new RestoreDefaultSizeAction()).setAsSecondary(true);
        this.myToolBar = new ActionToolbarImpl("JavadocToolbar", (ActionGroup)toolbarActions, true);
        this.myToolBar.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        this.myToolBar.setTargetComponent(this);
        JBLayeredPane jBLayeredPane = new JBLayeredPane(){

            public void doLayout() {
                Rectangle r = this.getBounds();
                for (Component component2 : this.getComponents()) {
                    if (component2 instanceof JScrollPane) {
                        component2.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    Dimension d = component2.getPreferredSize();
                    component2.setBounds(r.width - d.width - 2, r.height - d.height - 7, d.width, d.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension size = DocumentationComponent.this.myScrollPane.getPreferredSize();
                if (DocumentationComponent.this.myHint == null && DocumentationComponent.this.myManager != null && DocumentationComponent.this.myManager.myToolWindow == null) {
                    int em = DocumentationComponent.this.myEditorPane.getFont().getSize();
                    int prefHeightMax = 10 * em;
                    return new Dimension(size.width, Math.min(prefHeightMax, size.height + (DocumentationComponent.this.needsToolbar() ? DocumentationComponent.this.myControlPanel.getPreferredSize().height : 0)));
                }
                return size;
            }
        };
        jBLayeredPane.add(this.myScrollPane);
        jBLayeredPane.setLayer(this.myScrollPane, 0);
        MyGearActionGroup gearActions = new MyGearActionGroup(new AnAction[0]);
        ShowAsToolwindowAction showAsToolwindowAction = new ShowAsToolwindowAction();
        gearActions.add(showAsToolwindowAction);
        gearActions.add((AnAction)new ToggleShowDocsOnHoverAction());
        gearActions.add(new MyShowSettingsAction());
        gearActions.add((AnAction)new ShowToolbarAction());
        gearActions.add((AnAction)new ShowPopupAutomaticallyAction());
        gearActions.add(new RestoreDefaultSizeAction());
        gearActions.addSeparator();
        gearActions.addAll(navigationAndAdditionalActions);
        Presentation presentation2 = new Presentation();
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        this.myCorner = new ActionButton((AnAction)gearActions, presentation2, "unknown", new Dimension(20, 20)){

            @Override
            protected DataContext getDataContext() {
                return DataManager.getInstance().getDataContext((Component)DocumentationComponent.this.myCorner);
            }
        };
        this.myCorner.setNoIconsInPopup(true);
        this.myScrollPane.setLayout((LayoutManager)((Object)new CornerAwareScrollPaneLayout(this.myCorner)));
        showAsToolwindowAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc"), this.myCorner);
        jBLayeredPane.add(this.myCorner);
        jBLayeredPane.setLayer(this.myCorner, JLayeredPane.POPUP_LAYER);
        this.add((Component)jBLayeredPane, "Center");
        this.myControlPanel = this.myToolBar.getComponent();
        this.myControlPanel.setBorder(IdeBorderFactory.createBorder((Color)UIUtil.getTooltipSeparatorColor(), (int)8));
        this.myControlPanelVisible = false;
        if (this.myHint != null) {
            Disposer.register((Disposable)this.myHint, (Disposable)this);
        } else if (this.myManager.myToolWindow != null) {
            Disposer.register((Disposable)this.myManager.myToolWindow.getContentManager(), (Disposable)this);
        }
        this.myEditorPane.putClientProperty("DataProvider", HELP_DATA_PROVIDER);
        this.myScrollPane.putClientProperty("DataProvider", HELP_DATA_PROVIDER);
        this.updateControlState();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.myEditorPane != null) {
            this.myEditorPane.setBackground(color);
        }
        if (this.myControlPanel != null) {
            this.myControlPanel.setBackground(color);
        }
    }

    public List<? extends AnAction> getNavigationActions() {
        return this.myNavigationActions;
    }

    public AnAction getFontSizeAction() {
        return new MyShowSettingsAction();
    }

    public void removeCornerMenu() {
        this.myCorner.setVisible(false);
    }

    public void setToolwindowCallback(Runnable callback2) {
        this.myToolwindowCallback = callback2;
    }

    public void showExternalDoc() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        this.myExternalDocAction.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext));
    }

    @Override
    public boolean requestFocusInWindow() {
        if (ScreenReader.isActive()) {
            return this.myEditorPane.requestFocusInWindow();
        }
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            if (ScreenReader.isActive()) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorPane, true);
            } else {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myScrollPane, true);
            }
        });
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DocumentationComponent.$$$reportNull$$$0(5);
        }
        if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.is(dataId)) {
            String selectedText = this.myEditorPane.getSelectedText();
            return selectedText == null ? null : selectedText.replace('\u00a0', ' ');
        }
        return null;
    }

    @NotNull
    public static FontSize getQuickDocFontSize() {
        FontSize v1 = DocumentationComponent.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V1_PROPERTY, true);
        FontSize v2 = DocumentationComponent.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V2_PROPERTY, true);
        FontSize v3 = DocumentationComponent.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V3_PROPERTY, false);
        if (v3 != null) {
            FontSize fontSize = v3;
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(6);
            }
            return fontSize;
        }
        if (v2 != null) {
            v3 = DocumentationComponent.migrateV2ToV3(v2);
            DocumentationComponent.setQuickDocFontSize(v3);
            FontSize fontSize = v3;
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(7);
            }
            return fontSize;
        }
        if (v1 != null) {
            v3 = DocumentationComponent.migrateV2ToV3(DocumentationComponent.migrateV1ToV2(v1));
            DocumentationComponent.setQuickDocFontSize(v3);
            FontSize fontSize = v3;
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(8);
            }
            return fontSize;
        }
        FontSize fontSize = FontSize.SMALL;
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(9);
        }
        return fontSize;
    }

    @NotNull
    private static FontSize migrateV1ToV2(@NotNull FontSize size) {
        if (size == null) {
            DocumentationComponent.$$$reportNull$$$0(10);
        }
        FontSize fontSize = size == FontSize.X_LARGE ? FontSize.XX_LARGE : (size == FontSize.LARGE ? FontSize.X_LARGE : size);
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(11);
        }
        return fontSize;
    }

    @NotNull
    private static FontSize migrateV2ToV3(@NotNull FontSize size) {
        if (size == null) {
            DocumentationComponent.$$$reportNull$$$0(12);
        }
        FontSize fontSize = size == FontSize.X_SMALL ? FontSize.XX_SMALL : (size == FontSize.SMALL ? FontSize.X_SMALL : size);
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(13);
        }
        return fontSize;
    }

    @Nullable
    private static FontSize readFontSizeFromSettings(@NotNull String propertyName, boolean unsetAfterReading) {
        String strValue;
        if (propertyName == null) {
            DocumentationComponent.$$$reportNull$$$0(14);
        }
        if ((strValue = PropertiesComponent.getInstance().getValue(propertyName)) != null) {
            if (unsetAfterReading) {
                PropertiesComponent.getInstance().unsetValue(propertyName);
            }
            try {
                return FontSize.valueOf((String)strValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(15);
        }
        PropertiesComponent.getInstance().setValue(QUICK_DOC_FONT_SIZE_V3_PROPERTY, fontSize.toString());
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible() {
        if (this.myControlPanelVisible) {
            return;
        }
        this.add((Component)this.myControlPanel, "North");
        this.myControlPanelVisible = true;
    }

    public void setHint(JBPopup hint) {
        this.myHint = (AbstractPopup)hint;
        PopupDragListener.dragPopupByComponent(hint, this.myControlPanel);
        this.myEditorPane.setHint(hint);
    }

    public JBPopup getHint() {
        return this.myHint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    private void setElement(SmartPsiElementPointer<PsiElement> element2) {
        this.myElement = element2;
        this.myModificationCount = this.getCurrentModificationCount();
    }

    public boolean isUpToDate() {
        return this.getElement() != null && this.myModificationCount == this.getCurrentModificationCount();
    }

    private long getCurrentModificationCount() {
        return this.myElement != null ? PsiModificationTracker.SERVICE.getInstance((Project)this.myElement.getProject()).getModificationCount() : -1L;
    }

    public void setText(@NotNull @Nls String text2, @Nullable PsiElement element2, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(16);
        }
        this.setData(element2, text2, null, null, provider2);
    }

    public void replaceText(@NotNull @Nls String text2, @Nullable PsiElement element2) {
        PsiElement current2;
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(17);
        }
        if ((current2 = this.getElement()) == null || !current2.getManager().areElementsEquivalent(current2, element2)) {
            return;
        }
        this.restoreContext(this.saveContext().withText(text2));
    }

    public void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    private void pushHistory() {
        if (this.myElement != null) {
            this.myBackStack.push((Object)this.saveContext());
            this.myForwardStack.clear();
        }
    }

    public void setData(@Nullable PsiElement element2, @NotNull @Nls String text2, @Nullable String effectiveExternalUrl, @Nullable String ref, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(18);
        }
        this.pushHistory();
        this.myExternalUrl = effectiveExternalUrl;
        this.myProvider = provider2;
        SmartPsiElementPointer pointer = null;
        if (element2 != null && element2.isValid()) {
            pointer = SmartPointerManager.getInstance((Project)element2.getProject()).createSmartPsiElementPointer(element2);
        }
        this.setDataInternal((SmartPsiElementPointer<PsiElement>)pointer, text2, new Rectangle(0, 0), ref);
    }

    private void setDataInternal(@Nullable SmartPsiElementPointer<PsiElement> element2, @NotNull @Nls String text2, @NotNull Rectangle viewRect, @Nullable String ref) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(19);
        }
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(20);
        }
        this.myIsEmpty = false;
        if (this.myManager == null) {
            return;
        }
        this.myEditorPane.setText(text2);
        this.setElement(element2);
        if (element2 != null && element2.getElement() != null) {
            this.myManager.updateToolWindowTabName(element2.getElement());
        }
        this.showHint(viewRect, ref);
        if (this.myManager != null) {
            ((DocumentationComponentListener)this.myManager.getProject().getMessageBus().syncPublisher(DocumentationComponentListener.TOPIC)).onComponentDataChanged();
        }
    }

    protected void showHint(@NotNull Rectangle viewRect, @Nullable String ref) {
        Rectangle viewRectToUse;
        String refToUse;
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(21);
        }
        if ("$keepScrollingPosition$".equals(ref)) {
            refToUse = null;
            viewRectToUse = this.myScrollPane.getViewport().getViewRect();
        } else {
            refToUse = ref;
            viewRectToUse = viewRect;
        }
        this.updateControlState();
        this.myLinkHandler.highlightLink(-1);
        this.myEditorPane.applyFontProps(DocumentationComponent.getQuickDocFontSize());
        this.showHint();
        SwingUtilities.invokeLater(() -> {
            this.myEditorPane.scrollRectToVisible(viewRectToUse);
            if (refToUse != null) {
                UIUtil.scrollToReference((JEditorPane)this.myEditorPane, (String)refToUse);
            } else if (ScreenReader.isActive()) {
                this.myEditorPane.setCaretPosition(0);
            }
        });
    }

    protected void showHint() {
        if (this.myHint == null) {
            return;
        }
        this.setHintSize();
        DataContext dataContext = this.getDataContext();
        PopupPositionManager.positionPopupInBestPosition(this.myHint, this.myManager.getEditor(), dataContext, PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT);
        Window window = this.myHint.getPopupWindow();
        if (window != null) {
            window.setFocusableWindowState(true);
        }
        this.registerSizeTracker();
    }

    private DataContext getDataContext() {
        Component referenceComponent;
        if (this.myReferenceComponent == null) {
            referenceComponent = IdeFocusManager.getInstance((Project)this.myManager.myProject).getFocusOwner();
            this.myReferenceComponent = new WeakReference<Component>(referenceComponent);
        } else {
            referenceComponent = (Component)SoftReference.dereference(this.myReferenceComponent);
            if (referenceComponent == null || !referenceComponent.isShowing()) {
                referenceComponent = this.myHint.getComponent();
            }
        }
        return DataManager.getInstance().getDataContext(referenceComponent);
    }

    private void setHintSize() {
        Dimension hintSize = this.myManuallyResized ? DocumentationComponent.ensureMinimum(this.myHint.getContentSize()) : this.getDefaultHintSize();
        this.myHint.setSize(hintSize);
    }

    @NotNull
    private Dimension getDefaultHintSize() {
        if (this.myHint.getDimensionServiceKey() == null) {
            return this.getOptimalSize();
        }
        Dimension storedSize = DimensionService.getInstance().getSize("javadoc.popup.new", this.myManager.myProject);
        if (storedSize != null) {
            return DocumentationComponent.ensureMinimum(storedSize);
        }
        return new Dimension((Dimension)MIN_DEFAULT);
    }

    @NotNull
    private static Dimension ensureMinimum(@NotNull Dimension hintSize) {
        if (hintSize == null) {
            DocumentationComponent.$$$reportNull$$$0(22);
        }
        return new Dimension(Math.max(hintSize.width, DocumentationComponent.MIN_DEFAULT.width), Math.max(hintSize.height, DocumentationComponent.MIN_DEFAULT.height));
    }

    @NotNull
    private Dimension getOptimalSize() {
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight(width);
        return new Dimension(width, height);
    }

    public int getPreferredWidth() {
        int minWidth = JBUIScale.scale((int)300);
        int maxWidth = this.getPopupAnchor() != null ? JBUIScale.scale((int)435) : JBUIScale.scale((int)DocumentationComponent.MAX_DEFAULT.width);
        int width = this.myEditorPane.getPreferredWidth();
        Insets insets = this.getInsets();
        return MathUtil.clamp((int)width, (int)minWidth, (int)maxWidth) + insets.left + insets.right;
    }

    public int getPreferredHeight(int width) {
        this.myEditorPane.setBounds(0, 0, width, DocumentationComponent.MAX_DEFAULT.height);
        Dimension preferredSize = this.myEditorPane.getPreferredSize();
        int height = preferredSize.height + (this.needsToolbar() ? this.myControlPanel.getPreferredSize().height : 0);
        JScrollBar scrollBar = this.myScrollPane.getHorizontalScrollBar();
        int reservedForScrollBar = width < preferredSize.width && scrollBar.isOpaque() ? scrollBar.getPreferredSize().height : 0;
        Insets insets = this.getInsets();
        return MathUtil.clamp((int)height, (int)DocumentationComponent.MIN_DEFAULT.height, (int)DocumentationComponent.MAX_DEFAULT.height) + insets.top + insets.bottom + reservedForScrollBar;
    }

    private Component getPopupAnchor() {
        LookupEx lookup2;
        LookupEx lookupEx = lookup2 = this.myManager == null ? null : LookupManager.getActiveLookup(this.myManager.getEditor());
        if (lookup2 != null && lookup2.getCurrentItem() != null && lookup2.getComponent().isShowing()) {
            return lookup2.getComponent();
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null && popup2 != this.myHint && !popup2.isDisposed()) {
            return popup2.getContent();
        }
        return null;
    }

    private void registerSizeTracker() {
        AbstractPopup hint = this.myHint;
        if (hint == null || this.mySizeTrackerRegistered) {
            return;
        }
        this.mySizeTrackerRegistered = true;
        hint.addResizeListener(this::onManualResizing, this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                if (action2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (action2 instanceof WindowAction) {
                    DocumentationComponent.this.onManualResizing();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$4";
                objectArray[2] = "afterActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onManualResizing() {
        this.myManuallyResized = true;
        if (this.myStoreSize && this.myHint != null) {
            this.myHint.setDimensionServiceKey("javadoc.popup.new");
            this.myHint.storeDimensionSize();
        }
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context2 = (Context)this.myBackStack.pop();
        this.myForwardStack.push((Object)this.saveContext());
        this.restoreContext(context2);
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context2 = (Context)this.myForwardStack.pop();
        this.myBackStack.push((Object)this.saveContext());
        this.restoreContext(context2);
    }

    private Context saveContext() {
        Rectangle rect = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myEditorPane.getText(), this.myExternalUrl, this.myProvider, rect, this.myLinkHandler.getHighlightedLink());
    }

    private void restoreContext(@NotNull Context context2) {
        PsiElement element2;
        if (context2 == null) {
            DocumentationComponent.$$$reportNull$$$0(23);
        }
        this.myExternalUrl = context2.externalUrl;
        this.myProvider = context2.provider;
        this.setDataInternal(context2.element, context2.text, context2.viewRect, null);
        this.myLinkHandler.highlightLink(context2.highlightedLink);
        if (this.myManager != null && (element2 = context2.element.getElement()) != null) {
            this.myManager.updateToolWindowTabName(element2);
        }
    }

    private void updateControlState() {
        if (this.needsToolbar()) {
            this.myToolBar.updateActionsImmediately();
            this.setControlPanelVisible();
            this.removeCornerMenu();
        } else {
            this.myControlPanelVisible = false;
            this.remove(this.myControlPanel);
            if (this.myManager.myToolWindow != null) {
                return;
            }
            this.myCorner.setVisible(true);
        }
    }

    public boolean needsToolbar() {
        return this.myManager.myToolWindow == null && Registry.is((String)"documentation.show.toolbar");
    }

    @Nullable
    private Image getElementImage(@NotNull String imageSpec) {
        PsiElement element2;
        if (imageSpec == null) {
            DocumentationComponent.$$$reportNull$$$0(24);
        }
        return (element2 = this.getElement()) == null ? null : DocumentationManager.getElementImage(element2, imageSpec);
    }

    private static boolean isToolbar(@NotNull AnActionEvent e) {
        if (e == null) {
            DocumentationComponent.$$$reportNull$$$0(25);
        }
        return "JavadocToolbar".equals(e.getPlace());
    }

    private boolean hasExternalDoc() {
        boolean enabled = false;
        if (this.myElement != null && this.myProvider != null) {
            PsiElement element2 = this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element2);
            enabled = element2 != null && CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this.myProvider, (PsiElement)element2, (PsiElement)originalElement);
        }
        return enabled;
    }

    @Nls
    public String getText() {
        return this.myEditorPane.getText();
    }

    @Nls
    public String getDecoratedText() {
        return this.myEditorPane.getText();
    }

    public void dispose() {
        this.myEditorPane.getCaret().setVisible(false);
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontSize";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRect";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintSize";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndFetch";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocFontSize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateV1ToV2";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateV2ToV3";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndFetch";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "migrateV1ToV2";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "migrateV2ToV3";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readFontSizeFromSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setQuickDocFontSize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDataInternal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureMinimum";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "restoreContext";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getElementImage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class RestoreDefaultSizeAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        RestoreDefaultSizeAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.restore.size", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myHint != null && (DocumentationComponent.this.myManuallyResized || DocumentationComponent.this.myHint.getDimensionServiceKey() != null));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(1);
            }
            DocumentationComponent.this.myManuallyResized = false;
            if (DocumentationComponent.this.myStoreSize) {
                DimensionService.getInstance().setSize("javadoc.popup.new", null, DocumentationComponent.this.myManager.myProject);
                DocumentationComponent.this.myHint.setDimensionServiceKey(null);
            }
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$RestoreDefaultSizeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class ShowAsToolwindowAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ShowAsToolwindowAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.open.as.tool.window", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            if (DocumentationComponent.this.myManager == null) {
                presentation2.setEnabledAndVisible(false);
            } else {
                presentation2.setIcon(ToolWindowManager.getInstance((Project)DocumentationComponent.this.myManager.myProject).getLocationIcon("Documentation", EmptyIcon.ICON_16));
                presentation2.setEnabledAndVisible(DocumentationComponent.this.myToolwindowCallback != null);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(1);
            }
            DocumentationComponent.this.myToolwindowCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowAsToolwindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ShowPopupAutomaticallyAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        ShowPopupAutomaticallyAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.show.popup.automatically", (Object[])new Object[0]));
        }

        public void update(AnActionEvent e) {
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(project != null && LookupManager.getInstance(project).getActiveLookup() != null);
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowPopupAutomaticallyAction.$$$reportNull$$$0(0);
            }
            return CodeInsightSettings.getInstance().AUTO_POPUP_JAVADOC_INFO;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowPopupAutomaticallyAction.$$$reportNull$$$0(1);
            }
            CodeInsightSettings.getInstance().AUTO_POPUP_JAVADOC_INFO = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowPopupAutomaticallyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class ShowToolbarAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        ShowToolbarAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.show.toolbar", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(0);
            }
            return Registry.get((String)"documentation.show.toolbar").asBoolean();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(1);
            }
            Registry.get((String)"documentation.show.toolbar").setValue(state);
            DocumentationComponent.this.updateControlState();
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowToolbarAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyShowSettingsAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        MyShowSettingsAction() {
            super(CodeInsightBundle.message((String)"javadoc.adjust.font.size", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSettingsAction.$$$reportNull$$$0(0);
            }
            DocFontSizePopup.show((Component)DocumentationComponent.this, size -> {
                DocumentationComponent.this.myEditorPane.applyFontProps((FontSize)size);
                if (!DocumentationComponent.this.myManuallyResized && DocumentationComponent.this.myHint != null && DocumentationComponent.this.myHint.getDimensionServiceKey() == null) {
                    DocumentationComponent.this.showHint();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$MyShowSettingsAction", "actionPerformed"));
        }
    }

    private static class Context {
        final SmartPsiElementPointer<PsiElement> element;
        @Nls
        final String text;
        final String externalUrl;
        final DocumentationProvider provider;
        final Rectangle viewRect;
        final int highlightedLink;

        Context(SmartPsiElementPointer<PsiElement> element2, @Nls String text2, String externalUrl, DocumentationProvider provider2, Rectangle viewRect, int highlightedLink) {
            this.element = element2;
            this.text = text2;
            this.externalUrl = externalUrl;
            this.provider = provider2;
            this.viewRect = viewRect;
            this.highlightedLink = highlightedLink;
        }

        @NotNull
        Context withText(@NotNull @Nls String text2) {
            if (text2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            return new Context(this.element, text2, this.externalUrl, this.provider, this.viewRect, this.highlightedLink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/documentation/DocumentationComponent$Context", "withText"));
        }
    }

    private final class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ExternalDocAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.view.external", (Object[])new Object[0]), null, AllIcons.Actions.PreviousOccurence);
            this.setShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(0);
            }
            if (DocumentationComponent.this.myElement == null) {
                return;
            }
            PsiElement element2 = DocumentationComponent.this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element2);
            ExternalJavaDocAction.showExternalJavadoc(element2, originalElement, DocumentationComponent.this.myExternalUrl, e.getDataContext());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(DocumentationComponent.this.hasExternalDoc());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ExternalDocAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected final class EditDocumentationSourceAction
    extends BaseNavigateToSourceAction {
        private EditDocumentationSourceAction() {
            super(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer((String)"action.presentation.DocumentationComponent.text", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditDocumentationSourceAction.$$$reportNull$$$0(0);
            }
            super.actionPerformed(e);
            AbstractPopup hint = DocumentationComponent.this.myHint;
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        }

        @Override
        protected Navigatable @Nullable [] getNavigatables(DataContext dataContext) {
            SmartPsiElementPointer<PsiElement> element2 = DocumentationComponent.this.myElement;
            if (element2 != null) {
                Navigatable[] navigatableArray;
                PsiElement psiElement = element2.getElement();
                if (psiElement instanceof Navigatable) {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = (Navigatable)psiElement;
                } else {
                    navigatableArray = null;
                }
                return navigatableArray;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$EditDocumentationSourceAction", "actionPerformed"));
        }
    }

    protected class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ForwardAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.action.forward", (Object[])new Object[0]), AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goForward();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation2.setVisible(presentation2.isEnabled());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ForwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        BackAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.action.back", (Object[])new Object[0]), AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goBack();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation2.setVisible(presentation2.isEnabled());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$BackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGearActionGroup
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        MyGearActionGroup(AnAction ... actions2) {
            if (actions2 == null) {
                MyGearActionGroup.$$$reportNull$$$0(0);
            }
            super(actions2);
            this.setPopup(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/documentation/DocumentationComponent$MyGearActionGroup", "<init>"));
        }
    }
}

