/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationEditorPane;
import com.intellij.lang.documentation.DocumentationImageResolver;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DocumentationHintEditorPane
extends DocumentationEditorPane {
    private final Project myProject;
    private JBPopup myHint;
    private Point initialClick;

    public DocumentationHintEditorPane(@NotNull Project project, @NotNull Map<KeyStroke, ActionListener> keyboardActions, @NotNull DocumentationImageResolver imageResolver2) {
        if (project == null) {
            DocumentationHintEditorPane.$$$reportNull$$$0(0);
        }
        if (keyboardActions == null) {
            DocumentationHintEditorPane.$$$reportNull$$$0(1);
        }
        if (imageResolver2 == null) {
            DocumentationHintEditorPane.$$$reportNull$$$0(2);
        }
        super(keyboardActions, imageResolver2);
        this.myProject = project;
    }

    public void setHint(final @NotNull JBPopup hint) {
        if (hint == null) {
            DocumentationHintEditorPane.$$$reportNull$$$0(3);
        }
        this.myHint = hint;
        FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component previouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(DocumentationHintEditorPane.this.myProject);
                if (previouslyFocused != DocumentationHintEditorPane.this) {
                    hint.cancel();
                }
            }
        };
        this.addFocusListener(focusAdapter2);
        Disposer.register((Disposable)hint, () -> {
            this.myHint = null;
            this.removeFocusListener(focusAdapter2);
        });
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && this.myHint != null) {
            int y;
            int x;
            this.initialClick = null;
            StyledDocument document = (StyledDocument)this.getDocument();
            if (!(this.hasTextAt(document, x = e.getX(), y = e.getY()) || this.hasTextAt(document, x + 3, y) || this.hasTextAt(document, x - 3, y) || this.hasTextAt(document, x, y + 3) || this.hasTextAt(document, x, y - 3))) {
                this.initialClick = e.getPoint();
            }
        }
        super.processMouseEvent(e);
    }

    private boolean hasTextAt(StyledDocument document, int x, int y) {
        Element element2 = document.getCharacterElement(this.viewToModel(new Point(x, y)));
        try {
            String text2 = document.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
            if (StringUtil.isEmpty((String)text2.trim())) {
                return false;
            }
        }
        catch (BadLocationException ignored) {
            return false;
        }
        return true;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && this.myHint != null && this.initialClick != null) {
            Point location = this.myHint.getLocationOnScreen();
            this.myHint.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
            e.consume();
            return;
        }
        super.processMouseMotionEvent(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyboardActions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationHintEditorPane";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

