/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationActionProvider;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.documentation.render.DocRenderImageManager;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRendererMemoryManager;
import com.intellij.codeInsight.documentation.render.PsiCommentInlineDocumentation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.documentation.InlineDocumentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocRenderer
implements EditorCustomElementRenderer,
CustomFoldRegionRenderer {
    private static final Logger LOG = Logger.getInstance(DocRenderer.class);
    private static final Key<EditorPane> CACHED_LOADING_PANE = Key.create((String)"cached.loading.pane");
    private static final DocRendererMemoryManager MEMORY_MANAGER = new DocRendererMemoryManager();
    private static final DocRenderImageManager IMAGE_MANAGER = new DocRenderImageManager();
    private static final int MIN_WIDTH = 350;
    private static final int MAX_WIDTH = 680;
    private static final int LEFT_INSET = 14;
    private static final int RIGHT_INSET = 12;
    private static final int TOP_BOTTOM_INSETS = 2;
    private static final int TOP_BOTTOM_MARGINS = 4;
    private static final int LINE_WIDTH = 2;
    private static final int ARC_RADIUS = 5;
    private static StyleSheet ourCachedStyleSheet;
    private static String ourCachedStyleSheetLinkColor;
    final DocRenderItem myItem;
    private boolean myContentUpdateNeeded;
    private EditorPane myPane;
    private int myCachedWidth;
    private int myCachedHeight;

    DocRenderer(@NotNull DocRenderItem item) {
        if (item == null) {
            DocRenderer.$$$reportNull$$$0(0);
        }
        this.myCachedWidth = -1;
        this.myCachedHeight = -1;
        this.myItem = item;
    }

    private boolean useOldBackend() {
        return this.myItem.useOldBackend();
    }

    void update(boolean updateSize, boolean updateContent2, List<Runnable> foldingTasks) {
        if (this.useOldBackend()) {
            Inlay<DocRenderer> inlay = this.myItem.inlay;
            if (inlay != null) {
                if (updateSize) {
                    this.myCachedWidth = -1;
                    this.myCachedHeight = -1;
                }
                this.myContentUpdateNeeded = updateContent2;
                inlay.update();
            }
        } else {
            FoldRegion foldRegion = this.myItem.foldRegion;
            if (foldRegion instanceof CustomFoldRegion) {
                if (updateSize) {
                    this.myCachedWidth = -1;
                    this.myCachedHeight = -1;
                }
                this.myContentUpdateNeeded = updateContent2;
                Runnable task2 = () -> ((CustomFoldRegion)foldRegion).update();
                if (foldingTasks == null) {
                    task2.run();
                } else {
                    foldingTasks.add(task2);
                }
            }
        }
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(1);
        }
        return this.doCalcWidth(inlay.getEditor());
    }

    public int calcWidthInPixels(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(2);
        }
        return this.doCalcWidth(region.getEditor());
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(3);
        }
        return this.doCalcHeight(inlay.getEditor());
    }

    public int calcHeightInPixels(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(4);
        }
        return this.doCalcHeight(region.getEditor());
    }

    private int doCalcWidth(Editor editor2) {
        if (this.myCachedWidth < 0) {
            this.myCachedWidth = DocRenderer.calcWidth(editor2);
            return this.myCachedWidth;
        }
        return this.myCachedWidth;
    }

    private int doCalcHeight(Editor editor2) {
        if (this.myCachedHeight < 0) {
            int indent = 0;
            if (this.myItem.textToRender != null) {
                indent = this.calcInlayStartX() - editor2.getInsets().left;
            }
            int width = Math.max(0, DocRenderer.calcWidth(editor2) - indent - DocRenderer.scale(14) - DocRenderer.scale(12));
            EditorPane component2 = this.getRendererComponent(editor2, width);
            this.myCachedHeight = Math.max(editor2.getLineHeight(), ((JComponent)component2).getPreferredSize().height + DocRenderer.scale(2) * 2 + DocRenderer.scale(4) * 2);
            return this.myCachedHeight;
        }
        return this.myCachedHeight;
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(5);
        }
        if (g == null) {
            DocRenderer.$$$reportNull$$$0(6);
        }
        if (r == null) {
            DocRenderer.$$$reportNull$$$0(7);
        }
        if (textAttributes == null) {
            DocRenderer.$$$reportNull$$$0(8);
        }
        this.doPaint(inlay.getEditor(), g, r.x, r.y, r.width, r.height, textAttributes);
    }

    public void paint(@NotNull CustomFoldRegion region, @NotNull Graphics2D g, @NotNull Rectangle2D r, @NotNull TextAttributes textAttributes) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(9);
        }
        if (g == null) {
            DocRenderer.$$$reportNull$$$0(10);
        }
        if (r == null) {
            DocRenderer.$$$reportNull$$$0(11);
        }
        if (textAttributes == null) {
            DocRenderer.$$$reportNull$$$0(12);
        }
        this.doPaint(region.getEditor(), g, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight(), textAttributes);
    }

    private void doPaint(@NotNull Editor editor2, @NotNull Graphics g, int x, int y, int width, int height, @NotNull TextAttributes textAttributes) {
        Color bgColor;
        int endX;
        int startX;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(13);
        }
        if (g == null) {
            DocRenderer.$$$reportNull$$$0(14);
        }
        if (textAttributes == null) {
            DocRenderer.$$$reportNull$$$0(15);
        }
        if ((startX = this.calcInlayStartX()) >= (endX = x + width)) {
            return;
        }
        int margin = DocRenderer.scale(4);
        int filledHeight = height - margin * 2;
        if (filledHeight <= 0) {
            return;
        }
        int filledStartY = y + margin;
        Color defaultBgColor = ((EditorEx)editor2).getBackgroundColor();
        Color currentBgColor = textAttributes.getBackgroundColor();
        Color color = bgColor = currentBgColor == null ? defaultBgColor : ColorUtil.mix((Color)defaultBgColor, (Color)textAttributes.getBackgroundColor(), (double)0.5);
        if (currentBgColor != null) {
            g.setColor(bgColor);
            int arcDiameter = 10;
            if (endX - startX >= arcDiameter) {
                g.fillRect(startX, filledStartY, endX - startX - 5, filledHeight);
                Object savedHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillRoundRect(endX - arcDiameter, filledStartY, arcDiameter, filledHeight, arcDiameter, arcDiameter);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedHint);
            } else {
                g.fillRect(startX, filledStartY, endX - startX, filledHeight);
            }
        }
        g.setColor(editor2.getColorsScheme().getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE));
        g.fillRect(startX, filledStartY, DocRenderer.scale(2), filledHeight);
        int topBottomInset = DocRenderer.scale(2);
        int componentWidth = endX - startX - DocRenderer.scale(14) - DocRenderer.scale(12);
        int componentHeight = filledHeight - topBottomInset * 2;
        if (componentWidth > 0 && componentHeight > 0) {
            EditorPane component2 = this.getRendererComponent(editor2, componentWidth);
            component2.setBackground(bgColor);
            Graphics dg = g.create(startX + DocRenderer.scale(14), filledStartY + topBottomInset, componentWidth, componentHeight);
            UISettings.setupAntialiasing((Graphics)dg);
            ((JComponent)component2).paint(dg);
            dg.dispose();
        }
    }

    public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(16);
        }
        return this.doCalcGutterRenderer();
    }

    @Nullable
    public GutterIconRenderer calcGutterIconRenderer(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(17);
        }
        return this.doCalcGutterRenderer();
    }

    @Nullable
    private GutterIconRenderer doCalcGutterRenderer() {
        DocRenderItem.MyGutterIconRenderer myGutterIconRenderer;
        DocRenderItem.MyGutterIconRenderer highlighterIconRenderer = (DocRenderItem.MyGutterIconRenderer)this.myItem.highlighter.getGutterIconRenderer();
        if (highlighterIconRenderer == null) {
            myGutterIconRenderer = null;
        } else {
            DocRenderItem docRenderItem = this.myItem;
            Objects.requireNonNull(docRenderItem);
            myGutterIconRenderer = docRenderItem.new DocRenderItem.MyGutterIconRenderer(AllIcons.Gutter.JavadocEdit, highlighterIconRenderer.isIconVisible());
        }
        return myGutterIconRenderer;
    }

    public ActionGroup getContextMenuGroup(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(18);
        }
        return this.doGetContextMenu();
    }

    @Nullable
    public ActionGroup getContextMenuGroup(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(19);
        }
        return this.doGetContextMenu();
    }

    @NotNull
    private DefaultActionGroup doGetContextMenu() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new CopySelection());
        group2.addSeparator();
        group2.add(this.myItem.createToggleAction());
        AnAction toggleRenderAllAction = ActionManager.getInstance().getAction("ToggleRenderedDocPresentationForAll");
        if (toggleRenderAllAction != null) {
            group2.add(toggleRenderAllAction);
        }
        group2.add((AnAction)new DocRenderItem.ChangeFontSize());
        PsiDocCommentBase comment = this.getComment();
        for (DocumentationActionProvider provider2 : (DocumentationActionProvider[])DocumentationActionProvider.EP_NAME.getExtensions()) {
            provider2.additionalActions(this.myItem.editor, comment, this.myItem.textToRender).forEach(arg_0 -> ((DefaultActionGroup)group2).add(arg_0));
        }
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            DocRenderer.$$$reportNull$$$0(20);
        }
        return defaultActionGroup;
    }

    @Nullable
    private PsiDocCommentBase getComment() {
        InlineDocumentation documentation = this.myItem.getInlineDocumentation();
        return documentation instanceof PsiCommentInlineDocumentation ? ((PsiCommentInlineDocumentation)documentation).getComment() : null;
    }

    private static int scale(int value2) {
        return (int)((float)value2 * UISettings.getDefFontScale());
    }

    static int calcWidth(@NotNull Editor editor2) {
        int availableWidth;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(21);
        }
        if ((availableWidth = editor2.getScrollingModel().getVisibleArea().width) <= 0) {
            return 680;
        }
        return Math.max(DocRenderer.scale(350), Math.min(DocRenderer.scale(680), availableWidth));
    }

    private int calcInlayStartX() {
        Document document;
        int nextLineNumber;
        Editor editor2 = this.myItem.editor;
        RangeHighlighter highlighter = this.myItem.highlighter;
        if (highlighter.isValid() && (nextLineNumber = (document = editor2.getDocument()).getLineNumber(highlighter.getEndOffset()) + 1) < document.getLineCount()) {
            int lineStartOffset = document.getLineStartOffset(nextLineNumber);
            int contentStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getImmutableCharSequence(), (int)lineStartOffset, (String)" \t\n");
            return editor2.offsetToXY((int)contentStartOffset, (boolean)false, (boolean)true).x;
        }
        return editor2.getInsets().left;
    }

    Rectangle getEditorPaneBoundsWithinRenderer(int width, int height) {
        int relativeX = this.calcInlayStartX() - this.myItem.editor.getInsets().left + DocRenderer.scale(14);
        int relativeY = DocRenderer.scale(4) + DocRenderer.scale(2);
        return new Rectangle(relativeX, relativeY, width - relativeX - DocRenderer.scale(12), height - relativeY * 2);
    }

    EditorPane getRendererComponent(Editor editor2, int width) {
        boolean newInstance = false;
        EditorPane pane2 = this.myPane;
        if (pane2 == null || this.myContentUpdateNeeded) {
            this.myContentUpdateNeeded = false;
            this.clearCachedComponent();
            if (this.myItem.textToRender == null) {
                pane2 = this.getLoadingPane(editor2);
            } else {
                this.myPane = pane2 = this.createEditorPane(editor2, this.myItem.textToRender, false);
                newInstance = true;
            }
        }
        AppUIUtil.targetToDevice(pane2, editor2.getContentComponent());
        pane2.setSize(width, 10000000);
        if (newInstance) {
            pane2.getPreferredSize();
            pane2.startImageTracking();
        }
        return pane2;
    }

    private EditorPane getLoadingPane(@NotNull Editor editor2) {
        EditorPane pane2;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(22);
        }
        if ((pane2 = (EditorPane)editor2.getUserData(CACHED_LOADING_PANE)) == null) {
            pane2 = this.createEditorPane(editor2, CodeInsightBundle.message((String)"doc.render.loading.text", (Object[])new Object[0]), true);
            editor2.putUserData(CACHED_LOADING_PANE, (Object)pane2);
        }
        return pane2;
    }

    static void clearCachedLoadingPane(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(23);
        }
        editor2.putUserData(CACHED_LOADING_PANE, null);
    }

    private EditorPane createEditorPane(@NotNull Editor editor2, @Nls @NotNull String text2, boolean reusable) {
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            DocRenderer.$$$reportNull$$$0(25);
        }
        EditorPane pane2 = new EditorPane(!reusable);
        pane2.setEditable(false);
        pane2.getCaret().setSelectionVisible(!reusable);
        pane2.putClientProperty("caretWidth", 0);
        pane2.setEditorKit(DocRenderer.createEditorKit(editor2));
        pane2.setBorder((Border)JBUI.Borders.empty());
        HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
        fontAttributes.put(TextAttribute.SIZE, JBUIScale.scale((int)DocumentationComponent.getQuickDocFontSize().getSize()));
        fontAttributes.put(TextAttribute.KERNING, 0);
        pane2.setFont(pane2.getFont().deriveFont(fontAttributes));
        Color textColor = DocRenderer.getTextColor(editor2.getColorsScheme());
        pane2.setForeground(textColor);
        pane2.setSelectedTextColor(textColor);
        pane2.setSelectionColor(editor2.getSelectionModel().getTextAttributes().getBackgroundColor());
        UIUtil.enableEagerSoftWrapping((JTextComponent)pane2);
        pane2.setText(text2);
        pane2.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.activateLink(e);
            }
        });
        pane2.getDocument().putProperty("imageCache", IMAGE_MANAGER.getImageProvider());
        return pane2;
    }

    void clearCachedComponent() {
        if (this.myPane != null) {
            this.myPane.dispose();
            this.myPane = null;
        }
    }

    void dispose() {
        this.clearCachedComponent();
    }

    @NotNull
    private static Color getTextColor(@NotNull EditorColorsScheme scheme2) {
        TextAttributes attributes2;
        if (scheme2 == null) {
            DocRenderer.$$$reportNull$$$0(26);
        }
        Color color = (attributes2 = scheme2.getAttributes(DefaultLanguageHighlighterColors.DOC_COMMENT)) == null ? null : attributes2.getForegroundColor();
        Color color2 = color == null ? scheme2.getDefaultForeground() : color;
        if (color2 == null) {
            DocRenderer.$$$reportNull$$$0(27);
        }
        return color2;
    }

    private void activateLink(HyperlinkEvent event) {
        Element element2 = event.getSourceElement();
        if (element2 == null) {
            return;
        }
        Rectangle2D location = null;
        try {
            location = ((JEditorPane)event.getSource()).modelToView2D(element2.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (location == null) {
            return;
        }
        String url = event.getDescription();
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            this.activateLinkV2(url, location);
            return;
        }
        InlineDocumentation documentation = this.myItem.getInlineDocumentation();
        if (documentation == null) {
            return;
        }
        PsiElement context2 = ((PsiCommentInlineDocumentation)documentation).getContext();
        if (DocRenderer.isGotoDeclarationEvent()) {
            DocRenderer.navigateToDeclaration(context2, url);
        } else {
            this.showDocumentation(this.myItem.editor, context2, url, location);
        }
    }

    private void activateLinkV2(@NotNull String url, @NotNull Rectangle2D location) {
        Editor editor2;
        Project project;
        if (url == null) {
            DocRenderer.$$$reportNull$$$0(28);
        }
        if (location == null) {
            DocRenderer.$$$reportNull$$$0(29);
        }
        if ((project = (editor2 = this.myItem.editor).getProject()) == null) {
            return;
        }
        if (DocRenderer.isGotoDeclarationEvent()) {
            com.intellij.lang.documentation.ide.impl.DocumentationManager.instance(project).navigateInlineLink(url, (Function0<? extends InlineDocumentation>)((Function0)this.myItem::getInlineDocumentation));
        } else {
            com.intellij.lang.documentation.ide.impl.DocumentationManager.instance(project).activateInlineLink(url, (Function0<? extends InlineDocumentation>)((Function0)this.myItem::getInlineDocumentation), editor2, this.popupPosition(location));
        }
    }

    private static boolean isGotoDeclarationEvent() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return false;
        }
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        MouseShortcut mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)((MouseEvent)event));
        return keymapManager2.getActiveKeymap().getActionIds(mouseShortcut).contains("GotoDeclaration");
    }

    private static void navigateToDeclaration(@NotNull PsiElement context2, @NotNull String linkUrl) {
        PsiElement targetElement;
        if (context2 == null) {
            DocRenderer.$$$reportNull$$$0(30);
        }
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(31);
        }
        if ((targetElement = DocumentationManager.getInstance(context2.getProject()).getTargetElement(context2, linkUrl)) instanceof Navigatable) {
            ((Navigatable)targetElement).navigate(true);
        }
    }

    private void showDocumentation(@NotNull Editor editor2, @NotNull PsiElement context2, @NotNull String linkUrl, @NotNull Rectangle2D linkLocationWithinInlay) {
        DocumentationComponent component2;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(32);
        }
        if (context2 == null) {
            DocRenderer.$$$reportNull$$$0(33);
        }
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(34);
        }
        if (linkLocationWithinInlay == null) {
            DocRenderer.$$$reportNull$$$0(35);
        }
        if (DocRenderer.isExternalLink(linkUrl)) {
            BrowserUtil.open((String)linkUrl);
            return;
        }
        Project project = context2.getProject();
        DocumentationManager documentationManager = DocumentationManager.getInstance(project);
        if (QuickDocUtil.getActiveDocComponent(project) == null) {
            editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, (Object)this.popupPosition(linkLocationWithinInlay));
            documentationManager.showJavaDocInfo(editor2, context2, context2, () -> editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null), "", false, true);
        }
        if ((component2 = QuickDocUtil.getActiveDocComponent(project)) != null) {
            if (!documentationManager.hasActiveDockedDocWindow()) {
                component2.startWait();
            }
            documentationManager.navigateByLink(component2, context2, linkUrl);
        }
        if (documentationManager.getDocInfoHint() == null) {
            editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null);
        }
        if (documentationManager.hasActiveDockedDocWindow()) {
            final Disposable disposable2 = Disposer.newDisposable();
            editor2.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)disposable2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderer$1", "caretPositionChanged"));
                }
            }, disposable2);
            documentationManager.muteAutoUpdateTill(disposable2);
        }
    }

    @NotNull
    private Point popupPosition(@NotNull Rectangle2D linkLocationWithinInlay) {
        Rectangle relativeBounds;
        Point rendererPosition;
        if (linkLocationWithinInlay == null) {
            DocRenderer.$$$reportNull$$$0(36);
        }
        if (this.useOldBackend()) {
            Inlay<DocRenderer> inlay = this.myItem.inlay;
            rendererPosition = Objects.requireNonNull(inlay.getBounds()).getLocation();
            relativeBounds = this.getEditorPaneBoundsWithinRenderer(inlay.getWidthInPixels(), inlay.getHeightInPixels());
        } else {
            CustomFoldRegion foldRegion = (CustomFoldRegion)this.myItem.foldRegion;
            rendererPosition = Objects.requireNonNull(foldRegion.getLocation());
            relativeBounds = this.getEditorPaneBoundsWithinRenderer(foldRegion.getWidthInPixels(), foldRegion.getHeightInPixels());
        }
        return new Point(rendererPosition.x + relativeBounds.x + (int)linkLocationWithinInlay.getX(), rendererPosition.y + relativeBounds.y + (int)Math.ceil(linkLocationWithinInlay.getMaxY()));
    }

    private static boolean isExternalLink(@NotNull String linkUrl) {
        String l;
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(37);
        }
        return (l = linkUrl.toLowerCase(Locale.ROOT)).startsWith("http://") || l.startsWith("https://");
    }

    private static EditorKit createEditorKit(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(38);
        }
        MyEditorKit editorKit = new MyEditorKit(editor2);
        ((HTMLEditorKit)((Object)editorKit)).getStyleSheet().addStyleSheet(DocRenderer.getStyleSheet(editor2));
        return editorKit;
    }

    private static StyleSheet getStyleSheet(@NotNull Editor editor2) {
        String linkColorHex;
        EditorColorsScheme colorsScheme;
        Color linkColor;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(39);
        }
        if ((linkColor = (colorsScheme = editor2.getColorsScheme()).getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_LINK)) == null) {
            linkColor = DocRenderer.getTextColor(colorsScheme);
        }
        if (!Objects.equals(linkColorHex = ColorUtil.toHex((Color)linkColor), ourCachedStyleSheetLinkColor)) {
            String editorFontNamePlaceHolder = "_EditorFontNoLigatures_";
            ourCachedStyleSheet = StartupUiUtil.createStyleSheet((String)("body {overflow-wrap: anywhere}code {font-family: \"" + editorFontNamePlaceHolder + "\"}pre {font-family: \"" + editorFontNamePlaceHolder + "\";white-space: pre-wrap}h1, h2, h3, h4, h5, h6 {margin-top: 0; padding-top: 1}a {color: #" + linkColorHex + "; text-decoration: none}p {padding: 7 0 2 0}ol {padding: 0 20 0 0}ul {padding: 0 20 0 0}li {padding: 1 0 2 0}li p {padding-top: 0}table p {padding-bottom: 0}th {text-align: left}td {padding: 2 0 2 0}td p {padding-top: 0}.sections {border-spacing: 0}.section {padding-right: 5; white-space: nowrap}.content {padding: 2 0 2 0}"));
            ourCachedStyleSheetLinkColor = linkColorHex;
        }
        return ourCachedStyleSheet;
    }

    static {
        ourCachedStyleSheetLinkColor = "non-existing";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkUrl";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkLocationWithinInlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetContextMenu";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcHeightInPixels";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doPaint";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calcGutterIconRenderer";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroup";
                break;
            }
            case 20: 
            case 27: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calcWidth";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPane";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedLoadingPane";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditorPane";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTextColor";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "activateLinkV2";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDeclaration";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showDocumentation";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "popupPosition";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isExternalLink";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createEditorKit";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStyleSheet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopySelection
    extends DumbAwareAction {
        CopySelection() {
            super(CodeInsightBundle.messagePointer((String)"doc.render.copy.action.text", (Object[])new Object[0]), AllIcons.Actions.Copy);
            AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
            if (copyAction != null) {
                this.copyShortcutFrom(copyAction);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopySelection.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(DocRenderer.this.myPane != null && DocRenderer.this.myPane.hasSelection());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String text2;
            if (e == null) {
                CopySelection.$$$reportNull$$$0(1);
            }
            String string = text2 = DocRenderer.this.myPane == null ? null : DocRenderer.this.myPane.getSelectedText();
            if (!StringUtil.isEmpty((String)text2)) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer$CopySelection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyScalingImageView
    extends ImageView {
        private int myAvailableWidth;

        private MyScalingImageView(Element element2) {
            super(element2);
        }

        @Override
        public int getResizeWeight(int axis) {
            return 1;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        @Override
        public float getPreferredSpan(int axis) {
            float baseSpan = super.getPreferredSpan(axis);
            if (axis == 0) {
                return baseSpan;
            }
            int availableWidth = this.getAvailableWidth();
            if (availableWidth <= 0) {
                return baseSpan;
            }
            float baseXSpan = super.getPreferredSpan(0);
            if (baseXSpan <= 0.0f) {
                return baseSpan;
            }
            if ((float)availableWidth > baseXSpan) {
                availableWidth = (int)baseXSpan;
            }
            if (this.myAvailableWidth > 0 && availableWidth != this.myAvailableWidth) {
                this.preferenceChanged(null, false, true);
            }
            this.myAvailableWidth = availableWidth;
            return baseSpan * (float)availableWidth / baseXSpan;
        }

        private int getAvailableWidth() {
            View v = this;
            while (v != null) {
                View parent = v.getParent();
                if (parent instanceof FlowView) {
                    int childCount = parent.getViewCount();
                    for (int i2 = 0; i2 < childCount; ++i2) {
                        if (parent.getView(i2) != v) continue;
                        return ((FlowView)parent).getFlowSpan(i2);
                    }
                }
                v = parent;
            }
            return 0;
        }

        @Override
        public void paint(Graphics g, Shape a) {
            final Rectangle targetRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            Graphics2DDelegate scalingGraphics = new Graphics2DDelegate((Graphics2D)g){

                public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
                    int maxWidth = Math.max(0, targetRect.width - 2 * (x - targetRect.x));
                    int maxHeight = Math.max(0, targetRect.height - 2 * (y - targetRect.y));
                    if (width > maxWidth) {
                        height = height * maxWidth / width;
                        width = maxWidth;
                    }
                    if (height > maxHeight) {
                        width = width * maxHeight / height;
                        height = maxHeight;
                    }
                    return super.drawImage(img, x, y, width, height, observer);
                }
            };
            super.paint((Graphics)scalingGraphics, a);
        }
    }

    private static class MyViewFactory
    extends JBHtmlEditorKit.JBHtmlFactory {
        private static final MyViewFactory INSTANCE = new MyViewFactory();

        private MyViewFactory() {
        }

        public View create(Element elem) {
            View view = super.create(elem);
            return view instanceof ImageView ? new MyScalingImageView(elem) : view;
        }
    }

    private static class MyEditorKit
    extends JBHtmlEditorKit {
        private MyEditorKit(Editor editor2) {
            this.setFontResolver(EditorCssFontResolver.getInstance(editor2));
        }

        public ViewFactory getViewFactory() {
            return MyViewFactory.INSTANCE;
        }
    }

    class EditorPane
    extends JEditorPane {
        private final List<Image> myImages = new ArrayList<Image>();
        private final AtomicBoolean myUpdateScheduled = new AtomicBoolean();
        private final AtomicBoolean myRepaintScheduled = new AtomicBoolean();
        private final ImageObserver myImageObserver = new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 3) != 0) {
                    EditorPane.this.scheduleUpdate();
                    return false;
                }
                return true;
            }
        };
        private boolean myRepaintRequested;

        EditorPane(boolean trackMemory) {
            if (trackMemory) {
                MEMORY_MANAGER.register(DocRenderer.this, 50);
            }
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            this.myRepaintRequested = true;
        }

        void doWithRepaintTracking(Runnable task2) {
            this.myRepaintRequested = false;
            task2.run();
            if (this.myRepaintRequested) {
                this.repaintRenderer();
            }
        }

        private void repaintRenderer() {
            if (DocRenderer.this.useOldBackend()) {
                Inlay<DocRenderer> inlay = DocRenderer.this.myItem.inlay;
                if (inlay != null) {
                    inlay.repaint();
                }
            } else {
                FoldRegion foldRegion = DocRenderer.this.myItem.foldRegion;
                if (foldRegion instanceof CustomFoldRegion) {
                    ((CustomFoldRegion)foldRegion).repaint();
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            MEMORY_MANAGER.notifyPainted(DocRenderer.this);
            for (Image image : this.myImages) {
                IMAGE_MANAGER.notifyPainted(image);
            }
            super.paint(g);
        }

        Editor getEditor() {
            return DocRenderer.this.myItem.editor;
        }

        void removeSelection() {
            this.doWithRepaintTracking(() -> this.select(0, 0));
        }

        boolean hasSelection() {
            return this.getSelectionStart() != this.getSelectionEnd();
        }

        @Nullable
        Point getSelectionPositionInEditor() {
            Rectangle2D locationInPane;
            Rectangle boundsWithinRenderer;
            Point rendererLocation;
            if (DocRenderer.this.myPane != this) {
                return null;
            }
            if (DocRenderer.this.useOldBackend()) {
                Inlay<DocRenderer> inlay = DocRenderer.this.myItem.inlay;
                if (inlay == null || inlay.getRenderer() != DocRenderer.this) {
                    return null;
                }
                Rectangle bounds2 = inlay.getBounds();
                if (bounds2 == null) {
                    return null;
                }
                rendererLocation = bounds2.getLocation();
                boundsWithinRenderer = DocRenderer.this.getEditorPaneBoundsWithinRenderer(inlay.getWidthInPixels(), inlay.getHeightInPixels());
            } else {
                CustomFoldRegion foldRegion = (CustomFoldRegion)DocRenderer.this.myItem.foldRegion;
                if (foldRegion == null || foldRegion.getRenderer() != DocRenderer.this) {
                    return null;
                }
                rendererLocation = foldRegion.getLocation();
                if (rendererLocation == null) {
                    return null;
                }
                boundsWithinRenderer = DocRenderer.this.getEditorPaneBoundsWithinRenderer(foldRegion.getWidthInPixels(), foldRegion.getHeightInPixels());
            }
            try {
                locationInPane = this.modelToView2D(this.getSelectionStart());
            }
            catch (BadLocationException e) {
                LOG.error((Throwable)e);
                locationInPane = new Rectangle();
            }
            return new Point(rendererLocation.x + boundsWithinRenderer.x + (int)locationInPane.getX(), rendererLocation.y + boundsWithinRenderer.y + (int)locationInPane.getY());
        }

        private void scheduleUpdate() {
            if (this.myUpdateScheduled.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(() -> {
                    this.myRepaintScheduled.set(false);
                    this.myUpdateScheduled.set(false);
                    if (this == DocRenderer.this.myPane) {
                        if (DocRenderer.this.useOldBackend()) {
                            Inlay<DocRenderer> inlay = DocRenderer.this.myItem.inlay;
                            if (inlay != null) {
                                DocRenderItemUpdater.getInstance().updateInlays(Collections.singleton(inlay), false);
                            }
                        } else {
                            FoldRegion foldRegion = DocRenderer.this.myItem.foldRegion;
                            if (foldRegion instanceof CustomFoldRegion) {
                                DocRenderItemUpdater.getInstance().updateFoldRegions(Collections.singleton((CustomFoldRegion)foldRegion), false);
                            }
                        }
                    }
                });
            }
        }

        private void scheduleRepaint() {
            if (!this.myUpdateScheduled.get() && this.myRepaintScheduled.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(() -> {
                    this.myRepaintScheduled.set(false);
                    if (this == DocRenderer.this.myPane) {
                        this.repaintRenderer();
                    }
                });
            }
        }

        void startImageTracking() {
            this.collectImages(this.getUI().getRootView(this));
            boolean update2 = false;
            for (Image image : this.myImages) {
                IMAGE_MANAGER.setCompletionListener(image, this::scheduleRepaint);
                update2 |= image.getWidth(this.myImageObserver) >= 0 || image.getHeight(this.myImageObserver) >= 0;
            }
            if (update2) {
                this.myImageObserver.imageUpdate(null, 3, 0, 0, 0, 0);
            }
        }

        private void collectImages(View view) {
            Image image;
            if (view instanceof ImageView && (image = ((ImageView)view).getImage()) != null) {
                this.myImages.add(image);
            }
            int childCount = view.getViewCount();
            for (int i2 = 0; i2 < childCount; ++i2) {
                this.collectImages(view.getView(i2));
            }
        }

        void dispose() {
            MEMORY_MANAGER.unregister(DocRenderer.this);
            this.myImages.forEach(image -> IMAGE_MANAGER.dispose((Image)image));
        }
    }
}

