/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.FoldingData;
import com.intellij.codeInsight.editorActions.FoldingTransferableData;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPasteFoldingProcessor
extends CopyPastePostProcessor<FoldingTransferableData> {
    @Override
    @NotNull
    public List<FoldingTransferableData> collectTransferableData(PsiFile file2, Editor editor2, int[] startOffsets, int[] endOffsets) {
        FoldRegion[] regions;
        ArrayList<FoldingData> list2 = new ArrayList<FoldingData>();
        block0: for (FoldRegion region : regions = editor2.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid()) continue;
            int refOffset = 0;
            for (int j = 0; j < startOffsets.length; ++j) {
                refOffset += startOffsets[j];
                if (startOffsets[j] <= region.getStartOffset() && region.getEndOffset() <= endOffsets[j]) {
                    list2.add(new FoldingData(region.getStartOffset() - refOffset, region.getEndOffset() - refOffset, region.isExpanded(), region.getPlaceholderText()));
                    continue block0;
                }
                refOffset -= endOffsets[j] + 1;
            }
        }
        List<FoldingTransferableData> list3 = Collections.singletonList(new FoldingTransferableData(list2.toArray(new FoldingData[0])));
        if (list3 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(0);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<FoldingTransferableData> extractTransferableData(Transferable content2) {
        FoldingTransferableData foldingData = null;
        try {
            DataFlavor flavor = FoldingData.getDataFlavor();
            if (flavor != null) {
                foldingData = (FoldingTransferableData)content2.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        if (foldingData != null) {
            List<FoldingTransferableData> list2 = Collections.singletonList(foldingData.clone());
            if (list2 == null) {
                CopyPasteFoldingProcessor.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<FoldingTransferableData> list3 = Collections.emptyList();
        if (list3 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @Override
    public void processTransferableData(Project project, Editor editor2, RangeMarker bounds2, int caretOffset, Ref<? super Boolean> indented, List<? extends FoldingTransferableData> values2) {
        assert (values2.size() == 1);
        FoldingTransferableData value2 = values2.get(0);
        if (value2.getData().length == 0 || indented.get() != null) {
            return;
        }
        CodeFoldingManagerImpl foldingManager = (CodeFoldingManagerImpl)CodeFoldingManager.getInstance(project);
        if (foldingManager == null) {
            return;
        }
        Runnable operation = () -> {
            FoldingModel model2 = editor2.getFoldingModel();
            int docLength = editor2.getDocument().getTextLength();
            for (FoldingData data2 : value2.getData()) {
                FoldRegion region;
                int start2 = data2.startOffset + bounds2.getStartOffset();
                int end = data2.endOffset + bounds2.getStartOffset();
                if (start2 < 0 || end > docLength || start2 > end || (region = model2.addFoldRegion(start2, end, data2.placeholderText)) == null) continue;
                foldingManager.markForUpdate(region);
                region.setExpanded(data2.isExpanded);
            }
        };
        int verticalPositionBefore = editor2.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        editor2.getFoldingModel().runBatchFoldingOperation(operation);
        EditorUtil.runWithAnimationDisabled(editor2, () -> editor2.getScrollingModel().scrollVertically(verticalPositionBefore));
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project) {
        if (editor2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

