/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlGtTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile editedFile, @NotNull FileType fileType) {
        if (project == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(1);
        }
        if (editedFile == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(3);
        }
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (c == '>' && webEditorOptions != null && webEditorOptions.isAutomaticallyInsertClosingTag() && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element2;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            FileViewProvider provider2 = editedFile.getViewProvider();
            int offset = editor2.getCaretModel().getOffset();
            PsiElement elementAtCaret = null;
            if (offset < editor2.getDocument().getTextLength()) {
                PsiElement parent;
                IElementType tokenType;
                elementAtCaret = element2 = provider2.findElementAt(offset, XMLLanguage.class);
                if (element2 == null && offset > 0) {
                    elementAtCaret = element2 = provider2.findElementAt(offset - 1, XMLLanguage.class);
                }
                if (!(element2 instanceof PsiWhiteSpace)) {
                    boolean nonAcceptableDelimiter = true;
                    if (element2 instanceof XmlToken) {
                        tokenType = ((XmlToken)element2).getTokenType();
                        if (tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_END_TAG_START) {
                            PsiElement previousElement;
                            if (offset > 0 && (previousElement = provider2.findElementAt(offset - 1, XMLLanguage.class)) instanceof XmlToken) {
                                tokenType = ((XmlToken)previousElement).getTokenType();
                                element2 = previousElement;
                                nonAcceptableDelimiter = false;
                            }
                        } else if ((tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) && element2.getNextSibling() instanceof PsiErrorElement) {
                            nonAcceptableDelimiter = false;
                        }
                        if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && element2.getTextOffset() == offset - 1) {
                            EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
                            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
                            if (result2 == null) {
                                XmlGtTypedHandler.$$$reportNull$$$0(4);
                            }
                            return result2;
                        }
                    }
                    if (nonAcceptableDelimiter) {
                        TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                        if (result3 == null) {
                            XmlGtTypedHandler.$$$reportNull$$$0(5);
                        }
                        return result3;
                    }
                } else {
                    PsiElement previousElement = provider2.findElementAt(offset - 1, XMLLanguage.class);
                    if (previousElement instanceof XmlToken) {
                        tokenType = ((XmlToken)previousElement).getTokenType();
                        if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                            TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                            if (result4 == null) {
                                XmlGtTypedHandler.$$$reportNull$$$0(6);
                            }
                            return result4;
                        }
                        if (tokenType == XmlTokenType.XML_START_TAG_START) {
                            TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
                            if (result5 == null) {
                                XmlGtTypedHandler.$$$reportNull$$$0(7);
                            }
                            return result5;
                        }
                    }
                }
                if ((parent = element2.getParent()) instanceof XmlText) {
                    String text2 = parent.getText();
                    int index2 = offset - parent.getTextOffset() - 1;
                    if (index2 >= 0 && text2.charAt(index2) == '/') {
                        TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                        if (result6 == null) {
                            XmlGtTypedHandler.$$$reportNull$$$0(8);
                        }
                        return result6;
                    }
                    element2 = parent.getPrevSibling();
                } else if (parent instanceof XmlTag && !(element2.getPrevSibling() instanceof XmlTag) && !(element2.getPrevSibling() instanceof OuterLanguageElement)) {
                    element2 = parent;
                } else if (parent instanceof XmlAttributeValue) {
                    element2 = parent;
                }
            } else {
                element2 = provider2.findElementAt(editor2.getDocument().getTextLength() - 1, XMLLanguage.class);
                if (element2 == null) {
                    TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result7 == null) {
                        XmlGtTypedHandler.$$$reportNull$$$0(9);
                    }
                    return result7;
                }
                element2 = element2.getParent();
            }
            if (offset > 0 && offset <= editor2.getDocument().getTextLength() && editor2.getDocument().getCharsSequence().charAt(offset - 1) == '/') {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.CONTINUE;
                if (result8 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(10);
                }
                return result8;
            }
            if (element2 instanceof XmlAttributeValue) {
                element2 = element2.getParent().getParent();
            }
            while (element2 instanceof PsiWhiteSpace || element2 instanceof OuterLanguageElement) {
                element2 = element2.getPrevSibling();
            }
            if (element2 instanceof XmlDocument) {
                element2 = element2.getLastChild();
            }
            if (element2 == null) {
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.CONTINUE;
                if (result9 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(11);
                }
                return result9;
            }
            if (!(element2 instanceof XmlTag)) {
                if (element2 instanceof XmlTokenImpl && element2.getPrevSibling() != null && element2.getPrevSibling().getText().equals("<")) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)("</" + element2.getText() + ">"), (boolean)false, (int)0);
                }
                TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
                if (result10 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(12);
                }
                return result10;
            }
            XmlTag tag2 = (XmlTag)element2;
            if (XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_TAG_END) != null) {
                TypedHandlerDelegate.Result result11 = TypedHandlerDelegate.Result.CONTINUE;
                if (result11 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(13);
                }
                return result11;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                TypedHandlerDelegate.Result result12 = TypedHandlerDelegate.Result.CONTINUE;
                if (result12 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(14);
                }
                return result12;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                TypedHandlerDelegate.Result result13 = TypedHandlerDelegate.Result.CONTINUE;
                if (result13 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(15);
                }
                return result13;
            }
            String name2 = tag2.getName();
            if (elementAtCaret instanceof XmlToken && (((XmlToken)elementAtCaret).getTokenType() == XmlTokenType.XML_NAME || ((XmlToken)elementAtCaret).getTokenType() == XmlTokenType.XML_TAG_NAME)) {
                name2 = name2.substring(0, offset - elementAtCaret.getTextOffset());
            }
            if (tag2 instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag2, true)) {
                TypedHandlerDelegate.Result result14 = TypedHandlerDelegate.Result.CONTINUE;
                if (result14 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(16);
                }
                return result14;
            }
            if (name2.isEmpty()) {
                TypedHandlerDelegate.Result result15 = TypedHandlerDelegate.Result.CONTINUE;
                if (result15 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(17);
                }
                return result15;
            }
            int tagOffset = tag2.getTextRange().getStartOffset();
            XmlToken nameToken = XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_NAME);
            if (nameToken != null && nameToken.getTextRange().getStartOffset() > offset) {
                TypedHandlerDelegate.Result result16 = TypedHandlerDelegate.Result.CONTINUE;
                if (result16 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(18);
                }
                return result16;
            }
            HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(tagOffset);
            if (BraceMatchingUtil.matchBrace(editor2.getDocument().getCharsSequence(), fileType, iterator2, true, true)) {
                PsiElement parent = tag2.getParent();
                boolean hasBalance = true;
                block1: while (parent instanceof XmlTag) {
                    if (name2.equals(((XmlTag)parent).getName())) {
                        hasBalance = false;
                        ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(parent.getNode());
                        if (astNode == null) {
                            hasBalance = true;
                            break;
                        }
                        for (PsiElement el = parent.getNextSibling(); el != null; el = el.getNextSibling()) {
                            if (!(el instanceof PsiErrorElement) || !el.getText().startsWith("</" + name2)) continue;
                            hasBalance = true;
                            break block1;
                        }
                    }
                    parent = parent.getParent();
                }
                if (hasBalance) {
                    TypedHandlerDelegate.Result result17 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result17 == null) {
                        XmlGtTypedHandler.$$$reportNull$$$0(19);
                    }
                    return result17;
                }
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)("</" + name2 + ">"), (boolean)false, (int)0);
            TypedHandlerDelegate.Result result18 = this.insertTagContent(project, tag2, name2, editedFile, editor2);
            if (result18 == null) {
                XmlGtTypedHandler.$$$reportNull$$$0(20);
            }
            return result18;
        }
        TypedHandlerDelegate.Result result19 = TypedHandlerDelegate.Result.CONTINUE;
        if (result19 == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(21);
        }
        return result19;
    }

    @NotNull
    protected TypedHandlerDelegate.Result insertTagContent(@NotNull Project project, XmlTag tag2, String name2, PsiFile file2, @NotNull Editor editor2) {
        if (project == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(22);
        }
        if (editor2 == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(23);
        }
        TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
        if (result2 == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(24);
        }
        return result2;
    }

    public static boolean fileContainsXmlLanguage(@Nullable PsiFile editedFile) {
        if (editedFile == null) {
            return false;
        }
        if (editedFile.getLanguage() instanceof XMLLanguage) {
            return true;
        }
        if (HtmlUtil.supportsXmlTypedHandlers(editedFile)) {
            return true;
        }
        FileViewProvider provider2 = editedFile.getViewProvider();
        if (provider2.getBaseLanguage() instanceof XMLLanguage) {
            return true;
        }
        return provider2 instanceof TemplateLanguageFileViewProvider && ((TemplateLanguageFileViewProvider)provider2).getTemplateDataLanguage() instanceof XMLLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlGtTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlGtTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "insertTagContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insertTagContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

