/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterBetweenBracesDelegate {
    private static final Logger LOG = Logger.getInstance(EnterBetweenBracesDelegate.class);
    static final LanguageExtension<EnterBetweenBracesDelegate> EP_NAME = new LanguageExtension("com.intellij.enterBetweenBracesDelegate");

    public boolean bracesAreInTheSameElement(@NotNull PsiFile file2, @NotNull Editor editor2, int lBraceOffset, int rBraceOffset) {
        if (file2 == null) {
            EnterBetweenBracesDelegate.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterBetweenBracesDelegate.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor2.getDocument());
        return file2.findElementAt(lBraceOffset) == file2.findElementAt(rBraceOffset);
    }

    protected void formatAtOffset(@NotNull PsiFile file2, @NotNull Editor editor2, int offset, @Nullable Language language2) {
        if (file2 == null) {
            EnterBetweenBracesDelegate.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            EnterBetweenBracesDelegate.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor2.getDocument());
        try {
            CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent(file2, offset);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isInComment(@NotNull PsiFile file2, @NotNull Editor editor2, int offset) {
        if (file2 == null) {
            EnterBetweenBracesDelegate.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            EnterBetweenBracesDelegate.$$$reportNull$$$0(5);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiComment.class) != null;
    }

    protected boolean isBracePair(char lBrace, char rBrace) {
        return lBrace == '(' && rBrace == ')' || lBrace == '{' && rBrace == '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bracesAreInTheSameElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "formatAtOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

