/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DocumentFoldingInfo
implements CodeFoldingState {
    private static final Logger LOG = Logger.getInstance(DocumentFoldingInfo.class);
    private static final Key<FoldingInfo> FOLDING_INFO_KEY = Key.create((String)"FOLDING_INFO");
    @NotNull
    private final Project myProject;
    private final VirtualFile myFile;
    @NotNull
    private final List<Info> myInfos;
    @NotNull
    private final List<RangeMarker> myRangeMarkers;
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "ph";

    DocumentFoldingInfo(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(1);
        }
        this.myInfos = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
    }

    void loadFromEditor(@NotNull Editor editor2) {
        FoldRegion[] foldRegions;
        if (editor2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(!editor2.isDisposed());
        this.clear();
        for (FoldRegion region : foldRegions = editor2.getFoldingModel().getAllFoldRegions()) {
            boolean collapseByDefault;
            if (!region.isValid() || region.shouldNeverExpand()) continue;
            boolean expanded2 = region.isExpanded();
            String signature = (String)region.getUserData(UpdateFoldRegionsOperation.SIGNATURE);
            if (signature == "no signature") continue;
            Boolean storedCollapseByDefault = (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
            boolean bl = collapseByDefault = storedCollapseByDefault != null && storedCollapseByDefault != false && !FoldingUtil.caretInsideRange(editor2, TextRange.create((Segment)region));
            if (collapseByDefault != expanded2 && signature != null) continue;
            if (signature != null) {
                this.myInfos.add(new Info(signature, expanded2));
                continue;
            }
            RangeMarker marker = editor2.getDocument().createRangeMarker(region.getStartOffset(), region.getEndOffset());
            this.myRangeMarkers.add(marker);
            marker.putUserData(FOLDING_INFO_KEY, (Object)new FoldingInfo(region.getPlaceholderText(), expanded2));
        }
    }

    @Override
    public void setToEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.myFile);
        if (psiFile == null) {
            return;
        }
        Map<PsiElement, FoldingDescriptor> ranges = null;
        for (Info info2 : this.myInfos) {
            TextRange range2;
            FoldRegion region;
            FoldingDescriptor descriptor2;
            PsiElement element2 = FoldingPolicy.restoreBySignature(psiFile, info2.signature);
            if (element2 == null || !element2.isValid()) continue;
            if (ranges == null) {
                ranges = DocumentFoldingInfo.buildRanges(editor2, psiFile);
            }
            if ((descriptor2 = (FoldingDescriptor)ranges.get(element2)) == null || (region = FoldingUtil.findFoldRegion(editor2, (range2 = descriptor2.getRange()).getStartOffset(), range2.getEndOffset())) == null) continue;
            region.setExpanded(info2.expanded);
        }
        for (RangeMarker marker : this.myRangeMarkers) {
            if (!marker.isValid() || marker.getStartOffset() == marker.getEndOffset()) continue;
            FoldRegion region = FoldingUtil.findFoldRegion(editor2, marker.getStartOffset(), marker.getEndOffset());
            FoldingInfo info3 = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (region == null) {
                if (info3 != null) {
                    region = editor2.getFoldingModel().addFoldRegion(marker.getStartOffset(), marker.getEndOffset(), info3.placeHolder);
                }
                if (region == null) {
                    return;
                }
            }
            boolean state = info3 != null && info3.expanded;
            region.setExpanded(state);
        }
    }

    @NotNull
    private static Map<PsiElement, FoldingDescriptor> buildRanges(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (editor2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(5);
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        FileASTNode node2 = psiFile.getNode();
        if (node2 == null) {
            Map<PsiElement, FoldingDescriptor> map2 = Collections.emptyMap();
            if (map2 == null) {
                DocumentFoldingInfo.$$$reportNull$$$0(6);
            }
            return map2;
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiFile, (Document)editor2.getDocument(), (boolean)true);
        HashMap<PsiElement, FoldingDescriptor> ranges = new HashMap<PsiElement, FoldingDescriptor>();
        for (FoldingDescriptor descriptor2 : descriptors) {
            ASTNode ast = descriptor2.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges.put(psi, descriptor2);
        }
        HashMap<PsiElement, FoldingDescriptor> hashMap = ranges;
        if (hashMap == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    void clear() {
        this.myInfos.clear();
        for (RangeMarker marker : this.myRangeMarkers) {
            marker.dispose();
        }
        this.myRangeMarkers.clear();
    }

    void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(8);
        }
        if (this.myInfos.isEmpty() && this.myRangeMarkers.isEmpty()) {
            return;
        }
        for (Info info2 : this.myInfos) {
            Element e = new Element(ELEMENT_TAG);
            e.setAttribute(SIGNATURE_ATT, info2.signature);
            if (info2.expanded) {
                e.setAttribute(EXPANDED_ATT, Boolean.toString(true));
            }
            element2.addContent(e);
        }
        String date = null;
        for (RangeMarker marker : this.myRangeMarkers) {
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if (date.isEmpty()) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
            String signature = marker.getStartOffset() + ":" + marker.getEndOffset();
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = fi == null ? DEFAULT_PLACEHOLDER : fi.placeHolder;
            e.setAttribute(PLACEHOLDER_ATT, XmlStringUtil.escapeIllegalXmlChars((String)placeHolderText));
            element2.addContent(e);
        }
    }

    void readExternal(Element element2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.clear();
            if (!this.myFile.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
            if (document == null) {
                return;
            }
            String date = null;
            for (Element e : element2.getChildren()) {
                String signature = e.getAttributeValue(SIGNATURE_ATT);
                if (signature == null) continue;
                boolean expanded2 = Boolean.parseBoolean(e.getAttributeValue(EXPANDED_ATT));
                if (ELEMENT_TAG.equals(e.getName())) {
                    this.myInfos.add(new Info(signature, expanded2));
                    continue;
                }
                if (MARKER_TAG.equals(e.getName())) {
                    if (date == null) {
                        date = this.getTimeStamp();
                    }
                    if (date.isEmpty() || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(signature, ":");
                    try {
                        int start2 = Integer.valueOf(tokenizer.nextToken());
                        int end = Integer.valueOf(tokenizer.nextToken());
                        if (start2 < 0 || end >= document.getTextLength() || start2 > end) continue;
                        RangeMarker marker = document.createRangeMarker(start2, end);
                        this.myRangeMarkers.add(marker);
                        String placeholderAttributeValue = e.getAttributeValue(PLACEHOLDER_ATT);
                        String placeHolderText = placeholderAttributeValue == null ? DEFAULT_PLACEHOLDER : XmlStringUtil.unescapeIllegalXmlChars((String)placeholderAttributeValue);
                        FoldingInfo fi = new FoldingInfo(placeHolderText, expanded2);
                        marker.putUserData(FOLDING_INFO_KEY, (Object)fi);
                    }
                    catch (NoSuchElementException exc) {
                        LOG.error((Throwable)exc);
                    }
                    continue;
                }
                throw new IllegalStateException("unknown tag: " + e.getName());
            }
        });
    }

    private String getTimeStamp() {
        if (!this.myFile.isValid()) {
            return "";
        }
        return Long.toString(this.myFile.getTimeStamp());
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.myInfos.hashCode();
        result2 = 31 * result2 + this.myRangeMarkers.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFoldingInfo info2 = (DocumentFoldingInfo)o;
        if (this.myFile != null ? !this.myFile.equals(info2.myFile) : info2.myFile != null) {
            return false;
        }
        if (!this.myProject.equals(info2.myProject) || !this.myInfos.equals(info2.myInfos)) {
            return false;
        }
        if (this.myRangeMarkers.size() != info2.myRangeMarkers.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myRangeMarkers.size(); ++i2) {
            FoldingInfo ofi;
            RangeMarker other;
            RangeMarker marker = this.myRangeMarkers.get(i2);
            if (marker == (other = info2.myRangeMarkers.get(i2)) || !marker.isValid() || !other.isValid()) continue;
            if (!TextRange.areSegmentsEqual((Segment)marker, (Segment)other)) {
                return false;
            }
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (Comparing.equal((Object)fi, (Object)(ofi = (FoldingInfo)other.getUserData(FOLDING_INFO_KEY)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildRanges";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FoldingInfo {
        private final String placeHolder;
        private final boolean expanded;

        private FoldingInfo(@NotNull String placeHolder, boolean expanded2) {
            if (placeHolder == null) {
                FoldingInfo.$$$reportNull$$$0(0);
            }
            this.placeHolder = placeHolder;
            this.expanded = expanded2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FoldingInfo info2 = (FoldingInfo)o;
            return this.expanded == info2.expanded && this.placeHolder.equals(info2.placeHolder);
        }

        public int hashCode() {
            int result2 = this.placeHolder.hashCode();
            result2 = 31 * result2 + (this.expanded ? 1 : 0);
            return result2;
        }

        public boolean getExpanded() {
            return this.expanded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeHolder", "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo", "<init>"));
        }
    }

    private static class Info {
        private final String signature;
        private final boolean expanded;

        Info(@NotNull String signature, boolean expanded2) {
            if (signature == null) {
                Info.$$$reportNull$$$0(0);
            }
            this.signature = signature;
            this.expanded = expanded2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info2 = (Info)o;
            return this.expanded == info2.expanded && Objects.equals(this.signature, info2.signature);
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.expanded);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DocumentFoldingInfo.SIGNATURE_ATT, "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$Info", "<init>"));
        }
    }
}

