/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CodeBlockSupportHandler {
    public static final LanguageExtension<CodeBlockSupportHandler> EP = new LanguageExtension("com.intellij.codeBlockSupportHandler");

    @NotNull
    public List<TextRange> getCodeBlockMarkerRanges(@NotNull PsiElement var1);

    @NotNull
    public TextRange getCodeBlockRange(@NotNull PsiElement var1);

    @NotNull
    public static TextRange findCodeBlockRange(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        int offset;
        PsiElement contextElement;
        if (editor2 == null) {
            CodeBlockSupportHandler.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            CodeBlockSupportHandler.$$$reportNull$$$0(1);
        }
        if ((contextElement = psiFile.findElementAt(offset = TargetElementUtil.adjustOffset(psiFile, editor2.getDocument(), editor2.getCaretModel().getOffset()))) == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                CodeBlockSupportHandler.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = EP.allForLanguage(contextElement.getLanguage()).stream().map(handler2 -> handler2.getCodeBlockRange(contextElement)).filter(codeBlockRange -> !codeBlockRange.isEmpty()).findFirst().orElse(TextRange.EMPTY_RANGE);
        if (textRange == null) {
            CodeBlockSupportHandler.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public static List<TextRange> findMarkersRanges(@Nullable PsiElement markerPsiElement) {
        if (markerPsiElement == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                CodeBlockSupportHandler.$$$reportNull$$$0(4);
            }
            return list2;
        }
        for (CodeBlockSupportHandler handler2 : EP.allForLanguage(markerPsiElement.getLanguage())) {
            List<TextRange> rangesToHighlight = handler2.getCodeBlockMarkerRanges(markerPsiElement);
            if (rangesToHighlight.isEmpty()) continue;
            List<TextRange> list3 = rangesToHighlight;
            if (list3 == null) {
                CodeBlockSupportHandler.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List<TextRange> list4 = Collections.emptyList();
        if (list4 == null) {
            CodeBlockSupportHandler.$$$reportNull$$$0(6);
        }
        return list4;
    }

    @NotNull
    public static List<TextRange> findMarkersRanges(@Nullable PsiFile psiFile, @NotNull Language language2, int offset) {
        if (language2 == null) {
            CodeBlockSupportHandler.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                CodeBlockSupportHandler.$$$reportNull$$$0(8);
            }
            return list2;
        }
        return CodeBlockSupportHandler.findMarkersRanges(psiFile.getViewProvider().findElementAt(offset, language2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/CodeBlockSupportHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/CodeBlockSupportHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeBlockRange";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMarkersRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findCodeBlockRange";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMarkersRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

