/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ImplementationTextProcessor;
import com.intellij.codeInsight.hint.ImplementationTextSelectioner;
import com.intellij.codeInsight.hint.ImplementationViewDocumentFactory;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.LanguageImplementationTextProcessor;
import com.intellij.codeInsight.hint.LanguageImplementationTextSelectioner;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ToolbarLabelAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.list.LeftRightRenderer;
import com.intellij.usages.UsageView;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ImplementationViewComponent
extends JPanel {
    @NonNls
    private static final String TEXT_PAGE_KEY = "Text";
    @NonNls
    private static final String BINARY_PAGE_KEY = "Binary";
    private static final String IMPLEMENTATION_VIEW_PLACE = "ImplementationView";
    private final EditorFactory factory;
    private final Project project;
    private ImplementationViewElement[] myElements;
    private int myIndex;
    private EditorEx myEditor;
    private volatile boolean myEditorReleased;
    private final JPanel myViewingPanel;
    private final CardLayout myBinarySwitch;
    private final JPanel myBinaryPanel;
    private ComboBox<FileDescriptor> myFileChooser;
    private FileEditor myNonTextEditor;
    private FileEditorProvider myCurrentNonTextEditorProvider;
    private JBPopup myHint;
    @NlsContexts.TabTitle
    private String myTitle;
    private final ActionToolbar myToolbar;
    private JPanel mySingleEntryPanel;

    public void setHint(JBPopup hint, @NotNull @NlsContexts.TabTitle String title2) {
        if (title2 == null) {
            ImplementationViewComponent.$$$reportNull$$$0(0);
        }
        this.myHint = hint;
        this.myTitle = title2;
    }

    public boolean hasElementsToShow() {
        return this.myElements != null && this.myElements.length > 0;
    }

    public ImplementationViewComponent(Collection<ImplementationViewElement> elements, int index2) {
        this(elements, index2, null);
    }

    public ImplementationViewComponent(Collection<ImplementationViewElement> elements, int index2, Consumer<ImplementationViewComponent> openUsageView) {
        super(new BorderLayout());
        this.project = elements.size() > 0 ? elements.iterator().next().getProject() : null;
        this.factory = EditorFactory.getInstance();
        Document doc = this.factory.createDocument((CharSequence)"");
        doc.setReadOnly(true);
        this.myEditor = (EditorEx)this.factory.createEditor(doc, this.project, EditorKind.PREVIEW);
        this.tuneEditor();
        this.myBinarySwitch = new CardLayout();
        this.myViewingPanel = new JPanel(this.myBinarySwitch);
        this.myViewingPanel.add((Component)this.myEditor.getComponent(), TEXT_PAGE_KEY);
        this.myBinaryPanel = new JPanel(new BorderLayout());
        this.myViewingPanel.add((Component)this.myBinaryPanel, BINARY_PAGE_KEY);
        this.add((Component)this.myViewingPanel, "Center");
        this.myToolbar = this.createToolbar(openUsageView);
        this.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        ImplementationViewComponent.update(elements, (PairFunction<? super ImplementationViewElement[], ? super List<FileDescriptor>, Boolean>)((PairFunction)(psiElements, fileDescriptors) -> {
            if (((ImplementationViewElement[])psiElements).length == 0) {
                return false;
            }
            this.myElements = psiElements;
            this.myIndex = index2 < this.myElements.length ? index2 : 0;
            VirtualFile virtualFile2 = this.myElements[this.myIndex].getContainingFile();
            this.tuneEditor(virtualFile2);
            JPanel toolbarPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)0), 0, 0);
            this.mySingleEntryPanel = new JPanel(new BorderLayout());
            toolbarPanel.add((Component)this.mySingleEntryPanel, gc);
            this.myFileChooser = new ComboBox((Object[])fileDescriptors.toArray(new FileDescriptor[0]), 250);
            this.myFileChooser.setOpaque(false);
            this.myFileChooser.addActionListener(e -> {
                int index1 = this.myFileChooser.getSelectedIndex();
                if (this.myIndex != index1) {
                    this.myIndex = index1;
                    UIEventLogger.ImplementationViewComboBoxSelected.log(this.project);
                    this.updateControls();
                }
            });
            toolbarPanel.add((Component)this.myFileChooser, gc);
            if (this.myElements.length > 1) {
                this.mySingleEntryPanel.setVisible(false);
                this.updateRenderer(this.project);
            } else {
                this.myFileChooser.setVisible(false);
                if (virtualFile2 != null) {
                    this.updateSingleEntryLabel(virtualFile2);
                }
            }
            gc.fill = 0;
            gc.weightx = 0.0;
            JComponent component2 = this.myToolbar.getComponent();
            component2.setBorder(null);
            toolbarPanel.add((Component)component2, gc);
            toolbarPanel.setBackground(UIUtil.getToolTipActionBackground());
            toolbarPanel.setBorder(JBUI.Borders.empty((int)3));
            toolbarPanel.setOpaque(false);
            this.add((Component)toolbarPanel, "North");
            this.updateControls();
            return true;
        }));
    }

    private DefaultActionGroup createGearActionButton(final Consumer<ImplementationViewComponent> openUsageView) {
        DefaultActionGroup gearActions = new DefaultActionGroup(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setIcon(AllIcons.Actions.More);
                e.getPresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/ImplementationViewComponent$1", "update"));
            }
        };
        gearActions.setPopup(true);
        EditSourceAction edit = new EditSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getEditSource(), CommonShortcuts.ENTER}), this);
        gearActions.add((AnAction)edit);
        if (openUsageView != null) {
            Icon icon2 = ToolWindowManager.getInstance((Project)this.project).getLocationIcon("Find", AllIcons.General.Pin_tab);
            gearActions.add(new AnAction(() -> IdeBundle.message((String)"show.in.find.window.button.name", (Object[])new Object[0]), icon2){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    openUsageView.accept(ImplementationViewComponent.this);
                    if (ImplementationViewComponent.this.myHint.isVisible()) {
                        ImplementationViewComponent.this.myHint.cancel();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/ImplementationViewComponent$2", "actionPerformed"));
                }
            });
        }
        return gearActions;
    }

    private void updateSingleEntryLabel(VirtualFile virtualFile2) {
        this.mySingleEntryPanel.removeAll();
        JLabel label2 = new JLabel(this.myElements[this.myIndex].getPresentableText(), ImplementationViewComponent.getIconForFile(virtualFile2, this.project), 2);
        this.mySingleEntryPanel.add((Component)label2, "Center");
        label2.setForeground(FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile2).getColor());
        this.mySingleEntryPanel.add((Component)new JLabel(this.myElements[this.myIndex].getLocationText(), this.myElements[this.myIndex].getLocationIcon(), 2), "East");
        this.mySingleEntryPanel.setOpaque(false);
        this.mySingleEntryPanel.setVisible(true);
        this.mySingleEntryPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)3));
    }

    private void tuneEditor(VirtualFile virtualFile2) {
        if (virtualFile2 != null) {
            this.myEditor.setHighlighter(HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)virtualFile2));
        }
    }

    private void tuneEditor() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.DOCUMENTATION_COLOR);
        if (color != null) {
            this.myEditor.setBackgroundColor(color);
        }
        EditorSettings settings = this.myEditor.getSettings();
        settings.setAdditionalLinesCount(1);
        settings.setAdditionalColumnsCount(1);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setCaretRowShown(false);
        this.myEditor.setBorder((Border)JBUI.Borders.empty((int)12, (int)6));
        this.myEditor.getScrollPane().setViewportBorder((Border)JBScrollPane.createIndentBorder());
    }

    private void updateRenderer(Project project) {
        this.myFileChooser.setRenderer(ImplementationViewComponent.createRenderer(project));
    }

    private static ListCellRenderer<FileDescriptor> createRenderer(final Project project) {
        ColoredListCellRenderer<FileDescriptor> mainRenderer = new ColoredListCellRenderer<FileDescriptor>(){

            protected void customizeCellRenderer(@NotNull JList<? extends FileDescriptor> list2, FileDescriptor value2, int index2, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)true));
                if (value2 != null) {
                    ImplementationViewElement element2 = value2.myElement;
                    this.setIcon(ImplementationViewComponent.getIconForFile(value2.myFile, project));
                    this.append(element2.getPresentableText());
                    String presentation2 = element2.getContainerPresentation();
                    if (presentation2 != null) {
                        this.append("  ");
                        this.append(StringUtil.trimStart((String)StringUtil.trimEnd((String)presentation2, (String)")"), (String)"("), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/hint/ImplementationViewComponent$3", "customizeCellRenderer"));
            }
        };
        SimpleListCellRenderer<FileDescriptor> rightRenderer2 = new SimpleListCellRenderer<FileDescriptor>(){

            public void customize(@NotNull JList<? extends FileDescriptor> list2, FileDescriptor value2, int index2, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.setForeground(UIUtil.getListForeground((boolean)selected2, (boolean)true));
                if (value2 != null) {
                    this.setText(value2.myElement.getLocationText());
                    this.setIcon(value2.myElement.getLocationIcon());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/hint/ImplementationViewComponent$4", "customize"));
            }
        };
        return new LeftRightRenderer((ListCellRenderer)mainRenderer, (ListCellRenderer)rightRenderer2);
    }

    @TestOnly
    public String[] getVisibleFiles() {
        ComboBoxModel model2 = this.myFileChooser.getModel();
        String[] result2 = new String[model2.getSize()];
        for (int i2 = 0; i2 < model2.getSize(); ++i2) {
            FileDescriptor o = (FileDescriptor)model2.getElementAt(i2);
            result2[i2] = o.myElement.getPresentableText();
        }
        return result2;
    }

    public void update(@NotNull Collection<? extends ImplementationViewElement> elements, int index2) {
        if (elements == null) {
            ImplementationViewComponent.$$$reportNull$$$0(1);
        }
        ImplementationViewComponent.update(elements, (PairFunction<? super ImplementationViewElement[], ? super List<FileDescriptor>, Boolean>)((PairFunction)(psiElements, fileDescriptors) -> {
            if (this.myEditor.isDisposed()) {
                return false;
            }
            if (((ImplementationViewElement[])psiElements).length == 0) {
                return false;
            }
            Project project = psiElements[0].getProject();
            this.myElements = psiElements;
            this.myIndex = index2 < this.myElements.length ? index2 : 0;
            VirtualFile virtualFile2 = this.myElements[this.myIndex].getContainingFile();
            if (virtualFile2 != null) {
                EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile2);
                this.myEditor.setHighlighter(highlighter);
            }
            if (this.myElements.length > 1) {
                this.myFileChooser.setVisible(true);
                this.mySingleEntryPanel.setVisible(false);
                this.myFileChooser.setModel(new DefaultComboBoxModel<FileDescriptor>(fileDescriptors.toArray(new FileDescriptor[0])));
                this.updateRenderer(project);
            } else {
                this.myFileChooser.setVisible(false);
                if (virtualFile2 != null) {
                    this.updateSingleEntryLabel(virtualFile2);
                }
            }
            this.updateControls();
            this.revalidate();
            this.repaint();
            return true;
        }));
    }

    private static void update(@NotNull Collection<? extends ImplementationViewElement> elements, @NotNull PairFunction<? super ImplementationViewElement[], ? super List<FileDescriptor>, Boolean> fun) {
        if (elements == null) {
            ImplementationViewComponent.$$$reportNull$$$0(2);
        }
        if (fun == null) {
            ImplementationViewComponent.$$$reportNull$$$0(3);
        }
        ArrayList<ImplementationViewElement> candidates = new ArrayList<ImplementationViewElement>(elements.size());
        ArrayList<FileDescriptor> files2 = new ArrayList<FileDescriptor>(elements.size());
        HashSet<String> names2 = new HashSet<String>();
        for (ImplementationViewElement implementationViewElement : elements) {
            if (implementationViewElement.isNamed()) {
                names2.add(implementationViewElement.getName());
            }
            if (names2.size() <= 1) continue;
            break;
        }
        for (ImplementationViewElement implementationViewElement : elements) {
            VirtualFile file2 = implementationViewElement.getContainingFile();
            if (file2 == null) continue;
            if (names2.size() > 1) {
                files2.add(new FileDescriptor(file2, implementationViewElement));
            } else {
                files2.add(new FileDescriptor(file2, implementationViewElement.getContainingMemberOrSelf()));
            }
            candidates.add(implementationViewElement);
        }
        fun.fun((Object)candidates.toArray(new ImplementationViewElement[0]), files2);
    }

    private static Icon getIconForFile(VirtualFile virtualFile2, Project project) {
        return IconUtil.getIcon(virtualFile2, 0, project);
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myElements.length > 1 ? this.myFileChooser : this.myEditor.getContentComponent();
    }

    @ApiStatus.Internal
    public ComboBox<FileDescriptor> getFileChooserComboBox() {
        return this.myFileChooser;
    }

    @ApiStatus.Internal
    public JPanel getSingleEntryPanel() {
        return this.mySingleEntryPanel;
    }

    @ApiStatus.Internal
    public JPanel getViewingPanel() {
        return this.myViewingPanel;
    }

    private void updateControls() {
        this.updateCombo();
        this.updateEditorText();
        this.myToolbar.updateActionsImmediately();
    }

    private void updateCombo() {
        if (this.myFileChooser != null && this.myFileChooser.isVisible()) {
            this.myFileChooser.setSelectedIndex(this.myIndex);
        }
    }

    private void updateEditorText() {
        FileEditorProvider[] providers;
        this.disposeNonTextEditor();
        ImplementationViewElement foundElement = this.myElements[this.myIndex];
        Project project = foundElement.getProject();
        VirtualFile vFile = foundElement.getContainingFile();
        if (vFile == null) {
            return;
        }
        for (ImplementationViewDocumentFactory documentFactory : (ImplementationViewDocumentFactory[])ImplementationViewDocumentFactory.EP_NAME.getExtensions()) {
            Document document = documentFactory.createDocument(foundElement);
            if (document == null) continue;
            this.replaceEditor(project, vFile, documentFactory, document);
            return;
        }
        for (FileEditorProvider provider2 : providers = FileEditorProviderManager.getInstance().getProviders(project, vFile)) {
            if (provider2 instanceof QuickDefinitionProvider) {
                this.updateTextElement(foundElement);
                this.myBinarySwitch.show(this.myViewingPanel, TEXT_PAGE_KEY);
                break;
            }
            if (!provider2.accept(project, vFile)) continue;
            this.myCurrentNonTextEditorProvider = provider2;
            this.myNonTextEditor = this.myCurrentNonTextEditorProvider.createEditor(project, vFile);
            this.myBinaryPanel.removeAll();
            this.myBinaryPanel.add(this.myNonTextEditor.getComponent());
            this.myBinarySwitch.show(this.myViewingPanel, BINARY_PAGE_KEY);
            break;
        }
    }

    private void replaceEditor(Project project, VirtualFile vFile, ImplementationViewDocumentFactory documentFactory, Document document) {
        this.myViewingPanel.remove(this.myEditor.getComponent());
        this.factory.releaseEditor((Editor)this.myEditor);
        this.myEditor = (EditorEx)this.factory.createEditor(document, project, EditorKind.PREVIEW);
        this.tuneEditor(vFile);
        documentFactory.tuneEditorBeforeShow(this.myEditor);
        this.myViewingPanel.add((Component)this.myEditor.getComponent(), TEXT_PAGE_KEY);
        this.myBinarySwitch.show(this.myViewingPanel, TEXT_PAGE_KEY);
        documentFactory.tuneEditorAfterShow(this.myEditor);
    }

    private void disposeNonTextEditor() {
        if (this.myNonTextEditor != null) {
            this.myCurrentNonTextEditorProvider.disposeEditor(this.myNonTextEditor);
            this.myNonTextEditor = null;
            this.myCurrentNonTextEditorProvider = null;
        }
    }

    private void updateTextElement(ImplementationViewElement elt) {
        String newText = elt.getText();
        if (newText == null || Comparing.strEqual((String)newText, (String)this.myEditor.getDocument().getText())) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            DocumentEx fragmentDoc = this.myEditor.getDocument();
            fragmentDoc.setReadOnly(false);
            fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), newText);
            fragmentDoc.setReadOnly(true);
            PsiElement element2 = elt.getElementForShowUsages();
            PsiFile file2 = element2 == null ? null : element2.getContainingFile();
            this.myEditor.getSettings().setTabSize(file2 != null ? CodeStyle.getIndentOptions((PsiFile)file2).TAB_SIZE : CodeStyle.getSettings((Project)elt.getProject()).getTabSize(null));
            this.myEditor.getCaretModel().moveToOffset(0);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        });
    }

    @Nullable
    public static String getNewText(PsiElement elt) {
        int end;
        Project project = elt.getProject();
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(elt);
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        if (elt.getTextRange() == null) {
            return null;
        }
        ImplementationTextSelectioner implementationTextSelectioner = (ImplementationTextSelectioner)LanguageImplementationTextSelectioner.INSTANCE.forLanguage(elt.getLanguage());
        int start2 = implementationTextSelectioner.getTextStartOffset(elt);
        CharSequence rawDefinition = doc.getCharsSequence().subSequence(start2, end);
        for (end = implementationTextSelectioner.getTextEndOffset(elt); end > start2 && StringUtil.isLineBreak((char)rawDefinition.charAt(end - start2 - 1)); --end) {
        }
        int lineStart = doc.getLineStartOffset(doc.getLineNumber(start2));
        int lineEnd = end < doc.getTextLength() ? doc.getLineEndOffset(doc.getLineNumber(end)) : doc.getTextLength();
        String text2 = doc.getCharsSequence().subSequence(lineStart, lineEnd).toString();
        ImplementationTextProcessor processor2 = (ImplementationTextProcessor)LanguageImplementationTextProcessor.INSTANCE.forLanguage(elt.getLanguage());
        return processor2 != null ? processor2.process(text2, elt) : text2;
    }

    private static PsiFile getContainingFile(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return psiFile.getOriginalFile();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this) && !this.myEditorReleased) {
            this.myEditorReleased = true;
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            this.disposeNonTextEditor();
        }
    }

    private ActionToolbar createToolbar(Consumer<ImplementationViewComponent> openUsageView) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        BackAction back = new BackAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), this);
        group2.add((AnAction)back);
        group2.add((AnAction)new ToolbarLabelAction(){

            @Override
            @NotNull
            public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
                if (presentation2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    5.$$$reportNull$$$0(1);
                }
                JComponent component2 = super.createCustomComponent(presentation2, place);
                component2.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
                JComponent jComponent = component2;
                if (jComponent == null) {
                    5.$$$reportNull$$$0(2);
                }
                return jComponent;
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(3);
                }
                super.update(e);
                Presentation presentation2 = e.getPresentation();
                if (ImplementationViewComponent.this.myElements != null && ImplementationViewComponent.this.myElements.length > 1) {
                    presentation2.setText(ImplementationViewComponent.this.myIndex + 1 + "/" + ImplementationViewComponent.this.myElements.length);
                    presentation2.setVisible(true);
                } else {
                    presentation2.setVisible(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/hint/ImplementationViewComponent$5";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/hint/ImplementationViewComponent$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCustomComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createCustomComponent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        ForwardAction forward = new ForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), this);
        group2.add((AnAction)forward);
        group2.add((AnAction)this.createGearActionButton(openUsageView));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(IMPLEMENTATION_VIEW_PLACE, (ActionGroup)group2, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent(this.myEditor.getContentComponent());
        return toolbar;
    }

    private void goBack() {
        --this.myIndex;
        this.updateControls();
    }

    private void goForward() {
        ++this.myIndex;
        this.updateControls();
    }

    public int getIndex() {
        return this.myIndex;
    }

    public ImplementationViewElement[] getElements() {
        return this.myElements;
    }

    public UsageView showInUsageView() {
        UIEventLogger.ImplementationViewToolWindowOpened.log(this.project);
        return FindUtil.showInUsageView(null, this.collectElementsForShowUsages(), this.myTitle, this.project);
    }

    private PsiElement[] collectElementsForShowUsages() {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (ImplementationViewElement element2 : this.myElements) {
            PsiElement psiElement = element2.getElementForShowUsages();
            if (psiElement == null) continue;
            result2.add(psiElement);
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ImplementationViewComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setHint";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class EditSourceActionBase
    extends AnAction {
        private final boolean myFocusEditor;

        EditSourceActionBase(boolean focusEditor, @NlsActions.ActionText Icon icon2, String text2) {
            super(text2, null, icon2);
            this.myFocusEditor = focusEditor;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditSourceActionBase.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(ImplementationViewComponent.this.myFileChooser == null || !ImplementationViewComponent.this.myFileChooser.isPopupVisible());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditSourceActionBase.$$$reportNull$$$0(1);
            }
            ImplementationViewComponent.this.myElements[ImplementationViewComponent.this.myIndex].navigate(this.myFocusEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/hint/ImplementationViewComponent$EditSourceActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditSourceAction
    extends EditSourceActionBase {
        EditSourceAction() {
            super(true, AllIcons.Actions.EditSource, CodeInsightBundle.message((String)"quick.definition.edit.source", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditSourceAction.$$$reportNull$$$0(0);
            }
            super.actionPerformed(e);
            if (ImplementationViewComponent.this.myHint.isVisible()) {
                ImplementationViewComponent.this.myHint.cancel();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/ImplementationViewComponent$EditSourceAction", "actionPerformed"));
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ForwardAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.forward", (Object[])new Object[0]), AllIcons.Actions.Play_forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(0);
            }
            ImplementationViewComponent.this.goForward();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(ImplementationViewComponent.this.myElements != null && ImplementationViewComponent.this.myIndex < ImplementationViewComponent.this.myElements.length - 1);
            presentation2.setVisible(ImplementationViewComponent.this.myElements != null && ImplementationViewComponent.this.myElements.length > 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/hint/ImplementationViewComponent$ForwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        BackAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.back", (Object[])new Object[0]), AllIcons.Actions.Play_back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(0);
            }
            ImplementationViewComponent.this.goBack();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(ImplementationViewComponent.this.myIndex > 0);
            presentation2.setVisible(ImplementationViewComponent.this.myElements != null && ImplementationViewComponent.this.myElements.length > 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/hint/ImplementationViewComponent$BackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileDescriptor {
        @NotNull
        public final VirtualFile myFile;
        public final ImplementationViewElement myElement;

        FileDescriptor(@NotNull VirtualFile file2, ImplementationViewElement element2) {
            if (file2 == null) {
                FileDescriptor.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
            this.myElement = element2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hint/ImplementationViewComponent$FileDescriptor", "<init>"));
        }
    }
}

