/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsPassFactory;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel;
import com.intellij.codeInsight.hints.settings.InlaySettingsPanel;
import com.intellij.codeInsight.hints.settings.InlaySettingsProvider;
import com.intellij.codeInsight.hints.settings.language.SingleLanguageInlayHintsSettingsPanelKt;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J.\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0002J\u001a\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0006\u0010\u001f\u001a\u00020\u0014J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0016J\u001c\u0010)\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010*2\b\u0010\u001a\u001a\u0004\u0018\u00010*H\u0003J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0018H\u0002J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001a\u001a\u0002012\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u00102\u001a\u00020.2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u00020%H\u0002J\u0018\u00103\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u00104\u001a\u00020.J\u0018\u00104\u001a\u00020.2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u00105\u001a\u00020\u0014J\u0018\u00105\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u00106\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00182\u0006\u00107\u001a\u00020.H\u0002J\u001e\u00108\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010:J\u0018\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0012\u0010=\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010\u0018H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006>"}, d2={"Lcom/intellij/codeInsight/hints/settings/InlaySettingsPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentEditor", "Lcom/intellij/openapi/editor/Editor;", "groups", "", "Lcom/intellij/codeInsight/hints/InlayGroup;", "", "Lcom/intellij/codeInsight/hints/settings/InlayProviderSettingsModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rightPanel", "tree", "Lcom/intellij/ui/CheckboxTree;", "getTree", "()Lcom/intellij/ui/CheckboxTree;", "addDescription", "", "s", "", "addModelNode", "Lcom/intellij/ui/CheckedTreeNode;", "model", "parent", "lastId", "selected", "addPreview", "previewText", "apply", "node", "settings", "Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "enableHintsForLanguage", "language", "Lcom/intellij/lang/Language;", "enableSearch", "Ljava/lang/Runnable;", "option", "getName", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getProviderId", "treeNode", "isCaseEnabled", "", "item", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable$Case;", "Ljavax/swing/tree/TreeNode;", "isLanguageEnabled", "isModelEnabled", "isModified", "reset", "resetNode", "value", "selectModel", "selector", "Ljava/util/function/Predicate;", "updateHints", "editor", "updateRightPanel", "intellij.platform.lang.impl"})
public final class InlaySettingsPanel
extends JPanel {
    @NotNull
    private final CheckboxTree tree;
    private final JPanel rightPanel;
    private final Map<InlayGroup, List<InlayProviderSettingsModel>> groups;
    private Editor currentEditor;
    @NotNull
    private final Project project;

    @NotNull
    public final CheckboxTree getTree() {
        return this.tree;
    }

    @Nls
    private final String getName(DefaultMutableTreeNode node2, DefaultMutableTreeNode parent) {
        Object item;
        DefaultMutableTreeNode defaultMutableTreeNode = node2;
        Object object = item = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        if (item instanceof InlayGroup) {
            return item.toString();
        }
        if (item instanceof Language) {
            String string = ((Language)item).getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.displayName");
            return string;
        }
        if (item instanceof InlayProviderSettingsModel) {
            String string;
            DefaultMutableTreeNode defaultMutableTreeNode2 = parent;
            if ((defaultMutableTreeNode2 != null ? defaultMutableTreeNode2.getUserObject() : null) instanceof InlayGroup) {
                String string2 = ((InlayProviderSettingsModel)item).getLanguage().getDisplayName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.language.displayName");
            } else {
                string = ((InlayProviderSettingsModel)item).getName();
            }
            return string;
        }
        if (item instanceof ImmediateConfigurable.Case) {
            return ((ImmediateConfigurable.Case)item).getName();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private final CheckedTreeNode addModelNode(InlayProviderSettingsModel model2, CheckedTreeNode parent, String lastId, CheckedTreeNode selected2) {
        void nodeToSelect;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = selected2;
        model2.setOnChangeListener(new ChangeListener(this, model2){
            final /* synthetic */ InlaySettingsPanel this$0;
            final /* synthetic */ InlayProviderSettingsModel $model;

            public void settingsChanged() {
                block0: {
                    Editor editor2 = InlaySettingsPanel.access$getCurrentEditor$p(this.this$0);
                    if (editor2 == null) break block0;
                    Editor editor3 = editor2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Editor it = editor3;
                    boolean bl3 = false;
                    InlaySettingsPanel.access$updateHints(this.this$0, it, this.$model);
                }
            }
            {
                this.this$0 = this$0;
                this.$model = $captured_local_variable$1;
            }
        });
        CheckedTreeNode node2 = new CheckedTreeNode(model2, model2){
            final /* synthetic */ InlayProviderSettingsModel $model;

            public void setChecked(boolean checked) {
                block0: {
                    super.setChecked(checked);
                    this.$model.setEnabled(checked);
                    ChangeListener changeListener = this.$model.getOnChangeListener();
                    if (changeListener == null) break block0;
                    changeListener.settingsChanged();
                }
            }
            {
                this.$model = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        parent.add((MutableTreeNode)node2);
        Iterable $this$forEach$iv = model2.getCases();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImmediateConfigurable.Case it = (ImmediateConfigurable.Case)element$iv;
            boolean bl = false;
            CheckedTreeNode caseNode = new CheckedTreeNode(it, it, this, model2, node2, (Ref.ObjectRef)nodeToSelect, lastId){
                final /* synthetic */ ImmediateConfigurable.Case $it;
                final /* synthetic */ InlaySettingsPanel this$0;
                final /* synthetic */ InlayProviderSettingsModel $model$inlined;
                final /* synthetic */ addModelNode.node.1 $node$inlined;
                final /* synthetic */ Ref.ObjectRef $nodeToSelect$inlined;
                final /* synthetic */ String $lastId$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = inlaySettingsPanel;
                    this.$model$inlined = inlayProviderSettingsModel;
                    this.$node$inlined = var5_5;
                    this.$nodeToSelect$inlined = objectRef;
                    this.$lastId$inlined = string;
                    super($super_call_param$2);
                }

                public void setChecked(boolean checked) {
                    block0: {
                        super.setChecked(checked);
                        this.$it.setValue(checked);
                        ChangeListener changeListener = this.$model$inlined.getOnChangeListener();
                        if (changeListener == null) break block0;
                        changeListener.settingsChanged();
                    }
                }
            };
            node2.add((MutableTreeNode)caseNode);
            if ((CheckedTreeNode)nodeToSelect.element != null || !Intrinsics.areEqual((Object)this.getProviderId(caseNode), (Object)lastId)) continue;
            nodeToSelect.element = caseNode;
        }
        return (CheckedTreeNode)nodeToSelect.element == null && Intrinsics.areEqual((Object)this.getProviderId(node2), (Object)lastId) ? (CheckedTreeNode)node2 : (CheckedTreeNode)nodeToSelect.element;
    }

    private final void updateRightPanel(CheckedTreeNode treeNode2) {
        Object item;
        this.rightPanel.removeAll();
        this.currentEditor = null;
        CheckedTreeNode checkedTreeNode = treeNode2;
        Object object = item = checkedTreeNode != null ? checkedTreeNode.getUserObject() : null;
        if (item instanceof InlayProviderSettingsModel) {
            if (treeNode2.isLeaf()) {
                this.addDescription(((InlayProviderSettingsModel)item).getDescription());
            }
            ((InlayProviderSettingsModel)item).getComponent().setBorder((Border)JBUI.Borders.empty());
            this.rightPanel.add(((InlayProviderSettingsModel)item).getComponent());
            if (treeNode2.isLeaf()) {
                String string = ((InlayProviderSettingsModel)item).getCasePreview(null);
                if (string == null) {
                    string = ((InlayProviderSettingsModel)item).getPreviewText();
                }
                this.addPreview(string, (InlayProviderSettingsModel)item);
            }
        } else if (item instanceof ImmediateConfigurable.Case) {
            TreeNode treeNode3 = treeNode2.getParent();
            if (treeNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
            }
            CheckedTreeNode parent = (CheckedTreeNode)treeNode3;
            Object object2 = parent.getUserObject();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel");
            }
            InlayProviderSettingsModel model2 = (InlayProviderSettingsModel)object2;
            this.addDescription(model2.getCaseDescription((ImmediateConfigurable.Case)item));
            String preview2 = model2.getCasePreview((ImmediateConfigurable.Case)item);
            this.addPreview(preview2, model2);
        }
        if (treeNode2 != null) {
            InlayHintsSettings.Companion.instance().saveLastViewedProviderId(this.getProviderId(treeNode2));
        }
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    private final void addPreview(String previewText, InlayProviderSettingsModel model2) {
        if (previewText != null) {
            EditorTextField editorTextField2 = SingleLanguageInlayHintsSettingsPanelKt.createEditor(model2.getLanguage(), this.project, (Function1<? super Editor, ? extends Object>)((Function1)new Function1<Editor, Unit>(this, model2){
                final /* synthetic */ InlaySettingsPanel this$0;
                final /* synthetic */ InlayProviderSettingsModel $model;

                public final void invoke(@NotNull Editor editor2) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    InlaySettingsPanel.access$setCurrentEditor$p(this.this$0, editor2);
                    InlaySettingsPanel.access$updateHints(this.this$0, editor2, this.$model);
                }
                {
                    this.this$0 = inlaySettingsPanel;
                    this.$model = inlayProviderSettingsModel;
                    super(1);
                }
            }));
            editorTextField2.setText(previewText);
            editorTextField2.addSettingsProvider(addPreview.1.INSTANCE);
            this.rightPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)editorTextField2))), "growx");
        }
    }

    private final void updateHints(Editor editor2, InlayProviderSettingsModel model2) {
        LanguageFileType languageFileType = model2.getLanguage().getAssociatedFileType();
        if (languageFileType == null) {
            languageFileType = PlainTextFileType.INSTANCE;
        }
        LanguageFileType fileType = languageFileType;
        ReadAction.nonBlocking((Callable)new Callable(this, model2, fileType, editor2){
            final /* synthetic */ InlaySettingsPanel this$0;
            final /* synthetic */ InlayProviderSettingsModel $model;
            final /* synthetic */ LanguageFileType $fileType;
            final /* synthetic */ Editor $editor;

            public final PsiFile call() {
                Project project = this.this$0.getProject();
                LanguageFileType languageFileType = this.$fileType;
                Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"fileType");
                FileType fileType = (FileType)languageFileType;
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                return this.$model.createFile(project, fileType, document);
            }
            {
                this.this$0 = inlaySettingsPanel;
                this.$model = inlayProviderSettingsModel;
                this.$fileType = languageFileType;
                this.$editor = editor2;
            }
        }).finishOnUiThread(ModalityState.defaultModalityState(), new Consumer(model2, editor2){
            final /* synthetic */ InlayProviderSettingsModel $model;
            final /* synthetic */ Editor $editor;

            public final void accept(PsiFile psiFile) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this, psiFile){
                    final /* synthetic */ updateHints.2 this$0;
                    final /* synthetic */ PsiFile $psiFile;

                    public final void run() {
                        InlayProviderSettingsModel inlayProviderSettingsModel = this.this$0.$model;
                        Editor editor2 = this.this$0.$editor;
                        PsiFile psiFile = this.$psiFile;
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiFile");
                        inlayProviderSettingsModel.collectAndApply(editor2, psiFile);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$psiFile = psiFile;
                    }
                });
            }
            {
                this.$model = inlayProviderSettingsModel;
                this.$editor = editor2;
            }
        }).inSmartMode(this.project).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void addDescription(@Nls String s) {
        JEditorPane jEditorPane = SwingHelper.createHtmlLabel(StringUtil.notNullize((String)s), null, null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"SwingHelper.createHtmlLa\u2026otNullize(s), null, null)");
        JEditorPane htmlLabel = jEditorPane;
        this.rightPanel.add((Component)htmlLabel, "growy");
    }

    private final String getProviderId(CheckedTreeNode treeNode2) {
        Object item = treeNode2.getUserObject();
        if (item instanceof InlayProviderSettingsModel) {
            return ((InlayProviderSettingsModel)item).getLanguage().getID() + "." + ((InlayProviderSettingsModel)item).getId();
        }
        if (item instanceof ImmediateConfigurable.Case) {
            TreeNode treeNode3 = treeNode2.getParent();
            if (treeNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
            }
            Object object = ((CheckedTreeNode)treeNode3).getUserObject();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel");
            }
            InlayProviderSettingsModel model2 = (InlayProviderSettingsModel)object;
            return model2.getLanguage().getID() + "." + model2.getId() + "." + ((ImmediateConfigurable.Case)item).getId();
        }
        return "";
    }

    public final void reset() {
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
        Object object = treeModel.getRoot();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
        }
        this.reset((CheckedTreeNode)object, InlayHintsSettings.Companion.instance());
    }

    /*
     * Unable to fully structure code
     */
    private final void reset(CheckedTreeNode node, InlayHintsSettings settings) {
        block13: {
            block12: {
                item = node.getUserObject();
                if (item instanceof InlayProviderSettingsModel) {
                    ((InlayProviderSettingsModel)item).reset();
                    this.resetNode(node, this.isModelEnabled((InlayProviderSettingsModel)item, settings));
                } else if (item instanceof ImmediateConfigurable.Case) {
                    v0 = (ImmediateConfigurable.Case)item;
                    v1 = node.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"node.parent");
                    this.resetNode(node, this.isCaseEnabled(v0, v1, settings));
                } else if (item instanceof Language) {
                    this.resetNode(node, this.isLanguageEnabled(settings, (Language)item));
                }
                v2 = node.children();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"node.children()");
                item = v2;
                var4_4 = false;
                v3 = Collections.list(item);
                Intrinsics.checkNotNullExpressionValue(v3, (String)"java.util.Collections.list(this)");
                $this$forEach$iv = v3;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (TreeNode)element$iv;
                    $i$a$-forEach-InlaySettingsPanel$reset$1 = false;
                    v4 = it;
                    if (v4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                    }
                    this.reset((CheckedTreeNode)v4, settings);
                }
                item = node.getUserObject();
                if (!(item instanceof InlayGroup)) break block13;
                v5 = node;
                v6 = this.groups.get(item);
                if (v6 == null) ** GOTO lbl-1000
                $i$f$forEach = v6;
                var10_12 = v5;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v7 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (InlayProviderSettingsModel)element$iv;
                        $i$a$-any-InlaySettingsPanel$reset$2 = false;
                        if (!it.isEnabled()) continue;
                        v7 = true;
                        break block12;
                    }
                    v7 = false;
                }
            }
            var11_14 = v7;
            v5 = var10_12;
            if (var11_14) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
            v5.setChecked(v8);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCaseEnabled(ImmediateConfigurable.Case item, TreeNode parent, InlayHintsSettings settings) {
        if (!item.getValue()) return false;
        TreeNode treeNode2 = parent;
        if (treeNode2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
        }
        Object object = ((CheckedTreeNode)treeNode2).getUserObject();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel");
        }
        if (!((InlayProviderSettingsModel)object).isEnabled()) return false;
        if (!settings.hintsEnabledGlobally()) return false;
        return true;
    }

    private final boolean isModelEnabled(InlayProviderSettingsModel model2, InlayHintsSettings settings) {
        return model2.isEnabled() && (!model2.isMergedNode() || settings.hintsEnabled(model2.getLanguage())) && settings.hintsEnabledGlobally();
    }

    private final void resetNode(CheckedTreeNode node2, boolean value2) {
        if (node2.isChecked() == value2) {
            return;
        }
        node2.setChecked(value2);
        TreeModel treeModel = this.tree.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        }
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        treeModel2.nodeChanged((TreeNode)node2);
        treeModel2.nodeChanged(node2.getParent());
        if (node2.getParent() != null) {
            TreeNode treeNode2 = node2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)treeNode2, (String)"node.parent");
            treeModel2.nodeChanged(treeNode2.getParent());
        }
    }

    public final void apply() {
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
        Object object = treeModel.getRoot();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
        }
        this.apply((CheckedTreeNode)object, InlayHintsSettings.Companion.instance());
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        InlayHintsPassFactory.Companion.forceHintsUpdateOnNextPass();
    }

    private final void apply(CheckedTreeNode node2, InlayHintsSettings settings) {
        block3: {
            Object item;
            block4: {
                block2: {
                    Enumeration enumeration = node2.children();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"node.children()");
                    Enumeration enumeration2 = enumeration;
                    boolean bl = false;
                    ArrayList arrayList = Collections.list(enumeration2);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                    Iterable $this$forEach$iv = arrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TreeNode it = (TreeNode)element$iv;
                        boolean bl2 = false;
                        TreeNode treeNode2 = it;
                        if (treeNode2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                        }
                        this.apply((CheckedTreeNode)treeNode2, settings);
                    }
                    item = node2.getUserObject();
                    if (!(item instanceof InlayProviderSettingsModel)) break block2;
                    ((InlayProviderSettingsModel)item).setEnabled(node2.isChecked());
                    ((InlayProviderSettingsModel)item).apply();
                    if (!((InlayProviderSettingsModel)item).isMergedNode()) break block3;
                    this.enableHintsForLanguage(((InlayProviderSettingsModel)item).getLanguage(), settings, node2);
                    break block3;
                }
                if (!(item instanceof ImmediateConfigurable.Case)) break block4;
                ((ImmediateConfigurable.Case)item).setValue(node2.isChecked());
                if (!node2.isChecked()) break block3;
                settings.setEnabledGlobally(true);
                break block3;
            }
            if (!(item instanceof Language)) break block3;
            this.enableHintsForLanguage((Language)item, settings, node2);
        }
    }

    private final void enableHintsForLanguage(Language language2, InlayHintsSettings settings, CheckedTreeNode node2) {
        if (node2.isChecked() && !this.isLanguageEnabled(settings, language2)) {
            settings.setHintsEnabledForLanguage(language2, true);
        }
    }

    public final boolean isModified() {
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
        Object object = treeModel.getRoot();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
        }
        return this.isModified((CheckedTreeNode)object, InlayHintsSettings.Companion.instance());
    }

    private final boolean isModified(CheckedTreeNode node2, InlayHintsSettings settings) {
        boolean bl;
        block11: {
            Object item = node2.getUserObject();
            if (item instanceof InlayProviderSettingsModel) {
                if (((InlayProviderSettingsModel)item).isModified() || node2.isChecked() != this.isModelEnabled((InlayProviderSettingsModel)item, settings)) {
                    return true;
                }
            } else if (item instanceof ImmediateConfigurable.Case) {
                boolean bl2 = node2.isChecked();
                ImmediateConfigurable.Case case_ = (ImmediateConfigurable.Case)item;
                TreeNode treeNode2 = node2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)treeNode2, (String)"node.parent");
                if (bl2 != this.isCaseEnabled(case_, treeNode2, settings)) {
                    return true;
                }
            } else if (item instanceof Language && this.isLanguageEnabled(settings, (Language)item) != node2.isChecked()) {
                return true;
            }
            Enumeration enumeration = node2.children();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"node.children()");
            item = enumeration;
            boolean bl3 = false;
            ArrayList arrayList = Collections.list(item);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
            Iterable $this$any$iv = arrayList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TreeNode it = (TreeNode)element$iv;
                    boolean bl4 = false;
                    TreeNode treeNode3 = it;
                    if (treeNode3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                    }
                    if (!this.isModified((CheckedTreeNode)treeNode3, settings)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isLanguageEnabled(InlayHintsSettings settings, Language item) {
        return settings.hintsEnabled(item);
    }

    @Nullable
    public final Runnable enableSearch(@Nullable String option2) {
        if (option2 == null) {
            return null;
        }
        return new Runnable(this, option2){
            final /* synthetic */ InlaySettingsPanel this$0;
            final /* synthetic */ String $option;

            public final void run() {
                TreeModel treeModel = this.this$0.getTree().getModel();
                Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
                Object object = treeModel.getRoot();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                }
                DefaultMutableTreeNode treeNode2 = TreeUtil.findNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), (Condition)new Condition(this){
                    final /* synthetic */ enableSearch.1 this$0;

                    public final boolean value(DefaultMutableTreeNode it) {
                        InlaySettingsPanel inlaySettingsPanel = this.this$0.this$0;
                        DefaultMutableTreeNode defaultMutableTreeNode = it;
                        Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"it");
                        String string = InlaySettingsPanel.access$getName(inlaySettingsPanel, it, (DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                        string = this.this$0.$option;
                        bl = false;
                        String string4 = string;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                        return StringsKt.startsWith$default((String)string3, (String)string5, (boolean)false, (int)2, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (treeNode2 != null) {
                    TreeUtil.selectNode((JTree)((JTree)((Object)this.this$0.getTree())), (TreeNode)treeNode2);
                }
            }
            {
                this.this$0 = inlaySettingsPanel;
                this.$option = string;
            }
        };
    }

    public final void selectModel(@NotNull Language language2, @Nullable Predicate<InlayProviderSettingsModel> selector) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Set set2 = LanguageUtil.getBaseLanguages((Language)language2).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"LanguageUtil.getBaseLanguages(language).toSet()");
        Set languages = set2;
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
        Object object = treeModel.getRoot();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        }
        DefaultMutableTreeNode node2 = TreeUtil.findNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), (Condition)new Condition(selector, languages, language2){
            final /* synthetic */ Predicate $selector;
            final /* synthetic */ Set $languages;
            final /* synthetic */ Language $language;

            public final boolean value(DefaultMutableTreeNode it) {
                boolean bl;
                if (this.$selector == null) {
                    bl = this.$languages.contains(this.$language);
                } else {
                    InlayProviderSettingsModel model2;
                    DefaultMutableTreeNode defaultMutableTreeNode = it;
                    Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"it");
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (!(object instanceof InlayProviderSettingsModel)) {
                        object = null;
                    }
                    bl = (model2 = (InlayProviderSettingsModel)object) != null && this.$selector.test(model2) && this.$languages.contains(model2.getLanguage());
                }
                return bl;
            }
            {
                this.$selector = predicate2;
                this.$languages = set2;
                this.$language = language2;
            }
        });
        if (node2 != null) {
            TreeUtil.selectNode((JTree)((JTree)((Object)this.tree)), (TreeNode)node2);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public InlaySettingsPanel(@NotNull Project project) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.rightPanel = new JPanel((LayoutManager)new MigLayout("wrap, insets 0 10 0 0, gapy 20, fillx"));
        Object $this$flatMap$iv = InlaySettingsProvider.EP.INSTANCE.getExtensions();
        boolean $i$f$flatMap = false;
        InlaySettingsProvider[] inlaySettingsProviderArray = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Object object = $this$flatMapTo$iv$iv;
        int n = ((void)object).length;
        for (int j = 0; j < n; ++j) {
            void $this$flatMapTo$iv$iv2;
            void element$iv$iv;
            void provider2 = element$iv$iv = object[j];
            boolean bl = false;
            Iterable $this$flatMap$iv2 = provider2.getSupportedLanguages(this.project);
            boolean $i$f$flatMap2 = false;
            Iterable iterable = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                Language it = (Language)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = provider2.createModels(this.project, it);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List models = (List)destination$iv$iv;
        $this$flatMap$iv = models;
        InlaySettingsPanel inlaySettingsPanel = this;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            InlayProviderSettingsModel it = (InlayProviderSettingsModel)element$iv$iv;
            boolean bl = false;
            InlayGroup key$iv$iv = it.getGroup();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object object3 = destination$iv$iv;
        inlaySettingsPanel.groups = MapsKt.toSortedMap((Map)object3);
        final CheckedTreeNode root2 = new CheckedTreeNode();
        String lastSelected = InlayHintsSettings.Companion.instance().getLastViewedProviderId();
        CheckedTreeNode nodeToSelect = null;
        object = this.groups;
        boolean element$iv$iv = false;
        for (Map.Entry group2 : object.entrySet()) {
            void $this$groupByTo$iv$iv2;
            CheckedTreeNode groupNode = new CheckedTreeNode(group2.getKey());
            root2.add((MutableTreeNode)groupNode);
            Object v = group2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"group.value");
            Object $this$groupBy$iv2 = (Iterable)v;
            boolean $i$f$groupBy2 = false;
            Iterable $this$getOrPut$iv$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv32 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv3 : $this$groupByTo$iv$iv2) {
                Object object4;
                InlayProviderSettingsModel it = (InlayProviderSettingsModel)element$iv$iv3;
                boolean bl = false;
                Language key$iv$iv = it.getLanguage();
                Map $this$getOrPut$iv$iv$iv2 = destination$iv$iv32;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv3);
            }
            $this$groupBy$iv2 = destination$iv$iv32;
            $i$f$groupBy2 = false;
            for (Map.Entry lang : $this$groupBy$iv2.entrySet()) {
                InlayProviderSettingsModel firstModel = (InlayProviderSettingsModel)CollectionsKt.first((List)((List)lang.getValue()));
                CheckedTreeNode langNode = null;
                int startFrom = 0;
                if ((((List)lang.getValue()).size() == 1 || Intrinsics.areEqual((Object)((InlayGroup)group2.getKey()).toString(), (Object)firstModel.getName())) && InlayGroup.OTHER_GROUP != (InlayGroup)group2.getKey()) {
                    nodeToSelect = this.addModelNode(firstModel, groupNode, lastSelected, nodeToSelect);
                    firstModel.setMergedNode(true);
                    TreeNode treeNode2 = groupNode.getFirstChild();
                    if (treeNode2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                    }
                    langNode = (CheckedTreeNode)treeNode2;
                    startFrom = 1;
                } else {
                    langNode = new CheckedTreeNode(lang.getKey());
                    groupNode.add((MutableTreeNode)langNode);
                    startFrom = 0;
                }
                int destination$iv$iv32 = startFrom;
                int n2 = ((List)lang.getValue()).size();
                while (destination$iv$iv32 < n2) {
                    void it;
                    nodeToSelect = this.addModelNode((InlayProviderSettingsModel)((List)lang.getValue()).get((int)it), langNode, lastSelected, nodeToSelect);
                    ++it;
                }
            }
        }
        this.tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, true){

            public void customizeRenderer(@Nullable JTree tree, @Nullable Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
                if (!(value2 instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value2;
                TreeNode treeNode2 = ((DefaultMutableTreeNode)value2).getParent();
                if (!(treeNode2 instanceof DefaultMutableTreeNode)) {
                    treeNode2 = null;
                }
                String name2 = this.getName(defaultMutableTreeNode, (DefaultMutableTreeNode)treeNode2);
                this.getTextRenderer().appendHTML(name2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }, root2, new CheckboxTreeBase.CheckPolicy(true, true, true, false)){

            @Override
            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)new Convertor(this){
                    final /* synthetic */ 3 this$0;

                    public final String convert(TreePath it) {
                        InlaySettingsPanel inlaySettingsPanel = this.this$0.this;
                        TreePath treePath = it;
                        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"it");
                        Object object = treePath.getLastPathComponent();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                        }
                        TreePath treePath2 = it.getParentPath();
                        return InlaySettingsPanel.access$getName(inlaySettingsPanel, (DefaultMutableTreeNode)object, (DefaultMutableTreeNode)(treePath2 != null ? treePath2.getLastPathComponent() : null));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, true);
            }
        };
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                Object object;
                Serializable serializable = it;
                if (!((serializable != null && (serializable = ((TreeSelectionEvent)serializable).getNewLeadSelectionPath()) != null ? ((TreePath)serializable).getLastPathComponent() : (object = null)) instanceof CheckedTreeNode)) {
                    object = null;
                }
                this.updateRightPanel((CheckedTreeNode)object);
            }
        });
        if (nodeToSelect == null) {
            TreeUtil.expand((JTree)((JTree)((Object)this.tree)), (int)1);
        } else {
            TreeUtil.selectNode((JTree)((JTree)((Object)this.tree)), (TreeNode)((TreeNode)nodeToSelect));
        }
        JBSplitter splitter2 = new JBSplitter(false, "inlay.settings.proportion.key", 0.5f);
        splitter2.setHonorComponentsMinimumSize(false);
        splitter2.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.tree)), (int)20, (int)31));
        splitter2.setSecondComponent((JComponent)this.rightPanel);
        this.add((Component)splitter2, "Center");
    }

    public static final /* synthetic */ Editor access$getCurrentEditor$p(InlaySettingsPanel $this) {
        return $this.currentEditor;
    }

    public static final /* synthetic */ void access$setCurrentEditor$p(InlaySettingsPanel $this, Editor editor2) {
        $this.currentEditor = editor2;
    }

    public static final /* synthetic */ void access$updateHints(InlaySettingsPanel $this, Editor editor2, InlayProviderSettingsModel model2) {
        $this.updateHints(editor2, model2);
    }
}

