/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.IntentionsOrderProvider;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedIntentions {
    private static final Logger LOG = Logger.getInstance(CachedIntentions.class);
    private final CopyOnWriteArraySet<IntentionActionWithTextCaching> myIntentions;
    private final CopyOnWriteArraySet<IntentionActionWithTextCaching> myErrorFixes;
    private final CopyOnWriteArraySet<IntentionActionWithTextCaching> myInspectionFixes;
    private final CopyOnWriteArraySet<IntentionActionWithTextCaching> myGutters;
    private final CopyOnWriteArraySet<IntentionActionWithTextCaching> myNotifications;
    private int myOffset;
    private HighlightInfoType myHighlightInfoType;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Project myProject;
    private final List<AnAction> myGuttersRaw;

    public CachedIntentions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor2) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(1);
        }
        this.myIntentions = new CopyOnWriteArraySet();
        this.myErrorFixes = new CopyOnWriteArraySet();
        this.myInspectionFixes = new CopyOnWriteArraySet();
        this.myGutters = new CopyOnWriteArraySet();
        this.myNotifications = new CopyOnWriteArraySet();
        this.myGuttersRaw = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getIntentions() {
        CopyOnWriteArraySet<IntentionActionWithTextCaching> copyOnWriteArraySet = this.myIntentions;
        if (copyOnWriteArraySet == null) {
            CachedIntentions.$$$reportNull$$$0(2);
        }
        return copyOnWriteArraySet;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getErrorFixes() {
        CopyOnWriteArraySet<IntentionActionWithTextCaching> copyOnWriteArraySet = this.myErrorFixes;
        if (copyOnWriteArraySet == null) {
            CachedIntentions.$$$reportNull$$$0(3);
        }
        return copyOnWriteArraySet;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getInspectionFixes() {
        CopyOnWriteArraySet<IntentionActionWithTextCaching> copyOnWriteArraySet = this.myInspectionFixes;
        if (copyOnWriteArraySet == null) {
            CachedIntentions.$$$reportNull$$$0(4);
        }
        return copyOnWriteArraySet;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getGutters() {
        CopyOnWriteArraySet<IntentionActionWithTextCaching> copyOnWriteArraySet = this.myGutters;
        if (copyOnWriteArraySet == null) {
            CachedIntentions.$$$reportNull$$$0(5);
        }
        return copyOnWriteArraySet;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getNotifications() {
        CopyOnWriteArraySet<IntentionActionWithTextCaching> copyOnWriteArraySet = this.myNotifications;
        if (copyOnWriteArraySet == null) {
            CachedIntentions.$$$reportNull$$$0(6);
        }
        return copyOnWriteArraySet;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            CachedIntentions.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(8);
        }
        return project;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public HighlightInfoType getHighlightInfoType() {
        return this.myHighlightInfoType;
    }

    @NotNull
    public static CachedIntentions create(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(10);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(11);
        }
        CachedIntentions res2 = new CachedIntentions(project, file2, editor2);
        res2.wrapAndUpdateActions(intentions, false);
        CachedIntentions cachedIntentions = res2;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(12);
        }
        return cachedIntentions;
    }

    @NotNull
    public static CachedIntentions createAndUpdateActions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(14);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(15);
        }
        CachedIntentions res2 = new CachedIntentions(project, file2, editor2);
        res2.wrapAndUpdateActions(intentions, true);
        CachedIntentions cachedIntentions = res2;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(16);
        }
        return cachedIntentions;
    }

    public boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        if (newInfo == null) {
            CachedIntentions.$$$reportNull$$$0(17);
        }
        this.myOffset = newInfo.getOffset();
        this.myHighlightInfoType = newInfo.getHighlightInfoType();
        boolean changed2 = this.wrapActionsTo(newInfo.errorFixesToShow, this.myErrorFixes, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myInspectionFixes, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.intentionsToShow, this.myIntentions, callUpdate);
        changed2 |= this.updateGuttersRaw(newInfo);
        return changed2 |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myNotifications, callUpdate);
    }

    private boolean updateGuttersRaw(@NotNull ShowIntentionsPass.IntentionsInfo newInfo) {
        if (newInfo == null) {
            CachedIntentions.$$$reportNull$$$0(18);
        }
        if (newInfo.guttersToShow.isEmpty()) {
            return false;
        }
        this.myGuttersRaw.addAll(newInfo.guttersToShow);
        return true;
    }

    public boolean addActions(@NotNull ShowIntentionsPass.IntentionsInfo info2) {
        if (info2 == null) {
            CachedIntentions.$$$reportNull$$$0(19);
        }
        boolean changed2 = this.addActionsTo(info2.errorFixesToShow, this.myErrorFixes);
        changed2 |= this.addActionsTo(info2.inspectionFixesToShow, this.myInspectionFixes);
        changed2 |= this.addActionsTo(info2.intentionsToShow, this.myIntentions);
        changed2 |= this.updateGuttersRaw(info2);
        return changed2 |= this.addActionsTo(info2.notificationActionsToShow, this.myNotifications);
    }

    public void wrapAndUpdateGutters() {
        LOG.assertTrue(this.myEditor != null);
        if (this.myGuttersRaw.isEmpty()) {
            return;
        }
        this.myGutters.clear();
        Predicate<IntentionAction> filter = action2 -> ContainerUtil.and((Iterable)IntentionActionFilter.EXTENSION_POINT_NAME.getExtensionList(), f -> f.accept((IntentionAction)action2, this.myFile));
        DataContext dataContext = Utils.wrapDataContext(EditorUtil.getEditorDataContext(this.myEditor));
        PresentationFactory presentationFactory = new PresentationFactory();
        List<AnAction> actions2 = Utils.expandActionGroup(false, (ActionGroup)new DefaultActionGroup(this.myGuttersRaw), presentationFactory, dataContext, "IntentionMenu");
        ArrayList<HighlightInfo.IntentionActionDescriptor> descriptors = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        int order = 0;
        for (AnAction action3 : actions2) {
            GutterIntentionAction intentionAction;
            Presentation presentation2 = presentationFactory.getPresentation(action3);
            Icon icon2 = (Icon)ObjectUtils.notNull((Object)presentation2.getIcon(), (Object)EmptyIcon.ICON_16);
            String text2 = presentation2.getText();
            if (StringUtil.isEmpty((String)text2) || !filter.test((IntentionAction)(intentionAction = new GutterIntentionAction(action3, order++, icon2, text2)))) continue;
            HighlightInfo.IntentionActionDescriptor descriptor2 = new HighlightInfo.IntentionActionDescriptor((IntentionAction)intentionAction, Collections.emptyList(), text2, icon2, null, null, null);
            descriptors.add(descriptor2);
        }
        this.wrapActionsTo(descriptors, this.myGutters, false);
    }

    private boolean addActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<? super IntentionActionWithTextCaching> cachedActions) {
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(20);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(21);
        }
        List actions2 = ContainerUtil.map(newDescriptors, descriptor2 -> this.wrapAction((HighlightInfo.IntentionActionDescriptor)descriptor2, (PsiElement)this.myFile, this.myFile, this.myEditor));
        return cachedActions.addAll(actions2);
    }

    private boolean wrapActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull CopyOnWriteArraySet<IntentionActionWithTextCaching> cachedActions, boolean shouldCallIsAvailable) {
        Editor injectedEditor;
        PsiFile injectedFile;
        PsiElement element2;
        PsiFile hostElement;
        int fileOffset;
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(22);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(23);
        }
        if (cachedActions.isEmpty() && newDescriptors.isEmpty()) {
            return false;
        }
        if (this.myEditor == null) {
            LOG.assertTrue(!shouldCallIsAvailable);
            List actions2 = ContainerUtil.map(newDescriptors, descriptor2 -> this.wrapAction((HighlightInfo.IntentionActionDescriptor)descriptor2, (PsiElement)this.myFile, this.myFile, null));
            return cachedActions.addAll(actions2);
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int n = fileOffset = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
        if (this.myFile instanceof PsiCompiledElement) {
            PsiFile element22;
            hostElement = element22 = this.myFile;
        } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            element2 = viewProvider.findElementAt(fileOffset, viewProvider.getBaseLanguage());
            hostElement = element2;
        } else {
            hostElement = this.myFile.getViewProvider().findElementAt(fileOffset, this.myFile.getLanguage());
            element2 = InjectedLanguageUtilBase.findElementAtNoCommit(this.myFile, fileOffset);
        }
        if (element2 == null || element2 == hostElement) {
            injectedFile = this.myFile;
            injectedEditor = this.myEditor;
        } else {
            injectedFile = element2.getContainingFile();
            injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
        }
        LinkedHashSet<IntentionActionWithTextCaching> wrappedNew = new LinkedHashSet<IntentionActionWithTextCaching>(newDescriptors.size());
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
            IntentionActionWithTextCaching cachedAction;
            IntentionAction action2 = intentionActionDescriptor.getAction();
            if (element2 != null && element2 != hostElement && (!shouldCallIsAvailable || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action2))) {
                cachedAction = this.wrapAction(intentionActionDescriptor, element2, injectedFile, injectedEditor);
                wrappedNew.add(cachedAction);
                continue;
            }
            if (hostElement == null || shouldCallIsAvailable && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action2)) continue;
            cachedAction = this.wrapAction(intentionActionDescriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
            wrappedNew.add(cachedAction);
        }
        if (cachedActions.equals(wrappedNew)) {
            return false;
        }
        cachedActions.clear();
        cachedActions.addAll(wrappedNew);
        return true;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @NotNull PsiElement element2, @NotNull PsiFile containingFile, @Nullable Editor containingEditor) {
        if (descriptor2 == null) {
            CachedIntentions.$$$reportNull$$$0(24);
        }
        if (element2 == null) {
            CachedIntentions.$$$reportNull$$$0(25);
        }
        if (containingFile == null) {
            CachedIntentions.$$$reportNull$$$0(26);
        }
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor2, (cached, action2) -> {
            if (action2 instanceof QuickFixWrapper) {
                this.removeActionFromCached((IntentionActionWithTextCaching)cached);
                this.markInvoked((IntentionAction)action2);
            }
        });
        for (IntentionAction intentionAction : descriptor2.getOptions(element2, containingEditor)) {
            boolean isInspectionFix;
            Pair<PsiFile, Editor> availableIn;
            Editor editor2 = (Editor)ObjectUtils.chooseNotNull((Object)this.myEditor, (Object)containingEditor);
            if (editor2 == null || (availableIn = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(this.myFile, editor2, containingFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(f, e) -> ShowIntentionActionsHandler.availableFor(f, e, option2)))) == null) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(intentionAction);
            boolean isErrorFix = this.myErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(intentionAction);
            }
            if (isInspectionFix = this.myInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(intentionAction);
                continue;
            }
            cachedAction.addIntention(intentionAction);
        }
        IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
        if (intentionActionWithTextCaching == null) {
            CachedIntentions.$$$reportNull$$$0(27);
        }
        return intentionActionWithTextCaching;
    }

    private void markInvoked(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(28);
        }
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action2);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(29);
        }
        this.myErrorFixes.remove(action2);
        this.myGutters.remove(action2);
        this.myInspectionFixes.remove(action2);
        this.myIntentions.remove(action2);
        this.myNotifications.remove(action2);
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getAllActions() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myErrorFixes);
        result2.addAll(this.myInspectionFixes);
        for (IntentionActionWithTextCaching intention : this.myIntentions) {
            if (this.myErrorFixes.contains(intention) || this.myInspectionFixes.contains(intention)) continue;
            result2.add(intention);
        }
        result2.addAll(this.myGutters);
        result2.addAll(this.myNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        Language language2 = PsiUtilCore.getLanguageAtOffset((PsiFile)this.getFile(), (int)this.getOffset());
        IntentionsOrderProvider intentionsOrder = (IntentionsOrderProvider)IntentionsOrderProvider.EXTENSION.forLanguage(language2);
        List<IntentionActionWithTextCaching> list2 = intentionsOrder.getSortedIntentions(this, result2);
        if (list2 == null) {
            CachedIntentions.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public IntentionGroup getGroup(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(31);
        }
        if (this.myErrorFixes.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.ERROR;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(32);
            }
            return intentionGroup;
        }
        if (this.myInspectionFixes.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.INSPECTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(33);
            }
            return intentionGroup;
        }
        if (this.myNotifications.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.NOTIFICATION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(34);
            }
            return intentionGroup;
        }
        if (this.myGutters.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.GUTTER;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(35);
            }
            return intentionGroup;
        }
        if (action2.getAction() instanceof EmptyIntentionAction) {
            IntentionGroup intentionGroup = IntentionGroup.EMPTY_ACTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(36);
            }
            return intentionGroup;
        }
        IntentionGroup intentionGroup = IntentionGroup.OTHER;
        if (intentionGroup == null) {
            CachedIntentions.$$$reportNull$$$0(37);
        }
        return intentionGroup;
    }

    @NotNull
    public Icon getIcon(@NotNull IntentionActionWithTextCaching value2) {
        Icon icon2;
        if (value2 == null) {
            CachedIntentions.$$$reportNull$$$0(38);
        }
        if (value2.getIcon() != null) {
            Icon icon3 = value2.getIcon();
            if (icon3 == null) {
                CachedIntentions.$$$reportNull$$$0(39);
            }
            return icon3;
        }
        IntentionAction action2 = value2.getAction();
        while (action2 instanceof IntentionActionDelegate) {
            action2 = ((IntentionActionDelegate)action2).getDelegate();
        }
        IntentionAction iconable = action2;
        if (action2 instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action2).getFix();
        }
        if (iconable instanceof Iconable && (icon2 = ((Iconable)iconable).getIcon(0)) != null) {
            Icon icon4 = icon2;
            if (icon4 == null) {
                CachedIntentions.$$$reportNull$$$0(40);
            }
            return icon4;
        }
        if (IntentionManagerSettings.getInstance().isShowLightBulb(action2)) {
            Icon icon5 = this.myErrorFixes.contains(value2) ? AllIcons.Actions.QuickfixBulb : (this.myInspectionFixes.contains(value2) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
            if (icon5 == null) {
                CachedIntentions.$$$reportNull$$$0(41);
            }
            return icon5;
        }
        if (this.myErrorFixes.contains(value2)) {
            Icon icon6 = AllIcons.Actions.QuickfixOffBulb;
            if (icon6 == null) {
                CachedIntentions.$$$reportNull$$$0(42);
            }
            return icon6;
        }
        Icon icon7 = IconLoader.getDisabledIcon((Icon)AllIcons.Actions.RealIntentionBulb);
        if (icon7 == null) {
            CachedIntentions.$$$reportNull$$$0(43);
        }
        return icon7;
    }

    public boolean showBulb() {
        return ContainerUtil.exists(this.getAllActions(), info2 -> IntentionManagerSettings.getInstance().isShowLightBulb(info2.getAction()));
    }

    public String toString() {
        return "CachedIntentions{myIntentions=" + this.myIntentions + ", myErrorFixes=" + this.myErrorFixes + ", myInspectionFixes=" + this.myInspectionFixes + ", myGutters=" + this.myGutters + ", myNotifications=" + this.myNotifications + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptors";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedActions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionFixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndUpdateActions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActions";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAndUpdateActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndUpdateActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateGuttersRaw";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addActionsTo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionsTo";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "wrapAction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "markInvoked";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeActionFromCached";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

