/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewContent;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewDiffResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEmptyResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewHtmlResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable;", "Ljava/util/concurrent/Callable;", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewContent;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "call", "generatePreview", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewDiffResult;", "mapInjectedOffsetToUnescaped", "", "injectedFile", "injectedOffset", "tryCreateDescriptionContent", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewHtmlResult;", "tryCreateDiffContent", "Companion", "intellij.platform.lang.impl"})
public final class IntentionPreviewComputable
implements Callable<IntentionPreviewContent> {
    private final Project project;
    private final IntentionAction action;
    private final PsiFile originalFile;
    private final Editor originalEditor;
    private static final Logger LOG;
    private static final Regex HTML_COMMENT_REGEX;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public IntentionPreviewContent call() {
        IntentionPreviewDiffResult diffContent = this.tryCreateDiffContent();
        if (diffContent != null) {
            return diffContent;
        }
        IntentionPreviewHtmlResult descriptionContent = this.tryCreateDescriptionContent();
        if (descriptionContent != null) {
            return descriptionContent;
        }
        return IntentionPreviewEmptyResult.INSTANCE;
    }

    private final IntentionPreviewHtmlResult tryCreateDescriptionContent() {
        Object object;
        Object v4;
        block5: {
            IntentionAction intentionAction = IntentionActionDelegate.unwrap((IntentionAction)this.action);
            Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"IntentionActionDelegate.unwrap(action)");
            IntentionAction originalAction = intentionAction;
            IntentionManagerSettings intentionManagerSettings = IntentionManagerSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)intentionManagerSettings, (String)"IntentionManagerSettings.getInstance()");
            List<IntentionActionMetaData> list2 = intentionManagerSettings.getMetaData();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"IntentionManagerSettings.getInstance().metaData");
            Iterable $this$singleOrNull$iv = list2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IntentionActionMetaData md = (IntentionActionMetaData)element$iv;
                boolean bl = false;
                IntentionActionMetaData intentionActionMetaData = md;
                Intrinsics.checkNotNullExpressionValue((Object)intentionActionMetaData, (String)"md");
                if (!(IntentionActionDelegate.unwrap((IntentionAction)intentionActionMetaData.getAction()) == originalAction)) continue;
                if (found$iv) {
                    v4 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        IntentionActionMetaData intentionActionMetaData = v4;
        if (intentionActionMetaData == null) {
            return null;
        }
        IntentionActionMetaData actionMetaData = intentionActionMetaData;
        try {
            TextDescriptor textDescriptor = actionMetaData.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)textDescriptor, (String)"actionMetaData.description");
            String string = textDescriptor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actionMetaData.description.text");
            object = string;
            Regex $i$f$singleOrNull = HTML_COMMENT_REGEX;
            String string2 = "";
            boolean bl = false;
            object = new IntentionPreviewHtmlResult($i$f$singleOrNull.replace((CharSequence)object, string2));
        }
        catch (IOException ex) {
            object = null;
        }
        return object;
    }

    private final IntentionPreviewDiffResult tryCreateDiffContent() {
        try {
            return this.generatePreview();
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            return null;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            LOG.debug("There are exceptions on invocation the intention: '" + this.action.getText() + "' on a copy of the file.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final IntentionPreviewDiffResult generatePreview() {
        block15: {
            block14: {
                v0 = ShowIntentionActionsHandler.chooseFileForAction(this.originalFile, this.originalEditor, this.action);
                if (v0 == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue(v0, (String)"ShowIntentionActionsHand\u2026r, action) ?: return null");
                origPair = v0;
                origFile = null;
                caretOffset = 0;
                if (Intrinsics.areEqual((Object)((PsiFile)origPair.first), (Object)this.originalFile) ^ true) {
                    manager = InjectedLanguageManager.getInstance((Project)this.project);
                    v1 = PsiFileFactory.getInstance((Project)this.project);
                    v2 = origPair.first;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"origPair.first");
                    v3 = ((PsiFile)v2).getName();
                    v4 = origPair.first;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"origPair.first");
                    v5 = v1.createFileFromText(v3, ((PsiFile)v4).getFileType(), (CharSequence)manager.getUnescapedText((PsiElement)origPair.first));
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"PsiFileFactory.getInstan\u2026apedText(origPair.first))");
                    origFile = v5;
                    v6 = origPair.first;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"origPair.first");
                    v7 = (PsiFile)v6;
                    v8 = origPair.second;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"origPair.second");
                    v9 = ((Editor)v8).getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"origPair.second.caretModel");
                    caretOffset = this.mapInjectedOffsetToUnescaped(v7, v9.getOffset());
                } else {
                    origFile = this.originalFile;
                    v10 = this.originalEditor.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"originalEditor.caretModel");
                    caretOffset = v10.getOffset();
                }
                v11 = origFile.copy();
                if (v11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
                }
                psiFileCopy = (PsiFile)v11;
                ProgressManager.checkCanceled();
                editorCopy = new IntentionPreviewEditor(psiFileCopy, caretOffset);
                v12 = this.originalEditor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"originalEditor.document");
                writable = v12.isWritable();
                try {
                    this.originalEditor.getDocument().setReadOnly(true);
                    ProgressManager.checkCanceled();
                    if (this.action.invokeForPreview(this.project, (Editor)editorCopy, psiFileCopy)) ** GOTO lbl87
                    if (this.action.startInWriteAction()) {
                        v13 = this.action.getElementToMakeWritable(this.originalFile);
                        if ((v13 != null ? v13.getContainingFile() : null) == this.originalFile) break block14;
                    }
                    var7_7 = null;
                }
                catch (Throwable var7_9) {
                    this.originalEditor.getDocument().setReadOnly(writable == false);
                    throw var7_9;
                }
                this.originalEditor.getDocument().setReadOnly(writable == false);
                return var7_7;
            }
            try {
                var8_10 = IntentionActionDelegate.unwrap((IntentionAction)this.action).getClass().getMethod("invokeForPreview", new Class[]{Project.class, Editor.class, PsiFile.class});
            }
            catch (NoSuchMethodException _) {
                var8_10 = null;
            }
            catch (SecurityException _) {
                var8_10 = null;
            }
            method = var8_10;
            if (method == null || !Intrinsics.areEqual(method.getDeclaringClass(), IntentionAction.class)) ** GOTO lbl87
            if (com.intellij.codeInsight.intention.impl.preview.IntentionPreviewComputable$Companion.access$findCopyIntention(IntentionPreviewComputable.Companion, this.project, editorCopy, psiFileCopy, this.action) != null) break block15;
            _ = null;
            this.originalEditor.getDocument().setReadOnly(writable == false);
            return _;
        }
        action = v14;
        v15 = IntentionActionDelegate.unwrap((IntentionAction)action);
        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"IntentionActionDelegate.unwrap(action)");
        unwrapped = v15;
        if (unwrapped instanceof QuickFixWrapper) {
            v16 = ((QuickFixWrapper)unwrapped).getFix();
            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"unwrapped.fix");
            v17 = (FileModifier)v16;
        } else {
            v17 = (FileModifier)unwrapped;
        }
        actionClass = Reflection.getOrCreateKotlinClass(v17.getClass()).getQualifiedName();
        IntentionPreviewComputable.LOG.error("Intention preview fallback is used for action " + actionClass + '|' + action.getFamilyName());
        action.invoke(this.project, (Editor)editorCopy, psiFileCopy);
lbl87:
        // 3 sources

        ProgressManager.checkCanceled();
        this.originalEditor.getDocument().setReadOnly(writable == false);
        v18 = ComparisonManager.getInstance();
        v19 = origFile.getText();
        v20 = editorCopy.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"editorCopy.document");
        v21 = v18.compareLines(v19, (CharSequence)v20.getText(), ComparisonPolicy.TRIM_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"ComparisonManager.getIns\u2026ogressIndicator.INSTANCE)");
        return new IntentionPreviewDiffResult(psiFileCopy, origFile, v21);
    }

    /*
     * WARNING - void declaration
     */
    private final int mapInjectedOffsetToUnescaped(PsiFile injectedFile, int injectedOffset) {
        void escapedOffset;
        void unescapedOffset;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = 0;
        injectedFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Ref.IntRef)unescapedOffset, (Ref.IntRef)escapedOffset, injectedOffset){
            final /* synthetic */ Ref.IntRef $unescapedOffset;
            final /* synthetic */ Ref.IntRef $escapedOffset;
            final /* synthetic */ int $injectedOffset;

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                String leafText = InjectedLanguageUtil.getUnescapedLeafText(element2, false);
                if (leafText != null) {
                    this.$unescapedOffset.element += leafText.length();
                    this.$escapedOffset.element += element2.getTextLength();
                    if (this.$escapedOffset.element >= this.$injectedOffset) {
                        this.$unescapedOffset.element -= this.$escapedOffset.element - this.$injectedOffset;
                        this.stopWalking();
                    }
                }
                super.visitElement(element2);
            }
            {
                this.$unescapedOffset = $captured_local_variable$0;
                this.$escapedOffset = $captured_local_variable$1;
                this.$injectedOffset = $captured_local_variable$2;
            }
        });
        return unescapedOffset.element;
    }

    public IntentionPreviewComputable(@NotNull Project project, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
        this.project = project;
        this.action = action2;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Inten\u2026ewComputable::class.java)");
        LOG = logger;
        HTML_COMMENT_REGEX = new Regex("<!--.+-->");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable$Companion;", "", "()V", "HTML_COMMENT_REGEX", "Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findCopyIntention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editorCopy", "Lcom/intellij/openapi/editor/Editor;", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "originalAction", "getFixes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching;", "cachedIntentions", "Lcom/intellij/codeInsight/intention/impl/CachedIntentions;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private final Sequence<IntentionActionWithTextCaching> getFixes(CachedIntentions cachedIntentions) {
            Sequence sequence = SequencesKt.sequenceOf((Object[])new IntentionActionWithTextCaching[0]);
            Set<IntentionActionWithTextCaching> set2 = cachedIntentions.getIntentions();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"cachedIntentions.intentions");
            Sequence sequence2 = SequencesKt.plus((Sequence)sequence, (Iterable)set2);
            Set<IntentionActionWithTextCaching> set3 = cachedIntentions.getInspectionFixes();
            Intrinsics.checkNotNullExpressionValue(set3, (String)"cachedIntentions.inspectionFixes");
            Sequence sequence3 = SequencesKt.plus((Sequence)sequence2, (Iterable)set3);
            Set<IntentionActionWithTextCaching> set4 = cachedIntentions.getErrorFixes();
            Intrinsics.checkNotNullExpressionValue(set4, (String)"cachedIntentions.errorFixes");
            return SequencesKt.plus((Sequence)sequence3, (Iterable)set4);
        }

        private final IntentionAction findCopyIntention(Project project, Editor editorCopy, PsiFile psiFileCopy, IntentionAction originalAction) {
            Object v2;
            block1: {
                ShowIntentionsPass.IntentionsInfo intentionsInfo = ShowIntentionsPass.getActionsToShow(editorCopy, psiFileCopy, false);
                Intrinsics.checkNotNullExpressionValue((Object)intentionsInfo, (String)"ShowIntentionsPass.getAc\u2026Copy, psiFileCopy, false)");
                ShowIntentionsPass.IntentionsInfo actionsToShow = intentionsInfo;
                CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project, psiFileCopy, editorCopy, actionsToShow);
                Intrinsics.checkNotNullExpressionValue((Object)cachedIntentions, (String)"CachedIntentions.createA\u2026ditorCopy, actionsToShow)");
                CachedIntentions cachedIntentions2 = cachedIntentions;
                Sequence<IntentionActionWithTextCaching> sequence = this.getFixes(cachedIntentions2);
                boolean bl = false;
                Sequence<IntentionActionWithTextCaching> sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    IntentionActionWithTextCaching it = (IntentionActionWithTextCaching)e;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)originalAction.getText())) continue;
                    v2 = e;
                    break block1;
                }
                v2 = null;
            }
            IntentionActionWithTextCaching intentionActionWithTextCaching = v2;
            return intentionActionWithTextCaching != null ? intentionActionWithTextCaching.getAction() : null;
        }

        private Companion() {
        }

        public static final /* synthetic */ IntentionAction access$findCopyIntention(Companion $this, Project project, Editor editorCopy, PsiFile psiFileCopy, IntentionAction originalAction) {
            return $this.findCopyIntention(project, editorCopy, psiFileCopy, originalAction);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

