/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupManager {
    public static final String PROP_ACTIVE_LOOKUP = "activeLookup";

    public static LookupManager getInstance(@NotNull Project project) {
        if (project == null) {
            LookupManager.$$$reportNull$$$0(0);
        }
        return (LookupManager)project.getService(LookupManager.class);
    }

    @Nullable
    public static LookupEx getActiveLookup(@Nullable Editor editor2) {
        if (editor2 == null) {
            return null;
        }
        Project project = editor2.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        LookupEx lookup2 = LookupManager.getInstance(project).getActiveLookup();
        if (lookup2 == null) {
            return null;
        }
        return lookup2.getTopLevelEditor() == InjectedLanguageEditorUtil.getTopLevelEditor(editor2) ? lookup2 : null;
    }

    @Nullable
    public LookupEx showLookup(@NotNull Editor editor2, LookupElement ... items) {
        if (editor2 == null) {
            LookupManager.$$$reportNull$$$0(1);
        }
        if (items == null) {
            LookupManager.$$$reportNull$$$0(2);
        }
        return this.showLookup(editor2, items, "", new LookupArranger.DefaultArranger());
    }

    @Nullable
    public LookupEx showLookup(@NotNull Editor editor2, LookupElement @NotNull [] items, @NotNull String prefix) {
        if (editor2 == null) {
            LookupManager.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            LookupManager.$$$reportNull$$$0(4);
        }
        if (items == null) {
            LookupManager.$$$reportNull$$$0(5);
        }
        return this.showLookup(editor2, items, prefix, new LookupArranger.DefaultArranger());
    }

    @Nullable
    public abstract LookupEx showLookup(@NotNull Editor var1, LookupElement @NotNull [] var2, @NotNull String var3, @NotNull LookupArranger var4);

    public abstract void hideActiveLookup();

    public static void hideActiveLookup(@NotNull Project project) {
        LookupManager lookupManager;
        if (project == null) {
            LookupManager.$$$reportNull$$$0(6);
        }
        if ((lookupManager = (LookupManager)project.getServiceIfCreated(LookupManager.class)) != null) {
            lookupManager.hideActiveLookup();
        }
    }

    @Nullable
    public abstract LookupEx getActiveLookup();

    @Deprecated
    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1, @NotNull Disposable var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void removePropertyChangeListener(@NotNull PropertyChangeListener var1);

    @NotNull
    public abstract Lookup createLookup(@NotNull Editor var1, LookupElement @NotNull [] var2, @NotNull String var3, @NotNull LookupArranger var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/lookup/LookupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showLookup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hideActiveLookup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

