/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.lang.html.HtmlQuotesFormatPreprocessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlZenCodingGenerator
extends ZenCodingGenerator {
    @Override
    public TemplateImpl generateTemplate(@NotNull TemplateToken token2, boolean hasChildren, @NotNull PsiElement context2) {
        if (token2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(1);
        }
        TemplateImpl tokenTemplate = token2.getTemplate();
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return tokenTemplate;
        }
        String s = this.toString(token2, hasChildren, context2);
        assert (tokenTemplate != null);
        TemplateImpl template = tokenTemplate.copy();
        template.setString(s);
        return template;
    }

    @Override
    public TemplateImpl createTemplateByKey(@NotNull String key, boolean forceSingleTag) {
        if (key == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(2);
        }
        StringBuilder builder2 = new StringBuilder("<");
        builder2.append(key).append('>');
        if (!forceSingleTag && !HtmlUtil.isSingleHtmlTag(key)) {
            builder2.append("$END$</").append(key).append('>');
        }
        return new TemplateImpl("", builder2.toString(), "");
    }

    @NotNull
    private String toString(@NotNull TemplateToken token2, boolean hasChildren, @NotNull PsiElement context2) {
        if (token2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(4);
        }
        CodeStyleSettings.QuoteStyle quoteStyle = XmlEditUtil.quoteStyle(context2.getContainingFile());
        XmlTag tag2 = token2.getXmlTag();
        if (tag2 != null) {
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None) {
                DocumentUtil.writeInRunUndoTransparentAction(() -> HtmlQuotesFormatPreprocessor.HtmlQuotesConverter.runOnElement(quoteStyle, (PsiElement)tag2));
            }
            String string = XmlZenCodingGenerator.replaceQuotesIfNeeded(this.toString(tag2, token2.getAttributes(), hasChildren, context2), context2.getContainingFile());
            if (string == null) {
                XmlZenCodingGenerator.$$$reportNull$$$0(5);
            }
            return string;
        }
        PsiFile file2 = token2.getFile();
        if (quoteStyle != CodeStyleSettings.QuoteStyle.None) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> HtmlQuotesFormatPreprocessor.HtmlQuotesConverter.runOnElement(quoteStyle, (PsiElement)file2));
        }
        String string = XmlZenCodingGenerator.replaceQuotesIfNeeded(file2.getText(), context2.getContainingFile());
        if (string == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static String replaceQuotesIfNeeded(@NotNull String text2, @NotNull PsiFile file2) {
        PsiElement context2;
        if (text2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(8);
        }
        if ((context2 = file2.getContext()) != null) {
            String contextText = context2.getText();
            if (StringUtil.startsWithChar((CharSequence)contextText, (char)'\"')) {
                return StringUtil.escapeChar((String)text2, (char)'\"');
            }
            if (StringUtil.startsWithChar((CharSequence)contextText, (char)'\'')) {
                return StringUtil.escapeChar((String)text2, (char)'\'');
            }
        }
        return text2;
    }

    public abstract String toString(@NotNull XmlTag var1, @NotNull Map<String, String> var2, boolean var3, @NotNull PsiElement var4);

    @NotNull
    public abstract String buildAttributesString(@NotNull Map<String, String> var1, boolean var2, int var3, int var4, @Nullable String var5);

    @Override
    public abstract boolean isMyContext(@NotNull CustomTemplateCallback var1, boolean var2);

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback2) {
        if (callback2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(9);
        }
        Editor editor2 = callback2.getEditor();
        int currentOffset = editor2.getCaretModel().getOffset();
        int startOffset = Math.min(editor2.getDocument().getLineStartOffset(editor2.getDocument().getLineNumber(currentOffset)), currentOffset);
        CharSequence documentText2 = editor2.getDocument().getCharsSequence();
        PsiElement prevVisibleLeaf = callback2.getContext();
        while (prevVisibleLeaf != null) {
            TextRange textRange = prevVisibleLeaf.getTextRange();
            int endOffset = textRange.getEndOffset();
            if (endOffset <= currentOffset) {
                if (endOffset <= startOffset) break;
                IElementType prevType = prevVisibleLeaf.getNode().getElementType();
                if (prevType == XmlTokenType.XML_TAG_END || prevType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    startOffset = endOffset;
                    break;
                }
            }
            prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)prevVisibleLeaf);
        }
        if (startOffset < 0 || currentOffset > documentText2.length() || currentOffset < startOffset) {
            Logger.getInstance(this.getClass()).error("Error while calculating emmet abbreviation. Offset: " + currentOffset + "; Start: " + startOffset, new Attachment[]{AttachmentFactory.createAttachment(editor2.getDocument())});
            return null;
        }
        String key = this.computeKey(documentText2.subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key) && ZenCodingTemplate.checkTemplateKey(key, callback2, this) ? key : null;
    }

    @Override
    public void disableEmmet() {
        EmmetOptions.getInstance().setEmmetEnabled(false);
    }

    @Override
    public boolean isHtml(@NotNull CustomTemplateCallback callback2) {
        if (callback2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(10);
        }
        return ZenCodingUtil.isHtml(callback2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateByKey";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceQuotesIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

