/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerationNode
extends UserDataHolderBase {
    private final TemplateToken myTemplateToken;
    private final List<GenerationNode> myChildren = new ArrayList<GenerationNode>();
    private final int myNumberInIteration;
    private final int myTotalIterations;
    private String mySurroundedText;
    private final boolean myInsertSurroundedTextAtTheEnd;
    private final boolean myInsertNewLineBetweenNodes;
    private GenerationNode myParent;
    private boolean myContainsSurroundedTextMarker = false;
    private static final Pattern ATTRIBUTE_VARIABLE_PATTERN = Pattern.compile("\\$[A-z_0-9]+\\$");
    private static final Pattern HREF_PATTERN = Pattern.compile("^(?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$])", 2);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,5}$");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^([A-z]+:)?//");

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        this(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, false);
    }

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent, boolean insertNewLineBetweenNodes) {
        this.myTemplateToken = templateToken;
        this.myNumberInIteration = numberInIteration;
        this.myTotalIterations = totalIterations;
        this.mySurroundedText = surroundedText;
        this.myInsertSurroundedTextAtTheEnd = insertSurroundedTextAtTheEnd;
        this.myInsertNewLineBetweenNodes = insertNewLineBetweenNodes;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isInsertNewLineBetweenNodes() {
        return this.myInsertNewLineBetweenNodes;
    }

    public List<GenerationNode> getChildren() {
        return this.myChildren;
    }

    public void addChild(GenerationNode child2) {
        child2.setParent(this);
        this.myChildren.add(child2);
    }

    public void addChildren(Collection<? extends GenerationNode> children2) {
        for (GenerationNode generationNode : children2) {
            this.addChild(generationNode);
        }
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    private boolean isBlockTag() {
        XmlTag tag2;
        if (this.myTemplateToken != null && (tag2 = this.myTemplateToken.getXmlTag()) != null) {
            return HtmlUtil.isHtmlBlockTagL(tag2.getName());
        }
        return false;
    }

    @NotNull
    public TemplateImpl generate(@NotNull CustomTemplateCallback callback2, @Nullable ZenCodingGenerator generator2, @NotNull Collection<ZenCodingFilter> filters, boolean insertSurroundedText, int segmentsLimit) {
        Map<String, String> predefinedValues;
        TemplateImpl parentTemplate;
        boolean hasChildren;
        String indentStr;
        if (callback2 == null) {
            GenerationNode.$$$reportNull$$$0(0);
        }
        if (filters == null) {
            GenerationNode.$$$reportNull$$$0(1);
        }
        this.myContainsSurroundedTextMarker = !insertSurroundedText || !this.myInsertSurroundedTextAtTheEnd;
        GenerationNode generationNode = this;
        boolean shouldNotReformatTemplate = false;
        boolean oneLineTemplateExpanding = false;
        for (ZenCodingFilter filter : filters) {
            generationNode = filter.filterNode(generationNode);
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            shouldNotReformatTemplate = true;
            oneLineTemplateExpanding = true;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)callback2.getFile());
        if (callback2.isInInjectedFragment()) {
            Editor editor2 = callback2.getEditor();
            Document document = editor2.getDocument();
            if (document instanceof DocumentWindow && ((DocumentWindow)document).isOneLine()) {
                oneLineTemplateExpanding = true;
                filters.add(new SingleLineEmmetFilter());
            }
            indentStr = "";
        } else if (settings.useTabCharacter(callback2.getFileType())) {
            indentStr = "\t";
        } else {
            int tabSize = settings.getTabSize(callback2.getFileType());
            indentStr = StringUtil.repeatSymbol((char)' ', (int)tabSize);
        }
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        boolean bl = hasChildren = this.myChildren.size() > 0;
        if (generator2 instanceof XmlZenCodingGenerator) {
            TemplateToken xmlTemplateToken = this.myTemplateToken;
            parentTemplate = this.invokeXmlTemplate(xmlTemplateToken, callback2, generator2, hasChildren);
            predefinedValues = this.buildPredefinedValues(xmlTemplateToken.getAttributes(), (XmlZenCodingGenerator)generator2, hasChildren);
        } else {
            parentTemplate = GenerationNode.invokeTemplate(this.myTemplateToken, hasChildren, callback2, generator2);
            predefinedValues = null;
        }
        String s = parentTemplate.getString();
        for (ZenCodingFilter filter : filters) {
            s = filter.filterText(s, this.myTemplateToken);
        }
        parentTemplate = parentTemplate.copy();
        parentTemplate.setString(s);
        String txt = hasChildren || this.myContainsSurroundedTextMarker ? null : this.mySurroundedText;
        parentTemplate = GenerationNode.expandTemplate(parentTemplate, predefinedValues, txt, segmentsLimit);
        int offset = builder2.insertTemplate(0, parentTemplate, null);
        int newOffset = GenerationNode.gotoChild(callback2.getProject(), builder2.getText(), offset, 0, builder2.length());
        if (offset < builder2.length() && newOffset != offset) {
            end = offset;
        }
        offset = newOffset;
        if (end == -1 && offset < builder2.length() && this.myChildren.size() == 0) {
            end = offset;
        }
        LiveTemplateBuilder.Marker marker = offset < builder2.length() ? builder2.createMarker(offset) : null;
        int myChildrenSize = this.myChildren.size();
        for (int i2 = 0; i2 < myChildrenSize; ++i2) {
            GenerationNode child2 = this.myChildren.get(i2);
            TemplateImpl childTemplate = child2.generate(callback2, generator2, filters, !this.myContainsSurroundedTextMarker, segmentsLimit);
            boolean blockTag = child2.isBlockTag();
            if (!oneLineTemplateExpanding && blockTag && !GenerationNode.isNewLineBefore(builder2.getText(), offset)) {
                builder2.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            int e = builder2.insertTemplate(offset, childTemplate, null);
            int n = offset = marker != null ? marker.getEndOffset() : builder2.length();
            if (!oneLineTemplateExpanding && (blockTag && !GenerationNode.isNewLineAfter(builder2.getText(), offset) || this.myInsertNewLineBetweenNodes)) {
                builder2.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            if (end != -1 || e >= offset) continue;
            end = e;
        }
        if (shouldNotReformatTemplate) {
            builder2.setIsToReformat(false);
        }
        TemplateImpl templateImpl = builder2.buildTemplate();
        if (templateImpl == null) {
            GenerationNode.$$$reportNull$$$0(2);
        }
        return templateImpl;
    }

    private static TemplateImpl invokeTemplate(@NotNull TemplateToken token2, boolean hasChildren, CustomTemplateCallback callback2, @Nullable ZenCodingGenerator generator2) {
        if (token2 == null) {
            GenerationNode.$$$reportNull$$$0(3);
        }
        TemplateImpl template = token2.getTemplate();
        if (generator2 != null) {
            assert (template != null);
            template = generator2.generateTemplate(token2, hasChildren, callback2.getContext());
            GenerationNode.removeVariablesWhichHasNoSegment(template);
        }
        return template;
    }

    private TemplateImpl invokeXmlTemplate(TemplateToken token2, CustomTemplateCallback callback2, @Nullable ZenCodingGenerator generator2, boolean hasChildren) {
        ZenCodingGenerator zenCodingGenerator = (ZenCodingGenerator)ObjectUtils.notNull((Object)generator2, (Object)XmlZenCodingGeneratorImpl.INSTANCE);
        Map<String, String> attributes2 = token2.getAttributes();
        TemplateImpl template = token2.getTemplate();
        assert (template != null);
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)callback2.getProject());
        PsiFile dummyFile = fileFactory.createFileFromText("dummy.html", callback2.getFile().getLanguage(), (CharSequence)token2.getTemplateText(), false, true);
        XmlTag tag2 = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)dummyFile, XmlTag.class);
        if (tag2 != null) {
            if (EmmetOptions.getInstance().isHrefAutoDetectEnabled() && StringUtil.isNotEmpty((String)this.mySurroundedText)) {
                boolean isEmptyLinkTag;
                boolean bl = isEmptyLinkTag = "a".equalsIgnoreCase(tag2.getName()) && GenerationNode.isEmptyValue(tag2.getAttributeValue("href"));
                if (!hasChildren && isEmptyLinkTag) {
                    if (HREF_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes2.put("href", (String)(PROTOCOL_PATTERN.matcher(this.mySurroundedText).find() ? this.mySurroundedText.trim() : "http://" + this.mySurroundedText.trim()));
                    } else if (EMAIL_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes2.put("href", "mailto:" + this.mySurroundedText.trim());
                    }
                }
            }
            for (Map.Entry<String, String> attribute : attributes2.entrySet()) {
                if (!Strings.isEmpty((String)attribute.getValue())) continue;
                template.addVariable(GenerationNode.prepareVariableName(attribute.getKey()), "", "", true);
            }
            XmlTag tag1 = hasChildren ? GenerationNode.expandEmptyTagIfNecessary(tag2) : tag2;
            this.setAttributeValues(tag1, attributes2, callback2, zenCodingGenerator.isHtml(callback2));
            token2.setTemplateText(tag1.getContainingFile().getText(), callback2);
        }
        template = zenCodingGenerator.generateTemplate(token2, hasChildren, callback2.getContext());
        GenerationNode.removeVariablesWhichHasNoSegment(template);
        return template;
    }

    private static String prepareVariableName(@NotNull String attributeName) {
        if (attributeName == null) {
            GenerationNode.$$$reportNull$$$0(4);
        }
        char[] toReplace = new char[]{'$', '-', '+', ':'};
        StringBuilder builder2 = new StringBuilder(attributeName.length());
        for (int i2 = 0; i2 < attributeName.length(); ++i2) {
            char c = attributeName.charAt(i2);
            boolean replaced = false;
            for (char aToReplace : toReplace) {
                if (c != aToReplace) continue;
                builder2.append('_');
                replaced = true;
                break;
            }
            if (replaced) continue;
            builder2.append(c);
        }
        return builder2.toString();
    }

    @NotNull
    private static TemplateImpl expandTemplate(@NotNull TemplateImpl template, Map<String, String> predefinedVarValues, String surroundedText, int segmentsLimit) {
        if (template == null) {
            GenerationNode.$$$reportNull$$$0(5);
        }
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        if (predefinedVarValues == null && surroundedText == null) {
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                GenerationNode.$$$reportNull$$$0(6);
            }
            return templateImpl;
        }
        int offset = builder2.insertTemplate(0, template, predefinedVarValues);
        if (surroundedText != null) {
            builder2.insertText(offset, surroundedText, true);
            builder2.setIsToReformat(true);
        }
        TemplateImpl templateImpl = builder2.buildTemplate();
        if (templateImpl == null) {
            GenerationNode.$$$reportNull$$$0(7);
        }
        return templateImpl;
    }

    @NotNull
    private static XmlTag expandEmptyTagIfNecessary(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            GenerationNode.$$$reportNull$$$0(8);
        }
        StringBuilder builder2 = new StringBuilder();
        boolean flag = false;
        for (PsiElement child2 : tag2.getChildren()) {
            if (child2 instanceof XmlToken && XmlTokenType.XML_EMPTY_ELEMENT_END.equals(((XmlToken)child2).getTokenType())) {
                flag = true;
                break;
            }
            builder2.append(child2.getText());
        }
        if (flag) {
            builder2.append("></").append(tag2.getName()).append('>');
            XmlTag xmlTag = XmlElementFactory.getInstance((Project)tag2.getProject()).createTagFromText((CharSequence)builder2.toString(), (Language)XMLLanguage.INSTANCE);
            if (xmlTag == null) {
                GenerationNode.$$$reportNull$$$0(9);
            }
            return xmlTag;
        }
        XmlTag xmlTag = tag2;
        if (xmlTag == null) {
            GenerationNode.$$$reportNull$$$0(10);
        }
        return xmlTag;
    }

    private static int gotoChild(Project project, CharSequence text2, int offset, int start2, int end) {
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (FileType)XmlFileType.INSTANCE, text2, LocalTimeCounter.currentTime(), false);
        PsiElement element2 = file2.findElementAt(offset);
        if (offset < end && element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return offset;
        }
        int newOffset = -1;
        XmlTag tag2 = (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)start2, (int)end, XmlTag.class);
        if (tag2 != null) {
            for (PsiElement child2 : tag2.getChildren()) {
                if (!(child2 instanceof XmlToken) || ((XmlToken)child2).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                newOffset = child2.getTextOffset();
            }
        }
        if (newOffset >= 0) {
            return newOffset;
        }
        return offset;
    }

    private static void removeVariablesWhichHasNoSegment(TemplateImpl template) {
        int i2;
        HashSet<String> segments = new HashSet<String>();
        for (i2 = 0; i2 < template.getSegmentsCount(); ++i2) {
            segments.add(template.getSegmentName(i2));
        }
        for (i2 = template.getVariableCount() - 1; i2 >= 0; --i2) {
            String varName = template.getVariableNameAt(i2);
            if (!segments.contains(varName)) {
                template.removeVariable(i2);
                continue;
            }
            segments.remove(varName);
        }
    }

    @Nullable
    private Map<String, String> buildPredefinedValues(@NotNull Map<String, String> attributes2, @Nullable XmlZenCodingGenerator generator2, boolean hasChildren) {
        Object attributesString;
        if (attributes2 == null) {
            GenerationNode.$$$reportNull$$$0(11);
        }
        if (generator2 == null) {
            return Collections.emptyMap();
        }
        for (String value2 : attributes2.values()) {
            if (!ZenCodingUtil.containsSurroundedTextMarker(value2)) continue;
            this.myContainsSurroundedTextMarker = true;
            break;
        }
        attributesString = ((String)(attributesString = generator2.buildAttributesString(attributes2, hasChildren, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText))).length() > 0 ? " " + (String)attributesString : null;
        HashMap<String, Object> predefinedValues = null;
        if (attributesString != null) {
            predefinedValues = new HashMap<String, Object>();
            predefinedValues.put("ATTRS", attributesString);
        }
        return predefinedValues;
    }

    private void setAttributeValues(@NotNull XmlTag tag2, @NotNull Map<String, String> attributes2, @NotNull CustomTemplateCallback callback2, boolean isHtml) {
        String defaultAttributeValue;
        if (tag2 == null) {
            GenerationNode.$$$reportNull$$$0(12);
        }
        if (attributes2 == null) {
            GenerationNode.$$$reportNull$$$0(13);
        }
        if (callback2 == null) {
            GenerationNode.$$$reportNull$$$0(14);
        }
        if ((defaultAttributeValue = attributes2.get("%default")) != null) {
            String attributeName;
            attributes2.remove("%default");
            List xmlAttributes = ContainerUtil.filter((Object[])tag2.getAttributes(), attribute -> !attributes2.containsKey(attribute.getLocalName()));
            XmlAttribute defaultAttribute = GenerationNode.findImpliedAttribute(xmlAttributes);
            if (defaultAttribute == null) {
                defaultAttribute = GenerationNode.findEmptyAttribute(xmlAttributes);
            }
            if (defaultAttribute != null && (attributeName = defaultAttribute.getName()).length() > 1) {
                String oldValue;
                if (GenerationNode.isImpliedAttribute(attributeName)) {
                    defaultAttribute = (XmlAttribute)defaultAttribute.setName(attributeName.substring(1));
                }
                if ((oldValue = defaultAttribute.getValue()) != null && StringUtil.containsChar((String)oldValue, (char)'|')) {
                    defaultAttribute.setValue(StringUtil.replace((String)oldValue, (String)"|", (String)defaultAttributeValue));
                } else {
                    defaultAttribute.setValue(defaultAttributeValue);
                }
            }
        }
        for (XmlAttribute xmlAttribute : tag2.getAttributes()) {
            String attributeName = xmlAttribute.getName();
            XmlAttributeValue xmlAttributeValueElement = xmlAttribute.getValueElement();
            if (xmlAttributeValueElement != null && !attributes2.containsKey(attributeName) || GenerationNode.isImpliedAttribute(attributeName) || TemplateImplUtil.isValidVariable(attributeName)) continue;
            String attributeValue = StringUtil.notNullize((String)attributes2.get(attributeName), (String)StringUtil.notNullize((String)xmlAttribute.getValue()));
            if (ZenCodingUtil.containsSurroundedTextMarker(attributeValue)) {
                this.myContainsSurroundedTextMarker = true;
            }
            if (isHtml && GenerationNode.isBooleanAttribute(attributeValue, xmlAttribute, callback2)) {
                if (HtmlUtil.isShortNotationOfBooleanAttributePreferred()) {
                    PsiElement prevSibling;
                    if (xmlAttributeValueElement == null || (prevSibling = xmlAttributeValueElement.getPrevSibling()) == null || !prevSibling.textMatches((CharSequence)"=")) continue;
                    xmlAttribute.deleteChildRange(prevSibling, (PsiElement)xmlAttributeValueElement);
                    continue;
                }
                if (xmlAttributeValueElement == null) {
                    xmlAttribute.delete();
                }
                tag2.setAttribute(attributeName, attributeName);
                continue;
            }
            if (xmlAttributeValueElement == null) {
                xmlAttribute.delete();
            }
            tag2.setAttribute(attributeName, (String)(StringUtil.isEmpty((String)attributeValue) ? "$" + GenerationNode.prepareVariableName(attributeName) + "$" : ZenCodingUtil.getValue(attributeValue, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText)));
        }
        for (XmlAttribute xmlAttribute : tag2.getAttributes()) {
            String xmlAttributeLocalName = xmlAttribute.getLocalName();
            if (xmlAttribute.getValue() == null || !GenerationNode.isImpliedAttribute(xmlAttributeLocalName)) continue;
            xmlAttribute.delete();
        }
    }

    private static boolean isBooleanAttribute(@Nullable String attributeValue, @NotNull XmlAttribute xmlAttribute, @NotNull CustomTemplateCallback callback2) {
        if (xmlAttribute == null) {
            GenerationNode.$$$reportNull$$$0(15);
        }
        if (callback2 == null) {
            GenerationNode.$$$reportNull$$$0(16);
        }
        if ("%boolean".equals(attributeValue)) {
            return true;
        }
        if (StringUtil.isEmpty((String)attributeValue)) {
            XmlAttributeDescriptor descriptor2 = xmlAttribute.getDescriptor();
            return descriptor2 != null && HtmlUtil.isBooleanAttribute(descriptor2, callback2.getContext());
        }
        return false;
    }

    private static boolean isImpliedAttribute(String xmlAttributeLocalName) {
        return StringUtil.startsWithChar((CharSequence)xmlAttributeLocalName, (char)'!');
    }

    private static boolean isEmptyValue(String attributeValue) {
        return attributeValue != null && (attributeValue.isEmpty() || ATTRIBUTE_VARIABLE_PATTERN.matcher(attributeValue).matches());
    }

    @Nullable
    private static XmlAttribute findImpliedAttribute(@NotNull List<? extends XmlAttribute> attributes2) {
        if (attributes2 == null) {
            GenerationNode.$$$reportNull$$$0(17);
        }
        for (XmlAttribute xmlAttribute : attributes2) {
            if (xmlAttribute.getValueElement() == null || !GenerationNode.isImpliedAttribute(xmlAttribute.getLocalName())) continue;
            return xmlAttribute;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute findEmptyAttribute(@NotNull List<? extends XmlAttribute> attributes2) {
        if (attributes2 == null) {
            GenerationNode.$$$reportNull$$$0(18);
        }
        for (XmlAttribute xmlAttribute : attributes2) {
            String attributeValue = xmlAttribute.getValue();
            if (!GenerationNode.isEmptyValue(attributeValue)) continue;
            return xmlAttribute;
        }
        return null;
    }

    private static boolean isNewLineBefore(CharSequence text2, int offset) {
        int i2;
        for (i2 = offset - 1; i2 >= 0 && Character.isWhitespace(text2.charAt(i2)); --i2) {
            if (text2.charAt(i2) != '\n') continue;
            return true;
        }
        return i2 < 0;
    }

    private static boolean isNewLineAfter(CharSequence text2, int offset) {
        int i2;
        for (i2 = offset; i2 < text2.length() && Character.isWhitespace(text2.charAt(i2)); ++i2) {
            if (text2.charAt(i2) != '\n') continue;
            return true;
        }
        return i2 == text2.length();
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    public String getSurroundedText() {
        return this.mySurroundedText;
    }

    public void setSurroundedText(String surroundedText) {
        this.mySurroundedText = surroundedText;
    }

    public GenerationNode getParent() {
        return this.myParent;
    }

    public void setParent(GenerationNode parent) {
        this.myParent = parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/nodes/GenerationNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/nodes/GenerationNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTemplate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expandEmptyTagIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareVariableName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandEmptyTagIfNecessary";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildPredefinedValues";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeValues";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findImpliedAttribute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findEmptyAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

