/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.MacroLexer;
import com.intellij.codeInsight.template.impl.MacroTokenType;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
public final class MacroParser {
    private static final Logger LOG = Logger.getInstance(MacroParser.class);

    @NotNull
    public static Expression parse(@Nullable String expression) {
        if (StringUtil.isEmpty((String)expression)) {
            return new ConstantNode("");
        }
        MacroLexer lexer = new MacroLexer();
        lexer.start(expression);
        MacroParser.skipWhitespaces((Lexer)lexer);
        Expression expression2 = MacroParser.parseMacro((Lexer)lexer, expression);
        if (expression2 == null) {
            MacroParser.$$$reportNull$$$0(0);
        }
        return expression2;
    }

    private static void advance(Lexer lexer) {
        lexer.advance();
        MacroParser.skipWhitespaces(lexer);
    }

    private static void skipWhitespaces(Lexer lexer) {
        while (lexer.getTokenType() == MacroTokenType.WHITE_SPACE) {
            lexer.advance();
        }
    }

    private static String getString(Lexer lexer, String expression) {
        return expression.substring(lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private static Expression parseMacro(Lexer lexer, String expression) {
        IElementType tokenType = lexer.getTokenType();
        String token2 = MacroParser.getString(lexer, expression);
        if (tokenType == MacroTokenType.STRING_LITERAL) {
            MacroParser.advance(lexer);
            return new ConstantNode(MacroParser.parseStringLiteral(token2));
        }
        if (tokenType != MacroTokenType.IDENTIFIER) {
            LOG.info("Bad macro syntax: Not identifier: " + token2);
            MacroParser.advance(lexer);
            return new ConstantNode("");
        }
        List<Macro> macros = MacroFactory.getMacros(token2);
        if (macros.isEmpty()) {
            return MacroParser.parseVariable(lexer, expression);
        }
        MacroParser.advance(lexer);
        MacroCallNode macroCallNode = new MacroCallNode(macros.get(0));
        if (lexer.getTokenType() == null) {
            return macroCallNode;
        }
        if (lexer.getTokenType() != MacroTokenType.LPAREN) {
            return macroCallNode;
        }
        MacroParser.advance(lexer);
        MacroParser.parseParameters(macroCallNode, lexer, expression);
        if (lexer.getTokenType() != MacroTokenType.RPAREN) {
            LOG.info("Bad macro syntax: ) expected: " + expression);
        }
        MacroParser.advance(lexer);
        return macroCallNode;
    }

    private static String parseStringLiteral(String token2) {
        if (token2.length() < 2) {
            return "";
        }
        StringBuilder sb = new StringBuilder(token2.length() - 2);
        for (int i2 = 1; i2 < token2.length() - 1; ++i2) {
            char c = token2.charAt(i2);
            if (c == '\\') {
                if ((c = token2.charAt(++i2)) == 'n') {
                    sb.append('\n');
                    continue;
                }
                if (c == 't') {
                    sb.append('\t');
                    continue;
                }
                if (c == 'f') {
                    sb.append('\f');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void parseParameters(MacroCallNode macroCallNode, Lexer lexer, String expression) {
        if (lexer.getTokenType() != MacroTokenType.RPAREN) {
            while (lexer.getTokenType() != null) {
                Expression node2 = MacroParser.parseMacro(lexer, expression);
                macroCallNode.addParameter(node2);
                if (lexer.getTokenType() != MacroTokenType.COMMA) break;
                MacroParser.advance(lexer);
            }
        }
    }

    private static Expression parseVariable(Lexer lexer, String expression) {
        String variableName = MacroParser.getString(lexer, expression);
        MacroParser.advance(lexer);
        if (lexer.getTokenType() == null) {
            if ("END".equals(variableName)) {
                return new EmptyNode();
            }
            return new VariableNode(variableName, null);
        }
        if (lexer.getTokenType() != MacroTokenType.EQ) {
            return new VariableNode(variableName, null);
        }
        MacroParser.advance(lexer);
        Expression node2 = MacroParser.parseMacro(lexer, expression);
        return new VariableNode(variableName, node2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/MacroParser", "parse"));
    }
}

