/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.offlineViewer.OfflineViewParseUtil;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ExceptionUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewOfflineResultsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ViewOfflineResultsAction.class);

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = event.getPresentation();
        Project project = event.getProject();
        presentation2.setEnabled(project != null);
        presentation2.setVisible(ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((project = event.getProject()) != null);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, false){

            public Icon getIcon(VirtualFile file2) {
                if (file2.isDirectory() && file2.findChild(".descriptions." + StdFileTypes.XML.getDefaultExtension()) != null) {
                    return AllIcons.Nodes.InspectionResults;
                }
                return super.getIcon(file2);
            }
        }.withFileFilter(f -> f.isDirectory() || StdFileTypes.XML.getDefaultExtension().equals(f.getExtension())).withTitle(InspectionsBundle.message((String)"view.offline.inspections.select.path.title", (Object[])new Object[0])).withDescription(InspectionsBundle.message((String)"view.offline.inspections.select.path.description", (Object[])new Object[0]));
        final VirtualFile virtualFile2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, null);
        if (virtualFile2 == null) {
            return;
        }
        final HashMap resMap = new HashMap();
        final String[] profileName = new String[1];
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, InspectionsBundle.message((String)"parsing.inspections.dump.progress.title", (Object[])new Object[0]), true, new PerformAnalysisInBackgroundOption(project)){

            public void run(@NotNull ProgressIndicator indicator2) {
                VirtualFile[] virtualFileArray;
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile2});
                if (virtualFile2.isDirectory()) {
                    virtualFileArray = virtualFile2.getChildren();
                } else {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = virtualFile2;
                }
                VirtualFile[] files2 = virtualFileArray;
                try {
                    for (VirtualFile inspectionFile : files2) {
                        if (inspectionFile.isDirectory()) continue;
                        String shortName = inspectionFile.getNameWithoutExtension();
                        String extension2 = inspectionFile.getExtension();
                        Path inspectionIoFile = inspectionFile.toNioPath();
                        try {
                            if (shortName.equals(".descriptions")) {
                                profileName[0] = (String)ReadAction.compute(() -> OfflineViewParseUtil.parseProfileName(inspectionIoFile));
                                continue;
                            }
                            if (!StdFileTypes.XML.getDefaultExtension().equals(extension2)) continue;
                            resMap.put(shortName, (Map)ReadAction.compute(() -> OfflineViewParseUtil.parse(inspectionIoFile)));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Can't read file: " + inspectionFile.getName(), e);
                        }
                    }
                    if (profileName[0] == null) {
                        profileName[0] = virtualFile2.getNameWithoutExtension();
                    }
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)ExceptionUtil.getThrowableText((Throwable)e), (String)InspectionsBundle.message((String)"offline.view.parse.exception.title", (Object[])new Object[0])));
                    throw new ProcessCanceledException((Throwable)e);
                }
            }

            public void onSuccess() {
                if (resMap.isEmpty()) {
                    return;
                }
                DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                    String name2 = profileName[0];
                    LOG.assertTrue(name2 != null);
                    ViewOfflineResultsAction.showOfflineView(project, name2, resMap, InspectionsBundle.message((String)"offline.view.title", (Object[])new Object[0]) + " (" + name2 + ")");
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/actions/ViewOfflineResultsAction$2", "run"));
            }
        });
    }

    public static InspectionResultsView showOfflineView(@NotNull Project project, @Nullable String profileName, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull @NlsContexts.TabTitle String title2) {
        InspectionProfileImpl profile;
        if (project == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(2);
        }
        if (resMap == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(3);
        }
        if (title2 == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(4);
        }
        if (profileName != null) {
            profile = InspectionProjectProfileManager.getInstance(project).getProfile(profileName, false);
            if (profile == null) {
                profile = InspectionProfileManager.getInstance().getProfile(profileName, false);
            }
        } else {
            profile = null;
        }
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(profileName != null ? profileName : "Server Side"){

            @Override
            @NotNull
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element2) {
                if (key == null) {
                    3.$$$reportNull$$$0(0);
                }
                HighlightDisplayLevel highlightDisplayLevel = InspectionProfileManager.getInstance().getCurrentProfile().getErrorLevel(key, element2);
                if (highlightDisplayLevel == null) {
                    3.$$$reportNull$$$0(1);
                }
                return highlightDisplayLevel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/actions/ViewOfflineResultsAction$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/actions/ViewOfflineResultsAction$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getErrorLevel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getErrorLevel";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (profile != null) {
            inspectionProfile.copyFrom(profile);
        }
        for (Tools tool : inspectionProfile.getAllEnabledInspectionTools(project)) {
            String id2 = tool.getShortName();
            if (resMap.containsKey(id2)) continue;
            ((ToolsImpl)tool).setEnabled(false);
        }
        for (String id3 : resMap.keySet()) {
            if (inspectionProfile.getToolsOrNull(id3, project) == null) continue;
            inspectionProfile.enableTool(id3, project);
        }
        return ViewOfflineResultsAction.showOfflineView(project, resMap, inspectionProfile, title2);
    }

    @NotNull
    public static InspectionResultsView showOfflineView(@NotNull Project project, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull InspectionProfileImpl inspectionProfile, @NotNull @NlsContexts.TabTitle String title2) {
        if (project == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(5);
        }
        if (resMap == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(6);
        }
        if (inspectionProfile == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(7);
        }
        if (title2 == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(8);
        }
        AnalysisScope scope2 = new AnalysisScope(project);
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl context2 = managerEx.createNewGlobalContext();
        context2.setExternalProfile(inspectionProfile);
        context2.setCurrentScope(scope2);
        context2.initializeTools(new ArrayList<Tools>(), new ArrayList<Tools>(), new ArrayList());
        InspectionResultsView view = new InspectionResultsView(context2, new OfflineInspectionRVContentProvider(resMap));
        ((RefManagerImpl)context2.getRefManager()).startOfflineView();
        context2.addView(view, title2, true);
        view.update();
        InspectionResultsView inspectionResultsView = view;
        if (inspectionResultsView == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(9);
        }
        return inspectionResultsView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resMap";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/ViewOfflineResultsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/ViewOfflineResultsAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "showOfflineView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showOfflineView";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

