/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class LoopAnalyzer {
    LoopAnalyzer() {
    }

    static int[] calcInLoop(ControlFlow controlFlow) {
        int[] loop = new int[controlFlow.getInstructionCount()];
        MyGraph graph2 = new MyGraph(controlFlow);
        DFSTBuilder builder2 = new DFSTBuilder((Graph)graph2);
        IntList sccs = builder2.getSCCs();
        int tNumber = 0;
        int component2 = 0;
        IntListIterator iterator2 = sccs.iterator();
        while (iterator2.hasNext()) {
            int size = iterator2.nextInt();
            int value2 = size > 1 ? ++component2 : 0;
            for (int i2 = 0; i2 < size; ++i2) {
                Instruction instruction = (Instruction)builder2.getNodeByTNumber(tNumber + i2);
                loop[instruction.getIndex()] = value2;
            }
            tNumber += size;
        }
        return loop;
    }

    private static final class MyGraph
    implements Graph<Instruction> {
        @NotNull
        private final ControlFlow myFlow;
        private final Instruction[] myInstructions;
        private final Int2ObjectMap<int[]> myIns;

        private MyGraph(@NotNull ControlFlow flow2) {
            if (flow2 == null) {
                MyGraph.$$$reportNull$$$0(0);
            }
            this.myIns = new Int2ObjectOpenHashMap();
            this.myFlow = flow2;
            for (Instruction instruction : this.myInstructions = flow2.getInstructions()) {
                int[] to;
                int fromIndex = instruction.getIndex();
                for (int toIndex : to = instruction.getSuccessorIndexes()) {
                    int[] froms = (int[])this.myIns.get(toIndex);
                    froms = froms == null ? new int[]{fromIndex} : ArrayUtil.append((int[])froms, (int)fromIndex);
                    this.myIns.put(toIndex, (Object)froms);
                }
            }
        }

        @NotNull
        public Collection<Instruction> getNodes() {
            List<Instruction> list2 = Arrays.asList(this.myFlow.getInstructions());
            if (list2 == null) {
                MyGraph.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        public Iterator<Instruction> getIn(Instruction n) {
            int[] ins = (int[])this.myIns.get(n.getIndex());
            return this.indicesToInstructions(ins);
        }

        @NotNull
        public Iterator<Instruction> getOut(Instruction instruction) {
            int[] next = instruction.getSuccessorIndexes();
            return this.indicesToInstructions(next);
        }

        @NotNull
        private Iterator<Instruction> indicesToInstructions(int[] next) {
            if (next == null) {
                Iterator<Instruction> iterator2 = Collections.emptyIterator();
                if (iterator2 == null) {
                    MyGraph.$$$reportNull$$$0(2);
                }
                return iterator2;
            }
            ArrayList<Instruction> out = new ArrayList<Instruction>(next.length);
            for (int i2 : next) {
                out.add(this.myInstructions[i2]);
            }
            Iterator<Instruction> iterator3 = out.iterator();
            if (iterator3 == null) {
                MyGraph.$$$reportNull$$$0(3);
            }
            return iterator3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/lang/ir/LoopAnalyzer$MyGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/lang/ir/LoopAnalyzer$MyGraph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "indicesToInstructions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

