/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.CleanupProblems;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionEventsKt;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.DelegatedInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TripleFunction;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GlobalInspectionContextImpl
extends GlobalInspectionContextEx {
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextImpl.class);
    @TestOnly
    public static volatile boolean TESTING_VIEW;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private final NotNullLazyValue<? extends ContentManager> myContentManager;
    private volatile InspectionResultsView myView;
    private Content myContent;
    private volatile boolean myViewClosed;
    private long myInspectionStartedTimestamp;
    private final ConcurrentMap<InspectionToolWrapper<?, ?>, InspectionToolPresentation> myPresentationMap;
    private boolean forceInspectAllScope;
    private final List<ProgressIndicator> dependentIndicators;
    private static final VirtualFile TOMBSTONE;
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT;

    public GlobalInspectionContextImpl(@NotNull Project project, @NotNull NotNullLazyValue<? extends ContentManager> contentManager2) {
        if (project == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(0);
        }
        if (contentManager2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(1);
        }
        super(project);
        this.myViewClosed = true;
        this.myPresentationMap = new ConcurrentHashMap();
        this.dependentIndicators = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myContentManager = contentManager2;
    }

    @NotNull
    private InspectListener getEventPublisher() {
        InspectListener inspectListener = (InspectListener)this.getProject().getMessageBus().syncPublisher(GlobalInspectionContextEx.INSPECT_TOPIC);
        if (inspectListener == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(2);
        }
        return inspectListener;
    }

    @NotNull
    private ContentManager getContentManager() {
        ContentManager contentManager2 = (ContentManager)this.myContentManager.getValue();
        if (contentManager2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(3);
        }
        return contentManager2;
    }

    public void addView(@NotNull InspectionResultsView view, @NotNull @NlsContexts.TabTitle String title2, boolean isOffline) {
        if (view == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(this.myContent == null, (Object)"GlobalInspectionContext is busy under other view now");
        this.myView = view;
        if (!isOffline) {
            this.myView.setUpdating(true);
        }
        this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title2, false);
        this.myContent.setHelpId("reference.toolWindows.inspections");
        this.myContent.setDisposer((Disposable)this.myView);
        Disposer.register((Disposable)this.myContent, () -> {
            if (this.myView != null) {
                this.close(false);
            }
            this.myContent = null;
        });
        RefManagerImpl.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RefGraphAnnotator>(){

            public void extensionRemoved(@NotNull RefGraphAnnotator graphAnnotator, @NotNull PluginDescriptor pluginDescriptor) {
                if (graphAnnotator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((RefManagerImpl)GlobalInspectionContextImpl.this.getRefManager()).unregisterAnnotator(graphAnnotator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "graphAnnotator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myContent);
        ContentManager contentManager2 = this.getContentManager();
        contentManager2.addContent(this.myContent);
        contentManager2.setSelectedContent(this.myContent);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.getProject());
        ToolWindow toolWindow2 = toolWindowManager.getToolWindow("Problems View");
        if (toolWindow2 == null) {
            toolWindow2 = toolWindowManager.getToolWindow("Inspection Results");
        }
        if (toolWindow2 != null) {
            toolWindow2.activate(null);
        }
    }

    public void addView(@NotNull InspectionResultsView view) {
        if (view == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(6);
        }
        this.addView(view, InspectionsBundle.message((String)(view.isSingleInspectionRun() ? "inspection.results.for.inspection.toolwindow.title" : "inspection.results.for.profile.toolwindow.title"), (Object[])new Object[]{view.getCurrentProfileName(), this.getCurrentScope().getShortenName()}), false);
    }

    @Override
    public void doInspections(@NotNull AnalysisScope scope2) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(7);
        }
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        super.doInspections(scope2);
    }

    public void resolveElement(@NotNull InspectionProfileEntry tool, @NotNull PsiElement element2) {
        RefElement refElement;
        if (tool == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(9);
        }
        if ((refElement = this.getRefManager().getReference(element2)) == null) {
            return;
        }
        Tools tools = this.getTools().get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                InspectionToolResultExporter presentation2 = this.getPresentationOrNull(toolWrapper);
                if (presentation2 == null) continue;
                GlobalInspectionContextImpl.resolveElementRecursively(presentation2, (RefEntity)refElement);
            }
        }
    }

    public InspectionResultsView getView() {
        return this.myView;
    }

    public boolean isForceInspectAllScope() {
        return this.forceInspectAllScope;
    }

    public void setForceInspectAllScope(boolean forceInspectAllScope) {
        this.forceInspectAllScope = forceInspectAllScope;
    }

    private static void resolveElementRecursively(@NotNull InspectionToolResultExporter presentation2, @NotNull RefEntity refElement) {
        if (presentation2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(10);
        }
        if (refElement == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(11);
        }
        presentation2.suppressProblem(refElement);
        List children2 = refElement.getChildren();
        for (RefEntity child2 : children2) {
            GlobalInspectionContextImpl.resolveElementRecursively(presentation2, child2);
        }
    }

    @NotNull
    public AnalysisUIOptions getUIOptions() {
        AnalysisUIOptions analysisUIOptions = AnalysisUIOptions.getInstance(this.getProject());
        if (analysisUIOptions == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(12);
        }
        return analysisUIOptions;
    }

    public void setSplitterProportion(float proportion) {
        this.getUIOptions().SPLITTER_PROPORTION = proportion;
    }

    @NotNull
    public ToggleAction createToggleAutoscrollAction() {
        ToggleAction toggleAction = this.getUIOptions().getAutoScrollToSourceHandler().createToggleAction();
        if (toggleAction == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(13);
        }
        return toggleAction;
    }

    @Override
    protected void launchInspections(@NotNull AnalysisScope scope2) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(14);
        }
        this.myViewClosed = false;
        super.launchInspections(scope2);
    }

    @Override
    @NotNull
    protected PerformInBackgroundOption createOption() {
        return new PerformAnalysisInBackgroundOption(this.getProject());
    }

    @Override
    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope2) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(15);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !TESTING_VIEW) {
            return;
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        long elapsed = System.currentTimeMillis() - this.myInspectionStartedTimestamp;
        LOG.info("Code inspection finished. Took " + elapsed + " ms");
        if (SystemProperties.getBooleanProperty((String)"idea.is.integration.test", (boolean)false)) {
            String logPath = PathManager.getLogPath();
            Path perfMetrics = Paths.get(logPath, new String[0]).resolve("performance-metrics").resolve("inspectionMetrics.json");
            try {
                FileUtil.writeToFile((File)perfMetrics.toFile(), (String)("{\n\t\"inspection_execution_time\" : " + elapsed + "\n}"));
            }
            catch (IOException ex) {
                LOG.info("Could not create json file " + perfMetrics + " with the performance metrics.");
            }
        }
        if (this.getProject().isDisposed()) {
            return;
        }
        InspectionResultsView oldView = this.myView;
        InspectionResultsView newView = oldView == null ? new InspectionResultsView(this, new InspectionRVContentProviderImpl()) : null;
        ReadAction.nonBlocking(() -> (oldView == null ? newView : oldView).hasProblems()).finishOnUiThread(ModalityState.any(), hasProblems -> {
            if (!hasProblems.booleanValue()) {
                this.showNoProblemsNotification(scope2, newView);
            } else if (newView != null && !newView.isDisposed() && this.getCurrentScope() != null) {
                this.addView(newView);
                newView.update();
            }
            if (this.myView != null) {
                this.myView.setUpdating(false);
            }
        }).expireWith((Disposable)this.getProject()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void showNoProblemsNotification(@NotNull AnalysisScope scope2, InspectionResultsView newView) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(16);
        }
        int totalFiles = this.getStdJobDescriptors().BUILD_GRAPH.getTotalAmount();
        Notification notification = NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{totalFiles, scope2.getShortenName()}), MessageType.INFO);
        if (!scope2.isIncludeTestSource()) {
            GlobalInspectionContextImpl.addRepeatWithTestsAction(scope2, notification, () -> this.doInspections(scope2));
        }
        notification.notify(this.getProject());
        this.close(true);
        if (newView != null) {
            Disposer.dispose((Disposable)newView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTools(@NotNull AnalysisScope scope2, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(17);
        }
        this.myInspectionStartedTimestamp = System.currentTimeMillis();
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            throw new IncorrectOperationException("Must be run under progress");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isDispatchThread()) {
            throw new IncorrectOperationException("Must not start inspections from within EDT");
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within write action");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within global read action");
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.getProject());
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        ArrayList<Tools> localTools = new ArrayList<Tools>();
        ArrayList globalSimpleTools = new ArrayList();
        this.initializeTools(globalTools, localTools, globalSimpleTools);
        this.appendPairedInspectionsForUnfairTools(globalTools, globalSimpleTools, localTools);
        this.runGlobalTools(scope2, inspectionManager, globalTools, isOfflineInspections);
        if (runGlobalToolsOnly || localTools.isEmpty() && globalSimpleTools.isEmpty()) {
            return;
        }
        SearchScope searchScope2 = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope2).toSearchScope());
        HashSet localScopeFiles = searchScope2 instanceof LocalSearchScope ? new HashSet() : null;
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            tool.inspectionStarted(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)this.getPresentation(toolWrapper));
        }
        boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        boolean inspectInjectedPsi = Registry.is((String)"idea.batch.inspections.inspect.injected.psi", (boolean)true);
        Map<String, InspectionToolWrapper<?, ?>> map2 = GlobalInspectionContextImpl.getInspectionWrappersMap(localTools);
        ArrayBlockingQueue filesToInspect = new ArrayBlockingQueue(1000);
        SensitiveProgressWrapper iteratingIndicator = new SensitiveProgressWrapper(progressIndicator);
        Future<?> future2 = this.startIterateScopeInBackground(scope2, iteratingIndicator, headlessEnvironment, localScopeFiles, filesToInspect);
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        Processor processor2 = virtualFile2 -> {
            ProgressManager.checkCanceled();
            Boolean readActionSuccess = (Boolean)DumbService.getInstance((Project)this.getProject()).tryRunReadActionInSmartMode(() -> {
                PsiFile file2;
                long start2 = this.getPathProfile() == null ? 0L : System.currentTimeMillis();
                PsiFile psiFile = file2 = virtualFile2.isValid() ? psiManager.findFile(virtualFile2) : null;
                if (file2 == null) {
                    return true;
                }
                if (!scope2.contains(virtualFile2)) {
                    LOG.info(file2.getName() + "; scope: " + scope2 + "; " + virtualFile2);
                    return true;
                }
                boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
                List<GlobalInspectionToolWrapper> globalSimpleWrappers = this.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow, wrapper2 -> !(wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection));
                List<LocalInspectionToolWrapper> localToolWrappers = this.getWrappersFromTools(localTools, file2, includeDoNotShow, wrapper2 -> !(wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection));
                this.inspectFile(file2, GlobalInspectionContextImpl.getEffectiveRange(searchScope2, file2), inspectionManager, map2, globalSimpleWrappers, localToolWrappers, inspectInjectedPsi && scope2.isAnalyzeInjectedCode());
                if (start2 != 0L) {
                    this.updateProfile((VirtualFile)virtualFile2, System.currentTimeMillis() - start2);
                }
                return true;
            }, LangBundle.message((String)"popup.content.inspect.code.not.available.until.indices.are.ready", (Object[])new Object[0]));
            if (readActionSuccess == null || !readActionSuccess.booleanValue()) {
                throw new ProcessCanceledException();
            }
            PsiFile file2 = (PsiFile)ReadAction.compute(() -> psiManager.findFile(virtualFile2));
            if (file2 == null) {
                return true;
            }
            this.getEventPublisher().fileAnalyzed(file2, this.getProject());
            boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
            List externalAnnotatable = ContainerUtil.concat(this.getWrappersFromTools(localTools, file2, includeDoNotShow, wrapper2 -> wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection), this.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow, wrapper2 -> wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection));
            externalAnnotatable.forEach(wrapper2 -> {
                ProblemDescriptor[] descriptors = ((ExternalAnnotatorBatchInspection)wrapper2.getTool()).checkFile(file2, this, inspectionManager);
                InspectionToolResultExporter toolPresentation = this.getPresentation((InspectionToolWrapper)wrapper2);
                ReadAction.run(() -> BatchModeDescriptorsUtil.addProblemDescriptors(Arrays.asList(descriptors), false, this, null, toolPresentation, CONVERT));
            });
            return true;
        };
        try {
            LinkedBlockingQueue filesFailedToInspect = new LinkedBlockingQueue();
            while (true) {
                Disposable disposable2 = Disposer.newDisposable();
                DaemonProgressIndicator wrapper2 = new DaemonProgressIndicator();
                this.dependentIndicators.add(wrapper2);
                try {
                    ReadAction.run(() -> {
                        wrapper2.start();
                        ProgressIndicatorUtils.forceWriteActionPriority(wrapper2, disposable2);
                        if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
                            throw new ProcessCanceledException();
                        }
                    });
                    ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(filesToInspect, filesFailedToInspect, wrapper2, TOMBSTONE, processor2);
                }
                catch (ProcessCanceledException e) {
                    progressIndicator.checkCanceled();
                    assert (isOfflineInspections || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Must be outside read action. PCE=\n" + ExceptionUtil.getThrowableText((Throwable)e);
                    assert (isOfflineInspections || !ApplicationManager.getApplication().isDispatchThread()) : "Must be outside EDT. PCE=\n" + ExceptionUtil.getThrowableText((Throwable)e);
                    ApplicationManager.getApplication().runReadAction(EmptyRunnable.getInstance());
                    continue;
                }
                finally {
                    this.dependentIndicators.remove((Object)wrapper2);
                    Disposer.dispose((Disposable)disposable2);
                    continue;
                }
                break;
            }
        }
        finally {
            iteratingIndicator.cancel();
            filesToInspect.clear();
            try {
                future2.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Thread dump: \n" + ThreadDumper.dumpThreadsToString(), (Throwable)e);
            }
        }
        ProgressManager.checkCanceled();
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor(toolWrapper, map2);
            tool.inspectionFinished(inspectionManager, (GlobalInspectionContext)this, problemDescriptionProcessor);
        }
        this.addProblemsToView(globalSimpleTools);
    }

    @NotNull
    private static TextRange getEffectiveRange(@NotNull SearchScope searchScope2, @NotNull PsiFile file2) {
        List scopeFileElements;
        if (searchScope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(19);
        }
        if (searchScope2 instanceof LocalSearchScope && !(scopeFileElements = ContainerUtil.filter((Object[])((LocalSearchScope)searchScope2).getScope(), e -> e.getContainingFile() == file2)).isEmpty()) {
            int start2 = -1;
            int end = -1;
            for (PsiElement scopeElement : scopeFileElements) {
                TextRange elementRange = scopeElement.getTextRange();
                start2 = start2 == -1 ? elementRange.getStartOffset() : Math.min(elementRange.getStartOffset(), start2);
                end = end == -1 ? elementRange.getEndOffset() : Math.max(elementRange.getEndOffset(), end);
            }
            return new TextRange(start2, end);
        }
        return new TextRange(0, file2.getTextLength());
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.dependentIndicators.forEach(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectFile(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull InspectionManager inspectionManager, @NotNull Map<String, InspectionToolWrapper<?, ?>> wrappersMap, @NotNull List<? extends GlobalInspectionToolWrapper> globalSimpleTools, @NotNull List<? extends LocalInspectionToolWrapper> localTools, boolean inspectInjectedPsi) {
        Document document;
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(20);
        }
        if (range2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(21);
        }
        if (inspectionManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(22);
        }
        if (wrappersMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(23);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(24);
        }
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(25);
        }
        if ((document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2)) == null) {
            return;
        }
        try {
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, p -> new InspectionProfileWrapper(this.getCurrentProfile()));
            LocalInspectionsPass pass2 = new LocalInspectionsPass(file2, document, range2.getStartOffset(), range2.getEndOffset(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty(), inspectInjectedPsi);
            pass2.doInspectInBatch(this, inspectionManager, localTools);
            GlobalInspectionContextImpl.assertUnderDaemonProgress();
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(globalSimpleTools, ProgressIndicatorProvider.getGlobalProgressIndicator(), toolWrapper -> {
                GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
                ProblemsHolder holder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor((GlobalInspectionToolWrapper)((Object)toolWrapper), wrappersMap);
                InspectionEventsKt.reportWhenInspectionFinished(this.getEventPublisher(), toolWrapper, InspectListener.InspectionKind.GLOBAL_SIMPLE, file2, this.getProject(), () -> {
                    tool.checkFile(file2, inspectionManager, holder, (GlobalInspectionContext)this, problemDescriptionProcessor);
                    return holder.getResultCount();
                });
                InspectionToolResultExporter toolPresentation = this.getPresentation((InspectionToolWrapper)toolWrapper);
                BatchModeDescriptorsUtil.addProblemDescriptors(holder.getResults(), false, this, null, toolPresentation, CONVERT);
                return true;
            });
            VirtualFile virtualFile2 = file2.getVirtualFile();
            String displayUrl = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile2, (String)virtualFile2.getPresentableUrl(), (Project)this.getProject(), (boolean)true, (boolean)false);
            this.incrementJobDoneAmount(this.getStdJobDescriptors().LOCAL_ANALYSIS, displayUrl);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("In file: " + file2.getViewProvider().getVirtualFile().getPath(), e);
        }
        finally {
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, null);
            InjectedLanguageManager.getInstance((Project)this.getProject()).dropFileCaches(file2);
        }
    }

    protected boolean includeDoNotShow(InspectionProfile profile) {
        return profile.getSingleTool() != null;
    }

    @NotNull
    private Future<?> startIterateScopeInBackground(final @NotNull AnalysisScope scope2, @NotNull ProgressIndicator progressIndicator, final boolean headlessEnvironment, final @Nullable Collection<? super VirtualFile> localScopeFiles, final @NotNull BlockingQueue<? super VirtualFile> outFilesToInspect) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(26);
        }
        if (progressIndicator == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(27);
        }
        if (outFilesToInspect == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(28);
        }
        Task.Backgroundable task2 = new Task.Backgroundable(this.getProject(), InspectionsBundle.message((String)"scanning.files.to.inspect.progress.text", (Object[])new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    Project project = scope2.getProject();
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    scope2.accept(arg_0 -> this.lambda$run$1((FileIndex)fileIndex, project, headlessEnvironment, localScopeFiles, outFilesToInspect, arg_0));
                }
                catch (ProcessCanceledException e) {
                }
                finally {
                    try {
                        outFilesToInspect.put(TOMBSTONE);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            private /* synthetic */ boolean lambda$run$1(FileIndex fileIndex, Project project, boolean headlessEnvironment2, Collection localScopeFiles2, BlockingQueue outFilesToInspect2, VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (!(GlobalInspectionContextImpl.this.forceInspectAllScope || !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2) && fileIndex.isInContent(file2))) {
                    return true;
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                    Document document;
                    if (project.isDisposed()) {
                        throw new ProcessCanceledException();
                    }
                    PsiFile psi = PsiManager.getInstance((Project)project).findFile(file2);
                    Document document2 = document = psi == null ? null : GlobalInspectionContextImpl.this.shouldProcess(psi, headlessEnvironment2, localScopeFiles2);
                    if (document != null) {
                        return psi;
                    }
                    return null;
                });
                if (psiFile != null) {
                    try {
                        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                            throw new IllegalStateException("Must not have read action");
                        }
                        outFilesToInspect2.put(file2);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
                ProgressManager.checkCanceled();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$2", "run"));
            }
        };
        Future<?> future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, progressIndicator, null);
        if (future2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(29);
        }
        return future2;
    }

    private Document shouldProcess(@NotNull PsiFile file2, boolean headlessEnvironment, @Nullable Collection<? super VirtualFile> localScopeFiles) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(30);
        }
        if ((virtualFile2 = file2.getVirtualFile()) == null) {
            return null;
        }
        if (GlobalInspectionContextImpl.isBinary(file2)) {
            return null;
        }
        if (this.myViewClosed && !headlessEnvironment) {
            throw new ProcessCanceledException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running local inspections on " + virtualFile2.getPath());
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile2)) {
            return null;
        }
        if (localScopeFiles != null && !localScopeFiles.add((VirtualFile)virtualFile2)) {
            return null;
        }
        if (!ProblemHighlightFilter.shouldProcessFileInBatch((PsiFile)file2)) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private void runGlobalTools(@NotNull AnalysisScope scope2, @NotNull InspectionManager inspectionManager, @NotNull List<? extends Tools> globalTools, boolean isOfflineInspections) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(31);
        }
        if (inspectionManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(32);
        }
        if (globalTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(33);
        }
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed() || isOfflineInspections, (Object)"Must not run under read action, too unresponsive");
        ArrayList needRepeatSearchRequest = new ArrayList();
        SearchScope initialSearchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope2).toSearchScope());
        boolean canBeExternalUsages = scope2.getScopeType() != 1 || !scope2.isIncludeTestSource();
        InspectListener eventPublisher = this.getEventPublisher();
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope stateScope;
                if (!state.isEnabled() || (stateScope = state.getScope(this.getProject())) == null) continue;
                AnalysisScope scopeForState = new AnalysisScope(GlobalSearchScopesCore.filterScope((Project)this.getProject(), (NamedScope)stateScope).intersectWith(initialSearchScope), this.getProject());
                InspectionToolWrapper toolWrapper = state.getTool();
                GlobalInspectionTool tool = (GlobalInspectionTool)toolWrapper.getTool();
                InspectionToolResultExporter toolPresentation = this.getPresentation(toolWrapper);
                try {
                    if (tool.isGraphNeeded()) {
                        try {
                            InspectionEventsKt.reportWhenActivityFinished(eventPublisher, InspectListener.ActivityKind.REFERENCE_SEARCH, this.getProject(), () -> ((RefManagerImpl)this.getRefManager()).findAllDeclarations());
                        }
                        catch (Throwable e) {
                            this.getStdJobDescriptors().BUILD_GRAPH.setDoneAmount(0);
                            throw e;
                        }
                    }
                    ThrowableRunnable runnable2 = () -> {
                        InspectionEventsKt.reportWhenInspectionFinished(eventPublisher, toolWrapper, InspectListener.InspectionKind.GLOBAL, null, this.getProject(), () -> {
                            tool.runInspection(scopeForState, inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation);
                            return toolPresentation.getProblemDescriptors().size();
                        });
                        if ((canBeExternalUsages || tool.getAdditionalJobs((GlobalInspectionContext)this) != null) && tool.queryExternalUsagesRequests(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation)) {
                            needRepeatSearchRequest.add(toolWrapper);
                        }
                    };
                    if (tool.isReadActionNeeded()) {
                        ReadAction.run((ThrowableRunnable)runnable2);
                        continue;
                    }
                    runnable2.run();
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        InspectionEventsKt.reportWhenActivityFinished(eventPublisher, InspectListener.ActivityKind.GLOBAL_POST_RUN_ACTIVITIES, this.getProject(), () -> this.processPostRunActivities(needRepeatSearchRequest));
        this.addProblemsToView(globalTools);
    }

    private static void logGraph(RefManager refManager) {
        final ArrayList roots2 = new ArrayList();
        final MultiMap entitiesWithParents = new MultiMap();
        refManager.iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (elem == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (elem instanceof RefElement) {
                    RefElement refElement = (RefElement)elem;
                    entitiesWithParents.put((Object)refElement, refElement.getInReferences());
                    if (refElement.getInReferences().isEmpty() || refElement.getInReferences().contains(refElement)) {
                        roots2.add(refElement);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$3", "visitElement"));
            }
        });
        StringBuilder result2 = new StringBuilder("\n");
        for (RefElement root2 : roots2) {
            ArrayList<List<RefElement>> paths2 = new ArrayList<List<RefElement>>();
            paths2.add(new ArrayList());
            GlobalInspectionContextImpl.traverse(root2, paths2, 0);
            String rootText = String.format("%s %s (owner: %s, reachable: %s, entry: %s):", root2.getClass().getSimpleName(), root2.getName(), root2.getOwner(), root2.isReachable(), root2.isEntry());
            result2.append(rootText).append("\n");
            for (List list2 : paths2) {
                if (list2.size() <= 1) continue;
                StringJoiner pathJoiner = new StringJoiner(" --> ");
                for (int i2 = 1; i2 < list2.size(); ++i2) {
                    RefElement element2 = (RefElement)list2.get(i2);
                    String elementText = String.format("%s %s (owner: %s, reachable: %s)", element2.getClass().getSimpleName(), element2.getName(), element2.getOwner(), element2.isReachable());
                    pathJoiner.add(elementText);
                }
                result2.append(" --> ").append(pathJoiner).append("\n");
            }
        }
        LOG.warn(result2.toString());
    }

    private static void traverse(RefElement element2, List<List<RefElement>> paths2, Integer depth) {
        int lastPathsIndex = paths2.size() - 1;
        List<RefElement> path2 = paths2.get(lastPathsIndex);
        if (path2.contains(element2)) {
            return;
        }
        path2.add(element2);
        ArrayList outRefs = new ArrayList(element2.getOutReferences());
        for (int i2 = 0; i2 < outRefs.size(); ++i2) {
            RefElement outRef = (RefElement)outRefs.get(i2);
            if (i2 > 0) {
                ArrayList<RefElement> pathCopy = new ArrayList<RefElement>(path2.subList(0, depth + 1));
                paths2.add(pathCopy);
            }
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth + 1);
            GlobalInspectionContextImpl.traverse(outRef, paths2, depth);
            n = depth;
            n2 = depth = Integer.valueOf(depth - 1);
        }
    }

    private void processPostRunActivities(List<InspectionToolWrapper<?, ?>> needRepeatSearchRequest) {
        for (GlobalInspectionContextExtension extension2 : this.myExtensions.values()) {
            try {
                extension2.performPostRunActivities(needRepeatSearchRequest, (GlobalInspectionContext)this);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    public ActionCallback initializeViewIfNeeded() {
        if (this.myView != null) {
            return ActionCallback.DONE;
        }
        return ApplicationManager.getApplication().getInvokator().invokeLater(() -> {
            if (this.getCurrentScope() == null) {
                return;
            }
            InspectionResultsView view = this.getView();
            if (view == null) {
                view = new InspectionResultsView(this, new InspectionRVContentProviderImpl());
                this.addView(view);
            }
        }, x -> this.getCurrentScope() == null);
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<? super Tools> globalTools, @NotNull List<? super Tools> globalSimpleTools, @NotNull List<Tools> localTools) {
        Tools[] lArray;
        if (globalTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(34);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(35);
        }
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(36);
        }
        for (Tools tool : lArray = localTools.toArray(new Tools[0])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            String batchShortName = ((PairedUnfairLocalInspectionTool)localTool).getInspectionForBatchShortName();
            InspectionProfileImpl currentProfile = this.getCurrentProfile();
            InspectionToolWrapper pairedWrapper = currentProfile.getInspectionTool(batchShortName, this.getProject());
            InspectionToolWrapper inspectionToolWrapper = batchInspection = pairedWrapper != null ? pairedWrapper.createCopy() : null;
            if (batchInspection == null || this.getTools().containsKey(batchShortName)) continue;
            InspectionProfileEntry batchTool = batchInspection.getTool();
            ScopeToolState defaultState = tool.getDefaultState();
            ToolsImpl newTool = new ToolsImpl(batchInspection, defaultState.getLevel(), true, defaultState.isEnabled());
            for (ScopeToolState state : tool.getTools()) {
                NamedScope scope2 = state.getScope(this.getProject());
                if (scope2 == null) continue;
                newTool.addTool(scope2, batchInspection, state.isEnabled(), state.getLevel());
            }
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalSimpleInspectionTool) {
                globalSimpleTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                globalTools.add(newTool);
            } else {
                throw new AssertionError(batchTool);
            }
            this.getTools().put(batchShortName, newTool);
            batchInspection.initialize((GlobalInspectionContext)this);
        }
    }

    @NotNull
    public <T extends InspectionToolWrapper<?, ?>> List<T> getWrappersFromTools(@NotNull List<? extends Tools> localTools, @NotNull PsiFile file2, boolean includeDoNotShow, @NotNull Predicate<? super T> filter) {
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(38);
        }
        if (filter == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(39);
        }
        List list2 = ContainerUtil.mapNotNull(localTools, tool -> {
            InspectionToolWrapper unwrapped = tool.getEnabledTool((PsiElement)file2, includeDoNotShow);
            if (unwrapped == null) {
                return null;
            }
            return filter.test(unwrapped) ? unwrapped : null;
        });
        if (list2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(40);
        }
        return list2;
    }

    @NotNull
    private ProblemDescriptionsProcessor getProblemDescriptionProcessor(final @NotNull GlobalInspectionToolWrapper toolWrapper, final @NotNull Map<String, InspectionToolWrapper<?, ?>> wrappersMap) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(41);
        }
        if (wrappersMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(42);
        }
        return new ProblemDescriptionsProcessor(){

            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                if (commonProblemDescriptors == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (CommonProblemDescriptor problemDescriptor : commonProblemDescriptors) {
                    GlobalInspectionToolWrapper targetWrapper;
                    if (!(problemDescriptor instanceof ProblemDescriptor) || SuppressionUtil.inspectionResultSuppressed(((ProblemDescriptor)problemDescriptor).getPsiElement(), toolWrapper.getTool())) continue;
                    ProblemGroup problemGroup = ((ProblemDescriptor)problemDescriptor).getProblemGroup();
                    GlobalInspectionToolWrapper globalInspectionToolWrapper = targetWrapper = problemGroup == null ? toolWrapper : (InspectionToolWrapper)wrappersMap.get(problemGroup.getProblemName());
                    if (targetWrapper == null) continue;
                    InspectionToolResultExporter toolPresentation = GlobalInspectionContextImpl.this.getPresentation(targetWrapper);
                    toolPresentation.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$4", "addProblemElement"));
            }
        };
    }

    @NotNull
    private static Map<String, InspectionToolWrapper<?, ?>> getInspectionWrappersMap(@NotNull List<? extends Tools> tools) {
        if (tools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(43);
        }
        HashMap name2Inspection = new HashMap(tools.size());
        for (Tools tools2 : tools) {
            InspectionToolWrapper toolWrapper = tools2.getTool();
            name2Inspection.put(toolWrapper.getShortName(), toolWrapper);
        }
        HashMap hashMap = name2Inspection;
        if (hashMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(44);
        }
        return hashMap;
    }

    @Override
    public void close(boolean noSuspiciousCodeFound) {
        if (!noSuspiciousCodeFound) {
            if (this.myView.isRerun()) {
                this.myViewClosed = true;
                this.myView = null;
            }
            if (this.myView == null) {
                return;
            }
        }
        if (this.myContent != null) {
            ContentManager contentManager2 = this.getContentManager();
            contentManager2.removeContent(this.myContent, true);
        }
        this.myViewClosed = true;
        this.myView = null;
        ((InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject())).closeRunningContext(this);
        this.myPresentationMap.clear();
        super.close(noSuspiciousCodeFound);
    }

    @Override
    public void cleanup() {
        if (this.myView != null) {
            this.myView.setUpdating(false);
        } else {
            this.myPresentationMap.clear();
            super.cleanup();
        }
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.getTree().getInspectionTreeModel().reload();
        }
    }

    @Nullable
    private InspectionToolResultExporter getPresentationOrNull(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(45);
        }
        return (InspectionToolResultExporter)this.myPresentationMap.get(toolWrapper);
    }

    @Override
    public void codeCleanup(final @NotNull AnalysisScope scope2, final @NotNull InspectionProfile profile, final @Nullable String commandName2, final @Nullable Runnable postRunnable, boolean modal, final @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(46);
        }
        if (profile == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(47);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(48);
        }
        String title2 = LangBundle.message((String)"progress.title.inspect.code", (Object[])new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting code cleanup");
        }
        Object task2 = modal ? new Task.Modal(this.getProject(), title2, true){
            private CleanupProblems problems;

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                this.problems = GlobalInspectionContextImpl.this.findProblems(scope2, profile, indicator2, shouldApplyFix);
            }

            public void onSuccess() {
                GlobalInspectionContextImpl.this.applyFixes(scope2, this.problems, commandName2, postRunnable, profile, true, shouldApplyFix);
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Code cleanup: an exception during findProblems");
                }
                super.onThrowable(error);
            }

            public void onCancel() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Code cleanup: cancelled");
                }
            }

            public void onFinished() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Code cleanup: finished searching for problems");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        } : new Task.Backgroundable(this.getProject(), title2, true){
            private CleanupProblems problems;

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                this.problems = GlobalInspectionContextImpl.this.findProblems(scope2, profile, indicator2, shouldApplyFix);
            }

            public void onSuccess() {
                GlobalInspectionContextImpl.this.applyFixes(scope2, this.problems, commandName2, postRunnable, profile, false, shouldApplyFix);
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Code cleanup: an exception during findProblems");
                }
                super.onThrowable(error);
            }

            public void onCancel() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Code cleanup: cancelled");
                }
            }

            public void onFinished() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Code cleanup: finished searching for problems");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CleanupProblems findProblems(@NotNull AnalysisScope scope2, final @NotNull InspectionProfile profile, final @NotNull ProgressIndicator progressIndicator, final @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        PsiElement[] elements;
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(49);
        }
        if (profile == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(50);
        }
        if (progressIndicator == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(51);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(52);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Code cleanup: searching for problems in code");
        }
        this.setCurrentScope(scope2);
        final int fileCount = scope2.getFileCount();
        progressIndicator.setIndeterminate(false);
        final SearchScope searchScope2 = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope2).toSearchScope());
        final TextRange range2 = searchScope2 instanceof LocalSearchScope ? ((elements = ((LocalSearchScope)searchScope2).getScope()).length == 1 ? (TextRange)ReadAction.compute(() -> ((PsiElement)elements[0]).getTextRange()) : null) : null;
        final List inspectionTools = ContainerUtil.filter((Collection)profile.getAllEnabledInspectionTools(this.getProject()), tools -> {
            assert (tools != null);
            return tools.getTool().isCleanupTool();
        });
        final boolean includeDoNotShow = this.includeDoNotShow(profile);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        refManager.inspectionReadActionStarted();
        final ArrayList descriptors = new ArrayList();
        final HashSet files2 = new HashSet();
        try {
            scope2.accept(new PsiElementVisitor(){
                private int myCount;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitFile(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Code cleanup: searching for problems in file " + file2.toString());
                    }
                    progressIndicator.setText(AbstractLayoutCodeProcessor.getPresentablePath(GlobalInspectionContextImpl.this.getProject(), file2));
                    progressIndicator.setFraction((double)(++this.myCount) / (double)fileCount);
                    if (GlobalInspectionContextImpl.isBinary(file2)) {
                        return;
                    }
                    ArrayList<LocalInspectionToolWrapper> lTools = new ArrayList<LocalInspectionToolWrapper>();
                    for (Tools tools : inspectionTools) {
                        InspectionToolWrapper tool = tools.getEnabledTool((PsiElement)file2, includeDoNotShow);
                        if (tool instanceof GlobalInspectionToolWrapper) {
                            tool = ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper();
                        }
                        if (tool == null) continue;
                        lTools.add((LocalInspectionToolWrapper)tool);
                        tool.initialize((GlobalInspectionContext)GlobalInspectionContextImpl.this);
                    }
                    if (!lTools.isEmpty()) {
                        try {
                            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, p -> new InspectionProfileWrapper(profile, p.getProfileManager()));
                            LocalInspectionsPass pass2 = new LocalInspectionsPass(file2, file2.getViewProvider().getDocument(), range2 != null ? range2.getStartOffset() : 0, range2 != null ? range2.getEndOffset() : file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty(), true);
                            Runnable runnable2 = () -> pass2.doInspectInBatch(GlobalInspectionContextImpl.this, InspectionManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()), lTools);
                            ApplicationManager.getApplication().runReadAction(runnable2);
                            TreeSet<ProblemDescriptor> localDescriptors = new TreeSet<ProblemDescriptor>(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
                            for (LocalInspectionToolWrapper tool : lTools) {
                                InspectionToolResultExporter toolPresentation = GlobalInspectionContextImpl.this.getPresentation(tool);
                                for (CommonProblemDescriptor descriptor2 : toolPresentation.getProblemDescriptors()) {
                                    if (!(descriptor2 instanceof ProblemDescriptor)) continue;
                                    localDescriptors.add((ProblemDescriptor)descriptor2);
                                }
                            }
                            if (searchScope2 instanceof LocalSearchScope) {
                                Iterator iterator2 = localDescriptors.iterator();
                                while (iterator2.hasNext()) {
                                    ProblemDescriptor descriptor3 = (ProblemDescriptor)iterator2.next();
                                    TextRange infoRange = descriptor3 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor3).getTextRange() : null;
                                    if (infoRange == null || ((LocalSearchScope)searchScope2).containsRange(file2, infoRange)) continue;
                                    iterator2.remove();
                                }
                            }
                            if (!localDescriptors.isEmpty()) {
                                for (ProblemDescriptor descriptor3 : localDescriptors) {
                                    if (!shouldApplyFix.test(descriptor3)) continue;
                                    descriptors.add(descriptor3);
                                }
                                files2.add(file2);
                            }
                        }
                        finally {
                            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, null);
                            GlobalInspectionContextImpl.this.myPresentationMap.clear();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$7", "visitFile"));
                }
            });
        }
        finally {
            refManager.inspectionReadActionFinished();
        }
        return new CleanupProblems(files2, descriptors, searchScope2 instanceof GlobalSearchScope);
    }

    private void applyFixes(@NotNull AnalysisScope scope2, @NotNull CleanupProblems problems, @Nullable String commandName2, @Nullable Runnable postRunnable, @NotNull InspectionProfile profile, boolean modal, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(53);
        }
        if (problems == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(54);
        }
        if (profile == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(55);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(56);
        }
        if (problems.getFiles().isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No problems found during code inspection, nothing to cleanup");
            }
            if (commandName2 != null) {
                Notification notification = NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{scope2.getFileCount(), scope2.getDisplayName()}), MessageType.INFO);
                if (!scope2.isIncludeTestSource()) {
                    GlobalInspectionContextImpl.addRepeatWithTestsAction(scope2, notification, () -> this.codeCleanup(scope2, profile, commandName2, postRunnable, modal, shouldApplyFix));
                }
                notification.notify(this.getProject());
            }
            if (postRunnable != null) {
                postRunnable.run();
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying fixes");
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(problems.getFiles())) {
            return;
        }
        CleanupInspectionUtil.getInstance().applyFixesNoSort(this.getProject(), LangBundle.message((String)"code.cleanup", (Object[])new Object[0]), problems.getProblemDescriptors(), null, false, problems.isGlobalScope());
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    private static void addRepeatWithTestsAction(final @NotNull AnalysisScope scope2, @NotNull Notification notification, final @NotNull Runnable analysisRepeater) {
        if (scope2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(57);
        }
        if (notification == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(58);
        }
        if (analysisRepeater == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(59);
        }
        notification.addAction((AnAction)new NotificationAction(InspectionsBundle.message((String)"inspection.no.problems.repeat.with.tests", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    8.$$$reportNull$$$0(1);
                }
                notification.expire();
                scope2.setIncludeTestSource(true);
                scope2.invalidate();
                analysisRepeater.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$8";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isBinary(@NotNull PsiFile file2) {
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(60);
        }
        return file2 instanceof PsiBinaryFile || file2.getFileType().isBinary();
    }

    public boolean isViewClosed() {
        return this.myViewClosed;
    }

    private void addProblemsToView(List<? extends Tools> tools) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !TESTING_VIEW) {
            return;
        }
        if (this.myView == null && !InspectionResultsView.hasProblems(tools, this, new InspectionRVContentProviderImpl())) {
            return;
        }
        this.initializeViewIfNeeded().doWhenDone(() -> this.myView.addTools(tools));
    }

    @Override
    @NotNull
    public InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(61);
        }
        InspectionToolPresentation inspectionToolPresentation = this.myPresentationMap.computeIfAbsent(toolWrapper, __ -> {
            String presentationClass;
            String string = presentationClass = toolWrapper.myEP == null ? null : toolWrapper.myEP.presentation;
            if (StringUtil.isEmpty((String)presentationClass)) {
                if (this.myProblemConsumer != null) {
                    return new DelegatedInspectionToolPresentation(toolWrapper, this, this.myProblemConsumer);
                }
                presentationClass = DefaultInspectionToolPresentation.class.getName();
            }
            try {
                InspectionEP extension2 = toolWrapper.getExtension();
                ClassLoader extensionClassLoader = extension2 != null ? extension2.getPluginDescriptor().getPluginClassLoader() : null;
                Constructor<?> constructor = Class.forName(presentationClass, true, extensionClassLoader != null ? extensionClassLoader : ((Object)((Object)this)).getClass().getClassLoader()).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextImpl.class);
                constructor.setAccessible(true);
                return (InspectionToolPresentation)constructor.newInstance(new Object[]{toolWrapper, this});
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        });
        if (inspectionToolPresentation == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(62);
        }
        return inspectionToolPresentation;
    }

    static {
        NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Inspection Results");
        TOMBSTONE = new LightVirtualFile("TOMBSTONE");
        CONVERT = (tool, elt, context2) -> {
            PsiNamedElement problemElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elt, (Class[])new Class[]{PsiFile.class});
            RefElement refElement = context2.getRefManager().getReference((PsiElement)problemElement);
            if (refElement == null && problemElement != null) {
                refElement = GlobalInspectionContextUtil.retrieveRefElement(elt, context2);
            }
            return refElement;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 29: 
            case 40: 
            case 44: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 29: 
            case 40: 
            case 44: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 29: 
            case 40: 
            case 44: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 46: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 19: 
            case 20: 
            case 30: 
            case 38: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 23: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappersMap";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSimpleTools";
                break;
            }
            case 25: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 27: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFilesToInspect";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 41: 
            case 45: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 47: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 48: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldApplyFix";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisRepeater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventPublisher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleAutoscrollAction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "startIterateScopeInBackground";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappersFromTools";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionWrappersMap";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 29: 
            case 40: 
            case 44: 
            case 62: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addView";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doInspections";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementRecursively";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "launchInspections";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notifyInspectionsFinished";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showNoProblemsNotification";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runTools";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveRange";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inspectFile";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "startIterateScopeInBackground";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "runGlobalTools";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "appendPairedInspectionsForUnfairTools";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getWrappersFromTools";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getProblemDescriptionProcessor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionWrappersMap";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationOrNull";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "codeCleanup";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findProblems";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "applyFixes";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addRepeatWithTestsAction";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 29: 
            case 40: 
            case 44: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

