/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    private final InspectionTreeModel myModel;
    private boolean myQueueUpdate;
    private final OccurenceNavigator myOccurenceNavigator;
    private final InspectionResultsView myView;
    private final ConcurrentHashMap<ProblemDescriptionNode, CancellablePromise<String>> scheduledTooltipTasks;

    public InspectionTree(@NotNull InspectionResultsView view) {
        if (view == null) {
            InspectionTree.$$$reportNull$$$0(0);
        }
        this.myOccurenceNavigator = new MyOccurrenceNavigator();
        this.scheduledTooltipTasks = new ConcurrentHashMap();
        this.myView = view;
        Disposer.register((Disposable)this.myView, (Disposable)new Disposable(){

            public void dispose() {
                InspectionTree.this.scheduledTooltipTasks.forEach((node2, promise) -> promise.cancel());
                InspectionTree.this.scheduledTooltipTasks.clear();
            }
        });
        this.myModel = new InspectionTreeModel();
        Disposer.register((Disposable)view, (Disposable)this.myModel);
        this.setModel((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myModel), false, view)));
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(true);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getSelectionModel().addTreeSelectionListener(e -> {
                if (this.isUnderQueueUpdate()) {
                    return;
                }
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                    if (this.myView.isAutoScrollMode()) {
                        OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), (boolean)false);
                    }
                }
            });
            EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
            EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
            TreeUtil.installActions((JTree)((Object)this));
            PopupHandler.installPopupMenu((JComponent)((Object)this), (String)"InspectionToolWindow.TreePopup", (String)"CodeInspection");
            new TreeSpeedSearch(this, (Convertor<? super TreePath, String>)((Convertor)o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString())));
        }
        this.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
            boolean myAlreadyDone;

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!this.myAlreadyDone && InspectionTree.this.getSelectionCount() == 0) {
                    this.myAlreadyDone = true;
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        InspectionTree.this.expandPath(new TreePath(InspectionTree.this.myModel.getRoot()));
                        SmartExpander.installOn((JTree)((Object)InspectionTree.this));
                        if (!InspectionTree.this.myView.isDisposed()) {
                            InspectionTree.this.myView.syncRightPanel();
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/ui/InspectionTree$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public InspectionTreeNode getRoot() {
        return this.myModel.getRoot();
    }

    public InspectionTreeModel getInspectionTreeModel() {
        return this.myModel;
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    public boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    public void removeAllNodes() {
        this.myModel.clearTree();
    }

    public String @Nullable [] getSelectedGroupPath() {
        TreePath commonPath = TreePathUtil.findCommonAncestor(this.getSelectionPaths());
        if (commonPath == null) {
            return null;
        }
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return InspectionTree.getGroupPath((InspectionGroupNode)n);
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper(boolean allowDummy) {
        InspectionProfileImpl profile = this.myView.getCurrentProfile();
        if (profile == null) {
            return null;
        }
        String singleToolName = profile.getSingleTool();
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            if (singleToolName != null) {
                InspectionToolWrapper tool = profile.getInspectionTool(singleToolName, this.myView.getProject());
                LOG.assertTrue(tool != null);
                return tool;
            }
            return null;
        }
        InspectionToolWrapper<?, ?> resultWrapper = null;
        block0: for (TreePath path2 : paths2) {
            Object[] nodes = path2.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node2 = nodes[j];
                if (node2 instanceof InspectionGroupNode) {
                    return null;
                }
                InspectionToolWrapper<?, ?> wrapper2 = null;
                if (node2 instanceof InspectionNode) {
                    wrapper2 = ((InspectionNode)node2).getToolWrapper();
                } else if (node2 instanceof SuppressableInspectionTreeNode) {
                    wrapper2 = ((SuppressableInspectionTreeNode)node2).getPresentation().getToolWrapper();
                }
                if (wrapper2 == null || !allowDummy && this.getContext().getPresentation((InspectionToolWrapper)wrapper2).isDummy()) continue;
                if (resultWrapper == null) {
                    resultWrapper = wrapper2;
                    continue block0;
                }
                if (resultWrapper == wrapper2) continue block0;
                return null;
            }
        }
        if (resultWrapper == null && singleToolName != null) {
            InspectionToolWrapper tool = profile.getInspectionTool(singleToolName, this.myView.getProject());
            LOG.assertTrue(tool != null);
            return tool;
        }
        return resultWrapper;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public String getToolTipText(MouseEvent e) {
        TreePath path2 = this.getPathForLocation(e.getX(), e.getY());
        if (path2 == null) {
            return null;
        }
        Object lastComponent = path2.getLastPathComponent();
        if (!(lastComponent instanceof ProblemDescriptionNode)) {
            return null;
        }
        ProblemDescriptionNode node2 = (ProblemDescriptionNode)lastComponent;
        if (!node2.needCalculateTooltip()) {
            return node2.getToolTipText();
        }
        @NlsContexts.Tooltip Promise tooltipLazy = (Promise)this.scheduledTooltipTasks.computeIfAbsent(node2, key -> {
            IdeTooltipManager tooltipManager = IdeTooltipManager.getInstance();
            Component component2 = e.getComponent();
            return ReadAction.nonBlocking(() -> node2.getToolTipText()).finishOnUiThread(ModalityState.any(), tooltipText -> tooltipManager.updateShownTooltip(component2)).submit((Executor)AppExecutorUtil.getAppExecutorService()).onError(throwable -> {
                if (!(throwable instanceof CancellationException)) {
                    LOG.error("Exception in ProblemDescriptionNode#getToolTipText", throwable);
                }
                this.scheduledTooltipTasks.remove(node2);
            }).onSuccess(tooltipText -> this.scheduledTooltipTasks.remove(node2));
        });
        if (tooltipLazy.isSucceeded()) {
            try {
                String text2 = (String)tooltipLazy.blockingGet(0);
                return text2;
            }
            catch (ExecutionException | TimeoutException error) {
                LOG.error((Throwable)error);
            }
        }
        return UIBundle.message((String)"crumbs.calculating.tooltip", (Object[])new Object[0]);
    }

    @Nullable
    public RefEntity getCommonSelectedElement() {
        TreePath[] paths2 = this.getSelectionPaths();
        TreePath ancestor = TreePathUtil.findCommonAncestor(paths2);
        if (ancestor == null) {
            return null;
        }
        Object node2 = ancestor.getLastPathComponent();
        return node2 instanceof RefElementNode ? ((RefElementNode)node2).getElement() : null;
    }

    public RefEntity @NotNull [] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    InspectionTree.$$$reportNull$$$0(1);
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet result2 = new LinkedHashSet();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node2 = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node2, result2);
            }
            RefEntity[] refEntityArray = (RefEntity[])ArrayUtil.reverseArray((Object[])result2.toArray(RefEntity.EMPTY_ELEMENTS_ARRAY));
            if (refEntityArray == null) {
                InspectionTree.$$$reportNull$$$0(2);
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            InspectionTree.$$$reportNull$$$0(3);
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    public OccurenceNavigator getOccurenceNavigator() {
        return this.myOccurenceNavigator;
    }

    public void selectNode(InspectionTreeNode node2) {
        TreePath path2 = TreePathUtil.pathToTreeNode(node2);
        if (path2 != null) {
            TreeUtil.promiseSelect((JTree)((Object)this), (TreePath)path2);
        }
    }

    private static void addElementsInNode(InspectionTreeNode node2, Set<? super RefEntity> out) {
        if (!node2.isValid()) {
            return;
        }
        if (node2 instanceof RefElementNode) {
            RefEntity element2 = ((RefElementNode)node2).getElement();
            out.add((RefEntity)element2);
        }
        if (node2 instanceof ProblemDescriptionNode) {
            RefEntity element2 = ((ProblemDescriptionNode)node2).getElement();
            out.add((RefEntity)element2);
        }
        for (InspectionTreeNode inspectionTreeNode : node2.getChildren()) {
            InspectionTree.addElementsInNode(inspectionTreeNode, out);
        }
    }

    public CommonProblemDescriptor @NotNull [] getAllValidSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, true, null));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(4);
        }
        return commonProblemDescriptorArray;
    }

    public CommonProblemDescriptor @NotNull [] getSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, false, null));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(5);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public List<CommonProblemDescriptor[]> getSelectedDescriptorPacks(boolean sortedByPosition, @Nullable Set<? super VirtualFile> readOnlyFilesSink, boolean allowResolved, TreePath[] paths2) {
        if (paths2 == null) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            paths2 = this.getSelectionPaths();
        }
        if (paths2 == null) {
            List<CommonProblemDescriptor[]> list2 = Collections.emptyList();
            if (list2 == null) {
                InspectionTree.$$$reportNull$$$0(6);
            }
            return list2;
        }
        MultiMap parentToChildNode = new MultiMap();
        TreeTraversal.PLAIN_BFS.traversal((Iterable)ContainerUtil.map((Object[])paths2, p -> (InspectionTreeNode)p.getLastPathComponent()), n -> this.myModel.getChildren(n)).filter(ProblemDescriptionNode.class).filter(node2 -> node2.getDescriptor() != null && InspectionTree.isNodeValidAndIncluded(node2, allowResolved)).consumeEach(node2 -> {
            Object key = InspectionTree.getVirtualFileOrEntity(node2.getElement());
            parentToChildNode.putValue(key, (Object)node2.getDescriptor());
        });
        ArrayList<CommonProblemDescriptor[]> descriptors = new ArrayList<CommonProblemDescriptor[]>();
        for (Map.Entry entry2 : parentToChildNode.entrySet()) {
            Object key = entry2.getKey();
            if (readOnlyFilesSink != null && key instanceof VirtualFile && !((VirtualFile)key).isWritable()) {
                readOnlyFilesSink.add((VirtualFile)((VirtualFile)key));
            }
            Stream stream = ((Collection)entry2.getValue()).stream();
            if (sortedByPosition) {
                stream = stream.sorted(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.add((CommonProblemDescriptor[])stream.toArray(arg_0 -> ((ArrayFactory)CommonProblemDescriptor.ARRAY_FACTORY).create(arg_0)));
        }
        ArrayList<CommonProblemDescriptor[]> arrayList = descriptors;
        if (arrayList == null) {
            InspectionTree.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public TreePath @Nullable [] getSelectionPaths() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return super.getSelectionPaths();
    }

    @NotNull
    InspectionTreeNode getToolProblemsRootNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(8);
        }
        if (errorLevel == null) {
            InspectionTree.$$$reportNull$$$0(9);
        }
        InspectionTreeNode parent = this.getToolParentNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        if (isSingleInspectionRun) {
            InspectionTreeNode inspectionTreeNode = parent;
            if (inspectionTreeNode == null) {
                InspectionTree.$$$reportNull$$$0(10);
            }
            return inspectionTreeNode;
        }
        InspectionNode inspectionNode = this.myModel.createInspectionNode(toolWrapper, this.myView.getCurrentProfile(), parent);
        if (inspectionNode == null) {
            InspectionTree.$$$reportNull$$$0(11);
        }
        return inspectionNode;
    }

    @NotNull
    private InspectionTreeNode getToolParentNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionTreeNode currentNode;
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(12);
        }
        if (errorLevel == null) {
            InspectionTree.$$$reportNull$$$0(13);
        }
        if (!groupedBySeverity && isSingleInspectionRun) {
            InspectionRootNode inspectionRootNode = this.myModel.getRoot();
            if (inspectionRootNode == null) {
                InspectionTree.$$$reportNull$$$0(14);
            }
            return inspectionRootNode;
        }
        InspectionTreeNode inspectionTreeNode = currentNode = groupedBySeverity ? this.myModel.createSeverityGroupNode(this.myView.getCurrentProfile().getProfileManager().getSeverityRegistrar(), errorLevel, this.myModel.getRoot()) : this.myModel.getRoot();
        if (isSingleInspectionRun) {
            InspectionRootNode inspectionRootNode = currentNode;
            if (inspectionRootNode == null) {
                InspectionTree.$$$reportNull$$$0(15);
            }
            return inspectionRootNode;
        }
        String[] groupPath = toolWrapper.getGroupPath();
        if (groupPath.length == 0) {
            LOG.error("groupPath is empty for tool: " + toolWrapper.getShortName() + ", class: " + toolWrapper.getTool().getClass());
        }
        for (String subGroup : groupPath) {
            currentNode = this.myModel.createGroupNode(subGroup, currentNode);
        }
        InspectionRootNode inspectionRootNode = currentNode;
        if (inspectionRootNode == null) {
            InspectionTree.$$$reportNull$$$0(16);
        }
        return inspectionRootNode;
    }

    public boolean areDescriptorNodesSelected() {
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            return false;
        }
        for (TreePath path2 : paths2) {
            if (path2.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    public int getSelectedProblemCount() {
        int count = 0;
        for (TreePath path2 : TreeCollector.TreePathRoots.collect((TreePath[])this.getSelectionPaths())) {
            LevelAndCount[] levels;
            for (LevelAndCount level : levels = ((InspectionTreeNode)path2.getLastPathComponent()).getProblemLevels()) {
                count += level.getCount();
            }
        }
        return count;
    }

    private static boolean isNodeValidAndIncluded(ProblemDescriptionNode node2, boolean allowResolved) {
        return node2.isValid() && (allowResolved || !node2.isExcluded() && !node2.isAlreadySuppressedFromView() && !node2.isQuickFixAppliedFromView());
    }

    public void removeSelectedProblems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] selected2 = this.getSelectionPaths();
        if (selected2 == null) {
            return;
        }
        if (!this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            for (TreePath path2 : selected2) {
                InspectionTreeNode node2 = (InspectionTreeNode)path2.getLastPathComponent();
                this.myModel.traverse(node2).forEach(InspectionTreeNode::dropProblemCountCaches);
            }
            return;
        }
        HashSet<InspectionTreeNode> processedNodes = new HashSet<InspectionTreeNode>();
        ArrayList<InspectionTreeNode> toRemove2 = new ArrayList<InspectionTreeNode>();
        block1: for (TreePath path3 : selected2) {
            Object[] nodePath = path3.getPath();
            for (int i2 = 1; i2 < nodePath.length; ++i2) {
                InspectionTreeNode node3 = (InspectionTreeNode)nodePath[i2];
                if (!processedNodes.add(node3) || !this.shouldDelete(node3)) continue;
                toRemove2.add(node3);
                continue block1;
            }
        }
        if (toRemove2.isEmpty()) {
            return;
        }
        TreePath pathToSelect = null;
        if (selected2.length == 1) {
            InspectionTreeNode nextNode = (InspectionTreeNode)this.myModel.traverseFrom((InspectionTreeNode)selected2[0].getLastPathComponent(), true).filter(n -> !this.shouldDelete((InspectionTreeNode)n)).first();
            if (nextNode != null) {
                pathToSelect = TreeUtil.getPathFromRoot((TreeNode)nextNode);
            }
        } else {
            TreePath commonAliveAncestorPath;
            for (commonAliveAncestorPath = TreePathUtil.findCommonAncestor(selected2); commonAliveAncestorPath != null && this.shouldDelete((InspectionTreeNode)commonAliveAncestorPath.getLastPathComponent()); commonAliveAncestorPath = commonAliveAncestorPath.getParentPath()) {
            }
            if (commonAliveAncestorPath != null) {
                pathToSelect = commonAliveAncestorPath;
            }
        }
        HashSet<InspectionTreeNode> parents2 = new HashSet<InspectionTreeNode>();
        for (InspectionTreeNode node4 : toRemove2) {
            InspectionTreeNode parent = node4.getParent();
            if (parent == null) continue;
            this.myModel.remove(node4);
            parents2.add(parent);
        }
        for (InspectionTreeNode parent : parents2) {
            parent.dropProblemCountCaches();
        }
        TreeUtil.selectPath((JTree)((Object)this), (TreePath)pathToSelect);
        this.revalidate();
        this.repaint();
    }

    private boolean shouldDelete(InspectionTreeNode node2) {
        if (node2 instanceof RefElementNode) {
            RefElementNode refElementNode = (RefElementNode)node2;
            InspectionToolPresentation presentation2 = refElementNode.getPresentation();
            RefEntity element2 = refElementNode.getElement();
            if (element2 == null || presentation2.isProblemResolved(element2) || presentation2.isExcluded(element2) || presentation2.isSuppressed(element2)) {
                return true;
            }
            List<? extends InspectionTreeNode> children2 = node2.getChildren();
            return !children2.isEmpty() && children2.stream().allMatch(this::shouldDelete);
        }
        if (node2 instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemDescriptionNode = (ProblemDescriptionNode)node2;
            CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
            InspectionToolPresentation presentation3 = problemDescriptionNode.getPresentation();
            if (descriptor2 == null || presentation3.isExcluded(descriptor2) || presentation3.isProblemResolved(descriptor2)) {
                return true;
            }
        } else {
            if (node2 instanceof InspectionGroupNode || node2 instanceof InspectionSeverityGroupNode || node2 instanceof InspectionModuleNode || node2 instanceof InspectionPackageNode) {
                return node2.getChildren().stream().allMatch(this::shouldDelete);
            }
            if (node2 instanceof InspectionNode) {
                InspectionToolResultExporter presentation4 = this.myView.getGlobalInspectionContext().getPresentation(((InspectionNode)node2).getToolWrapper());
                SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation4.getProblemElements();
                if (problemElements.isEmpty()) {
                    return true;
                }
                return problemElements.keys().stream().allMatch(entity -> presentation4.isExcluded((RefEntity)entity));
            }
        }
        return false;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myView.getGlobalInspectionContext();
        if (globalInspectionContextImpl == null) {
            InspectionTree.$$$reportNull$$$0(17);
        }
        return globalInspectionContextImpl;
    }

    private static String @NotNull [] getGroupPath(@NotNull InspectionGroupNode node2) {
        InspectionTreeNode parent;
        if (node2 == null) {
            InspectionTree.$$$reportNull$$$0(18);
        }
        ArrayList<String> path2 = new ArrayList<String>(2);
        while ((parent = node2.getParent()) instanceof InspectionGroupNode) {
            node2 = (InspectionGroupNode)parent;
            path2.add(node2.getSubGroup());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(path2);
        if (stringArray == null) {
            InspectionTree.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    @Nullable
    private static Object getVirtualFileOrEntity(@Nullable RefEntity entity) {
        VirtualFile file2;
        SmartPsiElementPointer pointer;
        if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (file2 = pointer.getVirtualFile()) != null) {
            return file2;
        }
        return entity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLevel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidSelectedDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptorPacks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolProblemsRootNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolParentNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolProblemsRootNode";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolParentNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getGroupPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyOccurrenceNavigator
    implements OccurenceNavigator {
        private MyOccurrenceNavigator() {
        }

        public boolean hasNextOccurence() {
            return this.getNextNode(true) != null;
        }

        public boolean hasPreviousOccurence() {
            return this.getNextNode(false) != null;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            InspectionTreeNode node2 = this.getNextNode(true);
            if (node2 == null) {
                return null;
            }
            InspectionTree.this.selectNode(node2);
            return new OccurenceNavigator.OccurenceInfo(this.createDescriptorForNode(node2), -1, -1);
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            InspectionTreeNode node2 = this.getNextNode(false);
            InspectionTree.this.selectNode(node2);
            return node2 == null ? null : new OccurenceNavigator.OccurenceInfo(this.createDescriptorForNode(node2), -1, -1);
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = InspectionsBundle.message((String)"inspection.action.go.next", (Object[])new Object[0]);
            if (string == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = InspectionsBundle.message((String)"inspection.action.go.prev", (Object[])new Object[0]);
            if (string == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(1);
            }
            return string;
        }

        private InspectionTreeNode getNextNode(boolean next) {
            InspectionTreeNode node2 = this.getSelectedNode();
            if (node2 == null) {
                return null;
            }
            return (InspectionTreeNode)InspectionTree.this.myModel.traverseFrom(node2, next).filter(n -> n != node2).filter(n -> this.isOccurrenceNode((InspectionTreeNode)n)).first();
        }

        private InspectionTreeNode getSelectedNode() {
            TreePath path2 = InspectionTree.this.getSelectionPath();
            if (path2 == null) {
                return null;
            }
            return (InspectionTreeNode)path2.getLastPathComponent();
        }

        private boolean isOccurrenceNode(@NotNull InspectionTreeNode node2) {
            if (node2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(2);
            }
            if (node2.isExcluded()) {
                return false;
            }
            if (node2 instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node2;
                if (this.hasDescriptorUnder(refNode)) {
                    return false;
                }
                RefEntity element2 = refNode.getElement();
                return element2 != null && element2.isValid();
            }
            return node2 instanceof ProblemDescriptionNode;
        }

        @Nullable
        private Navigatable createDescriptorForNode(@NotNull InspectionTreeNode node2) {
            if (node2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(3);
            }
            if (node2.isExcluded()) {
                return null;
            }
            if (node2 instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node2;
                if (this.hasDescriptorUnder(refNode)) {
                    return null;
                }
                RefEntity element2 = refNode.getElement();
                if (element2 == null || !element2.isValid()) {
                    return null;
                }
                if (element2 instanceof RefElement) {
                    return this.getOpenFileDescriptor((RefElement)element2);
                }
            } else if (node2 instanceof ProblemDescriptionNode) {
                ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node2;
                boolean isValid = problemNode.isValid() && (!problemNode.isQuickFixAppliedFromView() || problemNode.calculateIsValid());
                return isValid ? this.navigate(problemNode.getDescriptor()) : InspectionResultsViewUtil.getNavigatableForInvalidNode(problemNode);
            }
            return null;
        }

        @Nullable
        private Navigatable navigate(CommonProblemDescriptor descriptor2) {
            return InspectionResultsView.getSelectedNavigatable(descriptor2);
        }

        @Nullable
        private Navigatable getOpenFileDescriptor(RefElement refElement) {
            PsiElement psiElement = refElement.getPsiElement();
            if (psiElement == null) {
                return null;
            }
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 == null) {
                return null;
            }
            return PsiNavigationSupport.getInstance().createNavigatable(refElement.getRefManager().getProject(), file2, psiElement.getTextOffset());
        }

        private boolean hasDescriptorUnder(RefElementNode node2) {
            InspectionTreeNode current2 = node2;
            while (current2 != null && current2.getChildCount() != 0) {
                if (!((current2 = current2.getChildAt(0)) instanceof ProblemDescriptionNode)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree$MyOccurrenceNavigator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree$MyOccurrenceNavigator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isOccurrenceNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

