/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth;

import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.util.Url;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0004H&J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase;", "Lorg/jetbrains/ide/RestService;", "()V", "service", "Lcom/intellij/collaboration/auth/services/OAuthService;", "getService", "()Lcom/intellij/collaboration/auth/services/OAuthService;", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "handleAcceptCode", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "isAccepted", "", "oauthService", "sendRedirect", "", "url", "Lcom/intellij/util/Url;", "AcceptCodeHandleResult", "intellij.platform.collaborationTools"})
public abstract class OAuthCallbackHandlerBase
extends RestService {
    @NotNull
    protected final OAuthService<?> getService() {
        return this.oauthService();
    }

    @NotNull
    public abstract OAuthService<?> oauthService();

    @Override
    @NotNull
    protected String getServiceName() {
        return this.getService().getName();
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        block2: {
            AcceptCodeHandleResult handleResult;
            block1: {
                Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                OAuthService<?> oAuthService = this.getService();
                String string = urlDecoder.path();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlDecoder.path()");
                Map map2 = urlDecoder.parameters();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"urlDecoder.parameters()");
                boolean isCodeAccepted = oAuthService.handleServerCallback(string, map2);
                handleResult = this.handleAcceptCode(isCodeAccepted);
                if (!(handleResult instanceof AcceptCodeHandleResult.Page)) break block1;
                String string2 = ((AcceptCodeHandleResult.Page)handleResult).getHtml();
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                HttpResponse httpResponse = (HttpResponse)Responses.response((String)"text/html", (ByteBuf)Unpooled.wrappedBuffer((byte[])byArray));
                Channel channel2 = context2.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"context.channel()");
                Responses.send$default((HttpResponse)httpResponse, (Channel)channel2, (HttpRequest)((HttpRequest)request2), null, (int)4, null);
                break block2;
            }
            if (!(handleResult instanceof AcceptCodeHandleResult.Redirect)) break block2;
            this.sendRedirect(request2, context2, ((AcceptCodeHandleResult.Redirect)handleResult).getUrl());
        }
        return null;
    }

    @NotNull
    protected abstract AcceptCodeHandleResult handleAcceptCode(boolean var1);

    private final void sendRedirect(FullHttpRequest request2, ChannelHandlerContext context2, Url url) {
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toExternalForm());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.FOUND");
        Channel channel2 = context2.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"context.channel()");
        Responses.send((HttpResponseStatus)httpResponseStatus, (Channel)channel2, (HttpRequest)((HttpRequest)request2), null, (HttpHeaders)headers);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "", "()V", "Page", "Redirect", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Redirect;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Page;", "intellij.platform.collaborationTools"})
    protected static abstract class AcceptCodeHandleResult {
        private AcceptCodeHandleResult() {
        }

        public /* synthetic */ AcceptCodeHandleResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Redirect;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)V", "getUrl", "()Lcom/intellij/util/Url;", "intellij.platform.collaborationTools"})
        public static final class Redirect
        extends AcceptCodeHandleResult {
            @NotNull
            private final Url url;

            @NotNull
            public final Url getUrl() {
                return this.url;
            }

            public Redirect(@NotNull Url url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(null);
                this.url = url;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "html", "", "(Ljava/lang/String;)V", "getHtml", "()Ljava/lang/String;", "intellij.platform.collaborationTools"})
        public static final class Page
        extends AcceptCodeHandleResult {
            @NotNull
            private final String html;

            @NotNull
            public final String getHtml() {
                return this.html;
            }

            public Page(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                super(null);
                this.html = html;
            }
        }
    }
}

