/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SizeRequirements;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ParagraphView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/intellij/collaboration/ui/codereview/BaseHtmlEditorPane;", "Ljavax/swing/JEditorPane;", "iconsClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "createViewFactory", "Ljavax/swing/text/ViewFactory;", "setBody", "", "body", "", "HtmlEditorViewFactory", "MyParagraphView", "intellij.platform.collaborationTools"})
public class BaseHtmlEditorPane
extends JEditorPane {
    public final void setBody(@Nls @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        CharSequence charSequence = body;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.setText("");
        } else {
            this.setText("<html><body>" + body + "</body></html>");
        }
        this.setSize(0x3FFFFFFF, 0x3FFFFFFF);
    }

    @NotNull
    protected ViewFactory createViewFactory(@NotNull Class<?> iconsClass) {
        Intrinsics.checkNotNullParameter(iconsClass, (String)"iconsClass");
        return (ViewFactory)((Object)new HtmlEditorViewFactory(iconsClass));
    }

    public BaseHtmlEditorPane(final @NotNull Class<?> iconsClass) {
        Intrinsics.checkNotNullParameter(iconsClass, (String)"iconsClass");
        this.setEditorKit((EditorKit)new JBHtmlEditorKit(true){

            @NotNull
            public ViewFactory getViewFactory() {
                return this.createViewFactory(iconsClass);
            }
        });
        this.setEditable(false);
        this.setOpaque(false);
        this.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.setMargin((Insets)JBUI.emptyInsets());
        GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAAHintForSwingComponent());
        Caret caret = this.getCaret();
        if (caret == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.text.DefaultCaret");
        }
        DefaultCaret caret2 = (DefaultCaret)caret;
        caret2.setUpdatePolicy(1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/collaboration/ui/codereview/BaseHtmlEditorPane$HtmlEditorViewFactory;", "Lcom/intellij/util/ui/JBHtmlEditorKit$JBHtmlFactory;", "iconsClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "create", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "intellij.platform.collaborationTools"})
    protected static class HtmlEditorViewFactory
    extends JBHtmlEditorKit.JBHtmlFactory {
        private final Class<?> iconsClass;

        @NotNull
        public View create(@NotNull Element elem) {
            View view;
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            if (Intrinsics.areEqual((Object)"icon-inline", (Object)elem.getName())) {
                Icon icon2;
                Icon icon3;
                Object object = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                if (object != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Object object3 = it;
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    String path2 = (String)object3;
                    icon3 = IconLoader.findIcon((String)path2, this.iconsClass);
                } else {
                    icon3 = icon2 = null;
                }
                if (icon2 != null) {
                    return new InlineView(icon2, elem, elem){
                        final /* synthetic */ Icon $icon;
                        final /* synthetic */ Element $elem;

                        public float getPreferredSpan(int axis) {
                            switch (axis) {
                                case 0: {
                                    return (float)this.$icon.getIconWidth() + super.getPreferredSpan(axis);
                                }
                            }
                            return super.getPreferredSpan(axis);
                        }

                        public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
                            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                            Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
                            super.paint(g, allocation);
                            this.$icon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y);
                        }
                        {
                            this.$icon = $captured_local_variable$0;
                            this.$elem = $captured_local_variable$1;
                            super($super_call_param$2);
                        }
                    };
                }
            }
            if ((view = super.create(elem)) instanceof ParagraphView) {
                return new MyParagraphView(elem);
            }
            View view2 = view;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
            return view2;
        }

        public HtmlEditorViewFactory(@NotNull Class<?> iconsClass) {
            Intrinsics.checkNotNullParameter(iconsClass, (String)"iconsClass");
            this.iconsClass = iconsClass;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0014\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/collaboration/ui/codereview/BaseHtmlEditorPane$MyParagraphView;", "Ljavax/swing/text/html/ParagraphView;", "elem", "Ljavax/swing/text/Element;", "(Ljavax/swing/text/Element;)V", "calculateMinorAxisRequirements", "Ljavax/swing/SizeRequirements;", "axis", "", "r", "intellij.platform.collaborationTools"})
    protected static class MyParagraphView
    extends ParagraphView {
        @Override
        @NotNull
        protected SizeRequirements calculateMinorAxisRequirements(int axis, @Nullable SizeRequirements r) {
            SizeRequirements r2 = r;
            if (r2 == null) {
                r2 = new SizeRequirements();
            }
            int n = r2.minimum = (int)this.layoutPool.getMinimumSpan(axis);
            int n2 = (int)this.layoutPool.getPreferredSpan(axis);
            boolean bl = false;
            r2.preferred = Math.max(n, n2);
            r2.maximum = Integer.MAX_VALUE;
            r2.alignment = 0.5f;
            return r2;
        }

        public MyParagraphView(@NotNull Element elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem);
        }
    }
}

