/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview;

import com.intellij.collaboration.ui.codereview.NodeCodeReviewProgressState;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextIcon;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.CollaborationToolsIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00112\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J@\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u001dH\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/collaboration/ui/codereview/CodeReviewProgressRenderer;", "Lcom/intellij/ui/CellRendererPanel;", "Ljavax/swing/tree/TreeCellRenderer;", "renderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "codeReviewProgressStateProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/collaboration/ui/codereview/NodeCodeReviewProgressState;", "(Lcom/intellij/ui/ColoredTreeCellRenderer;Lkotlin/jvm/functions/Function1;)V", "discussionsCountFont", "Ljava/awt/Font;", "iconLabel", "Ljavax/swing/JLabel;", "buildLayout", "", "combine", "Ljavax/swing/Icon;", "backgroundIcon", "textIcon", "createDiscussionsCountIcon", "discussionsCount", "", "color", "Ljava/awt/Color;", "getIcon", "node", "getReadingStateIcon", "isRead", "", "getReadingStateWithDiscussionsIcon", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "hasFocus", "intellij.platform.collaborationTools"})
public final class CodeReviewProgressRenderer
extends CellRendererPanel
implements TreeCellRenderer {
    private final JLabel iconLabel;
    private final Font discussionsCountFont;
    private final ColoredTreeCellRenderer renderer;
    private final Function1<ChangesBrowserNode<?>, NodeCodeReviewProgressState> codeReviewProgressStateProvider;

    private final void buildLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.renderer, "Center");
        this.add(this.iconLabel, "East");
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ChangesBrowserNode cfr_ignored_0 = (ChangesBrowserNode)value2;
        ChangesTreeCellRenderer.Companion.customize(this, selected2);
        this.renderer.getTreeCellRendererComponent(tree, value2, selected2, expanded2, leaf, row2, hasFocus);
        this.iconLabel.setIcon(this.getIcon((ChangesBrowserNode)value2));
        return (Component)((Object)this);
    }

    private final Icon getIcon(ChangesBrowserNode<?> node2) {
        NodeCodeReviewProgressState state = (NodeCodeReviewProgressState)this.codeReviewProgressStateProvider.invoke(node2);
        boolean isRead = state.isRead();
        int discussionsCount = state.getDiscussionsCount();
        if (discussionsCount <= 0) {
            return this.getReadingStateIcon(isRead);
        }
        return this.getReadingStateWithDiscussionsIcon(isRead, discussionsCount);
    }

    private final Icon getReadingStateIcon(boolean isRead) {
        return !isRead ? CollaborationToolsIcons.FileUnread : null;
    }

    private final Icon getReadingStateWithDiscussionsIcon(boolean isRead, int discussionsCount) {
        boolean bl = discussionsCount > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (discussionsCount > 9) {
            Icon icon2;
            if (!isRead) {
                Icon icon3 = CollaborationToolsIcons.CommentUnreadMany;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CommentUnreadMany");
            } else {
                Icon icon4 = CollaborationToolsIcons.CommentReadMany;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"CommentReadMany");
            }
            return icon2;
        }
        Icon icon5 = !isRead ? CollaborationToolsIcons.CommentUnread : CollaborationToolsIcons.CommentUnresolved;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"if (!isRead) CommentUnread else CommentUnresolved");
        Icon backgroundIcon = icon5;
        Color textIconColor = UIUtil.isUnderDarcula() ? new Color(3948353) : Color.white;
        Icon discussionsCountIcon = this.createDiscussionsCountIcon(discussionsCount, textIconColor);
        return this.combine(backgroundIcon, discussionsCountIcon);
    }

    private final Icon createDiscussionsCountIcon(int discussionsCount, Color color) {
        int n = discussionsCount;
        n = 1 <= n && 9 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String text2 = String.valueOf(discussionsCount);
        TextIcon textIcon = new TextIcon(text2, color, null, 0);
        bl2 = false;
        bl3 = false;
        TextIcon $this$apply = textIcon;
        boolean bl5 = false;
        $this$apply.setFont(this.discussionsCountFont.deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI)));
        return textIcon;
    }

    private final Icon combine(Icon backgroundIcon, Icon textIcon) {
        int horizontalTextIconShift = PaintUtil.RoundingMode.CEIL.round((double)(backgroundIcon.getIconWidth() - textIcon.getIconWidth()) / 2.0);
        int verticalTextIconShift = backgroundIcon.getIconHeight() / 8;
        LayeredIcon layeredIcon = new LayeredIcon(2);
        boolean bl = false;
        boolean bl2 = false;
        LayeredIcon $this$apply = layeredIcon;
        boolean bl3 = false;
        $this$apply.setIcon(backgroundIcon, 0);
        $this$apply.setIcon(textIcon, 1, horizontalTextIconShift, verticalTextIconShift);
        return layeredIcon;
    }

    /*
     * WARNING - void declaration
     */
    public CodeReviewProgressRenderer(@NotNull ColoredTreeCellRenderer renderer2, @NotNull Function1<? super ChangesBrowserNode<?>, NodeCodeReviewProgressState> codeReviewProgressStateProvider) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Intrinsics.checkNotNullParameter(codeReviewProgressStateProvider, (String)"codeReviewProgressStateProvider");
        this.renderer = renderer2;
        this.codeReviewProgressStateProvider = codeReviewProgressStateProvider;
        JLabel jLabel = new JLabel();
        boolean bl = false;
        boolean bl2 = false;
        JLabel jLabel2 = jLabel;
        CodeReviewProgressRenderer codeReviewProgressRenderer = this;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        Unit unit = Unit.INSTANCE;
        codeReviewProgressRenderer.iconLabel = jLabel;
        this.discussionsCountFont = new Font(FontPreferences.DEFAULT_FONT_NAME, 0, FontPreferences.DEFAULT_FONT_SIZE);
        this.buildLayout();
    }
}

