/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.diff;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.diff.AddCommentGutterIconRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/collaboration/ui/codereview/diff/CreateDiffCommentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findRendererActionUnderCaret", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isActive", "", "isEnabledAndVisible", "update", "intellij.platform.collaborationTools"})
public abstract class CreateDiffCommentAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(this.isActive(e) && this.isEnabledAndVisible(e));
    }

    protected abstract boolean isActive(@NotNull AnActionEvent var1);

    private final boolean isEnabledAndVisible(AnActionEvent e) {
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return false");
        Editor editor3 = editor2;
        return this.findRendererActionUnderCaret(editor3) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor2 = (Editor)object;
        AnAction anAction2 = this.findRendererActionUnderCaret(editor2);
        if (anAction2 == null) {
            return;
        }
        AnAction action2 = anAction2;
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"editor.scrollingModel");
        ScrollingModel scrollingModel2 = scrollingModel;
        scrollingModel2.scrollToCaret(ScrollType.MAKE_VISIBLE);
        scrollingModel2.runActionOnScrollingFinished(new Runnable(action2, editor2, scrollingModel2, e){
            final /* synthetic */ AnAction $action;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ ScrollingModel $scrollingModel;
            final /* synthetic */ AnActionEvent $e;

            public final void run() {
                if (this.$action instanceof ActionGroup) {
                    CaretModel caretModel = this.$editor.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                    Point point = this.$editor.visualPositionToXY(caretModel.getVisualPosition());
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.visualPositionToX\u2026aretModel.visualPosition)");
                    Point point2 = point;
                    ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ICON_NAVIGATION_SECONDARY_BUTTON", (ActionGroup)this.$action);
                    Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026TOR_GUTTER_POPUP, action)");
                    actionPopupMenu.getComponent().show(this.$editor.getComponent(), point2.x, point2.y - this.$scrollingModel.getVerticalScrollOffset());
                } else {
                    ActionUtil.invokeAction((AnAction)this.$action, (Component)this.$editor.getComponent(), (String)"ICON_NAVIGATION", (InputEvent)this.$e.getInputEvent(), null);
                }
            }
            {
                this.$action = anAction2;
                this.$editor = editor2;
                this.$scrollingModel = scrollingModel;
                this.$e = anActionEvent;
            }
        });
    }

    private final AnAction findRendererActionUnderCaret(Editor editor2) {
        Object object;
        Editor editor3 = editor2;
        if (!(editor3 instanceof EditorEx)) {
            editor3 = null;
        }
        if ((object = (EditorEx)editor3) == null || (object = object.getMarkupModel()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(editor as? EditorEx)?.markupModel ?: return null");
        Object markupModel = object;
        CaretModel caretModel = ((EditorEx)editor2).getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.caretModel.logicalPosition");
        LogicalPosition logicalPosition2 = logicalPosition;
        int line = logicalPosition2.line;
        int offset = editor2.logicalPositionToOffset(logicalPosition2);
        CommonProcessors.FindProcessor<RangeHighlighterEx> findProcessor2 = new CommonProcessors.FindProcessor<RangeHighlighterEx>(line){
            final /* synthetic */ int $line;

            protected boolean accept(@NotNull RangeHighlighterEx t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                GutterIconRenderer gutterIconRenderer = t.getGutterIconRenderer();
                return gutterIconRenderer instanceof AddCommentGutterIconRenderer && ((AddCommentGutterIconRenderer)gutterIconRenderer).getLine() == this.$line;
            }
            {
                this.$line = $captured_local_variable$0;
            }
        };
        markupModel.processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)findProcessor2));
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)findProcessor2.getFoundValue();
        if (rangeHighlighterEx == null || (rangeHighlighterEx = rangeHighlighterEx.getGutterIconRenderer()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"findProcessor.foundValue\u2026onRenderer ?: return null");
        RangeHighlighterEx renderer2 = rangeHighlighterEx;
        AnAction anAction2 = renderer2.getClickAction();
        if (anAction2 == null) {
            anAction2 = (AnAction)renderer2.getPopupMenuActions();
        }
        return anAction2;
    }

    public CreateDiffCommentAction() {
        super(CollaborationToolsBundle.messagePointer("action.CodeReview.CreateDiffComment.text", new Object[0]));
    }
}

