/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.ImportSettingsAction;
import com.intellij.configurationStore.ImportSettingsActionKt;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0014J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0003J\b\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/configurationStore/ImportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmRestart", "", "message", "", "doImport", "saveFile", "Ljava/nio/file/Path;", "doImportFromDirectory", "getExportableComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "relativePaths", "", "getMarkedComponents", "components", "getRelativeNamesToExtract", "chosenComponents", "getRestartActionName", "restart", "update", "intellij.platform.configurationStore.impl"})
public class ImportSettingsAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, true, true, true, false, false){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isFileSelectable(@Nullable VirtualFile file2) {
                VirtualFile virtualFile2 = file2;
                if (virtualFile2 == null) return super.isFileSelectable(file2);
                if (!virtualFile2.isDirectory()) return super.isFileSelectable(file2);
                Path path2 = file2.getFileSystem().getNioPath(file2);
                if (path2 == null) return false;
                Path path3 = path2;
                boolean bl = false;
                boolean bl2 = false;
                Path path4 = path3;
                boolean bl3 = false;
                if (!ConfigImportHelper.isConfigDirectory(path4)) return false;
                return true;
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        FileChooserDescriptor $this$apply = fileChooserDescriptor2;
        boolean bl3 = false;
        $this$apply.setTitle(ConfigurationStoreBundle.message("title.import.file.location", new Object[0]));
        $this$apply.setDescription(ConfigurationStoreBundle.message("prompt.choose.import.file.path", new Object[0]));
        $this$apply.setHideIgnored(false);
        $this$apply.withFileFilter((Condition)actionPerformed.descriptor.2.1.INSTANCE);
        FileChooserDescriptor descriptor2 = fileChooserDescriptor2;
        ChooseComponentsToExportDialogKt.chooseSettingsFile(descriptor2, PathManager.getConfigPath(), component2, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
            final /* synthetic */ ImportSettingsAction this$0;

            public final void invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Path saveFile = Paths.get(it.getPath(), new String[0]);
                try {
                    Path path2 = saveFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"saveFile");
                    this.this$0.doImport(path2);
                }
                catch (ZipException e1) {
                    Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.reading.settings.file", saveFile, e1.getMessage()), (String)ConfigurationStoreBundle.message("title.invalid.file", new Object[0]));
                }
                catch (IOException e1) {
                    Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.reading.settings.file.2", saveFile, e1.getMessage()), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
                }
            }
            {
                this.this$0 = importSettingsAction;
                super(1);
            }
        }));
    }

    @NotNull
    protected Map<FileSpec, List<ExportableItem>> getExportableComponents(@NotNull Set<String> relativePaths) {
        Intrinsics.checkNotNullParameter(relativePaths, (String)"relativePaths");
        Map $this$filterKeys$iv = ExportSettingsActionKt.getExportableComponentsMap$default(true, null, true, 2, null);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map2.entrySet()) {
            FileSpec it = (FileSpec)entry$iv.getKey();
            boolean bl2 = false;
            if (!relativePaths.contains(it.getRelativePath())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    protected Set<ExportableItem> getMarkedComponents(@NotNull Set<ExportableItem> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        return components;
    }

    protected void doImport(@NotNull Path saveFile) {
        Path tempFile;
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        if (!PathKt.exists((Path)saveFile)) {
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.cannot.find.file", saveFile), (String)ConfigurationStoreBundle.message("title.file.not.found", new Object[0]));
            return;
        }
        if (PathKt.isDirectory((Path)saveFile)) {
            this.doImportFromDirectory(saveFile);
            return;
        }
        Set<String> relativePaths = ImportSettingsActionKt.getPaths(PathKt.inputStream((Path)saveFile));
        if (!relativePaths.contains("IntelliJ IDEA Global Settings")) {
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.no.settings.to.import", saveFile), (String)ConfigurationStoreBundle.message("title.invalid.file", new Object[0]));
            return;
        }
        Path configPath = Paths.get(PathManager.getConfigPath(), new String[0]);
        Map<FileSpec, List<ExportableItem>> map2 = this.getExportableComponents(relativePaths);
        String string = ConfigurationStoreBundle.message("title.select.components.to.import", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigurationStoreBundle\u2026ct.components.to.import\")");
        String string2 = ConfigurationStoreBundle.message("prompt.check.components.to.import", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ConfigurationStoreBundle\u2026ck.components.to.import\")");
        ChooseComponentsToExportDialog dialog2 = new ChooseComponentsToExportDialog(map2, false, string, string2);
        if (!dialog2.showAndGet()) {
            return;
        }
        Path path2 = tempFile = Paths.get(PathManager.getPluginTempPath(), new String[0]).resolve(saveFile.getFileName());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"tempFile");
        PathKt.copy((Path)saveFile, (Path)path2);
        ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(this.getRelativeNamesToExtract(this.getMarkedComponents(dialog2.getExportableComponents$intellij_platform_configurationStore_impl())));
        StartupActionScriptManager.addActionCommands((List)CollectionsKt.listOf((Object[])new Object[]{new StartupActionScriptManager.UnzipCommand(tempFile, configPath, (Predicate)filenameFilter), new StartupActionScriptManager.DeleteCommand(tempFile)}));
        UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.getRestartActionName();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        objectArray[1] = applicationNamesInfo.getFullProductName();
        String string3 = ConfigurationStoreBundle.message("message.settings.imported.successfully", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ConfigurationStoreBundle\u2026stance().fullProductName)");
        if (this.confirmRestart(string3)) {
            this.restart();
        }
    }

    private final void restart() {
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(){

            public final void run() {
                boolean bl = false;
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
                }
                ((ApplicationEx)application).restart(true);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable2, modalityState);
    }

    private final boolean confirmRestart(@NlsContexts.DialogMessage String message2) {
        String string = ConfigurationStoreBundle.message("import.settings.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigurationStoreBundle\u2026ings.confirmation.title\")");
        return MessageUtil.showOkCancelDialog$default((String)string, (String)message2, (String)this.getRestartActionName(), null, (Icon)Messages.getQuestionIcon(), null, null, (int)104, null) == 0;
    }

    @NlsContexts.Button
    private final String getRestartActionName() {
        String string;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isRestartCapable()) {
            String string2 = ConfigurationStoreBundle.message("import.settings.confirmation.button.restart", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ConfigurationStoreBundle\u2026irmation.button.restart\")");
        } else {
            String string3 = ConfigurationStoreBundle.message("import.default.settings.confirmation.button.shutdown", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ConfigurationStoreBundle\u2026rmation.button.shutdown\")");
        }
        return string;
    }

    private final void doImportFromDirectory(Path saveFile) {
        Object[] objectArray = new Object[1];
        Path path2 = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"PathManager.getConfigDir()");
        objectArray[0] = ConfigBackup.Companion.getNextBackupPath$default(ConfigBackup.Companion, path2, null, 2, null);
        String string = ConfigurationStoreBundle.message("restore.default.settings.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigurationStoreBundle\u2026hManager.getConfigDir()))");
        String confirmationMessage = string;
        if (this.confirmRestart(confirmationMessage)) {
            new CustomConfigMigrationOption.MigrateFromCustomPlace(saveFile).writeConfigMarkerFile();
            this.restart();
        }
    }

    private final Set<String> getRelativeNamesToExtract(Set<ExportableItem> chosenComponents) {
        HashSet<String> result2 = new HashSet<String>();
        for (ExportableItem item : chosenComponents) {
            result2.add(item.getFileSpec().getRelativePath());
        }
        result2.add("installed.txt");
        return result2;
    }
}

