/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.JdomSerializer;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.xml.KotlinAwareBeanBinding;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J3\u0010\u0015\u001a\u0004\u0018\u00010\r\"\b\b\u0000\u0010\u0006*\u00020\u00122\u0006\u0010\u0011\u001a\u0002H\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/configurationStore/JdomSerializerImpl;", "Lcom/intellij/configurationStore/JdomSerializer;", "()V", "clearSerializationCaches", "", "deserialize", "T", "url", "Ljava/net/URL;", "aClass", "Ljava/lang/Class;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "element", "Lorg/jdom/Element;", "clazz", "(Lorg/jdom/Element;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeInto", "obj", "", "getDefaultSerializationFilter", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "serialize", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "createElementIfEmpty", "", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/SerializationFilter;Z)Lorg/jdom/Element;", "serializeObjectInto", "target", "intellij.platform.objectSerializer"})
final class JdomSerializerImpl
implements JdomSerializer {
    @NotNull
    public SkipDefaultsSerializationFilter getDefaultSerializationFilter() {
        return XmlSerializerKt.access$doGetDefaultSerializationFilter();
    }

    @Nullable
    public <T> Element serialize(@NotNull T obj2, @Nullable SerializationFilter filter, boolean createElementIfEmpty) {
        Intrinsics.checkNotNullParameter(obj2, (String)"obj");
        try {
            Element element2;
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
            if (binding instanceof BeanBinding) {
                element2 = ((BeanBinding)binding).serialize(obj2, createElementIfEmpty, filter);
            } else {
                Object object = binding.serialize(obj2, null, filter);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jdom.Element");
                }
                element2 = (Element)object;
            }
            return element2;
        }
        catch (SerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Can't serialize instance of " + obj2.getClass(), (Throwable)e);
        }
    }

    public void serializeObjectInto(@NotNull Object obj2, @NotNull Element target2, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (obj2 instanceof Element) {
            Iterator attributeIterator;
            Iterator iterator2;
            Iterator iterator3 = iterator2 = ((Element)obj2).getChildren().iterator();
            boolean bl = false;
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Element child2 = (Element)iterator4.next();
                iterator2.remove();
                target2.addContent(child2);
            }
            Iterator iterator5 = attributeIterator = ((Element)obj2).getAttributes().iterator();
            boolean bl2 = false;
            iterator3 = iterator5;
            while (iterator3.hasNext()) {
                Attribute attribute = (Attribute)iterator3.next();
                attributeIterator.remove();
                target2.setAttribute(attribute);
            }
            return;
        }
        Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
        if (binding == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.serialization.xml.KotlinAwareBeanBinding");
        }
        KotlinAwareBeanBinding beanBinding = (KotlinAwareBeanBinding)binding;
        SerializationFilter serializationFilter = filter;
        if (serializationFilter == null) {
            serializationFilter = (SerializationFilter)this.getDefaultSerializationFilter();
        }
        beanBinding.serializeInto(obj2, target2, serializationFilter);
    }

    public <T> T deserialize(@NotNull Element element2, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (Intrinsics.areEqual(clazz, Element.class)) {
            return (T)element2;
        }
        try {
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(clazz, clazz);
            if (binding == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.xmlb.NotNullDeserializeBinding");
            }
            return (T)((NotNullDeserializeBinding)binding).deserialize(null, element2);
        }
        catch (SerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Cannot deserialize class " + clazz.getName(), (Throwable)e);
        }
    }

    public void clearSerializationCaches() {
        XmlSerializerKt.clearBindingCache();
    }

    public void deserializeInto(@NotNull Object obj2, @NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        try {
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
            if (binding == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding).deserializeInto(obj2, element2);
        }
        catch (SerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
    }

    public <T> T deserialize(@NotNull URL url, @NotNull Class<T> aClass) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        try {
            Element element2 = JDOMXIncluder.resolveRoot((Element)JDOMUtil.load((InputStream)URLUtil.openStream((URL)url)), (URL)url);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"JDOMXIncluder.resolveRoo\u2026il.openStream(url)), url)");
            return this.deserialize(element2, aClass);
        }
        catch (IOException e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
        catch (JDOMException e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
    }
}

