/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.configurationStore.statistic.eventLog.ConfigurationState;
import com.intellij.configurationStore.statistic.eventLog.ConfigurationStateExtractor;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventsKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J \u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J$\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\"\u0010\u001a\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter;", "", "recordDefault", "", "(Z)V", "valuesExtractor", "Lcom/intellij/configurationStore/statistic/eventLog/ConfigurationStateExtractor;", "logConfig", "", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "data", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "id", "", "logConfigurationState", "componentName", "state", "project", "Lcom/intellij/openapi/project/Project;", "logConfigurationStateChanged", "logDefaultConfigurationState", "clazz", "Ljava/lang/Class;", "logSettingsChanged", "Companion", "intellij.platform.configurationStore.impl"})
public class FeatureUsageSettingsEventPrinter {
    private final ConfigurationStateExtractor valuesExtractor;
    private final boolean recordDefault;
    private static final Logger LOG;
    private static final AtomicInteger counter;
    @NotNull
    public static final Companion Companion;

    public final void logDefaultConfigurationState(@NotNull String componentName, @NotNull Class<?> clazz, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            PluginInfo pluginInfo;
            if (this.recordDefault) {
                Object object = XmlSerializer.getJdomSerializer().getDefaultSerializationFilter().getDefaultValue(clazz);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jdomSerializer.getDefaul\u2026().getDefaultValue(clazz)");
                Object object2 = object;
                this.logConfigurationState(componentName, object2, project);
            } else if (Intrinsics.areEqual(clazz, Element.class) ^ true && (pluginInfo = PluginInfoDetectorKt.getPluginInfo(clazz)).isDevelopedByJetBrains()) {
                FeatureUsageSettingsEventsKt.access$getRecordedComponents$p().add(componentName);
                this.logConfig(FeatureUsageSettingsEventsKt.access$getGROUP$p(), "invoked", Companion.createComponentData(project, componentName, pluginInfo), counter.incrementAndGet());
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot initialize default settings for '" + componentName + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logConfigurationStateChanged(@NotNull String componentName, @NotNull Object state, @Nullable Project project) {
        void optionsValues;
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ConfigurationState configurationState = this.valuesExtractor.extract$intellij_platform_configurationStore_impl(project, componentName, state);
        if (configurationState == null) {
            return;
        }
        ConfigurationState configurationState2 = configurationState;
        List<FeatureUsageData> list2 = configurationState2.component1();
        PluginInfo pluginInfo = configurationState2.component2();
        int id2 = counter.incrementAndGet();
        for (FeatureUsageData data2 : optionsValues) {
            this.logSettingsChanged("component_changed_option", data2, id2);
        }
        if (!this.recordDefault) {
            this.logSettingsChanged("component_changed", Companion.createComponentData(project, componentName, pluginInfo), id2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logConfigurationState(@NotNull String componentName, @NotNull Object state, @Nullable Project project) {
        void optionsValues;
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ConfigurationState configurationState = this.valuesExtractor.extract$intellij_platform_configurationStore_impl(project, componentName, state);
        if (configurationState == null) {
            return;
        }
        ConfigurationState configurationState2 = configurationState;
        List<FeatureUsageData> list2 = configurationState2.component1();
        PluginInfo pluginInfo = configurationState2.component2();
        String eventId = this.recordDefault ? "option" : "not.default";
        int id2 = counter.incrementAndGet();
        for (FeatureUsageData data2 : optionsValues) {
            this.logConfig(FeatureUsageSettingsEventsKt.access$getGROUP$p(), eventId, data2, id2);
        }
        if (!this.recordDefault) {
            this.logConfig(FeatureUsageSettingsEventsKt.access$getGROUP$p(), "invoked", Companion.createComponentData(project, componentName, pluginInfo), id2);
        }
    }

    protected void logConfig(@NotNull EventLogGroup group2, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data2, int id2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FeatureUsageLogger.INSTANCE.logState(group2, eventId, data2.addData("id", id2).build());
    }

    protected void logSettingsChanged(@NonNls @NotNull String eventId, @NotNull FeatureUsageData data2, int id2) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FUCounterUsageLogger.getInstance().logEvent("settings.changes", eventId, data2.addData("id", id2));
    }

    public FeatureUsageSettingsEventPrinter(boolean recordDefault) {
        this.recordDefault = recordDefault;
        this.valuesExtractor = new ConfigurationStateExtractor(this.recordDefault);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FeatureUsageSettingsEventPrinter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Featu\u2026EventPrinter::class.java)");
        LOG = logger;
        counter = new AtomicInteger(0);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "createComponentData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "", "pluginInfo", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "intellij.platform.configurationStore.impl"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final FeatureUsageData createComponentData(@Nullable Project project, @NotNull String componentName, @NotNull PluginInfo pluginInfo) {
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            Intrinsics.checkNotNullParameter((Object)pluginInfo, (String)"pluginInfo");
            FeatureUsageData data2 = new FeatureUsageData().addData("component", componentName).addPluginInfo(pluginInfo);
            Project project2 = project;
            if (project2 != null) {
                if (project2.isDefault()) {
                    data2.addData("default_project", true);
                    return data2;
                }
            }
            data2.addProject(project);
            return data2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

