/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventsKt;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/SettingsComponentNameValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "isComponentName", "intellij.platform.configurationStore.impl"})
public final class SettingsComponentNameValidator
extends CustomValidationRule {
    public boolean acceptRuleId(@Nullable String ruleId) {
        return Intrinsics.areEqual((Object)"component_name", (Object)ruleId) || Intrinsics.areEqual((Object)"option_name", (Object)ruleId);
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isComponentName(data2, context2)) {
            return FeatureUsageSettingsEventsKt.isComponentNameWhitelisted(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        }
        return FeatureUsageSettingsEventsKt.isComponentOptionNameWhitelisted(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    private final boolean isComponentName(String data2, EventContext context2) {
        return context2.eventData.containsKey("component") && Intrinsics.areEqual((Object)data2, context2.eventData.get("component"));
    }
}

