/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@ApiStatus.Internal
public final class ModuleSettingsImpl
extends SettingsXmlFile
implements ModuleSettings {
    private final String myModuleName;
    private final ConversionContextImpl context;

    ModuleSettingsImpl(@NotNull Path moduleFile, @NotNull ConversionContextImpl context2) throws CannotConvertException {
        if (moduleFile == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(1);
        }
        super(moduleFile);
        this.myModuleName = Strings.trimEnd((String)moduleFile.getFileName().toString(), (String)".iml");
        this.context = context2;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public String getModuleType() {
        return this.getRootElement().getAttributeValue("type");
    }

    @Override
    @NotNull
    public Collection<Element> getFacetElements(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(3);
        }
        Element facetManager = this.getComponentElement("FacetManager");
        ArrayList<Element> elements = new ArrayList<Element>();
        ModuleSettingsImpl.addFacetTypes(facetTypeId, facetManager, elements);
        ArrayList<Element> arrayList = elements;
        if (arrayList == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void addFacetTypes(@NotNull String facetTypeId, @Nullable Element parent, @NotNull ArrayList<? super Element> elements) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(6);
        }
        for (Element child2 : JDOMUtil.getChildren((Element)parent, (String)"facet")) {
            if (facetTypeId.equals(child2.getAttributeValue("type"))) {
                elements.add((Element)child2);
                continue;
            }
            ModuleSettingsImpl.addFacetTypes(facetTypeId, child2, elements);
        }
    }

    @Override
    public Element getFacetElement(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(7);
        }
        return (Element)ContainerUtil.getFirstItem(this.getFacetElements(facetTypeId), null);
    }

    @Override
    public void addFacetElement(@NotNull String facetTypeId, @NotNull String facetName, Element configuration2) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(8);
        }
        if (facetName == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(9);
        }
        Element componentElement = JDomSerializationUtil.findOrCreateComponentElement((Element)this.getRootElement(), (String)"FacetManager");
        Element facetElement = new Element("facet");
        facetElement.setAttribute("type", facetTypeId);
        facetElement.setAttribute("name", facetName);
        configuration2.setName("configuration");
        facetElement.addContent(configuration2);
        componentElement.addContent(facetElement);
    }

    @Override
    public void setModuleType(@NotNull String moduleType) {
        if (moduleType == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(10);
        }
        this.getRootElement().setAttribute("type", moduleType);
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path2) {
        if (path2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(11);
        }
        String string = this.context.expandPath(path2, this);
        if (string == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path2) {
        if (path2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(13);
        }
        String string = ConversionContextImpl.collapsePath(path2, this);
        if (string == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<File> getSourceRoots(boolean includeTests) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            for (Element sourceFolder : JDOMUtil.getChildren((Element)contentRoot, (String)"sourceFolder")) {
                boolean isTestFolder = Boolean.parseBoolean(sourceFolder.getAttributeValue("isTestSource"));
                if (!includeTests && isTestFolder) continue;
                result2.add(this.getFile(sourceFolder.getAttributeValue("url")));
            }
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private List<Element> getContentRootElements() {
        return JDOMUtil.getChildren((Element)this.getComponentElement("NewModuleRootManager"), (String)"content");
    }

    @Override
    @NotNull
    public Collection<File> getContentRoots() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            String path2 = VfsUtilCore.urlToPath((String)contentRoot.getAttributeValue("url"));
            result2.add(new File(FileUtil.toSystemDependentName((String)this.expandPath(path2))));
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getProjectOutputUrl() {
        ComponentManagerSettings rootManagerSettings = this.context.getProjectRootManagerSettings();
        Element projectRootManager = rootManagerSettings == null ? null : rootManagerSettings.getComponentElement("ProjectRootManager");
        Element outputElement = projectRootManager == null ? null : projectRootManager.getChild("output");
        return outputElement == null ? null : outputElement.getAttributeValue("url");
    }

    @Override
    public void addExcludedFolder(@NotNull File directory) {
        File outputFile;
        String outputUrl;
        Element outputElement;
        Element projectRootManager;
        ComponentManagerSettings rootManagerSettings;
        if (directory == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(17);
        }
        if ((rootManagerSettings = this.context.getProjectRootManagerSettings()) != null && (projectRootManager = rootManagerSettings.getComponentElement("ProjectRootManager")) != null && (outputElement = projectRootManager.getChild("output")) != null && (outputUrl = outputElement.getAttributeValue("url")) != null && FileUtil.isAncestor((File)(outputFile = this.getFile(outputUrl)), (File)directory, (boolean)false)) {
            return;
        }
        for (Element contentRoot : this.getContentRootElements()) {
            File root2 = this.getFile(contentRoot.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)root2, (File)directory, (boolean)true)) continue;
            this.addExcludedFolder(directory, contentRoot);
        }
    }

    @Override
    @NotNull
    public List<File> getModuleLibraryRoots(String libraryName) {
        Element library2 = this.findModuleLibraryElement(libraryName);
        List<File> list2 = library2 != null ? this.context.getClassRoots(library2, this) : Collections.emptyList();
        if (list2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @Override
    public boolean hasModuleLibrary(String libraryName) {
        return this.findModuleLibraryElement(libraryName) != null;
    }

    @Nullable
    private Element findModuleLibraryElement(String libraryName) {
        for (Element element2 : this.getOrderEntries()) {
            Element library2;
            if (!"module-library".equals(element2.getAttributeValue("type")) || (library2 = element2.getChild("library")) == null || !libraryName.equals(library2.getAttributeValue("name"))) continue;
            return library2;
        }
        return null;
    }

    @Override
    public List<Element> getOrderEntries() {
        Element component2 = this.getComponentElement("NewModuleRootManager");
        return JDOMUtil.getChildren((Element)component2, (String)"orderEntry");
    }

    @Override
    @NotNull
    public Collection<ModuleSettings> getAllModuleDependencies() {
        HashSet<ModuleSettings> dependencies2 = new HashSet<ModuleSettings>();
        this.collectDependencies(dependencies2);
        HashSet<ModuleSettings> hashSet = dependencies2;
        if (hashSet == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private void collectDependencies(Set<ModuleSettings> dependencies2) {
        if (!dependencies2.add(this)) {
            return;
        }
        for (Element element2 : this.getOrderEntries()) {
            ModuleSettings moduleSettings;
            String moduleName;
            if (!"module".equals(element2.getAttributeValue("type")) || (moduleName = element2.getAttributeValue("module-name")) == null || (moduleSettings = this.context.getModuleSettings(moduleName)) == null) continue;
            ((ModuleSettingsImpl)moduleSettings).collectDependencies(dependencies2);
        }
    }

    private void addExcludedFolder(File directory, Element contentRoot) {
        for (Element excludedFolder : JDOMUtil.getChildren((Element)contentRoot, (String)"excludeFolder")) {
            File excludedDir = this.getFile(excludedFolder.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)excludedDir, (File)directory, (boolean)false)) continue;
            return;
        }
        String path2 = ConversionContextImpl.collapsePath(FileUtil.toSystemIndependentName((String)directory.getAbsolutePath()), this);
        contentRoot.addContent(new Element("excludeFolder").setAttribute("url", VfsUtilCore.pathToUrl((String)path2)));
    }

    private File getFile(String url) {
        return new File(FileUtil.toSystemDependentName((String)this.expandPath(VfsUtilCore.urlToPath((String)url))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ModuleSettingsImpl";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetTypeId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ModuleSettingsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collapsePath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraryRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFacetElements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFacetTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFacetElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFacetElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setModuleType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collapsePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

