/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageAnnotator
implements CoverageAnnotator {
    private final Project myProject;

    @Nullable
    protected abstract Runnable createRenewRequest(@NotNull CoverageSuitesBundle var1, @NotNull CoverageDataManager var2);

    public BaseCoverageAnnotator(Project project) {
        this.myProject = project;
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
    }

    @Override
    public void renewCoverageData(final @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        Runnable request2;
        if (suite == null) {
            BaseCoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (dataManager == null) {
            BaseCoverageAnnotator.$$$reportNull$$$0(1);
        }
        if ((request2 = this.createRenewRequest(suite, dataManager)) != null) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, CoverageBundle.message("coverage.view.loading.data", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    request2.run();
                }

                public void onSuccess() {
                    CoverageView coverageView = CoverageViewManager.getInstance(this.myProject).getToolwindow(suite);
                    if (coverageView != null) {
                        coverageView.updateParentTitle();
                    }
                }

                public void onCancel() {
                    super.onCancel();
                    CoverageDataManager.getInstance(this.myProject).chooseSuitesBundle(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/BaseCoverageAnnotator$1", "run"));
                }
            });
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "suite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/coverage/BaseCoverageAnnotator";
        objectArray[2] = "renewCoverageData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DirCoverageInfo
    extends FileCoverageInfo {
        public int totalFilesCount;
        public int coveredFilesCount;
    }

    public static class FileCoverageInfo {
        public int totalLineCount;
        public int coveredLineCount;
    }
}

