/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoverageListNode
extends AbstractTreeNode<Object> {
    protected CoverageSuitesBundle myBundle;
    protected CoverageViewManager.StateBean myStateBean;
    private final FileStatusManager myFileStatusManager;

    public CoverageListNode(Project project, @NotNull PsiNamedElement classOrPackage, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        if (classOrPackage == null) {
            CoverageListNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)classOrPackage);
        this.myName = (String)ReadAction.compute(() -> classOrPackage.getName());
        this.myBundle = bundle;
        this.myStateBean = stateBean;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Object[] children2 = CoverageViewTreeStructure.getChildren((Object)this, this.myBundle, this.myStateBean);
        List<CoverageListNode> list2 = Arrays.asList((CoverageListNode[])children2);
        if (list2 == null) {
            CoverageListNode.$$$reportNull$$$0(1);
        }
        return list2;
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            CoverageListNode.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object value2 = this.getValue();
            if (value2 instanceof PsiNamedElement) {
                if (value2 instanceof PsiQualifiedNamedElement && (this.myStateBean.myFlattenPackages && ((PsiNamedElement)value2).getContainingFile() == null || this.getParent() instanceof CoverageListRootNode)) {
                    presentation2.setPresentableText(((PsiQualifiedNamedElement)value2).getQualifiedName());
                } else {
                    presentation2.setPresentableText(((PsiNamedElement)value2).getName());
                }
                presentation2.setIcon(((PsiElement)value2).getIcon(0));
            }
        });
    }

    public FileStatus getFileStatus() {
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> {
            Object value2 = this.getValue();
            if (value2 instanceof PsiElement && ((PsiElement)value2).isValid()) {
                return ((PsiElement)value2).getContainingFile();
            }
            return null;
        });
        return containingFile != null ? this.myFileStatusManager.getStatus(containingFile.getVirtualFile()) : super.getFileStatus();
    }

    public boolean canNavigate() {
        Object value2 = this.getValue();
        return value2 instanceof PsiElement && ((PsiElement)value2).isValid() && ((PsiElement)value2).getContainingFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            PsiNamedElement value2 = (PsiNamedElement)this.getValue();
            if (requestFocus) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)value2, true);
            } else if (value2 instanceof NavigationItem) {
                ((NavigationItem)value2).navigate(false);
            }
        }
    }

    public int getWeight() {
        return (Integer)ReadAction.compute(() -> {
            Object value2 = this.getValue();
            if (value2 instanceof PsiElement && ((PsiElement)value2).getContainingFile() != null) {
                return 40;
            }
            return 30;
        });
    }

    public boolean contains(VirtualFile file2) {
        boolean equalContainingFile;
        Object value2 = this.getValue();
        if (value2 instanceof PsiElement && (equalContainingFile = Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value2)), (Object)file2))) {
            return true;
        }
        if (value2 instanceof PsiDirectory) {
            return this.contains(file2, (PsiDirectory)value2);
        }
        if (value2 instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiDirectoryContainer)value2).getDirectories()) {
                if (!this.contains(file2, directory)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(VirtualFile file2, PsiDirectory value2) {
        if (this.myStateBean.myFlattenPackages) {
            return Comparing.equal((Object)value2.getVirtualFile(), (Object)file2.getParent());
        }
        return VfsUtilCore.isAncestor((VirtualFile)value2.getVirtualFile(), (VirtualFile)file2, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

