/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH$J\u001b\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0096\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/credentialStore/keePass/BaseKeePassCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "()V", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "getDb", "()Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "markDirty", "", "set", "credentials", "intellij.platform.credentialStore"})
public abstract class BaseKeePassCredentialStore
implements CredentialStore {
    @NotNull
    protected abstract KeePassDatabase getDb();

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        KdbxGroup kdbxGroup = this.getDb().getRootGroup$intellij_platform_credentialStore().getGroup("IntelliJ Platform");
        if (kdbxGroup == null) {
            return null;
        }
        KdbxGroup group2 = kdbxGroup;
        String userName = StringKt.nullize$default((String)attributes2.getUserName(), (boolean)false, (int)1, null);
        KdbxEntry kdbxEntry = group2.getEntry(attributes2.getServiceName(), StringKt.nullize$default((String)userName, (boolean)false, (int)1, null));
        if (kdbxEntry == null) {
            return null;
        }
        KdbxEntry entry2 = kdbxEntry;
        String string = userName;
        if (string == null) {
            string = entry2.getUserName();
        }
        SecureString secureString = entry2.getPassword();
        return new Credentials(string, secureString != null ? SecureString.DefaultImpls.get$default(secureString, false, 1, null) : null);
    }

    public void set(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials2) {
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        if (credentials2 == null) {
            KdbxGroup kdbxGroup = this.getDb().getRootGroup$intellij_platform_credentialStore().getGroup("IntelliJ Platform");
            if (kdbxGroup != null) {
                kdbxGroup.removeEntry(attributes2.getServiceName(), StringKt.nullize$default((String)attributes2.getUserName(), (boolean)false, (int)1, null));
            }
        } else {
            SecureString secureString;
            KdbxGroup group2 = this.getDb().getRootGroup$intellij_platform_credentialStore().getOrCreateGroup("IntelliJ Platform");
            String string = StringKt.nullize$default((String)attributes2.getUserName(), (boolean)false, (int)1, null);
            if (string == null) {
                string = credentials2.getUserName();
            }
            String userName = string;
            KdbxEntry entry2 = group2.getEntry(attributes2.getServiceName(), Intrinsics.areEqual((Object)attributes2.getServiceName(), (Object)"IntelliJ Platform") ? userName : null);
            if (entry2 == null) {
                entry2 = group2.createEntry(attributes2.getServiceName(), userName);
            } else {
                entry2.setUserName(userName);
            }
            if (attributes2.isPasswordMemoryOnly() || credentials2.getPassword() == null) {
                secureString = null;
            } else {
                KeePassDatabase keePassDatabase = this.getDb();
                OneTimeString oneTimeString = credentials2.getPassword();
                Intrinsics.checkNotNull((Object)oneTimeString);
                secureString = keePassDatabase.protectValue$intellij_platform_credentialStore((CharSequence)oneTimeString);
            }
            entry2.setPassword(secureString);
        }
        if (this.getDb().isDirty()) {
            this.markDirty();
        }
    }

    protected abstract void markDirty();
}

