/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightToolWindow
extends JPanel {
    static final String LEFT_MIN_KEY = "left";
    static final String RIGHT_MIN_KEY = "right";
    static final int MINIMIZE_WIDTH = 25;
    private static final String IGNORE_WIDTH_KEY = "ignore_width";
    private final LightToolWindowContent myContent;
    private final JComponent myFocusedComponent;
    private final ThreeComponentsSplitter myContentSplitter;
    private ToolWindowAnchor myAnchor;
    private final Project myProject;
    private final LightToolWindowManager myManager;
    private final PropertiesComponent myPropertiesComponent;
    private boolean myShowContent;
    private final String myShowStateKey;
    private int myCurrentWidth;
    private final String myWidthKey;
    private final JPanel myMinimizeComponent;
    private final AnchoredButton myMinimizeButton;
    private final ComponentListener myWidthListener;

    public LightToolWindow(@NotNull LightToolWindowContent content2, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title2, @NotNull Icon icon2, @NotNull JComponent component2, @NotNull JComponent focusedComponent, @NotNull ThreeComponentsSplitter contentSplitter, @Nullable ToolWindowAnchor anchor2, @NotNull LightToolWindowManager manager2, @NotNull Project project, @NotNull String key, int defaultWidth, @Nullable List<AnAction> actions2) {
        if (content2 == null) {
            LightToolWindow.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            LightToolWindow.$$$reportNull$$$0(1);
        }
        if (icon2 == null) {
            LightToolWindow.$$$reportNull$$$0(2);
        }
        if (component2 == null) {
            LightToolWindow.$$$reportNull$$$0(3);
        }
        if (focusedComponent == null) {
            LightToolWindow.$$$reportNull$$$0(4);
        }
        if (contentSplitter == null) {
            LightToolWindow.$$$reportNull$$$0(5);
        }
        if (manager2 == null) {
            LightToolWindow.$$$reportNull$$$0(6);
        }
        if (project == null) {
            LightToolWindow.$$$reportNull$$$0(7);
        }
        if (key == null) {
            LightToolWindow.$$$reportNull$$$0(8);
        }
        super(new BorderLayout());
        this.myWidthListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width;
                int n = width = LightToolWindow.this.isLeft() ? LightToolWindow.this.myContentSplitter.getFirstSize() : LightToolWindow.this.myContentSplitter.getLastSize();
                if (width > 0 && width != LightToolWindow.this.myCurrentWidth && LightToolWindow.this.myContentSplitter.getInnerComponent().getClientProperty(LightToolWindow.IGNORE_WIDTH_KEY) == null) {
                    LightToolWindow.this.myCurrentWidth = width;
                    LightToolWindow.this.myPropertiesComponent.setValue(LightToolWindow.this.myWidthKey, Integer.toString(width));
                }
            }
        };
        this.myContent = content2;
        this.myFocusedComponent = focusedComponent;
        this.myContentSplitter = contentSplitter;
        this.myAnchor = anchor2;
        this.myProject = project;
        this.myManager = manager2;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myShowStateKey = "UI_DESIGNER_EDITOR_MODE." + key + ".SHOW";
        this.myWidthKey = "UI_DESIGNER_EDITOR_MODE." + key + ".WIDTH";
        HeaderPanel header2 = new HeaderPanel();
        header2.setLayout(new BorderLayout());
        this.add((Component)header2, "North");
        JLabel titleLabel = new JLabel(title2);
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)10));
        titleLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        header2.add((Component)titleLabel, "Center");
        JPanel actionPanel = new JPanel(new FlowLayout(1, 5, 0));
        actionPanel.setBorder((Border)JBUI.Borders.empty((int)3, (int)0, (int)2, (int)0));
        actionPanel.setOpaque(false);
        header2.add((Component)actionPanel, "East");
        if (actions2 != null) {
            for (AnAction action2 : actions2) {
                this.addAction(actionPanel, action2);
            }
            actionPanel.add(new JLabel(AllIcons.General.Divider));
        }
        this.addAction(actionPanel, new GearAction());
        this.addAction(actionPanel, new HideAction());
        JPanel contentWrapper = new JPanel(new BorderLayout());
        contentWrapper.setBorder(IdeBorderFactory.createBorder((int)2));
        contentWrapper.add((Component)component2, "Center");
        this.add((Component)contentWrapper, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                IdeFocusManager.getInstance((Project)LightToolWindow.this.myProject).requestFocus((Component)LightToolWindow.this.myFocusedComponent, true);
            }
        });
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component2, int x, int y) {
                LightToolWindow.this.showGearPopup(component2, x, y);
            }
        });
        this.myMinimizeButton = new AnchoredButton(title2, icon2){

            @Override
            public void updateUI() {
                this.setUI(StripeButtonUI.createUI(this));
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }

            @Override
            public int getMnemonic2() {
                return 0;
            }

            @Override
            public ToolWindowAnchor getAnchor() {
                return LightToolWindow.this.myAnchor;
            }
        };
        this.myMinimizeButton.addActionListener(e -> {
            this.myMinimizeButton.setSelected(false);
            this.updateContent(true, true);
        });
        this.myMinimizeButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.myMinimizeButton.setFocusable(false);
        this.myMinimizeButton.setRolloverEnabled(true);
        this.myMinimizeButton.setOpaque(false);
        this.myMinimizeComponent = new JPanel(){

            @Override
            public void doLayout() {
                Dimension size = LightToolWindow.this.myMinimizeButton.getPreferredSize();
                if (LightToolWindow.this.myAnchor == ToolWindowAnchor.BOTTOM) {
                    LightToolWindow.this.myMinimizeButton.setBounds(0, 1, size.width, 25);
                } else {
                    LightToolWindow.this.myMinimizeButton.setBounds(0, 0, this.getWidth(), size.height);
                }
            }
        };
        this.myMinimizeComponent.add(this.myMinimizeButton);
        this.configureBorder();
        this.configureWidth(defaultWidth);
        this.updateContent(this.myPropertiesComponent.getBoolean(this.myShowStateKey, true), false);
    }

    private void configureBorder() {
        int borderStyle;
        if (this.myAnchor == ToolWindowAnchor.LEFT) {
            borderStyle = 4;
        } else if (this.myAnchor == ToolWindowAnchor.RIGHT) {
            borderStyle = 1;
        } else if (this.myAnchor == ToolWindowAnchor.BOTTOM) {
            borderStyle = 2;
        } else {
            return;
        }
        this.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
        this.myMinimizeComponent.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
    }

    private void configureWidth(int defaultWidth) {
        this.myCurrentWidth = this.myPropertiesComponent.getInt(this.myWidthKey, defaultWidth);
        this.updateWidth();
        this.myContentSplitter.getInnerComponent().addComponentListener(this.myWidthListener);
    }

    private void updateWidth() {
        if (this.isLeft()) {
            this.myContentSplitter.setFirstSize(this.myCurrentWidth);
        } else {
            this.myContentSplitter.setLastSize(this.myCurrentWidth);
        }
    }

    void updateAnchor(ToolWindowAnchor newAnchor) {
        JComponent minimizeParent = this.myContentSplitter.getInnerComponent();
        minimizeParent.putClientProperty(IGNORE_WIDTH_KEY, Boolean.TRUE);
        if (this.myShowContent) {
            JComponent oldWindow;
            JComponent jComponent = oldWindow = this.isLeft() ? this.myContentSplitter.getFirstComponent() : this.myContentSplitter.getLastComponent();
            if (oldWindow == this) {
                this.setContentComponent(null);
            }
        } else {
            String key = this.getMinKey();
            if (minimizeParent.getClientProperty(key) == this.myMinimizeComponent) {
                minimizeParent.putClientProperty(key, null);
            }
            minimizeParent.putClientProperty(this.isLeft() ? RIGHT_MIN_KEY : LEFT_MIN_KEY, this.myMinimizeComponent);
            minimizeParent.revalidate();
        }
        this.myAnchor = newAnchor;
        this.configureBorder();
        this.updateWidth();
        if (this.myShowContent) {
            this.setContentComponent(this);
        }
        minimizeParent.putClientProperty(IGNORE_WIDTH_KEY, null);
    }

    private void updateContent(boolean show2, boolean flag) {
        this.myShowContent = show2;
        String key = this.getMinKey();
        JComponent minimizeParent = this.myContentSplitter.getInnerComponent();
        if (show2) {
            minimizeParent.putClientProperty(key, null);
            minimizeParent.remove(this.myMinimizeComponent);
        }
        this.setContentComponent(show2 ? this : null);
        if (!show2) {
            minimizeParent.putClientProperty(key, this.myMinimizeComponent);
            minimizeParent.add(this.myMinimizeComponent);
        }
        minimizeParent.revalidate();
        if (flag) {
            this.myPropertiesComponent.setValue(this.myShowStateKey, Boolean.toString(show2));
        }
    }

    private void setContentComponent(JComponent component2) {
        if (this.isLeft()) {
            this.myContentSplitter.setFirstComponent(component2);
        } else {
            this.myContentSplitter.setLastComponent(component2);
        }
    }

    public void dispose() {
        JComponent minimizeParent = this.myContentSplitter.getInnerComponent();
        minimizeParent.removeComponentListener(this.myWidthListener);
        this.setContentComponent(null);
        this.myContent.dispose();
        if (!this.myShowContent) {
            minimizeParent.putClientProperty(this.getMinKey(), null);
            minimizeParent.remove(this.myMinimizeComponent);
            minimizeParent.revalidate();
        }
    }

    private String getMinKey() {
        return this.isLeft() ? LEFT_MIN_KEY : RIGHT_MIN_KEY;
    }

    public Object getContent() {
        return this.myContent;
    }

    private boolean isLeft() {
        return this.myAnchor == ToolWindowAnchor.LEFT;
    }

    private boolean isActive() {
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component component2 = fm.getFocusedDescendantFor((Component)this);
        if (component2 != null) {
            return true;
        }
        Component owner = fm.getLastFocusedFor((Window)WindowManager.getInstance().getFrame(this.myProject));
        return owner != null && SwingUtilities.isDescendingFrom(owner, this);
    }

    private void addAction(JPanel actionPanel, AnAction action2) {
        actionPanel.add((Component)((Object)new ActionButton(action2)));
    }

    private DefaultActionGroup createGearPopupGroup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(this.myManager.createGearActions());
        if (this.myManager.getAnchor() == null) {
            group2.addSeparator();
            DefaultActionGroup viewModeGroup = DefaultActionGroup.createPopupGroup(() -> ActionsBundle.groupText((String)"TW.ViewModeGroup"));
            for (ToolWindowViewModeAction.ViewMode viewMode : ToolWindowViewModeAction.ViewMode.values()) {
                viewModeGroup.add((AnAction)new MyViewModeAction(viewMode));
            }
            group2.add((AnAction)viewModeGroup);
        }
        return group2;
    }

    private void showGearPopup(Component component2, int x, int y) {
        ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("ToolwindowPopup", (ActionGroup)this.createGearPopupGroup(), new MenuItemPresentationFactory());
        popupMenu.getComponent().show(component2, x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "content";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "focusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "contentSplitter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
        }
        objectArray[1] = "com/intellij/designer/LightToolWindow";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HeaderPanel
    extends JPanel {
        private HeaderPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width, TabsUtil.getTabsHeight());
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            return new Dimension(size.width, TabsUtil.getTabsHeight());
        }
    }

    private class ActionButton
    extends Wrapper
    implements ActionListener {
        private final AnAction myAction;

        ActionButton(AnAction action2) {
            this.myAction = action2;
            Presentation presentation2 = action2.getTemplatePresentation();
            InplaceButton button4 = new InplaceButton(KeymapUtil.createTooltipText((String)presentation2.getText(), (AnAction)action2), EmptyIcon.ICON_16, this){

                public boolean isActive() {
                    return LightToolWindow.this.isActive();
                }
            };
            button4.setHoveringEnabled(!SystemInfo.isMac);
            this.setContent((JComponent)button4);
            Icon icon2 = presentation2.getIcon();
            Icon hoveredIcon = presentation2.getHoveredIcon();
            button4.setIcons(icon2, icon2, hoveredIcon == null ? icon2 : hoveredIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputEvent inputEvent = e.getSource() instanceof InputEvent ? (InputEvent)e.getSource() : null;
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            this.myAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.myAction, (InputEvent)inputEvent, (String)"ToolwindowTitle", (DataContext)dataContext));
        }
    }

    private final class MyViewModeAction
    extends ToolWindowViewModeAction {
        private MyViewModeAction(ToolWindowViewModeAction.ViewMode mode) {
            if (mode == null) {
                MyViewModeAction.$$$reportNull$$$0(0);
            }
            super(mode);
            ActionUtil.copyFrom((AnAction)this, (String)mode.getActionID());
        }

        @Override
        @Nullable
        protected ToolWindow getToolWindow(AnActionEvent e) {
            return LightToolWindow.this.myManager.getToolWindow();
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyViewModeAction.$$$reportNull$$$0(1);
            }
            super.setSelected(e, state);
            LightToolWindow.this.myManager.setEditorMode(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/designer/LightToolWindow$MyViewModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HideAction
    extends AnAction {
        HideAction() {
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(UIBundle.messagePointer((String)"tool.window.hide.action.name", (Object[])new Object[0]));
            presentation2.setIcon(AllIcons.General.HideToolWindow);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HideAction.$$$reportNull$$$0(0);
            }
            LightToolWindow.this.updateContent(false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/LightToolWindow$HideAction", "actionPerformed"));
        }
    }

    private class GearAction
    extends AnAction {
        GearAction() {
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setIcon(AllIcons.General.GearPlain);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GearAction.$$$reportNull$$$0(0);
            }
            int x = 0;
            int y = 0;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            LightToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/LightToolWindow$GearAction", "actionPerformed"));
        }
    }
}

