/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance(PropertyTable.class);
    private static final Comparator<String> GROUP_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1, (String)o2, (boolean)true);
    private static final Comparator<Property> PROPERTY_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
    private boolean mySorted;
    private boolean myShowGroups;
    private boolean myShowExpertProperties;
    private String[] myColumnNames = new String[]{"Property", "Value"};
    private final TableSpeedSearch mySpeedSearch;
    private final AbstractTableModel myModel = new PropertyTableModel();
    protected List<PropertiesContainer> myContainers = Collections.emptyList();
    protected List<Property> myProperties = Collections.emptyList();
    protected final Set<String> myExpandedProperties = new HashSet<String>();
    private boolean mySkipUpdate;
    private boolean myStoppingEditing;
    private final TableCellRenderer myCellRenderer = new PropertyCellRenderer();
    private final PropertyCellEditor myCellEditor = new PropertyCellEditor();
    private final PropertyEditorListener myPropertyEditorListener = new PropertyCellEditorListener();

    public PropertyTable() {
        this.setModel(this.myModel);
        this.setSelectionMode(0);
        this.setShowColumns(false);
        this.setAutoResizeMode(3);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setGridColor(ColorUtil.darker((Color)this.getBackground(), (int)1));
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseTableListener());
        TableHoverListener.DEFAULT.removeFrom((JComponent)((Object)this));
        this.mySpeedSearch = new TableSpeedSearch((JTable)((Object)this), (object, cell2) -> {
            if (cell2.column != 0) {
                return null;
            }
            if (object instanceof GroupProperty) {
                return null;
            }
            return ((Property)object).getName();
        }){

            @Override
            protected void selectElement(Object element2, String selectedText) {
                super.selectElement(element2, selectedText);
                PropertyTable.this.repaint(PropertyTable.this.getVisibleRect());
            }
        };
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, false));
    }

    public void setColumnNames(String ... columnNames) {
        if (columnNames.length != 2) {
            throw new IllegalArgumentException("Invalid number of columns. Expected 2, got " + columnNames.length);
        }
        this.myColumnNames = columnNames;
        TableColumnModel mmodel = this.getColumnModel();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            mmodel.getColumn(i2).setHeaderValue(columnNames[i2]);
        }
    }

    public void setSorted(boolean sorted) {
        this.mySorted = sorted;
        this.update();
    }

    public boolean isSorted() {
        return this.mySorted;
    }

    public void setShowGroups(boolean showGroups) {
        this.myShowGroups = showGroups;
        this.update();
    }

    public boolean isShowGroups() {
        return this.myShowGroups;
    }

    public void showExpert(boolean showExpert) {
        this.myShowExpertProperties = showExpert;
        this.update();
    }

    public boolean isShowExpertProperties() {
        return this.myShowExpertProperties;
    }

    public void setUI(TableUI ui2) {
        super.setUI(ui2);
        ActionMap actionMap = this.getActionMap();
        this.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        InputMap focusedInputMap = this.getInputMap(0);
        InputMap ancestorInputMap = this.getInputMap(1);
        actionMap.put("selectPreviousRow", new MySelectNextPreviousRowAction(false));
        actionMap.put("selectNextRow", new MySelectNextPreviousRowAction(true));
        actionMap.put("startEditing", new MyStartEditingAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(113, 0));
        actionMap.put("smartEnter", new MyEnterAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(10, 0), "smartEnter");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(10, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        ancestorInputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("restoreDefault", new MyRestoreDefaultAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(127, 0), "restoreDefault");
        ancestorInputMap.put(KeyStroke.getKeyStroke(127, 0), "restoreDefault");
        focusedInputMap.put(KeyStroke.getKeyStroke(8, 0), "restoreDefault");
        ancestorInputMap.put(KeyStroke.getKeyStroke(8, 0), "restoreDefault");
        actionMap.put("expandCurrent", new MyExpandCurrentAction(true, false));
        focusedInputMap.put(KeyStroke.getKeyStroke(107, 0), "expandCurrent");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(107, 0));
        actionMap.put("expandCurrentRight", new MyExpandCurrentAction(true, true));
        focusedInputMap.put(KeyStroke.getKeyStroke(39, 0), "expandCurrentRight");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(39, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(227, 0), "expandCurrentRight");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(227, 0));
        actionMap.put("collapseCurrent", new MyExpandCurrentAction(false, false));
        focusedInputMap.put(KeyStroke.getKeyStroke(109, 0), "collapseCurrent");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(109, 0));
        actionMap.put("collapseCurrentLeft", new MyExpandCurrentAction(false, true));
        focusedInputMap.put(KeyStroke.getKeyStroke(37, 0), "collapseCurrentLeft");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(37, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(226, 0), "collapseCurrentLeft");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(226, 0));
    }

    public TableCellRenderer getCellRenderer(int row2, int column2) {
        return this.myCellRenderer;
    }

    public void restoreDefaultValue() {
        Property property2 = this.getSelectionProperty();
        if (property2 != null) {
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            this.doRestoreDefault((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
                for (PropertiesContainer component2 : this.myContainers) {
                    if (property2.isDefaultRecursively(component2)) continue;
                    property2.setDefaultValue(component2);
                }
            }));
            this.repaint();
        }
    }

    protected abstract boolean doRestoreDefault(ThrowableRunnable<Exception> var1);

    @Nullable
    public ErrorInfo getErrorInfoForRow(int row2) {
        if (this.myContainers.size() != 1) {
            return null;
        }
        Property property2 = this.myProperties.get(row2);
        if (property2.getParent() != null) {
            return null;
        }
        for (ErrorInfo errorInfo : this.getErrors(this.myContainers.get(0))) {
            if (!property2.getName().equals(errorInfo.getPropertyName())) continue;
            return errorInfo;
        }
        return null;
    }

    protected abstract List<ErrorInfo> getErrors(@NotNull PropertiesContainer var1);

    public String getToolTipText(MouseEvent event) {
        int row2 = this.rowAtPoint(event.getPoint());
        if (row2 != -1 && !this.myProperties.isEmpty()) {
            String tooltip2;
            ErrorInfo errorInfo = this.getErrorInfoForRow(row2);
            if (errorInfo != null) {
                return errorInfo.getName();
            }
            if (this.columnAtPoint(event.getPoint()) == 0 && (tooltip2 = this.myProperties.get(row2).getTooltip()) != null) {
                return tooltip2;
            }
        }
        return super.getToolTipText(event);
    }

    @Nullable
    protected PropertyContext getPropertyContext() {
        return null;
    }

    public void update() {
        this.update(this.myContainers, null);
    }

    public void update(@NotNull List<? extends PropertiesContainer> containers, @Nullable Property initialSelection) {
        if (containers == null) {
            PropertyTable.$$$reportNull$$$0(0);
        }
        this.update(containers, initialSelection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@NotNull List<? extends PropertiesContainer> containers, @Nullable Property initialSelection, boolean finishEditing) {
        if (containers == null) {
            PropertyTable.$$$reportNull$$$0(1);
        }
        if (finishEditing) {
            this.finishEditing();
        }
        if (this.mySkipUpdate) {
            return;
        }
        this.mySkipUpdate = true;
        try {
            if (finishEditing && this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            Property selection = initialSelection != null ? initialSelection : this.getSelectionProperty();
            this.myContainers = new ArrayList<PropertiesContainer>(containers);
            this.fillProperties();
            this.myModel.fireTableDataChanged();
            this.restoreSelection(selection);
        }
        finally {
            this.mySkipUpdate = false;
        }
    }

    private void sortPropertiesAndCreateGroups(List<Property> rootProperties) {
        if (!this.mySorted && !this.myShowGroups) {
            return;
        }
        rootProperties.sort((o1, o2) -> {
            int result2;
            if (o1.getParent() != null || o2.getParent() != null) {
                if (o1.getParent() == o2) {
                    return -1;
                }
                if (o2.getParent() == o1) {
                    return 1;
                }
                return 0;
            }
            if (this.myShowGroups && (result2 = this.getGroupComparator().compare(o1.getGroup(), o2.getGroup())) != 0) {
                return result2;
            }
            return this.mySorted ? this.getPropertyComparator().compare((Property)o1, (Property)o2) : 0;
        });
        if (this.myShowGroups) {
            for (int i2 = 0; i2 < rootProperties.size() - 1; ++i2) {
                String prevGroup;
                Property prev2 = i2 == 0 ? null : rootProperties.get(i2 - 1);
                Property each = rootProperties.get(i2);
                String eachGroup = each.getGroup();
                String string = prevGroup = prev2 == null ? null : prev2.getGroup();
                if (prevGroup == null && eachGroup == null || StringUtil.equalsIgnoreCase((CharSequence)eachGroup, (CharSequence)prevGroup)) continue;
                rootProperties.add(i2, new GroupProperty(each.getGroup()));
                ++i2;
            }
        }
    }

    @NotNull
    protected Comparator<String> getGroupComparator() {
        Comparator<String> comparator2 = GROUP_COMPARATOR;
        if (comparator2 == null) {
            PropertyTable.$$$reportNull$$$0(2);
        }
        return comparator2;
    }

    @NotNull
    protected Comparator<Property> getPropertyComparator() {
        Comparator<Property> comparator2 = PROPERTY_COMPARATOR;
        if (comparator2 == null) {
            PropertyTable.$$$reportNull$$$0(3);
        }
        return comparator2;
    }

    protected List<Property> getProperties(PropertiesContainer component2) {
        return component2.getProperties();
    }

    private void restoreSelection(Property selection) {
        int index2;
        int i2;
        ArrayList<Property> propertyPath = new ArrayList<Property>(2);
        while (selection != null) {
            propertyPath.add(0, selection);
            selection = selection.getParent();
        }
        int indexToSelect = -1;
        int size = propertyPath.size();
        for (i2 = 0; i2 < size && (index2 = PropertyTable.findFullPathProperty(this.myProperties, (Property)propertyPath.get(i2))) != -1; ++i2) {
            if (i2 == size - 1) {
                indexToSelect = index2;
                continue;
            }
            this.expand(index2);
        }
        if (indexToSelect != -1) {
            this.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
        } else if (this.getRowCount() > 0) {
            indexToSelect = 0;
            for (i2 = 0; i2 < this.myProperties.size(); ++i2) {
                if (this.myProperties.get(i2) instanceof GroupProperty) continue;
                indexToSelect = i2;
                break;
            }
            this.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
        }
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    private void fillProperties() {
        this.myProperties = new ArrayList<Property>();
        int size = this.myContainers.size();
        if (size > 0) {
            ArrayList<Property> rootProperties = new ArrayList<Property>();
            for (Property property2 : this.getProperties(this.myContainers.get(0))) {
                this.addIfNeeded(this.getCurrentComponent(), property2, rootProperties);
            }
            this.sortPropertiesAndCreateGroups(rootProperties);
            for (Property<Object> property3 : rootProperties) {
                this.myProperties.add(property3);
                this.addExpandedChildren(this.getCurrentComponent(), property3, this.myProperties);
            }
            if (size > 1) {
                Iterator<Property> I = this.myProperties.iterator();
                while (I.hasNext()) {
                    if (I.next().availableFor(this.myContainers)) continue;
                    I.remove();
                }
                for (int i2 = 1; i2 < size; ++i2) {
                    ArrayList arrayList = new ArrayList();
                    this.fillProperties(this.myContainers.get(i2), arrayList);
                    Iterator<Property> I2 = this.myProperties.iterator();
                    block4: while (I2.hasNext()) {
                        Property addedProperty = I2.next();
                        int index2 = PropertyTable.findFullPathProperty(arrayList, addedProperty);
                        if (index2 == -1) {
                            I2.remove();
                            continue;
                        }
                        Property testProperty = (Property)arrayList.get(index2);
                        if (!addedProperty.getClass().equals(testProperty.getClass())) {
                            I2.remove();
                            continue;
                        }
                        List<Property> addedChildren = this.getChildren(addedProperty);
                        List<Property> testChildren = this.getChildren(testProperty);
                        int addedChildrenSize = addedChildren.size();
                        if (addedChildrenSize != testChildren.size()) {
                            I2.remove();
                            continue;
                        }
                        for (int j = 0; j < addedChildrenSize; ++j) {
                            if (addedChildren.get(j).getName().equals(testChildren.get(j).getName())) continue;
                            I2.remove();
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    private void fillProperties(PropertiesContainer<?> component2, List<? super Property> properties2) {
        for (Property each : this.getProperties(component2)) {
            if (!this.addIfNeeded(component2, each, properties2)) continue;
            this.addExpandedChildren(component2, each, properties2);
        }
    }

    private void addExpandedChildren(PropertiesContainer<?> component2, Property property2, List<? super Property> properties2) {
        if (this.isExpanded(property2)) {
            for (Property child2 : this.getChildren(property2)) {
                if (!this.addIfNeeded(component2, child2, properties2)) continue;
                this.addExpandedChildren(component2, child2, properties2);
            }
        }
    }

    private boolean addIfNeeded(PropertiesContainer<?> component2, Property property2, List<? super Property> properties2) {
        if (property2.isExpert() && !this.myShowExpertProperties) {
            try {
                if (property2.isDefaultRecursively(component2)) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        properties2.add(property2);
        return true;
    }

    @Nullable
    public static Property findProperty(List<? extends Property> properties2, String name2) {
        for (Property property2 : properties2) {
            if (!name2.equals(property2.getName())) continue;
            return property2;
        }
        return null;
    }

    public static int findProperty(List<? extends Property> properties2, Property property2) {
        String name2 = property2.getName();
        int size = properties2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Property nextProperty = properties2.get(i2);
            if (!Objects.equals(nextProperty.getGroup(), property2.getGroup()) || !name2.equals(nextProperty.getName())) continue;
            return i2;
        }
        return -1;
    }

    private static int findFullPathProperty(List<? extends Property> properties2, Property property2) {
        Property parent = property2.getParent();
        if (parent == null) {
            return PropertyTable.findProperty(properties2, property2);
        }
        String name2 = PropertyTable.getFullPathName(property2);
        int size = properties2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!name2.equals(PropertyTable.getFullPathName(properties2.get(i2)))) continue;
            return i2;
        }
        return -1;
    }

    private static String getFullPathName(Property property2) {
        StringBuilder builder2 = new StringBuilder();
        while (property2 != null) {
            builder2.insert(0, ".").insert(0, property2.getName());
            property2 = property2.getParent();
        }
        return builder2.toString();
    }

    public static void moveProperty(List<? extends Property> source, String name2, List<? super Property> destination, int index2) {
        Property property2 = PropertyTable.extractProperty(source, name2);
        if (property2 != null) {
            if (index2 == -1) {
                destination.add(property2);
            } else {
                destination.add(index2, property2);
            }
        }
    }

    @Nullable
    public static Property extractProperty(List<? extends Property> properties2, String name2) {
        int size = properties2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!name2.equals(properties2.get(i2).getName())) continue;
            return properties2.remove(i2);
        }
        return null;
    }

    @Nullable
    public Property getSelectionProperty() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this.myProperties.size()) {
            return this.myProperties.get(selectedRow);
        }
        return null;
    }

    @Nullable
    private PropertiesContainer getCurrentComponent() {
        return this.myContainers.size() == 1 ? this.myContainers.get(0) : null;
    }

    private List<Property> getChildren(Property property2) {
        return property2.getChildren(this.getCurrentComponent());
    }

    private List<Property> getFilterChildren(Property property2) {
        ArrayList<Property> properties2 = new ArrayList<Property>(this.getChildren(property2));
        Iterator I = properties2.iterator();
        while (I.hasNext()) {
            Property child2 = (Property)I.next();
            if (!child2.isExpert() || this.myShowExpertProperties) continue;
            I.remove();
        }
        return properties2;
    }

    public boolean isDefault(Property property2) throws Exception {
        for (PropertiesContainer component2 : this.myContainers) {
            if (property2.isDefaultRecursively(component2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected final Object getValue(Property property2) throws Exception {
        int size = this.myContainers.size();
        if (size == 0) {
            return null;
        }
        Object value2 = property2.getValue(this.myContainers.get(0));
        for (int i2 = 1; i2 < size; ++i2) {
            if (Comparing.equal((Object)value2, (Object)property2.getValue(this.myContainers.get(i2)))) continue;
            return null;
        }
        return value2;
    }

    private boolean isExpanded(Property property2) {
        return this.myExpandedProperties.contains(property2.getPath());
    }

    private void collapse(int rowIndex) {
        int selectedRow = this.getSelectedRow();
        Property property2 = this.myProperties.get(rowIndex);
        int size = this.collapse(property2, rowIndex + 1);
        LOG.assertTrue(size > 0);
        this.myModel.fireTableDataChanged();
        if (selectedRow != -1) {
            if (selectedRow > rowIndex) {
                selectedRow -= size;
            }
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    }

    private int collapse(Property property2, int startIndex) {
        int totalSize = 0;
        if (this.myExpandedProperties.remove(property2.getPath())) {
            int size = this.getFilterChildren(property2).size();
            totalSize += size;
            for (int i2 = 0; i2 < size; ++i2) {
                totalSize += this.collapse(this.myProperties.remove(startIndex), startIndex);
            }
        }
        return totalSize;
    }

    private void expand(int rowIndex) {
        int selectedRow = this.getSelectedRow();
        Property property2 = this.myProperties.get(rowIndex);
        String path2 = property2.getPath();
        if (this.myExpandedProperties.contains(path2)) {
            return;
        }
        this.myExpandedProperties.add(path2);
        List<Property> properties2 = this.getFilterChildren(property2);
        this.myProperties.addAll(rowIndex + 1, properties2);
        this.myModel.fireTableDataChanged();
        if (selectedRow != -1) {
            if (selectedRow > rowIndex) {
                selectedRow += properties2.size();
            }
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        Rectangle rectStart = this.getCellRect(selectedRow, 0, true);
        Rectangle rectEnd = this.getCellRect(selectedRow + properties2.size(), 0, true);
        this.scrollRectToVisible(new Rectangle(rectStart.x, rectStart.y, rectEnd.x + rectEnd.width - rectStart.x, rectEnd.y + rectEnd.height - rectStart.y));
    }

    public void setValueAt(Object aValue, int row2, int column2) {
        Property property2 = this.myProperties.get(row2);
        super.setValueAt(aValue, row2, column2);
        if (property2.needRefreshPropertyList()) {
            this.update();
        }
        this.repaint();
    }

    public TableCellEditor getCellEditor(int row2, int column2) {
        PropertyEditor editor2 = this.myProperties.get(row2).getEditor();
        editor2.removePropertyEditorListener(this.myPropertyEditorListener);
        editor2.addPropertyEditorListener(this.myPropertyEditorListener);
        this.myCellEditor.setEditor(editor2);
        return this.myCellEditor;
    }

    public boolean editCellAt(int row2, int column2, EventObject e) {
        boolean result2 = super.editCellAt(row2, column2, e);
        this.repaint(this.getCellRect(row2, column2, true));
        return result2;
    }

    private void startEditing(int index2) {
        this.startEditing(index2, false);
    }

    private void startEditing(int index2, boolean startedWithKeyboard) {
        PropertyEditor editor2 = this.myProperties.get(index2).getEditor();
        if (editor2 == null) {
            return;
        }
        this.editCellAt(index2, this.convertColumnIndexToView(1));
        LOG.assertTrue(this.editorComp != null);
        JComponent preferredComponent = editor2.getPreferredFocusedComponent();
        if (preferredComponent == null) {
            preferredComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.editorComp);
        }
        if (preferredComponent != null) {
            preferredComponent.requestFocusInWindow();
        }
        if (startedWithKeyboard) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> editor2.activate());
        }
    }

    private void finishEditing() {
        if (this.editingRow != -1) {
            this.editingStopped(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingStopped(@Nullable ChangeEvent event) {
        if (this.myStoppingEditing) {
            return;
        }
        this.myStoppingEditing = true;
        LOG.assertTrue(this.isEditing());
        LOG.assertTrue(this.editingRow != -1);
        PropertyEditor editor2 = this.myProperties.get(this.editingRow).getEditor();
        editor2.removePropertyEditorListener(this.myPropertyEditorListener);
        try {
            this.setValueAt(editor2.getValue(), this.editingRow, this.editingColumn);
        }
        catch (Exception e) {
            PropertyTable.showInvalidInput(e);
        }
        finally {
            this.removeEditor();
            this.myStoppingEditing = false;
        }
    }

    public void removeEditor() {
        super.removeEditor();
        this.updateEditActions();
    }

    protected void updateEditActions() {
    }

    private boolean setValueAtRow(int row2, Object newValue2) {
        Property property2 = this.myProperties.get(row2);
        Object[] oldValue = new Object[1];
        try {
            boolean isNewValue;
            oldValue[0] = this.getValue(property2);
            boolean bl = isNewValue = !Comparing.equal((Object)oldValue[0], (Object)newValue2);
            if (newValue2 != null) break block4;
            if (!(oldValue[0] instanceof String)) break block5;
            if (((String)oldValue[0]).length() == 0) {
                isNewValue = false;
            }
        }
        finally {
            boolean isSetValue = true;
        }
        {
            block4: {
                block5: {
                }
            }
        }
    }

    protected abstract boolean doSetValue(ThrowableRunnable<Exception> var1);

    private static void showInvalidInput(Exception e) {
        String message2;
        Throwable cause = e.getCause();
        String string = message2 = cause == null ? e.getMessage() : cause.getMessage();
        if (message2 == null || message2.length() == 0) {
            message2 = IdeBundle.message((String)"dialog.message.no.message", (Object[])new Object[0]);
        }
        Messages.showMessageDialog((String)IdeBundle.message((String)"dialog.message.error.setting.value", (Object[])new Object[]{message2}), (String)IdeBundle.message((String)"dialog.title.invalid.input", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    private static int getDepth(@NotNull Property property2) {
        if (property2 == null) {
            PropertyTable.$$$reportNull$$$0(4);
        }
        int result2 = 0;
        Property each = property2.getParent();
        while (each != null) {
            each = each.getParent();
            ++result2;
        }
        return result2;
    }

    @NotNull
    private static Couple<Integer> getBeforeIconAndAfterIndents(@NotNull Property property2, @NotNull Icon icon2) {
        if (property2 == null) {
            PropertyTable.$$$reportNull$$$0(5);
        }
        if (icon2 == null) {
            PropertyTable.$$$reportNull$$$0(6);
        }
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int beforeIcon = nodeIndent * PropertyTable.getDepth(property2);
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - icon2.getIconWidth() / 2);
        int afterIcon = Math.max(0, nodeIndent - leftIconOffset - icon2.getIconWidth());
        Couple couple = Couple.of((Object)(beforeIcon += leftIconOffset), (Object)afterIcon);
        if (couple == null) {
            PropertyTable.$$$reportNull$$$0(7);
        }
        return couple;
    }

    public static void updateRenderer(JComponent component2, boolean selected2) {
        if (selected2) {
            component2.setForeground(UIUtil.getTableSelectionForeground());
            component2.setBackground(UIUtil.getTableSelectionBackground((boolean)true));
        } else {
            component2.setForeground(UIUtil.getTableForeground());
            component2.setBackground(UIUtil.getTableBackground());
        }
    }

    @NotNull
    protected abstract TextAttributesKey getErrorAttributes(@NotNull HighlightSeverity var1);

    private /* synthetic */ void lambda$setValueAtRow$6(Property property2, Object newValue2, boolean[] needRefresh, Object[] oldValue) throws Exception {
        for (PropertiesContainer component2 : this.myContainers) {
            property2.setValue(component2, newValue2);
            needRefresh[0] = needRefresh[0] | property2.needRefreshPropertyList(component2, oldValue[0], newValue2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containers";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/propertyTable/PropertyTable";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/propertyTable/PropertyTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyComparator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeIconAndAfterIndents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDepth";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeIconAndAfterIndents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GroupProperty
    extends Property {
        GroupProperty(@Nullable String name2) {
            super(null, StringUtil.notNullize((String)name2));
        }

        @Override
        @NotNull
        public PropertyRenderer getRenderer() {
            return new LabelPropertyRenderer(null);
        }

        @Override
        public PropertyEditor getEditor() {
            return null;
        }
    }

    private final class PropertyCellRenderer
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myCellRenderer = new MyCellRenderer();
        private final ColoredTableCellRenderer myGroupRenderer;

        private PropertyCellRenderer() {
            this.myGroupRenderer = new MyCellRenderer(){
                private boolean mySelected;
                public boolean myDrawTopLine;

                @Override
                protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.customizeCellRenderer(table, value2, selected2, hasFocus, row2, column2);
                    this.mySelected = selected2;
                    this.myDrawTopLine = row2 > 0;
                }

                protected void paintBackground(Graphics2D g, int x, int width, int height) {
                    if (this.mySelected) {
                        super.paintBackground(g, x, width, height);
                    } else {
                        UIUtil.drawHeader((Graphics)g, (int)x, (int)width, (int)height, (boolean)true, (boolean)this.myDrawTopLine);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/designer/propertyTable/PropertyTable$PropertyCellRenderer$1", "customizeCellRenderer"));
                }
            };
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean selected2, boolean cellHasFocus, int row2, int column2) {
            column2 = table.convertColumnIndexToModel(column2);
            Property property2 = (Property)value2;
            Color background = table.getBackground();
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean tableHasFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, table);
            ColoredTableCellRenderer renderer2 = property2 instanceof GroupProperty ? this.myGroupRenderer : this.myCellRenderer;
            renderer2.getTableCellRendererComponent(table, value2, selected2, cellHasFocus, row2, column2);
            renderer2.setBackground(selected2 ? UIUtil.getTreeSelectionBackground((boolean)tableHasFocus) : background);
            if (property2 instanceof GroupProperty) {
                renderer2.setIpad(new Insets(0, 5, 0, 0));
                if (column2 == 0) {
                    renderer2.append(property2.getName());
                }
                return renderer2;
            }
            boolean isDefault = true;
            try {
                for (PropertiesContainer container : PropertyTable.this.myContainers) {
                    if (property2.showAsDefault(container)) continue;
                    isDefault = false;
                    break;
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
            renderer2.clear();
            if (column2 == 0) {
                ErrorInfo errorInfo;
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (!selected2 && !isDefault) {
                    attr = attr.derive(-1, FileStatus.MODIFIED.getColor(), null, null);
                }
                if (property2.isImportant()) {
                    attr = attr.derive(attr.getStyle() | 1, null, null, null);
                }
                if (property2.isExpert()) {
                    attr = attr.derive(attr.getStyle() | 2, null, null, null);
                }
                if (property2.isDeprecated()) {
                    attr = attr.derive(attr.getStyle() | 4, null, null, null);
                }
                if ((errorInfo = PropertyTable.this.getErrorInfoForRow(row2)) != null) {
                    SimpleTextAttributes template = SimpleTextAttributes.fromTextAttributes(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertyTable.this.getErrorAttributes(errorInfo.getLevel().getSeverity())));
                    int style = ((template.getStyle() & 8) != 0 ? 8 : 0) | ((template.getStyle() & 0x10) != 0 ? 16 : 0);
                    attr = attr.derive(attr.getStyle() | style, template.getFgColor(), null, template.getWaveColor());
                }
                SearchUtil.appendFragments(PropertyTable.this.mySpeedSearch.getEnteredPrefix(), property2.getName(), attr.getStyle(), attr.getFgColor(), attr.getBgColor(), (SimpleColoredComponent)renderer2);
                Icon icon2 = UIUtil.getTreeNodeIcon((boolean)PropertyTable.this.isExpanded(property2), (boolean)selected2, (boolean)tableHasFocus);
                boolean hasChildren = !PropertyTable.this.getChildren(property2).isEmpty();
                renderer2.setIcon(hasChildren ? icon2 : null);
                Couple<Integer> indents = PropertyTable.getBeforeIconAndAfterIndents(property2, icon2);
                int indent = (Integer)indents.first;
                if (hasChildren) {
                    renderer2.setIconTextGap(((Integer)indents.second).intValue());
                } else {
                    indent += icon2.getIconWidth() + (Integer)indents.second;
                }
                renderer2.setIpad(new Insets(0, indent, 0, 0));
                return renderer2;
            }
            try {
                PropertyRenderer valueRenderer = property2.getRenderer();
                JComponent component2 = valueRenderer.getComponent(PropertyTable.this.getCurrentComponent(), PropertyTable.this.getPropertyContext(), PropertyTable.this.getValue(property2), selected2, tableHasFocus);
                component2.setBackground(selected2 ? UIUtil.getTreeSelectionBackground((boolean)tableHasFocus) : background);
                component2.setFont(table.getFont());
                return component2;
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                renderer2.append(IdeBundle.message((String)"dialog.text.error.getting.value", (Object[])new Object[]{e.getMessage()}), SimpleTextAttributes.ERROR_ATTRIBUTES);
                return renderer2;
            }
        }

        private class MyCellRenderer
        extends ColoredTableCellRenderer {
            private MyCellRenderer() {
            }

            protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                if (table == null) {
                    MyCellRenderer.$$$reportNull$$$0(0);
                }
                this.setPaintFocusBorder(false);
                this.setFocusBorderAroundIcon(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/designer/propertyTable/PropertyTable$PropertyCellRenderer$MyCellRenderer", "customizeCellRenderer"));
            }
        }
    }

    private class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private PropertyEditor myEditor;

        private PropertyCellEditor() {
        }

        public void setEditor(PropertyEditor editor2) {
            this.myEditor = editor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column2) {
            try {
                JComponent component2 = this.myEditor.getComponent(PropertyTable.this.getCurrentComponent(), PropertyTable.this.getPropertyContext(), PropertyTable.this.getValue((Property)value2), null);
                if (component2 instanceof JComboBox) {
                    ComboBox.registerTableCellEditor((JComboBox)((JComboBox)component2), (TableCellEditor)this);
                }
                JComponent jComponent = component2;
                return jComponent;
            }
            catch (Throwable e) {
                LOG.debug(e);
                SimpleColoredComponent errComponent = new SimpleColoredComponent();
                errComponent.append(IdeBundle.message((String)"dialog.text.error.getting.value", (Object[])new Object[]{e.getMessage()}), SimpleTextAttributes.ERROR_ATTRIBUTES);
                SimpleColoredComponent simpleColoredComponent = errComponent;
                return simpleColoredComponent;
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> PropertyTable.this.updateEditActions());
            }
        }

        @Override
        public Object getCellEditorValue() {
            try {
                return this.myEditor.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class PropertyCellEditorListener
    implements PropertyEditorListener {
        private PropertyCellEditorListener() {
        }

        @Override
        public void valueCommitted(@NotNull PropertyEditor source, boolean continueEditing, boolean closeEditorOnError) {
            if (source == null) {
                PropertyCellEditorListener.$$$reportNull$$$0(0);
            }
            if (PropertyTable.this.isEditing()) {
                Object value2;
                TableCellEditor tableCellEditor = PropertyTable.this.cellEditor;
                try {
                    value2 = tableCellEditor.getCellEditorValue();
                }
                catch (Exception e) {
                    PropertyTable.showInvalidInput(e);
                    return;
                }
                if (PropertyTable.this.setValueAtRow(PropertyTable.this.editingRow, value2)) {
                    if (!continueEditing && PropertyTable.this.editingRow != -1) {
                        PropertyEditor editor2 = PropertyTable.this.myProperties.get(PropertyTable.this.editingRow).getEditor();
                        editor2.removePropertyEditorListener(PropertyTable.this.myPropertyEditorListener);
                        PropertyTable.this.removeEditor();
                    }
                } else if (closeEditorOnError) {
                    tableCellEditor.cancelCellEditing();
                }
            }
        }

        @Override
        public void editingCanceled(@NotNull PropertyEditor source) {
            if (source == null) {
                PropertyCellEditorListener.$$$reportNull$$$0(1);
            }
            if (PropertyTable.this.isEditing()) {
                PropertyTable.this.cellEditor.cancelCellEditing();
            }
        }

        @Override
        public void preferredSizeChanged(@NotNull PropertyEditor source) {
            if (source == null) {
                PropertyCellEditorListener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/designer/propertyTable/PropertyTable$PropertyCellEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueCommitted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editingCanceled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preferredSizeChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PropertyTableModel
    extends AbstractTableModel {
        private PropertyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return PropertyTable.this.myColumnNames.length;
        }

        @Override
        public String getColumnName(int column2) {
            return PropertyTable.this.myColumnNames[column2];
        }

        @Override
        public boolean isCellEditable(int row2, int column2) {
            return column2 == 1 && PropertyTable.this.myProperties.get(row2).isEditable(PropertyTable.this.getCurrentComponent());
        }

        @Override
        public int getRowCount() {
            return PropertyTable.this.myProperties.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return PropertyTable.this.myProperties.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            PropertyTable.this.setValueAtRow(rowIndex, aValue);
        }
    }

    private class MouseTableListener
    extends MouseAdapter {
        private MouseTableListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row2 = PropertyTable.this.rowAtPoint(e.getPoint());
            if (row2 == -1) {
                return;
            }
            Property property2 = PropertyTable.this.myProperties.get(row2);
            if (PropertyTable.this.getChildren(property2).isEmpty()) {
                return;
            }
            Icon icon2 = UIUtil.getTreeNodeIcon((boolean)false, (boolean)true, (boolean)true);
            Rectangle rect = PropertyTable.this.getCellRect(row2, PropertyTable.this.convertColumnIndexToView(0), false);
            int indent = (Integer)PropertyTable.getBeforeIconAndAfterIndents((Property)property2, (Icon)icon2).first;
            if (e.getX() < rect.x + indent || e.getX() > rect.x + indent + icon2.getIconWidth() || e.getY() < rect.y || e.getY() > rect.y + rect.height) {
                return;
            }
            if (PropertyTable.this.isExpanded(property2)) {
                PropertyTable.this.collapse(row2);
            } else {
                PropertyTable.this.expand(row2);
            }
        }
    }

    private class MyRestoreDefaultAction
    extends AbstractAction {
        private MyRestoreDefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyTable.this.restoreDefaultValue();
        }
    }

    private class MyExpandCurrentAction
    extends AbstractAction {
        private final boolean myExpand;
        private final boolean mySelect;

        MyExpandCurrentAction(boolean expand, boolean select2) {
            this.myExpand = expand;
            this.mySelect = select2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Property parent;
            int selectedRow = PropertyTable.this.getSelectedRow();
            if (PropertyTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            Property property2 = PropertyTable.this.myProperties.get(selectedRow);
            List<Property> children2 = PropertyTable.this.getChildren(property2);
            if (!children2.isEmpty()) {
                Property parent2;
                if (this.myExpand) {
                    if (!PropertyTable.this.isExpanded(property2)) {
                        PropertyTable.this.expand(selectedRow);
                    } else if (this.mySelect) {
                        PropertyTable.this.restoreSelection(children2.get(0));
                    }
                } else if (PropertyTable.this.isExpanded(property2)) {
                    PropertyTable.this.collapse(selectedRow);
                } else if (this.mySelect && (parent2 = property2.getParent()) != null) {
                    PropertyTable.this.restoreSelection(parent2);
                }
            } else if (!this.myExpand && this.mySelect && (parent = property2.getParent()) != null) {
                PropertyTable.this.restoreSelection(parent);
            }
        }
    }

    private class MyEnterAction
    extends AbstractAction {
        private MyEnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyTable.this.getSelectedRow();
            if (PropertyTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            Property property2 = PropertyTable.this.myProperties.get(selectedRow);
            if (!PropertyTable.this.getChildren(property2).isEmpty()) {
                if (PropertyTable.this.isExpanded(property2)) {
                    PropertyTable.this.collapse(selectedRow);
                } else {
                    PropertyTable.this.expand(selectedRow);
                }
            } else {
                PropertyTable.this.startEditing(selectedRow, true);
            }
        }
    }

    private class MyStartEditingAction
    extends AbstractAction {
        private MyStartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyTable.this.getSelectedRow();
            if (selectedRow == -1 || PropertyTable.this.isEditing()) {
                return;
            }
            PropertyTable.this.startEditing(selectedRow, true);
        }
    }

    private final class MySelectNextPreviousRowAction
    extends AbstractAction {
        private final boolean selectNext;

        private MySelectNextPreviousRowAction(boolean selectNext) {
            this.selectNext = selectNext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowCount = PropertyTable.this.getRowCount();
            LOG.assertTrue(rowCount > 0);
            int selectedRow = PropertyTable.this.getSelectedRow();
            selectedRow = selectedRow == -1 ? 0 : (this.selectNext ? Math.min(rowCount - 1, PropertyTable.this.getSelectedRow() + 1) : Math.max(0, selectedRow - 1));
            if (PropertyTable.this.isEditing()) {
                PropertyTable.this.finishEditing();
                PropertyTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyTable.this.scrollRectToVisible(PropertyTable.this.getCellRect(selectedRow, 0, true));
                PropertyTable.this.startEditing(selectedRow);
            } else {
                PropertyTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyTable.this.scrollRectToVisible(PropertyTable.this.getCellRect(selectedRow, 0, true));
            }
        }
    }
}

