/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginConflictDialog
extends DialogWrapper {
    public static final int WIDTH = 450;
    @NotNull
    private final List<PluginId> myConflictingPlugins;
    private final boolean myIsConflictWithPlatform;
    @Nullable
    private final List<JBRadioButton> myRadioButtons;
    private JPanel myContentPane;
    private JBLabel myTopMessageLabel;
    private JPanel myConflictingPluginsListPanel;

    public PluginConflictDialog(@NotNull List<PluginId> conflictingPlugins, boolean isConflictWithPlatform) {
        if (conflictingPlugins == null) {
            PluginConflictDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.myConflictingPlugins = conflictingPlugins;
        this.myIsConflictWithPlatform = isConflictWithPlatform;
        this.myRadioButtons = this.myIsConflictWithPlatform ? null : new ArrayList<JBRadioButton>();
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("error.dialog.conflict.plugin.title", new Object[0]));
        this.init();
        this.setCrossClosesWindow(false);
        this.getOKAction().updateText();
        this.myTopMessageLabel.setText(this.getTopMessageText(conflictingPlugins, isConflictWithPlatform));
        this.myTopMessageLabel.setPreferredSize((Dimension)JBUI.size((int)450, (int)((int)this.myTopMessageLabel.getPreferredSize().getHeight())));
        this.myContentPane.setPreferredSize((Dimension)JBUI.size((int)450, (int)((int)this.myContentPane.getMinimumSize().getHeight())));
    }

    @NlsContexts.Label
    protected String getTopMessageText(@NotNull List<PluginId> conflictingPlugins, boolean isConflictWithPlatform) {
        if (conflictingPlugins == null) {
            PluginConflictDialog.$$$reportNull$$$0(1);
        }
        int pluginsNumber = conflictingPlugins.size();
        if (isConflictWithPlatform) {
            return DiagnosticBundle.message("error.dialog.conflict.plugin.header.platform", pluginsNumber);
        }
        List names2 = conflictingPlugins.stream().map(PluginConflictDialog::getPluginNameOrId).map(s -> "<b>" + s + "</b>").collect(Collectors.toList());
        return DiagnosticBundle.message("error.dialog.conflict.plugin.header.each.other", StringUtil.join(names2.subList(0, pluginsNumber - 1), (String)", "), names2.get(pluginsNumber - 1));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.myConflictingPluginsListPanel = new JPanel(new GridLayout(0, 1));
        List pluginDescriptions = ContainerUtil.map(this.myConflictingPlugins, plugin2 -> this.getChooserPanelForPlugin(buttonGroup2, (PluginId)plugin2));
        pluginDescriptions.forEach(this.myConflictingPluginsListPanel::add);
        if (!this.myIsConflictWithPlatform) {
            JPanel chooserPanelForPlugin = this.getChooserPanelForPlugin(buttonGroup2, null);
            this.myConflictingPluginsListPanel.add(chooserPanelForPlugin);
        }
        this.setUpDefaultSelection();
    }

    @NotNull
    private JPanel getChooserPanelForPlugin(@NotNull ButtonGroup buttonGroup2, @Nullable PluginId plugin2) {
        if (buttonGroup2 == null) {
            PluginConflictDialog.$$$reportNull$$$0(2);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        if (!this.myIsConflictWithPlatform) {
            assert (this.myRadioButtons != null);
            final JBRadioButton radioButton2 = new JBRadioButton();
            this.myRadioButtons.add(radioButton2);
            buttonGroup2.add((AbstractButton)radioButton2);
            radioButton2.addChangeListener(e -> this.getOKAction().updateText());
            panel2.add((Component)radioButton2, "West");
            panel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    radioButton2.setSelected(true);
                }
            });
        }
        JPanel descriptionPanel = plugin2 != null ? PluginConflictDialog.getPluginDescriptionPanel(plugin2, !this.myIsConflictWithPlatform) : PluginConflictDialog.getDisableAllPanel();
        descriptionPanel.setBorder((Border)new JBEmptyBorder(10, this.myIsConflictWithPlatform ? 10 : 0, 10, 20));
        panel2.add((Component)descriptionPanel, "Center");
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            PluginConflictDialog.$$$reportNull$$$0(3);
        }
        return jPanel2;
    }

    private void setUpDefaultSelection() {
        if (this.myIsConflictWithPlatform) {
            return;
        }
        assert (this.myRadioButtons != null && this.myRadioButtons.size() == this.myConflictingPlugins.size() + 1);
        for (int i2 = 0; i2 < this.myConflictingPlugins.size(); ++i2) {
            IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(this.myConflictingPlugins.get(i2));
            if (pluginDescriptor == null || !pluginDescriptor.isBundled() && !StringUtil.equalsIgnoreCase((CharSequence)pluginDescriptor.getVendor(), (CharSequence)"JetBrains")) continue;
            this.myRadioButtons.get(i2).setSelected(true);
            return;
        }
        this.myRadioButtons.get(this.myRadioButtons.size() - 1).setSelected(true);
    }

    @NotNull
    private static JPanel getPluginDescriptionPanel(@NotNull PluginId plugin2, boolean addUseWord) {
        if (plugin2 == null) {
            PluginConflictDialog.$$$reportNull$$$0(4);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(plugin2);
        if (pluginDescriptor == null) {
            panel2.add((Component)new JBLabel(plugin2.getIdString()), "Center");
            JPanel jPanel2 = panel2;
            if (jPanel2 == null) {
                PluginConflictDialog.$$$reportNull$$$0(5);
            }
            return jPanel2;
        }
        HtmlBuilder message2 = new HtmlBuilder();
        String vendor = pluginDescriptor.getVendor();
        message2.append(DiagnosticBundle.message("plugin.conflict.use.by.vendor.label", addUseWord ? 0 : 1, pluginDescriptor.getName(), vendor != null ? 0 : 1, vendor));
        panel2.add((Component)new JBLabel(message2.wrapWithHtmlBody().toString()));
        JPanel jPanel3 = panel2;
        if (jPanel3 == null) {
            PluginConflictDialog.$$$reportNull$$$0(6);
        }
        return jPanel3;
    }

    @NotNull
    private static String getPluginNameOrId(@NotNull PluginId pluginId) {
        IdeaPluginDescriptor pluginDescriptor;
        if (pluginId == null) {
            PluginConflictDialog.$$$reportNull$$$0(7);
        }
        if ((pluginDescriptor = PluginManagerCore.getPlugin(pluginId)) == null) {
            String string = pluginId.getIdString();
            if (string == null) {
                PluginConflictDialog.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = pluginDescriptor.getName();
        if (string == null) {
            PluginConflictDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static JPanel getDisableAllPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("error.dialog.conflict.plugin.disable.all", new Object[0])));
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            PluginConflictDialog.$$$reportNull$$$0(10);
        }
        return jPanel2;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            PluginConflictDialog.$$$reportNull$$$0(11);
        }
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DisableAction();
    }

    @NotNull
    protected DisableAction getOKAction() {
        DisableAction disableAction2 = (DisableAction)((Object)this.myOKAction);
        if (disableAction2 == null) {
            PluginConflictDialog.$$$reportNull$$$0(12);
        }
        return disableAction2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictingPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttonGroup";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/errordialog/PluginConflictDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/errordialog/PluginConflictDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserPanelForPlugin";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptionPanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNameOrId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisableAllPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTopMessageText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChooserPanelForPlugin";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptionPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPluginNameOrId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(400, -1));
        this.myTopMessageLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = this.myConflictingPluginsListPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class DisableAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAction() {
            super((DialogWrapper)PluginConflictDialog.this, IdeBundle.message((String)"plugins.configurable.disable", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        public void updateText() {
            this.putValue("Name", this.getButtonText());
            PluginConflictDialog.this.repaint();
        }

        @NotNull
        @NlsContexts.Button
        private String getButtonText() {
            if (PluginConflictDialog.this.myIsConflictWithPlatform) {
                String string = DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]);
                if (string == null) {
                    DisableAction.$$$reportNull$$$0(0);
                }
                return string;
            }
            assert (PluginConflictDialog.this.myRadioButtons != null);
            for (int i2 = 0; i2 < PluginConflictDialog.this.myConflictingPlugins.size(); ++i2) {
                if (!PluginConflictDialog.this.myRadioButtons.get(i2).isSelected()) continue;
                String string = DiagnosticBundle.message("error.dialog.conflict.plugin.button.enable.and.restart", new Object[0]);
                if (string == null) {
                    DisableAction.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = DiagnosticBundle.message("error.dialog.conflict.plugin.button.disable.all", new Object[0]);
            if (string == null) {
                DisableAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void doAction(ActionEvent e) {
            for (int i2 = 0; i2 < PluginConflictDialog.this.myConflictingPlugins.size(); ++i2) {
                if (PluginConflictDialog.this.myRadioButtons != null && PluginConflictDialog.this.myRadioButtons.get(i2).isSelected()) continue;
                PluginManagerCore.disablePlugin(PluginConflictDialog.this.myConflictingPlugins.get(i2));
            }
            PluginConflictDialog.this.close(0);
            ApplicationManagerEx.getApplicationEx().restart(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog$DisableAction", "getButtonText"));
        }
    }
}

