/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import com.intellij.diagnostic.hprof.util.FileBackedHashMap;
import com.intellij.diagnostic.hprof.util.IntList;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/hprof/util/FileBackedIntList;", "Lcom/intellij/diagnostic/hprof/util/IntList;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "get", "", "index", "set", "", "value", "Companion", "intellij.platform.ide.impl"})
public final class FileBackedIntList
implements IntList {
    private final ByteBuffer buffer;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public int get(int index2) {
        this.buffer.position(index2 * 4);
        return this.buffer.getInt();
    }

    @Override
    public void set(int index2, int value2) {
        this.buffer.position(index2 * 4);
        this.buffer.putInt(value2);
    }

    public FileBackedIntList(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/util/FileBackedIntList$Companion;", "", "()V", "createEmpty", "Lcom/intellij/diagnostic/hprof/util/IntList;", "channel", "Ljava/nio/channels/FileChannel;", "size", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final IntList createEmpty(@NotNull FileChannel channel2, long size) {
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            FileBackedHashMap.Companion.createEmptyFile(channel2, size * (long)4);
            MappedByteBuffer mappedByteBuffer = channel2.map(FileChannel.MapMode.READ_WRITE, 0L, channel2.size());
            Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"channel.map(FileChannel.\u2026WRITE, 0, channel.size())");
            return new FileBackedIntList(mappedByteBuffer);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

