/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BlankDiffWindowUtil;
import com.intellij.diff.actions.RecentBlankContent;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.LinkedListWithSum;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToIntFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/diff/actions/BlankDiffWindowUtil;", "", "()V", "BLANK_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getBLANK_KEY", "()Lcom/intellij/openapi/util/Key;", "REMEMBER_CONTENT_KEY", "ourRecentFiles", "Lcom/intellij/util/containers/LinkedListWithSum;", "Lcom/intellij/diff/actions/RecentBlankContent;", "createBlankDiffRequestChain", "Lcom/intellij/diff/actions/impl/MutableDiffRequestChain;", "content1", "Lcom/intellij/diff/contents/DocumentContent;", "content2", "baseContent", "deleteAfterAllowedMaximum", "", "getRecentFiles", "", "getRecentFiles$intellij_platform_diff_impl", "saveRecentContent", "content", "Lcom/intellij/diff/contents/DiffContent;", "saveRecentContents", "request", "Lcom/intellij/diff/requests/DiffRequest;", "intellij.platform.diff.impl"})
public final class BlankDiffWindowUtil {
    @NotNull
    private static final Key<Boolean> BLANK_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> REMEMBER_CONTENT_KEY;
    private static final LinkedListWithSum<RecentBlankContent> ourRecentFiles;
    @NotNull
    public static final BlankDiffWindowUtil INSTANCE;

    @NotNull
    public final Key<Boolean> getBLANK_KEY() {
        return BLANK_KEY;
    }

    @JvmStatic
    @NotNull
    public static final MutableDiffRequestChain createBlankDiffRequestChain(@NotNull DocumentContent content1, @NotNull DocumentContent content2, @Nullable DocumentContent baseContent) {
        Intrinsics.checkNotNullParameter((Object)content1, (String)"content1");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content2");
        MutableDiffRequestChain chain = new MutableDiffRequestChain((DiffContent)content1, (DiffContent)baseContent, (DiffContent)content2);
        chain.putUserData(BLANK_KEY, true);
        return chain;
    }

    public static /* synthetic */ MutableDiffRequestChain createBlankDiffRequestChain$default(DocumentContent documentContent, DocumentContent documentContent2, DocumentContent documentContent3, int n, Object object) {
        if ((n & 4) != 0) {
            documentContent3 = null;
        }
        return BlankDiffWindowUtil.createBlankDiffRequestChain(documentContent, documentContent2, documentContent3);
    }

    @NotNull
    public final List<RecentBlankContent> getRecentFiles$intellij_platform_diff_impl() {
        return CollectionsKt.toList((Iterable)((Iterable)ourRecentFiles));
    }

    @RequiresEdt
    public final void saveRecentContents(@NotNull DiffRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (request2 instanceof ContentDiffRequest) {
            Iterator iterator2 = ((ContentDiffRequest)request2).getContents().iterator();
            while (iterator2.hasNext()) {
                DiffContent content2;
                DiffContent diffContent = content2 = (DiffContent)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"content");
                this.saveRecentContent(diffContent);
            }
        }
    }

    @RequiresEdt
    public final void saveRecentContent(@NotNull DiffContent content2) {
        Object v2;
        String text2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (!(content2 instanceof DocumentContent)) {
                return;
            }
            if (!DiffUtil.isUserDataFlagSet(REMEMBER_CONTENT_KEY, (UserDataHolder)content2)) {
                return;
            }
            Document document = ((DocumentContent)content2).getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"content.document");
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"content.document.text");
            text2 = string;
            if (StringsKt.isBlank((CharSequence)text2)) {
                return;
            }
            Iterable iterable = (Iterable)ourRecentFiles;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                RecentBlankContent it = (RecentBlankContent)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)text2)) continue;
                v2 = t;
                break block6;
            }
            v2 = null;
        }
        RecentBlankContent oldValue = v2;
        if (oldValue != null) {
            ourRecentFiles.remove((Object)oldValue);
            ourRecentFiles.add(0, (Object)oldValue);
        } else {
            ourRecentFiles.add(0, (Object)new RecentBlankContent(text2, System.currentTimeMillis()));
            this.deleteAfterAllowedMaximum();
        }
    }

    private final void deleteAfterAllowedMaximum() {
        int n = 1;
        int n2 = Registry.intValue((String)"blank.diff.history.max.items");
        int n3 = 0;
        int maxCount = Math.max(n, n2);
        n2 = 0;
        n3 = Registry.intValue((String)"blank.diff.history.max.memory");
        boolean bl = false;
        int maxMemory = Math.max(n2, n3);
        CopyPasteManagerEx.deleteAfterAllowedMaximum(ourRecentFiles, maxCount, maxMemory, deleteAfterAllowedMaximum.1.INSTANCE);
    }

    private BlankDiffWindowUtil() {
    }

    static {
        BlankDiffWindowUtil blankDiffWindowUtil;
        INSTANCE = blankDiffWindowUtil = new BlankDiffWindowUtil();
        Key key = Key.create((String)"Diff.BlankWindow");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"Diff.BlankWindow\")");
        BLANK_KEY = key;
        Key key2 = Key.create((String)"Diff.BlankWindow.BlankContent");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<Boolean>(\"Dif\u2026lankWindow.BlankContent\")");
        REMEMBER_CONTENT_KEY = key2;
        ourRecentFiles = new LinkedListWithSum((ToIntFunction)ourRecentFiles.1.INSTANCE);
    }
}

