/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.BlankDiffWindowUtil;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareClipboardWithSelectionAction
extends BaseShowDiffAction {
    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(0);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
            return editor2;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    @Nullable
    private static FileType getEditorFileType(@NotNull AnActionEvent e) {
        DiffContent content2;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(1);
        }
        if ((content2 = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT)) != null && content2.getContentType() != null) {
            return content2.getContentType();
        }
        DiffRequest request2 = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (request2 instanceof ContentDiffRequest) {
            for (DiffContent diffContent : ((ContentDiffRequest)request2).getContents()) {
                FileType type = diffContent.getContentType();
                if (type == null || type == UnknownFileType.INSTANCE) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(2);
        }
        return (editor2 = CompareClipboardWithSelectionAction.getEditor(e)) != null;
    }

    @Override
    @Nullable
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        Editor editor2 = CompareClipboardWithSelectionAction.getEditor(e);
        FileType editorFileType = CompareClipboardWithSelectionAction.getEditorFileType(e);
        assert (editor2 != null);
        DiffContent selectedContent = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT);
        DocumentContent content2 = CompareClipboardWithSelectionAction.createContent(project, editor2, editorFileType, selectedContent, e);
        DocumentContent content1 = DiffContentFactory.getInstance().createClipboardContent(project, content2);
        content1.putUserData(BlankDiffWindowUtil.REMEMBER_CONTENT_KEY, (Object)true);
        MutableDiffRequestChain chain = BlankDiffWindowUtil.createBlankDiffRequestChain(content1, content2, null);
        chain.setWindowTitle(DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]));
        chain.setTitle1(DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]));
        chain.setTitle2(CompareClipboardWithSelectionAction.createContentTitle(editor2));
        int currentLine = editor2.getCaretModel().getLogicalPosition().line;
        chain.putRequestUserData(DiffUserDataKeys.SCROLL_TO_LINE, Pair.create((Object)Side.RIGHT, (Object)currentLine));
        return chain;
    }

    @NotNull
    private static DocumentContent createContent(@Nullable Project project, @NotNull Editor editor2, @Nullable FileType type, @Nullable DiffContent selectedContent, @NotNull AnActionEvent e) {
        SelectionModel selectionModel;
        Document editorDocument;
        Document contentDocument;
        if (editor2 == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(5);
        }
        DocumentContent content2 = null;
        if (selectedContent instanceof DocumentContent && (contentDocument = ((DocumentContent)selectedContent).getDocument()).equals(editorDocument = editor2.getDocument())) {
            content2 = (DocumentContent)selectedContent;
        }
        if (content2 == null) {
            content2 = DiffContentFactory.getInstance().create(project, editor2.getDocument(), type);
        }
        if ((selectionModel = editor2.getSelectionModel()).hasSelection() && !EditorUtil.contextMenuInvokedOutsideOfSelection(e)) {
            TextRange range2 = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            content2 = DiffContentFactory.getInstance().createFragment(project, content2, range2);
        }
        if (editor2.isViewer()) {
            content2.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        }
        DocumentContent documentContent = content2;
        if (documentContent == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    @NotNull
    private static String createContentTitle(@NotNull Editor editor2) {
        VirtualFile file2;
        String title2;
        if (editor2 == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(7);
        }
        String string = title2 = (file2 = FileDocumentManager.getInstance().getFile(editor2.getDocument())) != null ? DiffRequestFactory.getInstance().getContentTitle(file2) : DiffBundle.message((String)"diff.content.editor.content.title", (Object[])new Object[0]);
        if (editor2.getSelectionModel().hasSelection()) {
            title2 = DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{title2});
        }
        String string2 = title2;
        if (string2 == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareClipboardWithSelectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareClipboardWithSelectionAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestChain";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createContentTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

