/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create("CompareFilesAction.DiffRequest");
    @NonNls
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    @NonNls
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        String text2 = ActionsBundle.message((String)"action.compare.files.text", (Object[])new Object[0]);
        Object[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null) {
            if (files2.length == 1) {
                text2 = ActionsBundle.message((String)"action.compare.with.text", (Object[])new Object[0]);
            } else if (files2.length == 2 || files2.length == 3) {
                Set types = ContainerUtil.map2Set((Object[])files2, CompareFilesAction::getType);
                if (types.size() != 1) {
                    text2 = ActionsBundle.message((String)"action.compare.text", (Object[])new Object[0]);
                } else {
                    switch ((Type)((Object)types.iterator().next())) {
                        case FILE: {
                            text2 = ActionsBundle.message((String)"action.compare.files.text", (Object[])new Object[0]);
                            break;
                        }
                        case DIRECTORY: {
                            text2 = ActionsBundle.message((String)"action.CompareDirs.text", (Object[])new Object[0]);
                            break;
                        }
                        case ARCHIVE: {
                            text2 = ActionsBundle.message((String)"action.compare.archives.text", (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
        e.getPresentation().setText(text2);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Set types;
        DiffRequest request2;
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(1);
        }
        if ((request2 = (DiffRequest)e.getData(DIFF_REQUEST)) != null) {
            return true;
        }
        Object[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 == null) {
            return false;
        }
        if (files2.length == 0 || files2.length > 3) {
            return false;
        }
        boolean hasContent = ContainerUtil.all(Arrays.asList(files2), BaseShowDiffAction::hasContent);
        if (!hasContent) {
            return false;
        }
        return files2.length != 3 || !(types = ContainerUtil.map2Set((Object[])files2, CompareFilesAction::getType)).contains((Object)Type.DIRECTORY) && !types.contains((Object)Type.ARCHIVE);
    }

    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(2);
        }
        return (DiffRequest)e.getData(DIFF_REQUEST);
    }

    @Override
    @Nullable
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        VirtualFile file2;
        VirtualFile file1;
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        DiffRequest diffRequest = this.getDiffRequest(e);
        if (diffRequest != null) {
            return new SimpleDiffRequestChain(diffRequest);
        }
        VirtualFile baseFile = null;
        Object[] files2 = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2.length == 1) {
            file1 = files2[0];
            file2 = CompareFilesAction.getOtherFile(project, file1);
            if (file2 == null || !CompareFilesAction.hasContent(file2)) {
                return null;
            }
        } else if (files2.length == 2) {
            file1 = files2[0];
            file2 = files2[1];
        } else {
            file1 = files2[0];
            baseFile = files2[1];
            file2 = files2[2];
        }
        if (!file1.isValid() || !file2.isValid() || baseFile != null && !baseFile.isValid()) {
            return null;
        }
        Set types = ContainerUtil.map2Set((Object[])files2, CompareFilesAction::getType);
        if (types.contains((Object)Type.DIRECTORY)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("dir.diff");
        }
        if (types.contains((Object)Type.ARCHIVE)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("jar.diff");
        }
        return CompareFilesAction.createMutableChainFromFiles(project, file1, file2, baseFile);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project, @NotNull VirtualFile file2) {
        String key;
        FileChooserDescriptor descriptor2;
        Type type;
        if (file2 == null) {
            CompareFilesAction.$$$reportNull$$$0(4);
        }
        if ((type = CompareFilesAction.getType(file2)) == Type.DIRECTORY || type == Type.ARCHIVE) {
            descriptor2 = new FileChooserDescriptor(false, true, true, true, true, false);
            key = LAST_USED_FOLDER_KEY;
        } else {
            descriptor2 = new FileChooserDescriptor(true, false, false, true, true, false);
            key = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project, key, file2);
        VirtualFile otherFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)selectedFile);
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project, key, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file2) {
        if (key == null) {
            CompareFilesAction.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            CompareFilesAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            VirtualFile virtualFile2 = file2;
            if (virtualFile2 == null) {
                CompareFilesAction.$$$reportNull$$$0(7);
            }
            return virtualFile2;
        }
        String path2 = PropertiesComponent.getInstance((Project)project).getValue(key);
        if (path2 == null) {
            VirtualFile virtualFile3 = file2;
            if (virtualFile3 == null) {
                CompareFilesAction.$$$reportNull$$$0(8);
            }
            return virtualFile3;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path2);
        VirtualFile virtualFile4 = lastSelection != null ? lastSelection : file2;
        if (virtualFile4 == null) {
            CompareFilesAction.$$$reportNull$$$0(9);
        }
        return virtualFile4;
    }

    private static void updateDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file2) {
        if (key == null) {
            CompareFilesAction.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            CompareFilesAction.$$$reportNull$$$0(11);
        }
        if (project == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project).setValue(key, file2.getPath());
    }

    @NotNull
    private static Type getType(@Nullable VirtualFile file2) {
        if (file2 == null) {
            Type type = Type.FILE;
            if (type == null) {
                CompareFilesAction.$$$reportNull$$$0(12);
            }
            return type;
        }
        if (file2.getFileType() instanceof ArchiveFileType) {
            Type type = Type.ARCHIVE;
            if (type == null) {
                CompareFilesAction.$$$reportNull$$$0(13);
            }
            return type;
        }
        if (file2.isDirectory()) {
            Type type = Type.DIRECTORY;
            if (type == null) {
                CompareFilesAction.$$$reportNull$$$0(14);
            }
            return type;
        }
        Type type = Type.FILE;
        if (type == null) {
            CompareFilesAction.$$$reportNull$$$0(15);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareFilesAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSelection";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestChain";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOtherFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSelection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Type {
        FILE,
        DIRECTORY,
        ARCHIVE;

    }
}

