/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableDocumentFragmentContent
extends DiffContentBase
implements DocumentContent {
    @NotNull
    private final DocumentContent myOriginal;
    @NotNull
    private final Document myDocument;
    private final int myStartLine;

    public ImmutableDocumentFragmentContent(@NotNull DocumentContent original, @NotNull TextRange range2) {
        if (original == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(1);
        }
        this.myOriginal = original;
        Document originalDocument = this.myOriginal.getDocument();
        this.myStartLine = originalDocument.getLineNumber(range2.getStartOffset());
        String text2 = StringUtil.convertLineSeparators((String)range2.subSequence(originalDocument.getImmutableCharSequence()).toString());
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)text2);
        this.myDocument.setReadOnly(true);
        IntUnaryOperator originalLineConvertor = (IntUnaryOperator)original.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
        this.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value2 -> {
            int line = this.myStartLine + value2;
            return originalLineConvertor != null ? originalLineConvertor.applyAsInt(line) : line;
        });
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(2);
        }
        return document;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myOriginal.getHighlightFile();
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(3);
        }
        LineCol originalPosition = new LineCol(this.myStartLine + position.line, position.column);
        return this.myOriginal.getNavigatable(originalPosition);
    }

    @Nullable
    public FileType getContentType() {
        return this.myOriginal.getContentType();
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/ImmutableDocumentFragmentContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/ImmutableDocumentFragmentContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

