/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result2, final @NotNull MergeRequest request2, final @NotNull MergeContext context2, final @NotNull MergeTool.MergeViewer viewer, final boolean contentWasModified) {
        if (result2 == null) {
            MergeUtil.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            MergeUtil.$$$reportNull$$$0(2);
        }
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(3);
        }
        String caption = MergeUtil.getResolveActionTitle(result2, request2, context2);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request2, context2, contentWasModified)) {
                    return;
                }
                context2.finishMerge(result2);
            }
        };
    }

    @Nls
    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result2, @Nullable MergeRequest request2, @Nullable MergeContext context2) {
        Function<MergeResult, String> getter;
        String message2;
        if (result2 == null) {
            MergeUtil.$$$reportNull$$$0(4);
        }
        String string = message2 = (getter = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS)) != null ? (String)getter.fun((Object)result2) : null;
        if (message2 != null) {
            String string2 = message2;
            if (string2 == null) {
                MergeUtil.$$$reportNull$$$0(5);
            }
            return string2;
        }
        switch (result2) {
            case CANCEL: {
                String string3 = DiffBundle.message((String)"button.merge.resolve.cancel", (Object[])new Object[0]);
                if (string3 == null) {
                    MergeUtil.$$$reportNull$$$0(6);
                }
                return string3;
            }
            case LEFT: {
                String string4 = DiffBundle.message((String)"button.merge.resolve.accept.left", (Object[])new Object[0]);
                if (string4 == null) {
                    MergeUtil.$$$reportNull$$$0(7);
                }
                return string4;
            }
            case RIGHT: {
                String string5 = DiffBundle.message((String)"button.merge.resolve.accept.right", (Object[])new Object[0]);
                if (string5 == null) {
                    MergeUtil.$$$reportNull$$$0(8);
                }
                return string5;
            }
            case RESOLVED: {
                String string6 = DiffBundle.message((String)"button.merge.resolve.apply", (Object[])new Object[0]);
                if (string6 == null) {
                    MergeUtil.$$$reportNull$$$0(9);
                }
                return string6;
            }
        }
        throw new IllegalArgumentException(result2.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        if (mergeContentTitles == null) {
            MergeUtil.$$$reportNull$$$0(10);
        }
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]));
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]));
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        List<String> list2 = Arrays.asList(left, base, right);
        if (list2 == null) {
            MergeUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request2, @NotNull MergeContext context2, boolean contentWasModified) {
        Condition<MergeTool.MergeViewer> customHandler;
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(12);
        }
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            MergeUtil.$$$reportNull$$$0(14);
        }
        if ((customHandler = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER)) != null) {
            return customHandler.value((Object)viewer);
        }
        return !contentWasModified || MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request2, context2);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component2, @NotNull MergeRequest request2, @NotNull MergeContext context2) {
        Couple<String> customMessage;
        if (component2 == null) {
            MergeUtil.$$$reportNull$$$0(15);
        }
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            MergeUtil.$$$reportNull$$$0(17);
        }
        if ((customMessage = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE)) != null) {
            String title2 = (String)customMessage.first;
            String message2 = (String)customMessage.second;
            return MessageDialogBuilder.yesNo((String)title2, (String)message2).ask((Component)component2);
        }
        return MergeUtil.showConfirmDiscardChangesDialog(component2, DiffBundle.message((String)"button.cancel.merge", (Object[])new Object[0]), true);
    }

    public static boolean showConfirmDiscardChangesDialog(@NotNull JComponent parent, @NotNull @Nls String actionName, boolean contentWasModified) {
        if (parent == null) {
            MergeUtil.$$$reportNull$$$0(18);
        }
        if (actionName == null) {
            MergeUtil.$$$reportNull$$$0(19);
        }
        if (!contentWasModified) {
            return true;
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)actionName, (String)DiffBundle.message((String)"label.merge.unsaved.changes.discard.and.do.anyway", (Object[])new Object[]{actionName.toLowerCase(DynamicBundle.getLocale())})).yesText(DiffBundle.message((String)"button.discard.changes.and.do", (Object[])new Object[]{actionName}))).noText(DiffBundle.message((String)"button.continue.merge", (Object[])new Object[0]))).ask((Component)parent);
    }

    public static boolean shouldRestoreOriginalContentOnCancel(@NotNull MergeRequest request2) {
        MergeCallback callback2;
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(20);
        }
        if ((callback2 = MergeCallback.getCallback((MergeRequest)request2)).checkIsValid()) {
            return true;
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.conflict.is.outdated", (Object[])new Object[0])).yesText(CommonBundle.message((String)"button.without.mnemonic.restore", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.without.mnemonic.do.nothing", (Object[])new Object[0]))).guessWindowAndAsk();
    }

    public static void reportProjectFileChangeIfNeeded(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project != null && file2 != null && MergeUtil.isProjectFile(file2)) {
            StoreReloadManager.getInstance().saveChangedProjectFile(file2, project);
        }
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MergeUtil.$$$reportNull$$$0(21);
        }
        if (file2.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
            return true;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        return importProvider != null && importProvider.lookForProjectsInDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContentTitles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveActionTitle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullizeContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleResolveAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolveActionTitle";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notNullizeContentTitles";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showExitWithoutApplyingChangesDialog";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showConfirmDiscardChangesDialog";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreOriginalContentOnCancel";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                ProxyDiffContext.$$$reportNull$$$0(0);
            }
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocusedInWindow() {
            return this.myMergeContext.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            this.myMergeContext.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(1);
            }
            return (T)this.myMergeContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(2);
            }
            this.myMergeContext.putUserData(key, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeUtil$ProxyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

