/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.tools.combined.CombinedDiffBlock;
import com.intellij.diff.tools.combined.CombinedDiffViewer;
import com.intellij.diff.tools.combined.CombinedDiffViewerKt;
import com.intellij.diff.tools.combined.ScrollPolicy;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002R\u0018\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport;", "", "project", "Lcom/intellij/openapi/project/Project;", "viewer", "Lcom/intellij/diff/tools/combined/CombinedDiffViewer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diff/tools/combined/CombinedDiffViewer;)V", "blockIterable", "Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedDiffPrevNextBlocksIterable;", "getBlockIterable$intellij_platform_diff_impl", "()Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedDiffPrevNextBlocksIterable;", "combinedEditorsScrollingModel", "Lcom/intellij/openapi/editor/impl/ScrollingModelImpl;", "currentPrevNextIterable", "Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedDiffPrevNextDifferenceIterable;", "getCurrentPrevNextIterable$intellij_platform_diff_impl", "()Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedDiffPrevNextDifferenceIterable;", "scroll", "", "index", "", "block", "Lcom/intellij/diff/tools/combined/CombinedDiffBlock;", "scrollPolicy", "Lcom/intellij/diff/tools/combined/ScrollPolicy;", "scrollToDiffBlock", "scrollToDiffChangeWithCaret", "CombinedDiffPrevNextBlocksIterable", "CombinedDiffPrevNextDifferenceIterable", "CombinedEditorsScrollingModelHelper", "intellij.platform.diff.impl"})
public final class CombinedDiffScrollSupport {
    @NotNull
    private final CombinedDiffPrevNextDifferenceIterable currentPrevNextIterable;
    @NotNull
    private final CombinedDiffPrevNextBlocksIterable blockIterable;
    private final ScrollingModelImpl combinedEditorsScrollingModel;
    private final CombinedDiffViewer viewer;

    @NotNull
    public final CombinedDiffPrevNextDifferenceIterable getCurrentPrevNextIterable$intellij_platform_diff_impl() {
        return this.currentPrevNextIterable;
    }

    @NotNull
    public final CombinedDiffPrevNextBlocksIterable getBlockIterable$intellij_platform_diff_impl() {
        return this.blockIterable;
    }

    public final void scroll(int index2, @NotNull CombinedDiffBlock block, @NotNull ScrollPolicy scrollPolicy) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)((Object)scrollPolicy), (String)"scrollPolicy");
        if (scrollPolicy == ScrollPolicy.DIFF_BLOCK || !CombinedDiffViewerKt.isEditorBased(block.getContent().getViewer())) {
            this.scrollToDiffBlock(index2);
        } else if (scrollPolicy == ScrollPolicy.DIFF_CHANGE) {
            this.scrollToDiffChangeWithCaret();
        }
    }

    private final void scrollToDiffChangeWithCaret() {
        if (CombinedDiffViewerKt.isEditorBased(this.viewer.getCurrentDiffViewer$intellij_platform_diff_impl())) {
            this.combinedEditorsScrollingModel.scrollToCaret(ScrollType.CENTER);
        }
    }

    private final void scrollToDiffBlock(int index2) {
        block1: {
            int n = index2;
            if (0 > n || ((Collection)this.viewer.getDiffBlocks$intellij_platform_diff_impl()).size() <= n) break block1;
            Object[] objectArray = this.viewer.getContentPanel$intellij_platform_diff_impl().getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"viewer.contentPanel.components");
            Serializable serializable = (Component)ArraysKt.getOrNull((Object[])objectArray, (int)index2);
            if (serializable != null && (serializable = serializable.getBounds()) != null) {
                Serializable serializable2 = serializable;
                JPanel jPanel2 = this.viewer.getContentPanel$intellij_platform_diff_impl();
                boolean bl = false;
                boolean bl2 = false;
                Serializable p1 = serializable2;
                boolean bl3 = false;
                jPanel2.scrollRectToVisible((Rectangle)p1);
            }
        }
    }

    public CombinedDiffScrollSupport(@Nullable Project project, @NotNull CombinedDiffViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        this.viewer = viewer;
        this.currentPrevNextIterable = new CombinedDiffPrevNextDifferenceIterable();
        this.blockIterable = new CombinedDiffPrevNextBlocksIterable();
        this.combinedEditorsScrollingModel = new ScrollingModelImpl(new CombinedEditorsScrollingModelHelper(project, (Disposable)this.viewer));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedDiffPrevNextDifferenceIterable;", "Lcom/intellij/diff/tools/util/PrevNextDifferenceIterable;", "(Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport;)V", "canGoNext", "", "canGoPrev", "goNext", "", "goPrev", "intellij.platform.diff.impl"})
    public final class CombinedDiffPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        @Override
        public boolean canGoNext() {
            PrevNextDifferenceIterable prevNextDifferenceIterable = CombinedDiffScrollSupport.this.viewer.getDifferencesIterable$intellij_platform_diff_impl();
            return prevNextDifferenceIterable != null && prevNextDifferenceIterable.canGoNext();
        }

        @Override
        public boolean canGoPrev() {
            PrevNextDifferenceIterable prevNextDifferenceIterable = CombinedDiffScrollSupport.this.viewer.getDifferencesIterable$intellij_platform_diff_impl();
            return prevNextDifferenceIterable != null && prevNextDifferenceIterable.canGoPrev();
        }

        @Override
        public void goNext() {
            PrevNextDifferenceIterable prevNextDifferenceIterable = CombinedDiffScrollSupport.this.viewer.getDifferencesIterable$intellij_platform_diff_impl();
            if (prevNextDifferenceIterable != null) {
                prevNextDifferenceIterable.goNext();
            }
            CombinedDiffScrollSupport.this.scrollToDiffChangeWithCaret();
        }

        @Override
        public void goPrev() {
            PrevNextDifferenceIterable prevNextDifferenceIterable = CombinedDiffScrollSupport.this.viewer.getDifferencesIterable$intellij_platform_diff_impl();
            if (prevNextDifferenceIterable != null) {
                prevNextDifferenceIterable.goPrev();
            }
            CombinedDiffScrollSupport.this.scrollToDiffChangeWithCaret();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedDiffPrevNextBlocksIterable;", "Lcom/intellij/diff/tools/util/PrevNextDifferenceIterable;", "(Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "canGoNext", "", "canGoPrev", "goNext", "", "goPrev", "intellij.platform.diff.impl"})
    public final class CombinedDiffPrevNextBlocksIterable
    implements PrevNextDifferenceIterable {
        private int index;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public boolean canGoNext() {
            return this.index < CombinedDiffScrollSupport.this.viewer.getDiffBlocks$intellij_platform_diff_impl().size() - 1;
        }

        @Override
        public boolean canGoPrev() {
            return this.index > 0;
        }

        @Override
        public void goNext() {
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public void goPrev() {
            int n = this.index;
            this.index = n + -1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport$CombinedEditorsScrollingModelHelper;", "Lcom/intellij/openapi/editor/ScrollingModel$Supplier;", "Lcom/intellij/openapi/editor/ScrollingModel$ScrollingHelper;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "(Lcom/intellij/diff/tools/combined/CombinedDiffScrollSupport;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "dummyEditor", "Lcom/intellij/openapi/editor/Editor;", "calculateScrollingLocation", "Ljava/awt/Point;", "editor", "pos", "Lcom/intellij/openapi/editor/LogicalPosition;", "Lcom/intellij/openapi/editor/VisualPosition;", "dispose", "", "getEditor", "getScrollPane", "Ljavax/swing/JScrollPane;", "getScrollingHelper", "intellij.platform.diff.impl"})
    private final class CombinedEditorsScrollingModelHelper
    implements ScrollingModel.Supplier,
    ScrollingModel.ScrollingHelper,
    Disposable {
        private final Editor dummyEditor;

        @NotNull
        public Editor getEditor() {
            FrameDiffTool.DiffViewer diffViewer = CombinedDiffScrollSupport.this.viewer.getDiffViewer$intellij_platform_diff_impl(CombinedDiffScrollSupport.this.getBlockIterable$intellij_platform_diff_impl().getIndex());
            if (diffViewer == null || (diffViewer = CombinedDiffViewerKt.getEditor(diffViewer)) == null) {
                diffViewer = this.dummyEditor;
            }
            return diffViewer;
        }

        @NotNull
        public JScrollPane getScrollPane() {
            return (JScrollPane)CombinedDiffScrollSupport.this.viewer.getScrollPane$intellij_platform_diff_impl();
        }

        @NotNull
        public ScrollingModel.ScrollingHelper getScrollingHelper() {
            return this;
        }

        @NotNull
        public Point calculateScrollingLocation(@NotNull Editor editor2, @NotNull VisualPosition pos) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Point point = editor2.visualPositionToXY(pos);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.visualPositionToXY(pos)");
            Point targetLocationInEditor = point;
            Component component2 = editor2.getComponent();
            JViewport jViewport = this.getScrollPane().getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
            Point point2 = SwingUtilities.convertPoint(component2, targetLocationInEditor, jViewport.getView());
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"SwingUtilities.convertPo\u2026scrollPane.viewport.view)");
            return point2;
        }

        @NotNull
        public Point calculateScrollingLocation(@NotNull Editor editor2, @NotNull LogicalPosition pos) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Point point = editor2.logicalPositionToXY(pos);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.logicalPositionToXY(pos)");
            Point targetLocationInEditor = point;
            Component component2 = editor2.getComponent();
            JViewport jViewport = this.getScrollPane().getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
            Point point2 = SwingUtilities.convertPoint(component2, targetLocationInEditor, jViewport.getView());
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"SwingUtilities.convertPo\u2026scrollPane.viewport.view)");
            return point2;
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor(this.dummyEditor);
        }

        public CombinedEditorsScrollingModelHelper(@NotNull Project project, Disposable disposable2) {
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            EditorEx editorEx = DiffUtil.createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), project, true, true);
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"DiffUtil.createEditor(Ed\u2026\"\"), project, true, true)");
            this.dummyEditor = editorEx;
            Disposer.register((Disposable)disposable2, (Disposable)this);
        }
    }
}

