/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content2) {
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(0);
        }
        if (content2 instanceof EmptyContent) {
            return true;
        }
        if (content2 instanceof DocumentContent) {
            return true;
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            return !DiffUtil.isFileWithoutContent(file2);
        }
        if (content2 instanceof DirectoryContent) {
            return ((DirectoryContent)content2).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@Nullable Project project, @NotNull DiffContent content2, @NotNull FileNameInfo fileName) throws IOException {
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(2);
        }
        if (content2 instanceof EmptyContent) {
            return new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName));
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalInputFile(file2);
            }
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, fileName));
        }
        if (content2 instanceof DocumentContent) {
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(project, (DocumentContent)content2, fileName));
        }
        if (content2 instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content2).getFile();
            if (file3.isInLocalFileSystem()) {
                return new LocalInputFile(file3);
            }
            throw new IllegalArgumentException(content2.toString());
        }
        throw new IllegalArgumentException(content2.toString());
    }

    @NotNull
    private static File createTempFile(@Nullable Project project, @NotNull DocumentContent content2, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bom;
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveDocument(content2.getDocument());
        LineSeparator separator2 = content2.getLineSeparator();
        if (separator2 == null) {
            separator2 = LineSeparator.getSystemLineSeparator();
        }
        Charset charset = ExternalDiffToolUtil.getContentCharset(project, content2);
        Boolean hasBom = content2.hasBom();
        if (hasBom == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = content2.getDocument().getText();
        if (separator2 != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator2.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull FileNameInfo fileName) throws IOException {
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(6);
        }
        byte[] bytes = file2.contentsToByteArray();
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static Charset getContentCharset(@Nullable Project project, @NotNull DocumentContent content2) {
        Charset charset;
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(7);
        }
        if ((charset = content2.getCharset()) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(8);
            }
            return charset2;
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        Charset charset3 = e.getDefaultCharset();
        if (charset3 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(9);
        }
        return charset3;
    }

    @NotNull
    private static OutputFile createOutputFile(@Nullable Project project, @NotNull DiffContent content2, @NotNull FileNameInfo fileName) throws IOException {
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(11);
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalOutputFile(file2);
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file2, fileName);
            return new NonLocalOutputFile(file2, tempFile);
        }
        if (content2 instanceof DocumentContent) {
            DocumentContent documentContent = (DocumentContent)content2;
            File tempFile = ExternalDiffToolUtil.createTempFile(project, documentContent, fileName);
            Charset charset = ExternalDiffToolUtil.getContentCharset(project, documentContent);
            return new DocumentOutputFile(documentContent.getDocument(), charset, tempFile);
        }
        throw new IllegalArgumentException(content2.toString());
    }

    @NotNull
    private static File createFile(byte @NotNull [] bytes, @NotNull FileNameInfo fileName) throws IOException {
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(12);
        }
        if (bytes == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(13);
        }
        File tempFile = FileUtil.createTempFile((String)(fileName.prefix + "_"), (String)("_" + fileName.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file2 = tempFile;
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(14);
        }
        return file2;
    }

    public static void execute(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(15);
        }
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(16);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(17);
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files2 = new ArrayList<InputFile>();
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            DiffContent content2 = contents.get(i2);
            FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
            files2.add(ExternalDiffToolUtil.createFile(project, content2, fileName));
        }
        HashMap<String, String> patterns = new HashMap<String, String>();
        if (files2.size() == 2) {
            patterns.put("%1", ((InputFile)files2.get(0)).getPath());
            patterns.put("%2", ((InputFile)files2.get(1)).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", ((InputFile)files2.get(0)).getPath());
            patterns.put("%2", ((InputFile)files2.get(2)).getPath());
            patterns.put("%3", ((InputFile)files2.get(1)).getPath());
        }
        ExternalDiffToolUtil.execute(settings.getDiffExePath(), settings.getDiffParameters(), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void executeMerge(@Nullable Project project, @NotNull ExternalDiffSettings externalDiffSettings, @NotNull ThreesideMergeRequest threesideMergeRequest, @Nullable JComponent jComponent) throws IOException, ExecutionException {
        void request2;
        void settings;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(18);
        }
        if (request2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(19);
        }
        request2.onAssigned(true);
        try {
            boolean success2 = false;
            try {
                void parentComponent;
                Project project2;
                success2 = ExternalDiffToolUtil.tryExecuteMerge(project2, (ExternalDiffSettings)settings, (ThreesideMergeRequest)request2, (JComponent)parentComponent);
                request2.applyResult(success2 ? MergeResult.RESOLVED : MergeResult.CANCEL);
            }
            catch (Throwable throwable) {
                request2.applyResult(success2 ? MergeResult.RESOLVED : MergeResult.CANCEL);
                throw throwable;
            }
        }
        finally {
            request2.onAssigned(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryExecuteMerge(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request2, @Nullable JComponent parentComponent) throws IOException, ExecutionException {
        boolean success2;
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(20);
        }
        if (request2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(21);
        }
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request2.getOutputContent();
            List contents = request2.getContents();
            List titles = request2.getContentTitles();
            String windowTitle = request2.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i2 = 0; i2 < contents.size(); ++i2) {
                DiffContent content2 = (DiffContent)contents.get(i2);
                FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
                inputFiles.add(ExternalDiffToolUtil.createFile(project, content2, fileName));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(project, outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
            HashMap<String, String> patterns = new HashMap<String, String>();
            patterns.put("%1", ((InputFile)inputFiles.get(0)).getPath());
            patterns.put("%2", ((InputFile)inputFiles.get(2)).getPath());
            patterns.put("%3", ((InputFile)inputFiles.get(1)).getPath());
            patterns.put("%4", outputFile.getPath());
            final Process process2 = ExternalDiffToolUtil.execute(settings.getMergeExePath(), settings.getMergeParameters(), patterns);
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    final Semaphore semaphore = new Semaphore(0);
                    Thread waiter = new Thread("external process waiter"){

                        @Override
                        public void run() {
                            try {
                                resultRef.set((Object)(process2.waitFor() == 0 ? 1 : 0));
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                semaphore.release();
                            }
                        }
                    };
                    waiter.start();
                    try {
                        do {
                            ProgressManager.checkCanceled();
                        } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        waiter.interrupt();
                    }
                }, DiffBundle.message((String)"waiting.for.external.tool", (Object[])new Object[0]), true, project, parentComponent);
                success2 = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TimeoutUtil.sleep((long)1000L), DiffBundle.message((String)"launching.external.tool", (Object[])new Object[0]), false, project, parentComponent);
                boolean bl = success2 = Messages.showYesNoDialog((Project)project, (String)DiffBundle.message((String)"press.mark.as.resolve", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.in.external.tool", (Object[])new Object[0]), (String)DiffBundle.message((String)"mark.as.resolved", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.revert", (Object[])new Object[0]), null) == 0;
            }
            if (success2) {
                outputFile.apply();
            }
        }
        finally {
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
        }
        return success2;
    }

    @NotNull
    private static Process execute(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) throws ExecutionException {
        if (exePath == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(22);
        }
        if (parametersTemplate == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(23);
        }
        if (patterns == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(24);
        }
        List parameters2 = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from2 = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry2 : patterns.entrySet()) {
            from2.add(entry2.getKey());
            to.add(entry2.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter : parameters2) {
            String arg = StringUtil.replace((String)parameter, from2, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        Process process2 = generalCommandLine.createProcess();
        if (process2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(25);
        }
        return process2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersTemplate";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentCharset";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFile";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContentCharset";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 25: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createOutputFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeMerge";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryExecuteMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        FileNameInfo(@NotNull @NonNls String prefix, @NotNull @NonNls String name2) {
            if (prefix == null) {
                FileNameInfo.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                FileNameInfo.$$$reportNull$$$0(1);
            }
            this.prefix = prefix;
            this.name = name2;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index2) {
            if (contents == null) {
                FileNameInfo.$$$reportNull$$$0(2);
            }
            if (titles == null) {
                FileNameInfo.$$$reportNull$$$0(3);
            }
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index2);
                DiffContent content2 = (DiffContent)side.select(contents);
                String title2 = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name2 = FileNameInfo.getFileName(content2, title2, windowTitle);
                return new FileNameInfo(prefix, name2);
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index2);
                DiffContent content3 = (DiffContent)side.select(contents);
                String title3 = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name3 = FileNameInfo.getFileName(content3, title3, windowTitle);
                return new FileNameInfo(prefix, name3);
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content2, @Nullable String windowTitle) {
            if (content2 == null) {
                FileNameInfo.$$$reportNull$$$0(4);
            }
            String name2 = FileNameInfo.getFileName(content2, null, windowTitle);
            return new FileNameInfo("merge_result", name2);
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content2, @Nullable String title2, @Nullable String windowTitle) {
            String ext;
            if (content2 == null) {
                FileNameInfo.$$$reportNull$$$0(5);
            }
            if (content2 instanceof EmptyContent) {
                return "no_content.tmp";
            }
            String fileName = (String)content2.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName == null && content2 instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content2).getHighlightFile();
                String string = fileName = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName == null && content2 instanceof FileContent) {
                fileName = ((FileContent)content2).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName)) {
                String string = fileName;
                if (string == null) {
                    FileNameInfo.$$$reportNull$$$0(6);
                }
                return string;
            }
            FileType fileType = content2.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            Object name2 = "";
            if (title2 != null && windowTitle != null) {
                name2 = title2 + "_" + windowTitle;
            } else if (title2 != null || windowTitle != null) {
                Object object = name2 = title2 != null ? title2 : windowTitle;
            }
            if (((String)name2).length() > 50) {
                name2 = ((String)name2).substring(0, 50);
            }
            String string2 = PathUtil.suggestFileName((String)((String)name2 + "." + ext), (boolean)true, (boolean)false);
            if (string2 == null) {
                FileNameInfo.$$$reportNull$$$0(7);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titles";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createMergeResult";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileName";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        TempInputFile(@NotNull File localFile) {
            if (localFile == null) {
                TempInputFile.$$$reportNull$$$0(0);
            }
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                TempInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        LocalInputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LocalInputFile.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                LocalInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        DocumentOutputFile(@NotNull Document document, @NotNull Charset charset, @NotNull File localFile) {
            if (document == null) {
                DocumentOutputFile.$$$reportNull$$$0(0);
            }
            if (charset == null) {
                DocumentOutputFile.$$$reportNull$$$0(1);
            }
            if (localFile == null) {
                DocumentOutputFile.$$$reportNull$$$0(2);
            }
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset;
        }

        @Override
        public void apply() throws IOException {
            String content2 = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            if (file2 == null) {
                NonLocalOutputFile.$$$reportNull$$$0(0);
            }
            if (localFile == null) {
                NonLocalOutputFile.$$$reportNull$$$0(1);
            }
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            FileUtil.copy((File)this.myLocalFile, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myFile});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        LocalOutputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LocalOutputFile.$$$reportNull$$$0(0);
            }
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "<init>"));
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

