/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffModel;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.IntUnaryOperator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffViewer
extends ListenerDiffViewerBase {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    private final UnifiedDiffPanel myPanel;
    @NotNull
    private final OnesideContentPanel myContentPanel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MarkupUpdater myMarkupUpdater;
    @NotNull
    protected final TwosideTextDiffProvider.NoIgnore myTextDiffProvider;
    @NotNull
    protected Side myMasterSide;
    @NotNull
    private final UnifiedDiffModel myModel;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public UnifiedDiffViewer(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (context2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(1);
        }
        super(context2, (ContentDiffRequest)request2);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myMasterSide = Side.RIGHT;
        this.myModel = new UnifiedDiffModel(this);
        this.myReadOnlyLockSet = false;
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        this.myContentPanel = new OnesideContentPanel(this.myEditor.getComponent());
        if (this.getProject() != null) {
            this.myContentPanel.setBreadcrumbs(new UnifiedBreadcrumbsPanel(), this.getTextSettings());
        }
        this.myPanel = new UnifiedDiffPanel(this.myProject, this.myContentPanel, this, this.myContext);
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.myEditor, (Disposable)this);
        this.myMarkupUpdater = new MarkupUpdater(this.getContents());
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        this.myTextDiffProvider = DiffUtil.createNoIgnoreTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT), this.myPanel);
    }

    @Override
    @RequiresEdt
    protected void onInit() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.onInit();
        this.installEditorListeners();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
        this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications(this, (UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
        this.myContentPanel.setTitle(this.createTitles());
        new UiNotifyConnector((Component)this.getComponent(), new Activatable(){

            public void showNotify() {
                UnifiedDiffViewer.this.myMarkupUpdater.scheduleUpdate();
            }
        });
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myModel.clear();
        this.myFoldingModel.destroy();
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    @RequiresEdt
    protected void processContextHints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    @RequiresEdt
    protected void updateContextHints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    @Nullable
    protected JComponent createTitles() {
        List titles = DiffUtil.createTextTitles(this, this.myRequest, Arrays.asList(this.myEditor, this.myEditor));
        assert (titles.size() == 2);
        if ((titles = ContainerUtil.skipNulls(titles)).isEmpty()) {
            return null;
        }
        return DiffUtil.createStackedComponents(titles, DiffUtil.TITLE_GAP);
    }

    @RequiresEdt
    protected void updateEditorCanBeTyped() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @NotNull
    @RequiresEdt
    public List<AnAction> createToolbarActions() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<AnAction> group2 = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group2.add((AnAction)new MyToggleExpandByDefaultAction());
        group2.add((AnAction)new MyReadOnlyLockAction());
        group2.add((AnAction)this.myEditorSettingsAction);
        group2.add((AnAction)Separator.getInstance());
        group2.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group2;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    @RequiresEdt
    public List<AnAction> createPopupActions() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<AnAction> group2 = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group2.add((AnAction)new MyToggleExpandByDefaultAction());
        group2.add((AnAction)Separator.getInstance());
        group2.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group2;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>();
        if (this.isEditable(Side.RIGHT, false)) {
            group2.add(new ReplaceSelectedChangesAction(Side.LEFT));
            group2.add(new ReplaceSelectedChangesAction(Side.RIGHT));
        }
        group2.add((AnAction)Separator.getInstance());
        group2.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group2;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @RequiresEdt
    protected void installEditorListeners() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors(), this.myPanel);
    }

    @NotNull
    protected UnifiedDiffChangeUi createUi(@NotNull UnifiedDiffChange change) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(5);
        }
        return new UnifiedDiffChangeUi(this, change);
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(6);
        }
        super.onBeforeDocumentChange(event);
        this.myMarkupUpdater.suspendUpdate();
    }

    @Override
    protected void onBeforeRediff() {
        super.onBeforeRediff();
        this.myMarkupUpdater.suspendUpdate();
    }

    @Override
    @RequiresEdt
    protected void onSlowRediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator2) {
        Runnable runnable2;
        if (indicator2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(7);
        }
        try {
            runnable2 = this.computeDifferences(indicator2);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setTooBigContent();
            };
            if (runnable3 == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(9);
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyErrorNotification();
            if (runnable4 == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(10);
            }
            return runnable4;
        }
        if (runnable2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(8);
        }
        return runnable2;
    }

    @NotNull
    protected Runnable applyErrorNotification() {
        Runnable runnable2 = () -> {
            this.clearDiffPresentation();
            this.myPanel.setErrorContent();
        };
        if (runnable2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(11);
        }
        return runnable2;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(12);
        }
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
        List<LineFragment> fragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator2);
        UnifiedFragmentBuilder builder2 = (UnifiedFragmentBuilder)ReadAction.compute(() -> {
            indicator2.checkCanceled();
            return new UnifiedFragmentBuilder(fragments, document1, document2, this.myMasterSide).exec();
        });
        Runnable runnable2 = this.apply(builder2, texts, indicator2);
        if (runnable2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(13);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    @RequiresEdt
    protected void markSuppressEditorTyping() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    @RequiresEdt
    protected void markStateIsOutOfDate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myStateIsOutOfDate = true;
        this.myFoldingModel.disposeLineConvertor();
        this.myModel.updateGutterActions();
    }

    @Nullable
    private static EditorHighlighter buildHighlighter(@Nullable Project project, @NotNull Document document, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (document == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(14);
        }
        if (content1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(15);
        }
        if (content2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(16);
        }
        if (text1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(18);
        }
        if (ranges == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(19);
        }
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(text2);
        }
        return new UnifiedEditorHighlighter(document, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    protected Runnable apply(@NotNull UnifiedFragmentBuilder builder2, CharSequence @NotNull [] texts, @NotNull ProgressIndicator indicator2) {
        if (builder2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(20);
        }
        if (indicator2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(21);
        }
        if (texts == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(22);
        }
        DocumentContent content1 = this.getContent1();
        DocumentContent content2 = this.getContent2();
        HighlightersData highlightersData = (HighlightersData)BackgroundTaskUtil.tryComputeFast(___ -> (HighlightersData)ReadAction.compute(() -> {
            EditorHighlighter highlighter = UnifiedDiffViewer.buildHighlighter(this.myProject, this.myDocument, content1, content2, texts[0], texts[1], builder2.getRanges(), builder2.getText().length());
            UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(this.myProject, content1.getDocument(), content2.getDocument(), builder2.getRanges());
            return new HighlightersData(highlighter, rangeHighlighter);
        }), 500L);
        LineNumberConvertor convertor1 = builder2.getConvertor1();
        LineNumberConvertor convertor2 = builder2.getConvertor2();
        List<LineRange> changedLines = builder2.getChangedLines();
        boolean isContentsEqual = changedLines.isEmpty() && StringUtil.equals((CharSequence)texts[0], (CharSequence)texts[1]);
        Side masterSide = builder2.getMasterSide();
        FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(changedLines, this.getFoldingModelSettings(), this.getDocument(masterSide), (LineNumberConvertor)masterSide.select((Object)convertor1, (Object)convertor2), StringUtil.countNewLines((CharSequence)builder2.getText()) + 1);
        Runnable runnable2 = () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            LineCol oldCaretPosition = LineCol.fromOffset((Document)this.myDocument, (int)this.myEditor.getCaretModel().getPrimaryCaret().getOffset());
            Pair<int[], Side> oldCaretLineTwoside = this.transferLineFromOneside(oldCaretPosition.line);
            this.clearDiffPresentation();
            if (isContentsEqual && !DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DISABLE_CONTENTS_EQUALS_NOTIFICATION, new UserDataHolder[]{this.myContext, this.myRequest})) {
                this.myPanel.addNotification(TextDiffViewerUtil.createEqualContentsNotification(this.getContents()));
            }
            IntUnaryOperator foldingLineConvertor = this.myFoldingModel.getLineNumberConvertor();
            IntUnaryOperator contentConvertor1 = DiffUtil.getContentLineConvertor(this.getContent1());
            IntUnaryOperator contentConvertor2 = DiffUtil.getContentLineConvertor(this.getContent2());
            IntUnaryOperator merged1 = UnifiedDiffViewer.mergeLineConverters(contentConvertor1, convertor1.createConvertor(), foldingLineConvertor);
            IntUnaryOperator merged2 = UnifiedDiffViewer.mergeLineConverters(contentConvertor2, convertor2.createConvertor(), foldingLineConvertor);
            this.myEditor.getGutter().setLineNumberConverter((LineNumberConverter)(merged1 == null ? LineNumberConverter.DEFAULT : new LineNumberConverterAdapter(merged1)), (LineNumberConverter)(merged2 == null ? null : new LineNumberConverterAdapter(merged2)));
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myDuringOnesideDocumentModification = true;
                try {
                    this.myDocument.setText(builder2.getText());
                }
                finally {
                    this.myDuringOnesideDocumentModification = false;
                }
            });
            DiffUtil.setEditorCodeStyle(this.myProject, this.myEditor, this.getContent(this.myMasterSide));
            ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
            if (!this.myEditor.isViewer()) {
                for (UnifiedDiffChange change : builder2.getChanges()) {
                    LineRange range2 = (LineRange)this.myMasterSide.select((Object)change.getInsertedRange(), (Object)change.getDeletedRange());
                    if (range2.isEmpty()) continue;
                    TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range2.start, range2.end);
                    guarderRangeBlocks.add(this.createGuardedBlock(textRange.getStartOffset(), textRange.getEndOffset()));
                }
                int textLength = this.myDocument.getTextLength();
                guarderRangeBlocks.add(this.createGuardedBlock(textLength, textLength));
            }
            this.myModel.setChanges(builder2.getChanges(), isContentsEqual, guarderRangeBlocks, convertor1, convertor2, builder2.getRanges());
            int newCaretLine = this.transferLineToOneside((Side)oldCaretLineTwoside.second, ((Side)oldCaretLineTwoside.second).select((int[])oldCaretLineTwoside.first));
            this.myEditor.getCaretModel().moveToOffset(LineCol.toOffset((Document)this.myDocument, (int)newCaretLine, (int)oldCaretPosition.column));
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            HighlightersData.apply(this.myProject, this.myEditor, highlightersData);
            this.myMarkupUpdater.resumeUpdate();
            this.myInitialScrollHelper.onRediff();
            this.myStatusPanel.update();
            this.myPanel.setGoodContent();
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        };
        if (runnable2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(23);
        }
        return runnable2;
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start2, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start2, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(24);
        }
        return rangeMarker;
    }

    private static IntUnaryOperator mergeLineConverters(@Nullable IntUnaryOperator contentConvertor, @NotNull IntUnaryOperator unifiedConvertor, @NotNull IntUnaryOperator foldingConvertor) {
        if (unifiedConvertor == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(25);
        }
        if (foldingConvertor == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(26);
        }
        return DiffUtil.mergeLineConverters(DiffUtil.mergeLineConverters(contentConvertor, unifiedConvertor), foldingConvertor);
    }

    public int transferLineToOnesideStrict(@NotNull Side side, int line) {
        LineNumberConvertor convertor;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(27);
        }
        return (convertor = this.myModel.getLineNumberConvertor(side)) != null ? convertor.convertInv(line) : -1;
    }

    public int transferLineFromOnesideStrict(@NotNull Side side, int line) {
        LineNumberConvertor convertor;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(28);
        }
        return (convertor = this.myModel.getLineNumberConvertor(side)) != null ? convertor.convert(line) : -1;
    }

    public int transferLineToOneside(@NotNull Side side, int line) {
        LineNumberConvertor convertor;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(29);
        }
        return (convertor = this.myModel.getLineNumberConvertor(side)) != null ? convertor.convertApproximateInv(line) : line;
    }

    public int transferLineFromOneside(@NotNull Side side, int line) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(30);
        }
        return side.select((int[])this.transferLineFromOneside((int)line).first);
    }

    @NotNull
    public Pair<int[], Side> transferLineFromOneside(int line) {
        int[] lines2 = new int[2];
        UnifiedDiffModel.ChangedBlockData blockData = this.myModel.getData();
        if (blockData == null) {
            lines2[0] = line;
            lines2[1] = line;
            Pair pair = Pair.create((Object)lines2, (Object)this.myMasterSide);
            if (pair == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(31);
            }
            return pair;
        }
        LineNumberConvertor lineConvertor1 = blockData.getLineNumberConvertor(Side.LEFT);
        LineNumberConvertor lineConvertor2 = blockData.getLineNumberConvertor(Side.RIGHT);
        Side side = this.myMasterSide;
        lines2[0] = lineConvertor1.convert(line);
        lines2[1] = lineConvertor2.convert(line);
        if (lines2[0] == -1 && lines2[1] == -1) {
            lines2[0] = lineConvertor1.convertApproximate(line);
            lines2[1] = lineConvertor2.convertApproximate(line);
        } else if (lines2[0] == -1) {
            lines2[0] = lineConvertor1.convertApproximate(line);
            side = Side.RIGHT;
        } else if (lines2[1] == -1) {
            lines2[1] = lineConvertor2.convertApproximate(line);
            side = Side.LEFT;
        }
        Pair pair = Pair.create((Object)lines2, (Object)side);
        if (pair == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @RequiresEdt
    private void destroyChangedBlockData() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myModel.clear();
        UnifiedEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(33);
        }
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.scheduleRediff();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    public void replaceChange(@NotNull UnifiedDiffChange unifiedDiffChange, @NotNull Side side) {
        void sourceSide;
        void change;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(34);
        }
        if (sourceSide == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(35);
        }
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getStartLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    public void appendChange(@NotNull UnifiedDiffChange unifiedDiffChange, @NotNull Side side) {
        void sourceSide;
        void change;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(36);
        }
        if (sourceSide == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(37);
        }
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        if (sourceSide.getStartLine(lineFragment) == sourceSide.getEndLine(lineFragment)) {
            return;
        }
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getEndLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    @NotNull
    @RequiresEdt
    protected List<UnifiedDiffChange> getSelectedChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        BitSet lines2 = DiffUtil.getSelectedLines(this.myEditor);
        List changes = ContainerUtil.notNullize(this.myModel.getDiffChanges());
        List list2 = ContainerUtil.filter((Collection)changes, change -> UnifiedDiffViewer.isChangeSelected(change, lines2));
        if (list2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(38);
        }
        return list2;
    }

    private static boolean isChangeSelected(@NotNull UnifiedDiffChange change, @NotNull BitSet lines2) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(39);
        }
        if (lines2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(40);
        }
        return DiffUtil.isSelectedByLine(lines2, change.getLine1(), change.getLine2());
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(41);
        }
        return textDiffSettings;
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(42);
        }
        return settings;
    }

    @NotNull
    public FoldingModelSupport getFoldingModel() {
        MyFoldingModel myFoldingModel = this.myFoldingModel;
        if (myFoldingModel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(43);
        }
        return myFoldingModel;
    }

    @NotNull
    public Side getMasterSide() {
        Side side = this.myMasterSide;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(44);
        }
        return side;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(45);
        }
        return editorEx;
    }

    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list2 = Collections.singletonList(this.myEditor);
        if (list2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        List list2 = this.myRequest.getContents();
        if (list2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    protected DocumentContent getContent(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(48);
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(49);
        }
        return documentContent;
    }

    @NotNull
    protected DocumentContent getContent1() {
        DocumentContent documentContent = this.getContent(Side.LEFT);
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(50);
        }
        return documentContent;
    }

    @NotNull
    protected DocumentContent getContent2() {
        DocumentContent documentContent = this.getContent(Side.RIGHT);
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(51);
        }
        return documentContent;
    }

    @RequiresEdt
    @Nullable
    public List<UnifiedDiffChange> getDiffChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myModel.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        UnifiedDiffPanel unifiedDiffPanel = this.myPanel;
        if (unifiedDiffPanel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(52);
        }
        return unifiedDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected StatusPanel getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(53);
        }
        return myStatusPanel;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean isEditable(@NotNull Side side, boolean bl) {
        void respectReadOnlyLock;
        void side2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (side2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(54);
        }
        if (this.myReadOnlyLockSet && respectReadOnlyLock != false) {
            return false;
        }
        if (side2.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        return DiffUtil.canMakeWritable(this.getDocument((Side)side2));
    }

    @NotNull
    public Document getDocument(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(55);
        }
        Document document = this.getContent(side).getDocument();
        if (document == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(56);
        }
        return document;
    }

    protected boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getNavigatable(LineCol.fromCaret((Editor)this.myEditor));
    }

    @RequiresEdt
    @Nullable
    protected UnifiedDiffChange getCurrentChange() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<UnifiedDiffChange> changes = this.myModel.getDiffChanges();
        if (changes == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (UnifiedDiffChange change : changes) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    protected Navigatable getNavigatable(@NotNull LineCol lineCol) {
        void position;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (position == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(57);
        }
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int line1 = ((int[])pair.first)[0];
        int line2 = ((int[])pair.first)[1];
        Navigatable navigatable1 = this.getContent1().getNavigatable(new LineCol(line1, position.column));
        Navigatable navigatable2 = this.getContent2().getNavigatable(new LineCol(line2, position.column));
        if (navigatable1 == null) {
            return navigatable2;
        }
        if (navigatable2 == null) {
            return navigatable1;
        }
        return (Navigatable)((Side)pair.second).select((Object)navigatable1, (Object)navigatable2);
    }

    public boolean isContentGood() {
        return this.myPanel.isGoodContent() && this.myModel.isValid();
    }

    public static boolean canShowRequest(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (context2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(58);
        }
        if (request2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(59);
        }
        return TwosideTextDiffViewer.canShowRequest(context2, request2);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        UnifiedDiffChange change;
        if (dataId == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(60);
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getCurrentChange()) != null) {
            return new LineRange(change.getLine1(), change.getLine2());
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer";
                break;
            }
            case 5: 
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unifiedConvertor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingConvertor";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 48: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyErrorNotification";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "transferLineFromOneside";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMasterSide";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent1";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent2";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlighter";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mergeLineConverters";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "transferLineToOnesideStrict";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "transferLineFromOnesideStrict";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "transferLineToOneside";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "transferLineFromOneside";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChange";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSelected";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class UnifiedBreadcrumbsPanel
    extends DiffBreadcrumbsPanel {
        private final VirtualFile myFile1;
        private final VirtualFile myFile2;

        private UnifiedBreadcrumbsPanel() {
            super(UnifiedDiffViewer.this.getEditor(), (Disposable)UnifiedDiffViewer.this);
            this.myFile1 = FileDocumentManager.getInstance().getFile(UnifiedDiffViewer.this.getDocument(Side.LEFT));
            this.myFile2 = FileDocumentManager.getInstance().getFile(UnifiedDiffViewer.this.getDocument(Side.RIGHT));
        }

        @Override
        protected boolean updateCollectors(boolean enabled) {
            return enabled && (this.findCollector(this.myFile1) != null || this.findCollector(this.myFile2) != null);
        }

        @Override
        @Nullable
        protected Iterable<? extends Crumb> computeCrumbs(int offset) {
            Pair<Integer, Side> pair = this.transferOffsetToTwoside(offset);
            if (pair == null) {
                return null;
            }
            Side side = (Side)pair.second;
            int twosideOffset = (Integer)pair.first;
            VirtualFile file2 = (VirtualFile)side.select((Object)this.myFile1, (Object)this.myFile2);
            FileBreadcrumbsCollector collector = (FileBreadcrumbsCollector)side.select((Object)this.findCollector(this.myFile1), (Object)this.findCollector(this.myFile2));
            if (file2 == null || collector == null) {
                return null;
            }
            Iterable crumbs = collector.computeCrumbs(file2, UnifiedDiffViewer.this.getDocument(side), twosideOffset, null);
            return ContainerUtil.map((Iterable)crumbs, it -> it instanceof NavigatableCrumb ? new UnifiedNavigatableCrumb((NavigatableCrumb)it, side) : it);
        }

        @Override
        protected void navigateToCrumb(Crumb crumb, boolean withSelection) {
            if (crumb instanceof UnifiedNavigatableCrumb) {
                super.navigateToCrumb(crumb, withSelection);
            }
        }

        @Nullable
        private Pair<Integer, Side> transferOffsetToTwoside(int offset) {
            LineCol onesidePosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)offset);
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(onesidePosition.line);
            Side side = (Side)pair.second;
            int twosideLine = side.select((int[])pair.first);
            if (twosideLine == -1) {
                return null;
            }
            Document twosideDocument = UnifiedDiffViewer.this.getDocument(side);
            LineCol twosidePosition = new LineCol(twosideLine, onesidePosition.column);
            return Pair.create((Object)twosidePosition.toOffset(twosideDocument), (Object)side);
        }

        private int transferOffsetFromTwoside(@NotNull Side side, int offset) {
            if (side == null) {
                UnifiedBreadcrumbsPanel.$$$reportNull$$$0(0);
            }
            LineCol twosidePosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.getDocument(side), (int)offset);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, twosidePosition.line);
            if (onesideLine == -1) {
                return -1;
            }
            LineCol onesidePosition = new LineCol(onesideLine, twosidePosition.column);
            return onesidePosition.toOffset(UnifiedDiffViewer.this.myDocument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedBreadcrumbsPanel", "transferOffsetFromTwoside"));
        }

        private final class UnifiedNavigatableCrumb
        implements NavigatableCrumb {
            @NotNull
            private final NavigatableCrumb myDelegate;
            @NotNull
            private final Side mySide;

            private UnifiedNavigatableCrumb(@NotNull NavigatableCrumb delegate2, Side side) {
                if (delegate2 == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(0);
                }
                if (side == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(1);
                }
                this.myDelegate = delegate2;
                this.mySide = side;
            }

            public int getAnchorOffset() {
                int offset = this.myDelegate.getAnchorOffset();
                return offset != -1 ? UnifiedBreadcrumbsPanel.this.transferOffsetFromTwoside(this.mySide, offset) : -1;
            }

            @Nullable
            public TextRange getHighlightRange() {
                TextRange range2 = this.myDelegate.getHighlightRange();
                if (range2 == null) {
                    return null;
                }
                int start2 = UnifiedBreadcrumbsPanel.this.transferOffsetFromTwoside(this.mySide, range2.getStartOffset());
                int end = UnifiedBreadcrumbsPanel.this.transferOffsetFromTwoside(this.mySide, range2.getEndOffset());
                if (start2 == -1 || end == -1) {
                    return null;
                }
                return new TextRange(start2, end);
            }

            public void navigate(@NotNull Editor editor2, boolean withSelection) {
                TextRange range2;
                int offset;
                if (editor2 == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(2);
                }
                if ((offset = this.getAnchorOffset()) != -1) {
                    editor2.getCaretModel().moveToOffset(offset);
                    editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
                if (withSelection && (range2 = this.getHighlightRange()) != null) {
                    editor2.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                }
            }

            public Icon getIcon() {
                return this.myDelegate.getIcon();
            }

            public String getText() {
                return this.myDelegate.getText();
            }

            @Nullable
            public String getTooltip() {
                return this.myDelegate.getTooltip();
            }

            @NotNull
            public List<? extends Action> getContextActions() {
                List list2 = this.myDelegate.getContextActions();
                if (list2 == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(3);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedBreadcrumbsPanel$UnifiedNavigatableCrumb";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedBreadcrumbsPanel$UnifiedNavigatableCrumb";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContextActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "navigate";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class HighlightersData {
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;

        private HighlightersData(@Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter) {
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        public static void apply(@Nullable Project project, @NotNull EditorEx editor2, @Nullable HighlightersData highlightersData) {
            UnifiedEditorRangeHighlighter rangeHighlighter;
            if (editor2 == null) {
                HighlightersData.$$$reportNull$$$0(0);
            }
            EditorHighlighter highlighter = highlightersData != null ? highlightersData.myHighlighter : null;
            UnifiedEditorRangeHighlighter unifiedEditorRangeHighlighter = rangeHighlighter = highlightersData != null ? highlightersData.myRangeHighlighter : null;
            if (highlighter != null) {
                editor2.setHighlighter(highlighter);
            } else {
                editor2.setHighlighter(DiffUtil.createEmptyEditorHighlighter());
            }
            UnifiedEditorRangeHighlighter.erase(project, editor2.getDocument());
            if (rangeHighlighter != null) {
                rangeHighlighter.apply(project, editor2.getDocument());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$HighlightersData", "apply"));
        }
    }

    private final class MarkupUpdater
    implements Disposable {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;
        @NotNull
        private ProgressIndicator myUpdateIndicator;
        private boolean mySuspended;

        private MarkupUpdater(List<? extends DocumentContent> contents) {
            if (contents == null) {
                MarkupUpdater.$$$reportNull$$$0(0);
            }
            this.myUpdateQueue = new MergingUpdateQueue("UnifiedDiffViewer.MarkupUpdater", 300, true, (JComponent)UnifiedDiffViewer.this.myPanel, (Disposable)this);
            this.myUpdateIndicator = new EmptyProgressIndicator();
            Disposer.register((Disposable)UnifiedDiffViewer.this, (Disposable)this);
            MyMarkupModelListener markupListener = new MyMarkupModelListener();
            for (DocumentContent documentContent : contents) {
                Document document = documentContent.getDocument();
                MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document, UnifiedDiffViewer.this.myProject, true);
                model2.addMarkupModelListener(this, markupListener);
            }
        }

        public void dispose() {
            this.myUpdateIndicator.cancel();
        }

        @RequiresEdt
        public void suspendUpdate() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myUpdateIndicator.cancel();
            this.myUpdateQueue.cancelAllUpdates();
            this.mySuspended = true;
        }

        @RequiresEdt
        public void resumeUpdate() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.mySuspended = false;
            this.scheduleUpdate();
        }

        @RequiresEdt
        public void scheduleUpdate() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (UnifiedDiffViewer.this.myProject == null) {
                return;
            }
            if (this.mySuspended) {
                return;
            }
            if (!UnifiedDiffViewer.this.getComponent().isShowing()) {
                return;
            }
            this.myUpdateIndicator.cancel();
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    if (UnifiedDiffViewer.this.myStateIsOutOfDate || !UnifiedDiffViewer.this.myModel.isValid()) {
                        return;
                    }
                    MarkupUpdater.this.myUpdateIndicator.cancel();
                    MarkupUpdater.this.myUpdateIndicator = new EmptyProgressIndicator();
                    UnifiedDiffModel.ChangedBlockData blockData = Objects.requireNonNull(UnifiedDiffViewer.this.myModel.getData());
                    ReadAction.nonBlocking(() -> MarkupUpdater.this.updateHighlighters(blockData)).finishOnUiThread(ModalityState.stateForComponent((Component)UnifiedDiffViewer.this.myPanel), result2 -> {
                        if (UnifiedDiffViewer.this.myStateIsOutOfDate || blockData != UnifiedDiffViewer.this.myModel.getData()) {
                            return;
                        }
                        HighlightersData.apply(UnifiedDiffViewer.this.myProject, UnifiedDiffViewer.this.myEditor, result2);
                    }).withDocumentsCommitted(UnifiedDiffViewer.this.myProject).wrapProgress(MarkupUpdater.this.myUpdateIndicator).submit((Executor)NonUrgentExecutor.getInstance());
                }
            });
        }

        @NotNull
        private HighlightersData updateHighlighters(@NotNull UnifiedDiffModel.ChangedBlockData blockData) {
            if (blockData == null) {
                MarkupUpdater.$$$reportNull$$$0(1);
            }
            List<HighlightRange> ranges = blockData.getRanges();
            Document document1 = UnifiedDiffViewer.this.getContent1().getDocument();
            Document document2 = UnifiedDiffViewer.this.getContent2().getDocument();
            ProgressManager.checkCanceled();
            EditorHighlighter highlighter = UnifiedDiffViewer.buildHighlighter(UnifiedDiffViewer.this.myProject, UnifiedDiffViewer.this.myDocument, UnifiedDiffViewer.this.getContent1(), UnifiedDiffViewer.this.getContent2(), document1.getCharsSequence(), document2.getCharsSequence(), ranges, UnifiedDiffViewer.this.myDocument.getTextLength());
            ProgressManager.checkCanceled();
            UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(UnifiedDiffViewer.this.myProject, document1, document2, ranges);
            return new HighlightersData(highlighter, rangeHighlighter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MarkupUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateHighlighters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyMarkupModelListener
        implements MarkupModelListener {
            private MyMarkupModelListener() {
            }

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    MyMarkupModelListener.$$$reportNull$$$0(0);
                }
                MarkupUpdater.this.scheduleUpdate();
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    MyMarkupModelListener.$$$reportNull$$$0(1);
                }
                MarkupUpdater.this.scheduleUpdate();
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                if (highlighter == null) {
                    MyMarkupModelListener.$$$reportNull$$$0(2);
                }
                MarkupUpdater.this.scheduleUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MarkupUpdater$MyMarkupModelListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attributesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        @NotNull
        private DisposableLineNumberConvertor myLineNumberConvertor;

        MyFoldingModel(@Nullable Project project, @NotNull EditorEx editor2, @NotNull Disposable disposable2) {
            if (editor2 == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable2 == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, new EditorEx[]{editor2}, disposable2);
            this.myLineNumberConvertor = new DisposableLineNumberConvertor(null);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends LineRange> changedLines, @NotNull FoldingModelSupport.Settings settings, @NotNull Document document, @NotNull LineNumberConvertor lineConvertor, int lineCount) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ComparisonOperation.applyExpressionRewriter(ComparisonOperation.java:138)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanOperation.applyExpressionRewriter(BooleanOperation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.rewriteExpressions(StructuredIf.java:170)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NotNull
        public IntUnaryOperator getLineNumberConvertor() {
            IntUnaryOperator intUnaryOperator = this.getLineConvertor(0);
            if (intUnaryOperator == null) {
                MyFoldingModel.$$$reportNull$$$0(5);
            }
            return intUnaryOperator;
        }

        public void disposeLineConvertor() {
            this.myLineNumberConvertor.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineConvertor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineNumberConvertor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createState";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class DisposableLineNumberConvertor {
            @Nullable
            private volatile LineNumberConvertor myConvertor;

            private DisposableLineNumberConvertor(@Nullable LineNumberConvertor convertor) {
                this.myConvertor = convertor;
            }

            public int convert(int lineNumber) {
                LineNumberConvertor convertor = this.myConvertor;
                return convertor != null ? convertor.convert(lineNumber) : -1;
            }

            public void dispose() {
                this.myConvertor = null;
            }
        }

        private static final class MyFoldingBuilder
        extends FoldingModelSupport.FoldingBuilderBase {
            @NotNull
            private final Document myDocument;
            @NotNull
            private final DisposableLineNumberConvertor myLineConvertor;

            private MyFoldingBuilder(@NotNull Document document, @NotNull DisposableLineNumberConvertor lineConvertor, int lineCount, @NotNull FoldingModelSupport.Settings settings) {
                if (document == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(0);
                }
                if (lineConvertor == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(1);
                }
                if (settings == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(2);
                }
                super(new int[]{lineCount}, settings);
                this.myDocument = document;
                this.myLineConvertor = lineConvertor;
            }

            @Override
            @Nullable
            protected FoldingModelSupport.FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index2) {
                int masterLine;
                if (project == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(3);
                }
                if ((masterLine = this.myLineConvertor.convert(lineNumber)) == -1) {
                    return null;
                }
                return FoldingModelSupport.getLineSeparatorDescription(project, this.myDocument, masterLine);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineConvertor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel$MyFoldingBuilder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDescription";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list2 = UnifiedDiffViewer.this.getEditors();
            if (list2 == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        protected void disableSyncScroll(boolean value2) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        protected LogicalPosition @Nullable [] getCaretPositions() {
            LogicalPosition position = UnifiedDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)UnifiedDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(UnifiedDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            UnifiedDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(UnifiedDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(UnifiedDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(int line, int column2) {
            if (line == -1) {
                return new LogicalPosition(0, 0);
            }
            return new LogicalPosition(line, column2);
        }

        private void doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            if (side == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(1);
            }
            if (position == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(2);
            }
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, onesideLine, position.column, false);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            this.doScrollToLine((Side)this.myScrollToLine.first, new LogicalPosition(((Integer)this.myScrollToLine.second).intValue(), 0));
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            List<UnifiedDiffChange> changes;
            if (scrollToChangePolicy == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(3);
            }
            if ((changes = UnifiedDiffViewer.this.myModel.getDiffChanges()) == null) {
                return false;
            }
            UnifiedDiffChange targetChange = (UnifiedDiffChange)scrollToChangePolicy.select(ContainerUtil.filter(changes, it -> !it.isSkipped()));
            if (targetChange == null) {
                targetChange = scrollToChangePolicy.select(changes);
            }
            if (targetChange == null) {
                return false;
            }
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, targetChange.getLine1(), false);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myModel.getDiffChanges();
            if (changes == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(changes);
            int line = this.myNavigationContext.contextMatchCheck((Iterator)changedLinesIterator);
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(UnifiedDiffViewer.this.getContent2().getDocument());
                line = this.myNavigationContext.contextMatchCheck((Iterator)allLinesIterator);
            }
            if (line == -1) {
                return false;
            }
            this.doScrollToLine(Side.RIGHT, new LogicalPosition(line, 0));
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollToChangePolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doScrollToLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doScrollToChange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            UnifiedDiffModel.ChangedBlockData blockData = UnifiedDiffViewer.this.myModel.getData();
            if (blockData == null) {
                return null;
            }
            List<UnifiedDiffChange> allChanges = blockData.getDiffChanges();
            return DiffUtil.getStatusText(allChanges.size(), ContainerUtil.count(allChanges, it -> it.isExcluded()), UnifiedDiffViewer.this.myModel.isContentsEqual());
        }
    }

    private final class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final List<? extends UnifiedDiffChange> myChanges;
        private int myIndex;

        private ChangedLinesIterator(List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                ChangedLinesIterator.$$$reportNull$$$0(0);
            }
            this.myIndex = 0;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            LOG.assertTrue(!UnifiedDiffViewer.this.myStateIsOutOfDate);
            UnifiedDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            Document document = UnifiedDiffViewer.this.getContent2().getDocument();
            CharSequence insertedText = DiffUtil.getLinesContent(document, lineFragment.getStartLine2(), lineFragment.getEndLine2());
            int lineNumber = lineFragment.getStartLine2();
            LineTokenizer tokenizer = new LineTokenizer(insertedText.toString());
            for (String line : tokenizer.execute()) {
                this.addLine(lineNumber, line);
                ++lineNumber;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedLinesIterator", "<init>"));
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.ReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(UnifiedDiffViewer.this.getContext());
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            UnifiedDiffViewer.this.myReadOnlyLockSet = readOnly;
            UnifiedDiffViewer.this.myModel.updateGutterActions();
            UnifiedDiffViewer.this.updateEditorCanBeTyped();
            this.putEditorHint(UnifiedDiffViewer.this.myEditor, readOnly && UnifiedDiffViewer.this.isEditable(UnifiedDiffViewer.this.myMasterSide, false));
        }

        @Override
        protected boolean canEdit() {
            return !UnifiedDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent1().getDocument()) || !UnifiedDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent2().getDocument());
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(UnifiedDiffViewer.this.getTextSettings(), UnifiedDiffViewer.this.myFoldingModel);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor2, int line) {
            if (editor2 == null) {
                MyOpenInEditorWithMouseAction.$$$reportNull$$$0(0);
            }
            if (editor2 != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return UnifiedDiffViewer.this.getNavigatable(new LineCol(line));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<UnifiedDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<UnifiedDiffChange> getChanges() {
            List list2 = ContainerUtil.notNullize(UnifiedDiffViewer.this.getDiffChanges());
            if (list2 == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = UnifiedDiffViewer.this.myEditor;
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return change.getLine1();
        }

        @Override
        protected int getEndLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getLine2();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.copyShortcutFrom(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")));
            this.getTemplatePresentation().setText(DiffBundle.messagePointer((String)"action.presentation.diff.append.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setIcon(DiffUtil.getArrowDownIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (UnifiedDiffChange unifiedDiffChange : changes) {
                UnifiedDiffViewer.this.appendChange(unifiedDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$AppendSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.copyShortcutFrom(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            this.getTemplatePresentation().setText(UnifiedDiffChangeUi.getApplyActionText(UnifiedDiffViewer.this, focusedSide));
            this.getTemplatePresentation().setIcon(UnifiedDiffChangeUi.getApplyIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (UnifiedDiffChange unifiedDiffChange : changes) {
                UnifiedDiffViewer.this.replaceChange(unifiedDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ReplaceSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;

        ApplySelectedChangesActionBase(Side modifiedSide) {
            if (modifiedSide == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            this.myModifiedSide = modifiedSide;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor2 != UnifiedDiffViewer.this.getEditor()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true) || UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<UnifiedDiffChange> selectedChanges;
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if ((selectedChanges = UnifiedDiffViewer.this.getSelectedChanges()).isEmpty()) {
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true)) {
                return;
            }
            if (UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                return;
            }
            String title2 = DiffBundle.message((String)"message.use.selected.changes.command", (Object[])new Object[]{e.getPresentation().getText()});
            DiffUtil.executeWriteCommand(UnifiedDiffViewer.this.getDocument(this.myModifiedSide), e.getProject(), title2, () -> {
                this.apply(ContainerUtil.reverse((List)selectedChanges));
                UnifiedDiffViewer.this.scheduleRediff();
            });
        }

        protected boolean isSomeChangeSelected() {
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myModel.getDiffChanges();
            if (changes == null || changes.isEmpty()) {
                return false;
            }
            return DiffUtil.isSomeRangeSelected(UnifiedDiffViewer.this.getEditor(), (Condition<? super BitSet>)((Condition)lines2 -> ContainerUtil.exists((Iterable)changes, change -> UnifiedDiffViewer.isChangeSelected(change, lines2))));
        }

        @RequiresWriteLock
        protected abstract void apply(@NotNull List<? extends UnifiedDiffChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyOnesideDocumentListener
    implements DocumentListener {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyOnesideDocumentListener.$$$reportNull$$$0(0);
            }
            if (UnifiedDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            UnifiedDiffModel.ChangedBlockData blockData = UnifiedDiffViewer.this.myModel.getData();
            if (blockData == null) {
                LOG.warn("oneside beforeDocumentChange - model is invalid");
                return;
            }
            try {
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = UnifiedDiffViewer.this.getDocument(UnifiedDiffViewer.this.myMasterSide);
                LineCol onesideStartPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)e.getOffset());
                LineCol onesideEndPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)(e.getOffset() + e.getOldLength()));
                int line1 = onesideStartPosition.line;
                int line2 = onesideEndPosition.line + 1;
                int shift = DiffUtil.countLinesShift(e);
                int twosideStartLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    UnifiedDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (UnifiedDiffChange change : blockData.getDiffChanges()) {
                    change.processChange(line1, line2, shift);
                }
                LineNumberConvertor masterConvertor = blockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide);
                LineNumberConvertor slaveConvertor = blockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide.other());
                masterConvertor.handleMasterChange(line1, line2, shift, true);
                slaveConvertor.handleMasterChange(line1, line2, shift, false);
            }
            finally {
                UnifiedDiffViewer.this.markStateIsOutOfDate();
                UnifiedDiffViewer.this.scheduleRediff();
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            @NonNls StringBuilder info2 = new StringBuilder();
            Document document1 = UnifiedDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = UnifiedDiffViewer.this.getDocument(Side.RIGHT);
            info2.append("==== UnifiedDiffViewer Debug Info ====");
            info2.append("myMasterSide - ").append(UnifiedDiffViewer.this.myMasterSide).append('\n');
            info2.append("myLeftDocument.length() - ").append(document1.getTextLength()).append('\n');
            info2.append("myRightDocument.length() - ").append(document2.getTextLength()).append('\n');
            info2.append("myDocument.length() - ").append(UnifiedDiffViewer.this.myDocument.getTextLength()).append('\n');
            info2.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info2.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info2.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info2.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info2.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info2.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info2.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = UnifiedDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = UnifiedDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info2.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info2.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info2.append("---- UnifiedDiffViewer Debug Info ----");
            LOG.warn(info2.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOnesideDocumentListener", "beforeDocumentChange"));
        }
    }
}

