/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.SimpleAlignedDiffModel$WhenMappings;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffInlayMarkerRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 Y2\u00020\u0001:\u000bVWXYZ[\\]^_`B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020 2\b\b\u0002\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0018H\u0002J\u000e\u00108\u001a\u00020(2\u0006\u00103\u001a\u000204J(\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020 H\u0002J,\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020?2\u0006\u0010:\u001a\u00020\u00182\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010A\u001a\u00020BH\u0002J\u0006\u0010C\u001a\u00020(J6\u0010D\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010:\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020 2\u0006\u0010E\u001a\u00020$H\u0002J,\u0010F\u001a\u00020(2\u0006\u0010:\u001a\u00020\u00182\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010G\u001a\u0002062\u0006\u0010H\u001a\u00020$H\u0002J\u0018\u0010I\u001a\u00020?2\u0006\u0010:\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010J\u001a\u00020 2\u0006\u0010:\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010K\u001a\u00020$H\u0002J\u001c\u0010L\u001a\u00020$2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u00107\u001a\u00020\u0018H\u0002J\u001c\u0010M\u001a\u00020(2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010N\u001a\u00020(H\u0002J\f\u0010O\u001a\u00020 *\u000204H\u0002J\u0014\u0010P\u001a\u00020 *\u0002042\u0006\u0010:\u001a\u00020\u0018H\u0002J\u0012\u0010Q\u001a\u00020 *\u00020R2\u0006\u0010*\u001a\u00020 J\u0012\u0010S\u001a\u00020 *\u00020R2\u0006\u0010*\u001a\u00020 J\u001c\u0010T\u001a\u00020$*\u0002042\u0006\u0010:\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010U\u001a\u00020$*\u0002042\u0006\u0010:\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u00020 *\u0006\u0012\u0002\b\u00030\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u00020$*\u0006\u0012\u0002\b\u00030\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006a"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel;", "", "viewer", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "(Lcom/intellij/diff/tools/simple/SimpleDiffViewer;)V", "adjustedInlaysHeights", "", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$SideAndChange;", "Ljava/util/HashSet;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayHeight;", "alignedInlays", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeAlignDiffInlayPresentation;", "editor1", "Lcom/intellij/openapi/editor/ex/EditorEx;", "Lorg/jetbrains/annotations/NotNull;", "getEditor1", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "editor2", "getEditor2", "emptyInlays", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayId;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$EmptyLineAlignDiffInlayPresentation;", "inlayHighlighters", "Lcom/intellij/diff/util/Side;", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "id", "", "getId", "(Lcom/intellij/openapi/editor/Inlay;)J", "logicalLine", "", "getLogicalLine", "(Lcom/intellij/openapi/editor/Inlay;)I", "onLastLine", "", "getOnLastLine", "(Lcom/intellij/openapi/editor/Inlay;)Z", "addEmptyInlay", "", "inlayId", "line", "height", "above", "priority", "color", "Ljava/awt/Color;", "parent", "Lcom/intellij/openapi/Disposable;", "addInlay", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "inlaySide", "alignChange", "calculateHeight", "side", "linesToAdd", "inlaySideSoftWraps", "changeAlignedInlayHeight", "changeIntersection", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection;", "inlay", "processType", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ProcessType;", "clear", "createAlignInlay", "isLastLineToAdd", "createInlayHighlighter", "type", "isLastLine", "getChangeIntersection", "getRelatedLogicalLine", "isAboveInlay", "needSkipInlay", "processInlay", "realignChanges", "calculateDeltaHeight", "countSoftWraps", "getLineEndOffsetSafe", "Lcom/intellij/openapi/editor/Document;", "getLineStartOffsetSafe", "isMiddleLine", "isStartLine", "BaseAlignDiffInlayPresentation", "ChangeAlignDiffInlayPresentation", "ChangeIntersection", "Companion", "EmptyLineAlignDiffInlayPresentation", "InlayHeight", "InlayId", "MyInlayModelListener", "MySoftWrapModelListener", "ProcessType", "SideAndChange", "intellij.platform.diff.impl"})
public final class SimpleAlignedDiffModel {
    private final Map<SideAndChange, Inlay<ChangeAlignDiffInlayPresentation>> alignedInlays;
    private final Map<InlayId, Inlay<EmptyLineAlignDiffInlayPresentation>> emptyInlays;
    private final Map<SideAndChange, HashSet<InlayHeight>> adjustedInlaysHeights;
    private final Map<Side, List<RangeHighlighter>> inlayHighlighters;
    private final SimpleDiffViewer viewer;
    public static final int ALIGNED_CHANGE_INLAY_PRIORITY = 0;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void alignChange(@NotNull SimpleDiffChange change) {
        block2: {
            TextDiffType textDiffType;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                    if (!this.viewer.needAlignChanges()) {
                        return;
                    }
                    textDiffType = change.getDiffType();
                    if (!Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.INSERTED)) break block1;
                    TextDiffType textDiffType2 = TextDiffType.INSERTED;
                    Intrinsics.checkNotNullExpressionValue((Object)textDiffType2, (String)"TextDiffType.INSERTED");
                    this.addInlay(change, textDiffType2, Side.LEFT);
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED)) break block3;
                TextDiffType textDiffType3 = TextDiffType.DELETED;
                Intrinsics.checkNotNullExpressionValue((Object)textDiffType3, (String)"TextDiffType.DELETED");
                this.addInlay(change, textDiffType3, Side.RIGHT);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.MODIFIED)) break block2;
            TextDiffType textDiffType4 = TextDiffType.MODIFIED;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType4, (String)"TextDiffType.MODIFIED");
            this.addInlay(change, textDiffType4, Side.LEFT);
            TextDiffType textDiffType5 = TextDiffType.MODIFIED;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType5, (String)"TextDiffType.MODIFIED");
            this.addInlay(change, textDiffType5, Side.RIGHT);
        }
    }

    private final void addInlay(SimpleDiffChange change, TextDiffType diffType, Side inlaySide) {
        Side side = inlaySide.other();
        Intrinsics.checkNotNullExpressionValue((Object)side, (String)"inlaySide.other()");
        Side changeSide = side;
        int changeStartLine = change.getStartLine(changeSide);
        int changeEndLine = change.getEndLine(changeSide);
        int inlayStartLine = change.getStartLine(inlaySide);
        int inlayEndLine = change.getEndLine(inlaySide);
        EditorEx editorEx = this.viewer.getEditor(changeSide);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(changeSide)");
        boolean isLastLine = changeEndLine == DiffUtil.getLineCount(editorEx.getDocument());
        int changeSideSoftWraps = this.countSoftWraps(change, changeSide);
        int inlaySideSoftWraps = this.countSoftWraps(change, inlaySide);
        int delta = changeEndLine - changeStartLine - (inlayEndLine - inlayStartLine);
        if (delta < 0) {
            return;
        }
        if (delta == 0 && changeSideSoftWraps == inlaySideSoftWraps) {
            return;
        }
        if (delta == 0 && inlaySideSoftWraps > changeSideSoftWraps) {
            return;
        }
        Inlay<ChangeAlignDiffInlayPresentation> inlay = this.createAlignInlay(inlaySide, change, delta, inlaySideSoftWraps, isLastLine);
        boolean bl = false;
        boolean bl2 = false;
        Inlay<ChangeAlignDiffInlayPresentation> it = inlay;
        boolean bl3 = false;
        this.createInlayHighlighter(inlaySide, it, diffType, isLastLine);
        bl = false;
        bl2 = false;
        it = inlay;
        boolean bl4 = false;
        this.alignedInlays.put(new SideAndChange(inlaySide, change), it);
    }

    private final void createInlayHighlighter(Side side, Inlay<?> inlay, TextDiffType type, boolean isLastLine) {
        List list2;
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(side)");
        EditorEx editor2 = editorEx;
        int startOffset = inlay.getOffset();
        int endOffset = inlay instanceof RangeMarker ? ((RangeMarker)inlay).getEndOffset() : startOffset;
        RangeHighlighter rangeHighlighter = editor2.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, new TextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"editor.markupModel\n     \u2026erTargetArea.EXACT_RANGE)");
        RangeHighlighter highlighter = rangeHighlighter;
        if (Intrinsics.areEqual((Object)type, (Object)TextDiffType.MODIFIED) ^ true) {
            highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffInlayMarkerRenderer(type, inlay, isLastLine));
        }
        Map<Side, List<RangeHighlighter>> $this$getOrPut$iv = this.inlayHighlighters;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(side);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(side, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        list2.add((RangeHighlighter)highlighter);
    }

    private final Inlay<ChangeAlignDiffInlayPresentation> createAlignInlay(Side side, SimpleDiffChange change, int linesToAdd, int inlaySideSoftWraps, boolean isLastLineToAdd) {
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(side)");
        EditorEx editor2 = editorEx;
        int line = change.getDiffType() == TextDiffType.MODIFIED ? change.getEndLine(side) : change.getStartLine(side);
        int offset = DiffUtil.getOffset(editor2.getDocument(), line, 0);
        int n = this.calculateHeight(side, change, linesToAdd, inlaySideSoftWraps);
        TextDiffType textDiffType = change.getDiffType();
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"change.diffType");
        ChangeAlignDiffInlayPresentation inlayPresentation = new ChangeAlignDiffInlayPresentation(editor2, n, textDiffType);
        Inlay inlay = editor2.getInlayModel().addBlockElement(offset, new InlayProperties().showAbove(!isLastLineToAdd).priority(0), (EditorCustomElementRenderer)inlayPresentation);
        Intrinsics.checkNotNull((Object)inlay);
        return inlay;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateHeight(Side side, SimpleDiffChange change, int linesToAdd, int inlaySideSoftWraps) {
        int inlaySoftWrapHeight;
        int n;
        int n2;
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(side)");
        EditorEx inlayEditor = editorEx;
        Side side2 = side.other();
        Intrinsics.checkNotNullExpressionValue((Object)side2, (String)"side.other()");
        Side changeSide = side2;
        EditorEx editorEx2 = this.viewer.getEditor(changeSide);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"viewer.getEditor(changeSide)");
        EditorEx changeEditor = editorEx2;
        HashSet<InlayHeight> hashSet = this.adjustedInlaysHeights.get(new SideAndChange(side, change));
        if (hashSet != null) {
            Iterable iterable = hashSet;
            n2 = 0;
            int n3 = 0;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void receiver;
                Object t;
                Object t2 = t = iterator2.next();
                int n4 = n3;
                boolean bl = false;
                int n5 = ((InlayHeight)receiver).getHeight();
                n3 = n4 + n5;
            }
            n = n3;
        } else {
            n = 0;
        }
        int height = n;
        height += linesToAdd * changeEditor.getLineHeight();
        int n6 = change.getStartLine(changeSide);
        n2 = change.getEndLine(changeSide);
        while (n6 < n2) {
            void line;
            height += changeEditor.getLineHeight() * changeEditor.getSoftWrapModel().getSoftWrapsForLine((int)line).size();
            ++line;
        }
        if (change.getDiffType() == TextDiffType.MODIFIED && height > (inlaySoftWrapHeight = inlayEditor.getLineHeight() * inlaySideSoftWraps)) {
            height -= inlayEditor.getLineHeight() * inlaySideSoftWraps;
        }
        return height;
    }

    /*
     * WARNING - void declaration
     */
    private final void realignChanges() {
        void $this$forEach$iv;
        boolean bl;
        Iterable $this$any$iv;
        block6: {
            List<? extends EditorEx> list2 = this.viewer.getEditors();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"viewer.editors");
            $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorEx it = (EditorEx)element$iv;
                    boolean bl2 = false;
                    EditorEx editorEx = it;
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"it");
                    FoldingModelEx foldingModelEx = editorEx.getFoldingModel();
                    if (foldingModelEx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
                    }
                    if (!((FoldingModelImpl)foldingModelEx).isInBatchFoldingOperation()) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.clear();
        List<SimpleDiffChange> list3 = this.viewer.getDiffChanges();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"viewer.diffChanges");
        $this$any$iv = list3;
        SimpleAlignedDiffModel simpleAlignedDiffModel = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleDiffChange p1 = (SimpleDiffChange)element$iv;
            boolean bl3 = false;
            simpleAlignedDiffModel.alignChange(p1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        Object p1;
        Iterable $this$forEach$iv = this.alignedInlays.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p1 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p1);
        }
        this.alignedInlays.clear();
        Object object = this.inlayHighlighters;
        boolean element$iv = false;
        for (Map.Entry entry2 : object.entrySet()) {
            void side;
            p1 = entry2;
            boolean bl = false;
            object = (Side)p1.getKey();
            p1 = entry2;
            bl = false;
            List highlighters = (List)p1.getValue();
            EditorEx editorEx = this.viewer.getEditor((Side)side);
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(side)");
            Intrinsics.checkNotNullExpressionValue((Object)editorEx.getMarkupModel(), (String)"viewer.getEditor(side).markupModel");
            Iterable $this$forEach$iv2 = highlighters;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MarkupModelEx markupModel;
                RangeHighlighter p12 = (RangeHighlighter)element$iv2;
                boolean bl2 = false;
                markupModel.removeHighlighter(p12);
            }
        }
        this.inlayHighlighters.clear();
    }

    private final void processInlay(Inlay<?> inlay, ProcessType processType) {
        Side inlaySide;
        if (!this.viewer.needAlignChanges()) {
            return;
        }
        if (inlay.getRenderer() instanceof BaseAlignDiffInlayPresentation) {
            return;
        }
        int inlayLine = this.getLogicalLine(inlay);
        Side side = inlaySide = Intrinsics.areEqual((Object)this.viewer.getEditor(Side.LEFT), (Object)inlay.getEditor()) ? Side.LEFT : Side.RIGHT;
        if (this.needSkipInlay(inlay, inlaySide)) {
            return;
        }
        Side side2 = inlaySide.other();
        Intrinsics.checkNotNullExpressionValue((Object)side2, (String)"inlaySide.other()");
        Side alignSide = side2;
        InlayProperties inlayProperties = inlay.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)inlayProperties, (String)"inlay.properties");
        boolean isAboveInlay = inlayProperties.isShownAbove();
        int lineToBeAligned = this.getRelatedLogicalLine(inlaySide, inlayLine, isAboveInlay);
        ChangeIntersection changeIntersection = this.getChangeIntersection(inlaySide, inlayLine);
        InlayId inlayId = new InlayId(alignSide, inlay.getOffset(), this.getId(inlay));
        switch (SimpleAlignedDiffModel$WhenMappings.$EnumSwitchMapping$0[processType.ordinal()]) {
            case 1: {
                this.changeAlignedInlayHeight(changeIntersection, alignSide, inlay, processType);
                Inlay<EmptyLineAlignDiffInlayPresentation> inlay2 = this.emptyInlays.remove(inlayId);
                if (inlay2 != null) {
                    Inlay<EmptyLineAlignDiffInlayPresentation> inlay3 = inlay2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Disposable p1 = (Disposable)inlay3;
                    boolean bl3 = false;
                    Disposer.dispose((Disposable)p1);
                }
                break;
            }
            case 2: {
                this.changeAlignedInlayHeight(changeIntersection, alignSide, inlay, processType);
                Inlay<EmptyLineAlignDiffInlayPresentation> inlay4 = this.emptyInlays.get(inlayId);
                if (inlay4 != null) {
                    Inlay<EmptyLineAlignDiffInlayPresentation> inlay5 = inlay4;
                    boolean bl = false;
                    boolean bl4 = false;
                    Inlay<EmptyLineAlignDiffInlayPresentation> $this$run = inlay5;
                    boolean bl5 = false;
                    ((EmptyLineAlignDiffInlayPresentation)$this$run.getRenderer()).setHeight(inlay.getHeightInPixels());
                    $this$run.update();
                }
                break;
            }
            case 3: {
                ChangeIntersection changeIntersection2 = changeIntersection;
                if (changeIntersection2 instanceof ChangeIntersection.AboveChange) {
                    int alignInlayPriority = isAboveInlay ? 0 : Integer.MIN_VALUE;
                    SimpleAlignedDiffModel.addEmptyInlay$default(this, inlayId, lineToBeAligned, inlay.getHeightInPixels(), isAboveInlay, alignInlayPriority, null, (Disposable)inlay, 32, null);
                    break;
                }
                if (changeIntersection2 instanceof ChangeIntersection.InsideChange) {
                    this.changeAlignedInlayHeight(changeIntersection, alignSide, inlay, processType);
                    SimpleDiffChange change = ((ChangeIntersection.InsideChange)changeIntersection).getChange();
                    if (this.alignedInlays.containsKey(new SideAndChange(alignSide, change))) break;
                    int alignInlayPriority = isAboveInlay ? 0 : Integer.MIN_VALUE;
                    Color color = change.getDiffType().getColor(inlay.getEditor());
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"change.diffType.getColor(inlay.editor)");
                    Color color2 = color;
                    this.addEmptyInlay(inlayId, lineToBeAligned, inlay.getHeightInPixels(), isAboveInlay, alignInlayPriority, color2, (Disposable)inlay);
                    break;
                }
                if (!(changeIntersection2 instanceof ChangeIntersection.NoIntersection)) break;
                SimpleAlignedDiffModel.addEmptyInlay$default(this, inlayId, lineToBeAligned, inlay.getHeightInPixels(), isAboveInlay, Integer.MAX_VALUE, null, (Disposable)inlay, 32, null);
                break;
            }
        }
    }

    private final boolean needSkipInlay(Inlay<?> inlay, Side inlaySide) {
        Side side = inlaySide.other();
        Intrinsics.checkNotNullExpressionValue((Object)side, (String)"inlaySide.other()");
        Side alignSide = side;
        EditorEx editorEx = this.viewer.getEditor(inlaySide);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(inlaySide)");
        EditorEx inlayEditor = editorEx;
        EditorEx editorEx2 = this.viewer.getEditor(alignSide);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"viewer.getEditor(alignSide)");
        EditorEx alignEditor = editorEx2;
        InlayProperties inlayProperties = inlay.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)inlayProperties, (String)"inlay.properties");
        return !inlayProperties.isShownAbove() && this.getOnLastLine(inlay) && DiffUtil.getLineCount(alignEditor.getDocument()) <= DiffUtil.getLineCount(inlayEditor.getDocument());
    }

    /*
     * WARNING - void declaration
     */
    private final void changeAlignedInlayHeight(ChangeIntersection changeIntersection, Side side, Inlay<?> inlay, ProcessType processType) {
        block12: {
            InlayHeight inlayHeight;
            Object v2;
            boolean bl;
            Iterable iterable;
            HashSet storedInlaysHeights;
            Inlay<ChangeAlignDiffInlayPresentation> $this$run;
            InlayId inlayId;
            int inlayHeight2;
            SimpleDiffChange change;
            block11: {
                Object object;
                void $this$getOrPut$iv;
                if (!(changeIntersection instanceof ChangeIntersection.InsideChange)) {
                    return;
                }
                change = ((ChangeIntersection.InsideChange)changeIntersection).getChange();
                inlayHeight2 = inlay.getHeightInPixels();
                inlayId = new InlayId(side, inlay.getOffset(), this.getId(inlay));
                SideAndChange sideAndChange = new SideAndChange(side, change);
                Inlay<ChangeAlignDiffInlayPresentation> inlay2 = this.alignedInlays.get(sideAndChange);
                if (inlay2 == null) break block12;
                Inlay<ChangeAlignDiffInlayPresentation> inlay3 = inlay2;
                boolean bl2 = false;
                boolean bl3 = false;
                $this$run = inlay3;
                boolean bl4 = false;
                Map<SideAndChange, HashSet<InlayHeight>> map2 = this.adjustedInlaysHeights;
                SideAndChange key$iv = sideAndChange;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                storedInlaysHeights = (HashSet)object;
                iterable = storedInlaysHeights;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl7 = false;
                for (Object object2 : iterable2) {
                    InlayHeight it = (InlayHeight)object2;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)inlayId)) continue;
                    v2 = object2;
                    break block11;
                }
                v2 = null;
            }
            if ((inlayHeight = (InlayHeight)v2) == null) {
                inlayHeight = new InlayHeight(inlayId, inlayHeight2);
            }
            InlayHeight storedInlayHeight = inlayHeight;
            switch (SimpleAlignedDiffModel$WhenMappings.$EnumSwitchMapping$1[processType.ordinal()]) {
                case 1: {
                    storedInlaysHeights.removeIf(new Predicate(storedInlayHeight){
                        final /* synthetic */ InlayHeight $storedInlayHeight;

                        public final boolean test(@NotNull InlayHeight it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getId(), (Object)this.$storedInlayHeight.getId());
                        }
                        {
                            this.$storedInlayHeight = inlayHeight;
                        }
                    });
                    ChangeAlignDiffInlayPresentation changeAlignDiffInlayPresentation = (ChangeAlignDiffInlayPresentation)$this$run.getRenderer();
                    changeAlignDiffInlayPresentation.setHeight(changeAlignDiffInlayPresentation.getHeight() - inlayHeight2);
                    break;
                }
                case 2: {
                    storedInlaysHeights.add(storedInlayHeight);
                    ChangeAlignDiffInlayPresentation changeAlignDiffInlayPresentation = (ChangeAlignDiffInlayPresentation)$this$run.getRenderer();
                    changeAlignDiffInlayPresentation.setHeight(changeAlignDiffInlayPresentation.getHeight() + inlayHeight2);
                    break;
                }
                case 3: {
                    int n;
                    storedInlayHeight.setHeight(inlayHeight2);
                    iterable = storedInlaysHeights;
                    int n2 = this.calculateDeltaHeight(change);
                    ChangeAlignDiffInlayPresentation changeAlignDiffInlayPresentation = (ChangeAlignDiffInlayPresentation)$this$run.getRenderer();
                    bl = false;
                    int n3 = 0;
                    for (Iterator iterator2 : iterable) {
                        void receiver;
                        Object object2;
                        object2 = iterator2;
                        n = n3;
                        boolean bl9 = false;
                        int n4 = ((InlayHeight)receiver).getHeight();
                        n3 = n + n4;
                    }
                    n = n3;
                    changeAlignDiffInlayPresentation.setHeight(n2 + n);
                }
            }
            $this$run.update();
        }
    }

    private final void addEmptyInlay(InlayId inlayId, int line, int height, boolean above, int priority, Color color, Disposable parent) {
        EditorEx editorEx = this.viewer.getEditor(inlayId.getSide());
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(inlayId.side)");
        EditorEx editor2 = editorEx;
        int offset = DiffUtil.getOffset(editor2.getDocument(), line, 0);
        Disposable disposable2 = new Disposable(this, inlayId){
            final /* synthetic */ SimpleAlignedDiffModel this$0;
            final /* synthetic */ InlayId $inlayId;

            public final void dispose() {
                block0: {
                    Inlay inlay = (Inlay)SimpleAlignedDiffModel.access$getEmptyInlays$p(this.this$0).remove(this.$inlayId);
                    if (inlay == null) break block0;
                    Inlay inlay2 = inlay;
                    boolean bl = false;
                    boolean bl2 = false;
                    Disposable p1 = (Disposable)inlay2;
                    boolean bl3 = false;
                    Disposer.dispose((Disposable)p1);
                }
            }
            {
                this.this$0 = simpleAlignedDiffModel;
                this.$inlayId = inlayId;
            }
        };
        Inlay inlay = editor2.getInlayModel().addBlockElement(offset, new InlayProperties().showAbove(above).priority(priority), (EditorCustomElementRenderer)new EmptyLineAlignDiffInlayPresentation(editor2, height, color));
        Intrinsics.checkNotNull((Object)inlay);
        Inlay inlay2 = inlay;
        boolean bl = false;
        boolean bl2 = false;
        Inlay inlay3 = inlay2;
        InlayId inlayId2 = inlayId;
        Map<InlayId, Inlay<EmptyLineAlignDiffInlayPresentation>> map2 = this.emptyInlays;
        boolean bl3 = false;
        Disposer.register((Disposable)parent, (Disposable)disposable2);
        Unit unit = Unit.INSTANCE;
        Inlay inlay4 = inlay2;
        Intrinsics.checkNotNullExpressionValue((Object)inlay4, (String)"editor.inlayModel.addBlo\u2026ter(parent, disposable) }");
        map2.put(inlayId2, (Inlay<EmptyLineAlignDiffInlayPresentation>)inlay4);
    }

    static /* synthetic */ void addEmptyInlay$default(SimpleAlignedDiffModel simpleAlignedDiffModel, InlayId inlayId, int n, int n2, boolean bl, int n3, Color color, Disposable disposable2, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            EditorEx editorEx = simpleAlignedDiffModel.viewer.getEditor(inlayId.getSide().other());
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(inlayId.side.other())");
            Color color2 = editorEx.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"viewer.getEditor(inlayId\u2026.other()).backgroundColor");
            color = color2;
        }
        simpleAlignedDiffModel.addEmptyInlay(inlayId, n, n2, bl, n3, color, disposable2);
    }

    private final ChangeIntersection getChangeIntersection(Side side, int logicalLine) {
        for (SimpleDiffChange change : this.viewer.getDiffChanges()) {
            SimpleDiffChange simpleDiffChange = change;
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiffChange, (String)"change");
            if (this.isStartLine(simpleDiffChange, side, logicalLine)) {
                return ChangeIntersection.AboveChange.INSTANCE;
            }
            if (!this.isMiddleLine(change, side, logicalLine)) continue;
            return new ChangeIntersection.InsideChange(change);
        }
        return ChangeIntersection.NoIntersection.INSTANCE;
    }

    private final boolean isStartLine(SimpleDiffChange $this$isStartLine, Side side, int logicalLine) {
        return $this$isStartLine.getStartLine(side) == logicalLine;
    }

    private final boolean isMiddleLine(SimpleDiffChange $this$isMiddleLine, Side side, int logicalLine) {
        return $this$isMiddleLine.getStartLine(side) < logicalLine && $this$isMiddleLine.getEndLine(side) - 1 >= logicalLine;
    }

    private final int getRelatedLogicalLine(Side side, int logicalLine, boolean isAboveInlay) {
        boolean needAlignLastLine;
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(side)");
        boolean bl = needAlignLastLine = logicalLine == DiffUtil.getLineCount(editorEx.getDocument()) - 1;
        if (needAlignLastLine && !isAboveInlay) {
            Side side2 = side.other();
            Intrinsics.checkNotNullExpressionValue((Object)side2, (String)"side.other()");
            Side alignSide = side2;
            EditorEx editorEx2 = this.viewer.getEditor(alignSide);
            Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"viewer.getEditor(alignSide)");
            int lastLine = DiffUtil.getLineCount(editorEx2.getDocument()) - 1;
            ChangeIntersection changeIntersection = this.getChangeIntersection(alignSide, lastLine);
            if (Intrinsics.areEqual((Object)changeIntersection, (Object)ChangeIntersection.NoIntersection.INSTANCE)) {
                return lastLine;
            }
        }
        return this.viewer.transferPosition((Side)side, (LineCol)new LineCol((int)logicalLine, (int)0)).line;
    }

    private final boolean getOnLastLine(Inlay<?> $this$onLastLine) {
        Editor editor2 = $this$onLastLine.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        return DiffUtil.getLineCount(editor2.getDocument()) - 1 == this.getLogicalLine($this$onLastLine);
    }

    private final int getLogicalLine(Inlay<?> $this$logicalLine) {
        return $this$logicalLine.getEditor().offsetToLogicalPosition((int)$this$logicalLine.getOffset()).line;
    }

    private final long getId(Inlay<?> $this$id) {
        Inlay<?> inlay = $this$id;
        if (inlay == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
        }
        return ((RangeMarkerEx)inlay).getId();
    }

    private final EditorEx getEditor1() {
        EditorEx editorEx = this.viewer.getEditor1();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.editor1");
        return editorEx;
    }

    private final EditorEx getEditor2() {
        EditorEx editorEx = this.viewer.getEditor2();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.editor2");
        return editorEx;
    }

    private final int calculateDeltaHeight(SimpleDiffChange $this$calculateDeltaHeight) {
        int leftStartLine = $this$calculateDeltaHeight.getStartLine(Side.LEFT);
        int leftEndLine = $this$calculateDeltaHeight.getEndLine(Side.LEFT);
        int rightStartLine = $this$calculateDeltaHeight.getStartLine(Side.RIGHT);
        int rightEndLine = $this$calculateDeltaHeight.getEndLine(Side.RIGHT);
        int delta = leftEndLine - leftStartLine - (rightEndLine - rightStartLine);
        boolean bl = false;
        int n = Math.abs(delta);
        EditorEx editorEx = this.viewer.getEditor(Side.LEFT);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(Side.LEFT)");
        return n * editorEx.getLineHeight();
    }

    private final int countSoftWraps(SimpleDiffChange $this$countSoftWraps, Side side) {
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"viewer.getEditor(side)");
        EditorEx editor2 = editorEx;
        SoftWrapModelEx softWrapModelEx = editor2.getSoftWrapModel();
        Intrinsics.checkNotNullExpressionValue((Object)softWrapModelEx, (String)"editor.softWrapModel");
        SoftWrapModelEx softWrapModel = softWrapModelEx;
        if (!softWrapModel.isSoftWrappingEnabled()) {
            return 0;
        }
        DocumentEx documentEx = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        int startOffset = this.getLineStartOffsetSafe(document, $this$countSoftWraps.getStartLine(side));
        int endOffset = this.getLineEndOffsetSafe(document, $this$countSoftWraps.getEndLine(side) - 1);
        return softWrapModel.getSoftWrapsForRange(startOffset, endOffset).size();
    }

    public final int getLineEndOffsetSafe(@NotNull Document $this$getLineEndOffsetSafe, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineEndOffsetSafe, (String)"$this$getLineEndOffsetSafe");
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount($this$getLineEndOffsetSafe)) {
            return $this$getLineEndOffsetSafe.getTextLength();
        }
        return $this$getLineEndOffsetSafe.getLineEndOffset(line);
    }

    public final int getLineStartOffsetSafe(@NotNull Document $this$getLineStartOffsetSafe, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartOffsetSafe, (String)"$this$getLineStartOffsetSafe");
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount($this$getLineStartOffsetSafe)) {
            return $this$getLineStartOffsetSafe.getTextLength();
        }
        return $this$getLineStartOffsetSafe.getLineStartOffset(line);
    }

    public SimpleAlignedDiffModel(@NotNull SimpleDiffViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        this.viewer = viewer;
        boolean bl = false;
        this.alignedInlays = new LinkedHashMap();
        bl = false;
        this.emptyInlays = new LinkedHashMap();
        bl = false;
        this.adjustedInlaysHeights = new LinkedHashMap();
        bl = false;
        this.inlayHighlighters = new LinkedHashMap();
        MyInlayModelListener inlayListener = new MyInlayModelListener();
        this.getEditor1().getInlayModel().addListener((InlayModel.Listener)inlayListener, (Disposable)this.viewer);
        this.getEditor2().getInlayModel().addListener((InlayModel.Listener)inlayListener, (Disposable)this.viewer);
        MySoftWrapModelListener softWrapListener = new MySoftWrapModelListener();
        this.getEditor1().getSoftWrapModel().addSoftWrapChangeListener(softWrapListener);
        this.getEditor2().getSoftWrapModel().addSoftWrapChangeListener(softWrapListener);
    }

    public static final /* synthetic */ Map access$getEmptyInlays$p(SimpleAlignedDiffModel $this) {
        return $this.emptyInlays;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0010\u001a\u00020\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J,\u0010\u0014\u001a\u00020\u00152\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u0005*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$BaseAlignDiffInlayPresentation;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "height", "", "inlayColor", "Ljava/awt/Color;", "(Lcom/intellij/openapi/editor/ex/EditorEx;ILjava/awt/Color;)V", "getHeight", "()I", "setHeight", "(I)V", "maxWidth", "getMaxWidth", "(Lcom/intellij/openapi/editor/ex/EditorEx;)I", "calcHeightInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.diff.impl"})
    private static class BaseAlignDiffInlayPresentation
    implements EditorCustomElementRenderer {
        private final EditorEx editor;
        private int height;
        private final Color inlayColor;

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            EditorEx editorEx = this.editor;
            if (editorEx == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            }
            EditorImpl cfr_ignored_0 = (EditorImpl)editorEx;
            Color color = this.inlayColor;
            if (color == null) {
                return;
            }
            Color paintColor = color;
            g.setColor(paintColor);
            g.fillRect(targetRegion.x, targetRegion.y, this.getMaxWidth(this.editor), this.height);
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return this.getMaxWidth(this.editor);
        }

        public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return this.height;
        }

        private final int getMaxWidth(EditorEx $this$maxWidth) {
            EditorEx editorEx = $this$maxWidth;
            if (editorEx == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            }
            int n = ((EditorImpl)editorEx).getPreferredSize().width;
            JComponent jComponent = this.editor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
            int n2 = jComponent.getWidth();
            boolean bl = false;
            return Math.max(n, n2);
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public BaseAlignDiffInlayPresentation(@NotNull EditorEx editor2, int height, @Nullable Color inlayColor) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            this.height = height;
            this.inlayColor = inlayColor;
        }

        public /* synthetic */ BaseAlignDiffInlayPresentation(EditorEx editorEx, int n, Color color, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                color = null;
            }
            this(editorEx, n, color);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$EmptyLineAlignDiffInlayPresentation;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$BaseAlignDiffInlayPresentation;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "height", "", "inlayColor", "Ljava/awt/Color;", "(Lcom/intellij/openapi/editor/ex/EditorEx;ILjava/awt/Color;)V", "intellij.platform.diff.impl"})
    private static final class EmptyLineAlignDiffInlayPresentation
    extends BaseAlignDiffInlayPresentation {
        public EmptyLineAlignDiffInlayPresentation(@NotNull EditorEx editor2, int height, @Nullable Color inlayColor) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(editor2, height, inlayColor);
        }

        public /* synthetic */ EmptyLineAlignDiffInlayPresentation(EditorEx editorEx, int n, Color color, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                color = editorEx.getBackgroundColor();
            }
            this(editorEx, n, color);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeAlignDiffInlayPresentation;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$BaseAlignDiffInlayPresentation;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "height", "", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "(Lcom/intellij/openapi/editor/ex/EditorEx;ILcom/intellij/diff/util/TextDiffType;)V", "intellij.platform.diff.impl"})
    private static final class ChangeAlignDiffInlayPresentation
    extends BaseAlignDiffInlayPresentation {
        public ChangeAlignDiffInlayPresentation(@NotNull EditorEx editor2, int height, @NotNull TextDiffType diffType) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)diffType, (String)"diffType");
            super(editor2, height, Companion.getAlignedChangeColor(diffType, editor2));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$MySoftWrapModelListener;", "Lcom/intellij/openapi/editor/ex/SoftWrapChangeListener;", "(Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel;)V", "recalculationEnds", "", "softWrapsChanged", "intellij.platform.diff.impl"})
    private final class MySoftWrapModelListener
    implements SoftWrapChangeListener {
        @Override
        public void softWrapsChanged() {
            if (!SimpleAlignedDiffModel.this.viewer.needAlignChanges()) {
                return;
            }
            if (!SimpleAlignedDiffModel.this.viewer.getTextSettings().isUseSoftWraps()) {
                SimpleAlignedDiffModel.this.realignChanges();
            }
        }

        @Override
        public void recalculationEnds() {
            if (!SimpleAlignedDiffModel.this.viewer.needAlignChanges()) {
                return;
            }
            SimpleAlignedDiffModel.this.realignChanges();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001c\u0010\b\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$MyInlayModelListener;", "Lcom/intellij/openapi/editor/InlayModel$Listener;", "(Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel;)V", "onAdded", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "onRemoved", "onUpdated", "changeFlags", "", "intellij.platform.diff.impl"})
    private final class MyInlayModelListener
    implements InlayModel.Listener {
        public void onAdded(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            SimpleAlignedDiffModel.this.processInlay(inlay, ProcessType.ADDED);
        }

        public void onRemoved(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            SimpleAlignedDiffModel.this.processInlay(inlay, ProcessType.REMOVED);
        }

        public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            if ((changeFlags & 2) != 0) {
                SimpleAlignedDiffModel.this.processInlay(inlay, ProcessType.HEIGHT_UPDATED);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ProcessType;", "", "(Ljava/lang/String;I)V", "ADDED", "REMOVED", "HEIGHT_UPDATED", "intellij.platform.diff.impl"})
    private static final class ProcessType
    extends Enum<ProcessType> {
        public static final /* enum */ ProcessType ADDED;
        public static final /* enum */ ProcessType REMOVED;
        public static final /* enum */ ProcessType HEIGHT_UPDATED;
        private static final /* synthetic */ ProcessType[] $VALUES;

        static {
            ProcessType[] processTypeArray = new ProcessType[3];
            ProcessType[] processTypeArray2 = processTypeArray;
            processTypeArray[0] = ADDED = new ProcessType();
            processTypeArray[1] = REMOVED = new ProcessType();
            processTypeArray[2] = HEIGHT_UPDATED = new ProcessType();
            $VALUES = processTypeArray;
        }

        public static ProcessType[] values() {
            return (ProcessType[])$VALUES.clone();
        }

        public static ProcessType valueOf(String string) {
            return Enum.valueOf(ProcessType.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection;", "", "()V", "AboveChange", "InsideChange", "NoIntersection", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection$InsideChange;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection$AboveChange;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection$NoIntersection;", "intellij.platform.diff.impl"})
    private static abstract class ChangeIntersection {
        private ChangeIntersection() {
        }

        public /* synthetic */ ChangeIntersection(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection$InsideChange;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection;", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "(Lcom/intellij/diff/tools/simple/SimpleDiffChange;)V", "getChange", "()Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "intellij.platform.diff.impl"})
        public static final class InsideChange
        extends ChangeIntersection {
            @NotNull
            private final SimpleDiffChange change;

            @NotNull
            public final SimpleDiffChange getChange() {
                return this.change;
            }

            public InsideChange(@NotNull SimpleDiffChange change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                super(null);
                this.change = change;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection$AboveChange;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection;", "()V", "intellij.platform.diff.impl"})
        public static final class AboveChange
        extends ChangeIntersection {
            @NotNull
            public static final AboveChange INSTANCE;

            private AboveChange() {
                super(null);
            }

            static {
                AboveChange aboveChange;
                INSTANCE = aboveChange = new AboveChange();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection$NoIntersection;", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$ChangeIntersection;", "()V", "intellij.platform.diff.impl"})
        public static final class NoIntersection
        extends ChangeIntersection {
            @NotNull
            public static final NoIntersection INSTANCE;

            private NoIntersection() {
                super(null);
            }

            static {
                NoIntersection noIntersection;
                INSTANCE = noIntersection = new NoIntersection();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayHeight;", "", "id", "Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayId;", "height", "", "(Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayId;I)V", "getHeight", "()I", "setHeight", "(I)V", "getId", "()Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayId;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.diff.impl"})
    private static final class InlayHeight {
        @NotNull
        private final InlayId id;
        private int height;

        @NotNull
        public final InlayId getId() {
            return this.id;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public InlayHeight(@NotNull InlayId id2, int height) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.id = id2;
            this.height = height;
        }

        @NotNull
        public final InlayId component1() {
            return this.id;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final InlayHeight copy(@NotNull InlayId id2, int height) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return new InlayHeight(id2, height);
        }

        public static /* synthetic */ InlayHeight copy$default(InlayHeight inlayHeight, InlayId inlayId, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inlayId = inlayHeight.id;
            }
            if ((n2 & 2) != 0) {
                n = inlayHeight.height;
            }
            return inlayHeight.copy(inlayId, n);
        }

        @NotNull
        public String toString() {
            return "InlayHeight(id=" + this.id + ", height=" + this.height + ")";
        }

        public int hashCode() {
            InlayId inlayId = this.id;
            return (inlayId != null ? ((Object)inlayId).hashCode() : 0) * 31 + Integer.hashCode(this.height);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InlayHeight)) break block3;
                    InlayHeight inlayHeight = (InlayHeight)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)inlayHeight.id) || this.height != inlayHeight.height) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$InlayId;", "", "side", "Lcom/intellij/diff/util/Side;", "offset", "", "id", "", "(Lcom/intellij/diff/util/Side;IJ)V", "getId", "()J", "getOffset", "()I", "getSide", "()Lcom/intellij/diff/util/Side;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.diff.impl"})
    private static final class InlayId {
        @NotNull
        private final Side side;
        private final int offset;
        private final long id;

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final long getId() {
            return this.id;
        }

        public InlayId(@NotNull Side side, int offset, long id2) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.side = side;
            this.offset = offset;
            this.id = id2;
        }

        @NotNull
        public final Side component1() {
            return this.side;
        }

        public final int component2() {
            return this.offset;
        }

        public final long component3() {
            return this.id;
        }

        @NotNull
        public final InlayId copy(@NotNull Side side, int offset, long id2) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return new InlayId(side, offset, id2);
        }

        public static /* synthetic */ InlayId copy$default(InlayId inlayId, Side side, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                side = inlayId.side;
            }
            if ((n2 & 2) != 0) {
                n = inlayId.offset;
            }
            if ((n2 & 4) != 0) {
                l = inlayId.id;
            }
            return inlayId.copy(side, n, l);
        }

        @NotNull
        public String toString() {
            return "InlayId(side=" + this.side + ", offset=" + this.offset + ", id=" + this.id + ")";
        }

        public int hashCode() {
            Side side = this.side;
            return ((side != null ? side.hashCode() : 0) * 31 + Integer.hashCode(this.offset)) * 31 + Long.hashCode(this.id);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InlayId)) break block3;
                    InlayId inlayId = (InlayId)object;
                    if (!Intrinsics.areEqual((Object)this.side, (Object)inlayId.side) || this.offset != inlayId.offset || this.id != inlayId.id) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$SideAndChange;", "", "side", "Lcom/intellij/diff/util/Side;", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "(Lcom/intellij/diff/util/Side;Lcom/intellij/diff/tools/simple/SimpleDiffChange;)V", "getChange", "()Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "getSide", "()Lcom/intellij/diff/util/Side;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    private static final class SideAndChange {
        @NotNull
        private final Side side;
        @NotNull
        private final SimpleDiffChange change;

        public boolean equals(@Nullable Object other) {
            return other instanceof SideAndChange && this.side == ((SideAndChange)other).side && Companion.isSame(this.change, ((SideAndChange)other).change);
        }

        public int hashCode() {
            return Objects.hash(this.side, this.change.getStartLine(Side.LEFT), this.change.getEndLine(Side.LEFT), this.change.getStartLine(Side.RIGHT), this.change.getEndLine(Side.RIGHT));
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        @NotNull
        public final SimpleDiffChange getChange() {
            return this.change;
        }

        public SideAndChange(@NotNull Side side, @NotNull SimpleDiffChange change) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            this.side = side;
            this.change = change;
        }

        @NotNull
        public final Side component1() {
            return this.side;
        }

        @NotNull
        public final SimpleDiffChange component2() {
            return this.change;
        }

        @NotNull
        public final SideAndChange copy(@NotNull Side side, @NotNull SimpleDiffChange change) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            return new SideAndChange(side, change);
        }

        public static /* synthetic */ SideAndChange copy$default(SideAndChange sideAndChange, Side side, SimpleDiffChange simpleDiffChange, int n, Object object) {
            if ((n & 1) != 0) {
                side = sideAndChange.side;
            }
            if ((n & 2) != 0) {
                simpleDiffChange = sideAndChange.change;
            }
            return sideAndChange.copy(side, simpleDiffChange);
        }

        @NotNull
        public String toString() {
            return "SideAndChange(side=" + this.side + ", change=" + this.change + ")";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel$Companion;", "", "()V", "ALIGNED_CHANGE_INLAY_PRIORITY", "", "getAlignedChangeColor", "Ljava/awt/Color;", "type", "Lcom/intellij/diff/util/TextDiffType;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isSame", "", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "other", "intellij.platform.diff.impl"})
    public static final class Companion {
        private final boolean isSame(SimpleDiffChange $this$isSame, SimpleDiffChange other) {
            return $this$isSame.getStartLine(Side.LEFT) == other.getStartLine(Side.LEFT) && $this$isSame.getEndLine(Side.LEFT) == other.getEndLine(Side.LEFT) && $this$isSame.getStartLine(Side.RIGHT) == other.getStartLine(Side.RIGHT) && $this$isSame.getEndLine(Side.RIGHT) == other.getEndLine(Side.RIGHT);
        }

        @Nullable
        public final Color getAlignedChangeColor(@NotNull TextDiffType type, @NotNull Editor editor2) {
            Color color;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (type == TextDiffType.MODIFIED) {
                color = null;
            } else {
                Color color2 = type.getColor(editor2);
                boolean bl = false;
                boolean bl2 = false;
                Color it = color2;
                boolean bl3 = false;
                color = ColorUtil.toAlpha((Color)it, (int)200);
            }
            return color;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

