/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.SimpleAlignedDiffModel;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffModel {
    @NotNull
    private final SimpleDiffViewer myViewer;
    @NotNull
    private final List<SimpleDiffChange> myValidChanges;
    @NotNull
    private final List<SimpleDiffChange> myAllChanges;
    @NotNull
    private ThreeState myIsContentsEqual;
    @NotNull
    private final List<SimpleDiffChangeUi> myPresentations;
    @NotNull
    private final SimpleAlignedDiffModel myAlignedDiffModel;

    public SimpleDiffModel(@NotNull SimpleDiffViewer viewer) {
        if (viewer == null) {
            SimpleDiffModel.$$$reportNull$$$0(0);
        }
        this.myValidChanges = new ArrayList<SimpleDiffChange>();
        this.myAllChanges = new ArrayList<SimpleDiffChange>();
        this.myIsContentsEqual = ThreeState.UNSURE;
        this.myPresentations = new ArrayList<SimpleDiffChangeUi>();
        this.myViewer = viewer;
        this.myAlignedDiffModel = new SimpleAlignedDiffModel(viewer);
    }

    @NotNull
    public ThreeState isContentsEqual() {
        ThreeState threeState = this.myIsContentsEqual;
        if (threeState == null) {
            SimpleDiffModel.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    @NotNull
    public List<SimpleDiffChange> getChanges() {
        List<SimpleDiffChange> list2 = this.myValidChanges;
        if (list2 == null) {
            SimpleDiffModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public List<SimpleDiffChange> getAllChanges() {
        List list2 = ContainerUtil.filter(this.myAllChanges, it -> !it.isDestroyed());
        if (list2 == null) {
            SimpleDiffModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void setChanges(@NotNull List<SimpleDiffChange> changes, boolean isContentsEqual) {
        if (changes == null) {
            SimpleDiffModel.$$$reportNull$$$0(4);
        }
        this.clear();
        for (int i2 = 0; i2 < changes.size(); ++i2) {
            SimpleDiffChange change = changes.get(i2);
            SimpleDiffChange previousChange = i2 != 0 ? changes.get(i2 - 1) : null;
            SimpleDiffChangeUi changeUi = this.myViewer.createUi(change);
            changeUi.installHighlighter(previousChange);
            this.myAlignedDiffModel.alignChange(change);
            this.myPresentations.add(changeUi);
        }
        this.myValidChanges.addAll(changes);
        this.myAllChanges.addAll(changes);
        this.myIsContentsEqual = ThreeState.fromBoolean((boolean)isContentsEqual);
    }

    public void clear() {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.destroyHighlighter();
        }
        this.myValidChanges.clear();
        this.myAllChanges.clear();
        this.myPresentations.clear();
        this.myAlignedDiffModel.clear();
        this.myIsContentsEqual = ThreeState.UNSURE;
    }

    public void destroyChange(@NotNull SimpleDiffChange change) {
        SimpleDiffChangeUi changeUi;
        if (change == null) {
            SimpleDiffModel.$$$reportNull$$$0(5);
        }
        if ((changeUi = (SimpleDiffChangeUi)this.myPresentations.set(change.getIndex(), null)) != null) {
            changeUi.destroyHighlighter();
        }
        this.myValidChanges.remove(change);
        change.markDestroyed();
    }

    public void updateGutterActions(boolean force) {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.updateGutterActions(force);
        }
    }

    public void handleBeforeDocumentChange(@NotNull Side side, @NotNull DocumentEvent e) {
        if (side == null) {
            SimpleDiffModel.$$$reportNull$$$0(6);
        }
        if (e == null) {
            SimpleDiffModel.$$$reportNull$$$0(7);
        }
        if (this.myValidChanges.isEmpty()) {
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        HashSet<SimpleDiffChange> invalidated = new HashSet<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myValidChanges) {
            if (!change.processDocumentChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalidated.add(change);
            SimpleDiffChangeUi changeUi = this.myPresentations.get(change.getIndex());
            if (changeUi == null) continue;
            changeUi.invalidate();
        }
        this.myValidChanges.removeAll(invalidated);
    }

    public void paintPolygons(@NotNull Graphics2D g, @NotNull JComponent divider) {
        if (g == null) {
            SimpleDiffModel.$$$reportNull$$$0(8);
        }
        if (divider == null) {
            SimpleDiffModel.$$$reportNull$$$0(9);
        }
        MyPaintable paintable = new MyPaintable(this.getChanges(), this.myViewer.needAlignChanges());
        DiffDividerDrawUtil.paintPolygons(g, divider.getWidth(), this.myViewer.getEditor1(), this.myViewer.getEditor2(), paintable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "divider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "isContentsEqual";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "destroyChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeDocumentChange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        private final List<SimpleDiffChange> myChanges;
        private final boolean myNeedAlignChanges;

        private MyPaintable(@NotNull List<SimpleDiffChange> changes, boolean alignChanges) {
            if (changes == null) {
                MyPaintable.$$$reportNull$$$0(0);
            }
            this.myChanges = changes;
            this.myNeedAlignChanges = alignChanges;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyPaintable.$$$reportNull$$$0(1);
            }
            for (SimpleDiffChange diffChange : this.myChanges) {
                int startLine1 = diffChange.getStartLine(Side.LEFT);
                int endLine1 = diffChange.getEndLine(Side.LEFT);
                int startLine2 = diffChange.getStartLine(Side.RIGHT);
                int endLine2 = diffChange.getEndLine(Side.RIGHT);
                TextDiffType type = diffChange.getDiffType();
                if (!(this.myNeedAlignChanges ? !handler2.processAligned(startLine1, endLine1, startLine2, endLine2, type) : !handler2.processExcludable(startLine1, endLine1, startLine2, endLine2, type, diffChange.isExcluded(), diffChange.isSkipped()))) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffModel$MyPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

