/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsPanel;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffBreadcrumbsPanel
extends BreadcrumbsPanel {
    private boolean myCrumbsShown;

    public DiffBreadcrumbsPanel(@NotNull Editor editor2, @NotNull Disposable disposable2) {
        if (editor2 == null) {
            DiffBreadcrumbsPanel.$$$reportNull$$$0(0);
        }
        if (disposable2 == null) {
            DiffBreadcrumbsPanel.$$$reportNull$$$0(1);
        }
        super(editor2);
        Disposer.register((Disposable)disposable2, (Disposable)this);
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DiffBreadcrumbsPanel.this.updateVisibility();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/breadcrumbs/DiffBreadcrumbsPanel$1", "fileTypesChanged"));
            }
        });
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateVisibility());
    }

    public void setCrumbsShown(boolean value2) {
        this.myCrumbsShown = value2;
        this.updateVisibility();
    }

    private void updateVisibility() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.stateForComponent((Component)this), () -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            boolean hasCollectors = this.updateCollectors(this.myCrumbsShown);
            if (hasCollectors != this.isVisible()) {
                this.setVisible(hasCollectors);
                this.revalidate();
                this.repaint();
            }
            this.queueUpdate();
        });
    }

    protected abstract boolean updateCollectors(boolean var1);

    @Nullable
    protected FileBreadcrumbsCollector findCollector(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(file2);
        if (viewProvider == null) {
            return null;
        }
        if (!ContainerUtil.exists((Iterable)viewProvider.getLanguages(), lang -> BreadcrumbsUtilEx.isBreadcrumbsShownFor(lang) && BreadcrumbsUtil.getInfoProvider((Language)lang) != null)) {
            return null;
        }
        return DiffBreadcrumbsPanel.findCollectorFor(this.myProject, file2, this);
    }

    @Override
    protected int getLeftOffset() {
        if (((EditorEx)this.myEditor).getVerticalScrollbarOrientation() == 0) {
            return 0;
        }
        return super.getLeftOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/diff/tools/util/breadcrumbs/DiffBreadcrumbsPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

