/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.documentation.mdn;

import com.intellij.documentation.mdn.MdnApiStatus;
import com.intellij.documentation.mdn.MdnDocumentation;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnJavaScriptRuntime;
import com.intellij.documentation.mdn.MdnRawSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentationAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.psi.XmlPsiBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J%\u0010\u0019\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001a\u001a\u00020\u000f2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016J\f\u0010\u001f\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter;", "Lcom/intellij/documentation/mdn/MdnSymbolDocumentation;", "name", "", "source", "Lcom/intellij/documentation/mdn/MdnDocumentation;", "doc", "Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;", "(Ljava/lang/String;Lcom/intellij/documentation/mdn/MdnDocumentation;Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;)V", "description", "getDescription", "()Ljava/lang/String;", "footnote", "getFootnote", "isDeprecated", "", "()Z", "isExperimental", "getName", "sections", "", "getSections", "()Ljava/util/Map;", "url", "getUrl", "getDocumentation", "withDefinition", "Lcom/intellij/openapi/util/NlsSafe;", "additionalSectionsContent", "Ljava/util/function/Consumer;", "Ljava/lang/StringBuilder;", "fixUrls", "intellij.xml.psi.impl"})
public final class MdnSymbolDocumentationAdapter
implements MdnSymbolDocumentation {
    @NotNull
    private final String name;
    private final MdnDocumentation source;
    private final MdnRawSymbolDocumentation doc;

    @Override
    @NotNull
    public String getUrl() {
        return MdnDocumentationKt.access$fixMdnUrls(this.doc.getUrl(), this.source.getLang());
    }

    @Override
    public boolean isDeprecated() {
        Set<MdnApiStatus> set2 = this.doc.getStatus();
        return set2 != null && set2.contains((Object)MdnApiStatus.Deprecated);
    }

    @Override
    public boolean isExperimental() {
        Set<MdnApiStatus> set2 = this.doc.getStatus();
        return set2 != null && set2.contains((Object)MdnApiStatus.Experimental);
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.doc.getDoc();
        if (string == null) {
            string = "";
        }
        String string2 = StringUtil.capitalize((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(doc.doc ?: \"\")");
        return this.fixUrls(string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getSections() {
        void $this$mapTo$iv$iv;
        Sequence sequence;
        String sectionName;
        boolean bl;
        Object map2;
        Map result2 = MapsKt.toMutableMap(this.doc.getSections());
        if (this.doc.getCompatibility() != null) {
            Map<String, Map<MdnJavaScriptRuntime, String>> map3 = this.doc.getCompatibility();
            Intrinsics.checkNotNull(map3);
            Iterable $this$forEach$iv = map3.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CharSequence charSequence;
                String string;
                int n;
                CharSequence charSequence2;
                void id2;
                Map.Entry $dstr$id$map = (Map.Entry)element$iv;
                boolean bl2 = false;
                Map.Entry entry2 = $dstr$id$map;
                boolean bl3 = false;
                String string2 = (String)entry2.getKey();
                entry2 = $dstr$id$map;
                bl3 = false;
                map2 = (Map)entry2.getValue();
                String actualId = Intrinsics.areEqual((Object)id2, (Object)"default_context") ? "browser_compatibility" : id2;
                String bundleKey = "mdn.documentation.section.compat." + actualId;
                if (StringsKt.startsWith$default((String)actualId, (String)"support_of_", (boolean)false, (int)2, null) && !XmlPsiBundle.hasKey((String)bundleKey)) {
                    Object[] objectArray = new Object[1];
                    charSequence2 = actualId;
                    n = "support_of_".length();
                    bl = false;
                    String string3 = charSequence2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    objectArray[0] = string4;
                    String string5 = XmlPsiBundle.message((String)"mdn.documentation.section.compat.support_of", (Object[])objectArray);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"XmlPsiBundle.message(\"md\u2026ng(\"support_of_\".length))");
                } else {
                    String string6 = XmlPsiBundle.message((String)bundleKey, (Object[])new Object[0]);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"XmlPsiBundle.message(bundleKey)");
                }
                sectionName = string;
                Map map4 = result2;
                String string7 = sectionName;
                charSequence2 = CollectionsKt.joinToString$default((Iterable)map2.entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)sections.1.1.INSTANCE, (int)30, null);
                n = 0;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    String string8;
                    String string9 = string7;
                    Map map5 = map4;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)XmlPsiBundle.message((String)"mdn.documentation.section.compat.supported_by.none", (Object[])new Object[0]), (String)"XmlPsiBundle.message(\"md\u2026ompat.supported_by.none\")");
                    map4 = map5;
                    string7 = string9;
                    charSequence = string8;
                } else {
                    charSequence = charSequence2;
                }
                map4.put(string7, charSequence);
            }
        }
        if ((sequence = this.doc.getStatus()) != null && (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) != null && (sequence = SequencesKt.filter((Sequence)sequence, (Function1)sections.2.INSTANCE)) != null && (sequence = SequencesKt.map((Sequence)sequence, (Function1)sections.3.INSTANCE)) != null) {
            MapsKt.toMap((Sequence)sequence, (Map)result2);
        }
        Map $this$map$iv = result2;
        boolean $i$f$map = false;
        Map map6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_9 = $this$mapTo$iv$iv;
        boolean bl5 = false;
        for (Map.Entry item$iv$iv : var7_9.entrySet()) {
            void key;
            void $dstr$key$value;
            map2 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            void var13_21 = $dstr$key$value;
            bl = false;
            sectionName = (String)var13_21.getKey();
            var13_21 = $dstr$key$value;
            bl = false;
            String value2 = (String)var13_21.getValue();
            Pair pair = new Pair((Object)this.fixUrls((String)key), (Object)this.fixUrls(value2));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public String getFootnote() {
        return this.fixUrls("By <a href='" + this.doc.getUrl() + "/contributors.txt'>Mozilla Contributors</a>, <a href='https://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a>");
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition) {
        return this.getDocumentation(withDefinition, null);
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition, @Nullable Consumer<StringBuilder> additionalSectionsContent) {
        return MdnDocumentationKt.access$buildDoc(this, withDefinition, additionalSectionsContent);
    }

    private final String fixUrls(String $this$fixUrls) {
        CharSequence charSequence = $this$fixUrls;
        Regex regex = new Regex("<a[ \n\t]+href=[ \t]*['\"]#([^'\"]*)['\"]");
        String string = "<a href=\"" + Regex.Companion.escapeReplacement(this.doc.getUrl()) + "#$1\"";
        boolean bl = false;
        return MdnDocumentationKt.access$fixMdnUrls(regex.replace(charSequence, string), this.source.getLang());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public MdnSymbolDocumentationAdapter(@NotNull String name2, @NotNull MdnDocumentation source, @NotNull MdnRawSymbolDocumentation doc) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.name = name2;
        this.source = source;
        this.doc = doc;
    }
}

