/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentExecutor
implements Disposable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final List<Filter> myFilterList;
    private Runnable myRerunAction;
    private Runnable myStopAction;
    private Runnable myAfterCompletion;
    private Computable<Boolean> myStopEnabled;
    @NlsContexts.TabTitle
    private String myTitle;
    private String myHelpId;
    private boolean myActivateToolWindow;
    private boolean myFocusToolWindow;
    private ConsoleView myUserProvidedConsole;

    public RunContentExecutor(@NotNull Project project, @NotNull ProcessHandler process2) {
        if (project == null) {
            RunContentExecutor.$$$reportNull$$$0(0);
        }
        if (process2 == null) {
            RunContentExecutor.$$$reportNull$$$0(1);
        }
        this.myFilterList = new ArrayList<Filter>();
        this.myTitle = ExecutionBundle.message((String)"output.tab.default.title", (Object[])new Object[0]);
        this.myHelpId = null;
        this.myActivateToolWindow = true;
        this.myFocusToolWindow = true;
        this.myProject = project;
        this.myProcess = process2;
    }

    public RunContentExecutor withFilter(Filter filter) {
        this.myFilterList.add(filter);
        return this;
    }

    public RunContentExecutor withTitle(@NlsContexts.TabTitle String title2) {
        this.myTitle = title2;
        return this;
    }

    public RunContentExecutor withRerun(Runnable rerun) {
        this.myRerunAction = rerun;
        return this;
    }

    public RunContentExecutor withStop(@NotNull Runnable stop2, @NotNull Computable<Boolean> stopEnabled) {
        if (stop2 == null) {
            RunContentExecutor.$$$reportNull$$$0(2);
        }
        if (stopEnabled == null) {
            RunContentExecutor.$$$reportNull$$$0(3);
        }
        this.myStopAction = stop2;
        this.myStopEnabled = stopEnabled;
        return this;
    }

    public RunContentExecutor withAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
        return this;
    }

    public RunContentExecutor withHelpId(String helpId) {
        this.myHelpId = helpId;
        return this;
    }

    public RunContentExecutor withActivateToolWindow(boolean activateToolWindow2) {
        this.myActivateToolWindow = activateToolWindow2;
        return this;
    }

    public RunContentExecutor withFocusToolWindow(boolean focusToolWindow) {
        this.myFocusToolWindow = focusToolWindow;
        return this;
    }

    private ConsoleView createConsole() {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        consoleBuilder.filters(this.myFilterList);
        ConsoleView console2 = consoleBuilder.getConsole();
        if (this.myHelpId != null) {
            console2.setHelpId(this.myHelpId);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions2 = new DefaultActionGroup();
        JComponent consolePanel = RunContentExecutor.createConsolePanel(console2, (ActionGroup)actions2);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)console2, this.myProcess, consolePanel, this.myTitle);
        descriptor2.setActivateToolWindowWhenAdded(this.myActivateToolWindow);
        descriptor2.setAutoFocusContent(this.myFocusToolWindow);
        Disposer.register((Disposable)descriptor2, (Disposable)this);
        Disposer.register((Disposable)descriptor2, (Disposable)console2);
        actions2.add((AnAction)new RerunAction(consolePanel));
        actions2.add((AnAction)new StopAction());
        actions2.add((AnAction)new CloseAction(executor, descriptor2, this.myProject));
        RunContentManager.getInstance((Project)this.myProject).showRunContent(executor, descriptor2);
        return console2;
    }

    public void run() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ConsoleView view = this.myUserProvidedConsole != null ? this.myUserProvidedConsole : this.createConsole();
        view.attachToProcess(this.myProcess);
        if (this.myAfterCompletion != null) {
            this.myProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(RunContentExecutor.this.myAfterCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/RunContentExecutor$1", "processTerminated"));
                }
            });
        }
        this.myProcess.startNotify();
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions2) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)view.getComponent(), "Center");
        panel2.add((Component)RunContentExecutor.createToolbar(actions2), "West");
        return panel2;
    }

    private static JComponent createToolbar(ActionGroup actions2) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RunContentExecutor", actions2, false);
        return actionToolbar.getComponent();
    }

    public void dispose() {
    }

    @NotNull
    public RunContentExecutor withConsole(@Nullable ConsoleView console2) {
        this.myUserProvidedConsole = console2;
        RunContentExecutor runContentExecutor = this;
        if (runContentExecutor == null) {
            RunContentExecutor.$$$reportNull$$$0(4);
        }
        return runContentExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopEnabled";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/RunContentExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/RunContentExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withStop";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StopAction
    extends AnAction
    implements DumbAware {
        StopAction() {
            super(ExecutionBundle.messagePointer((String)"action.AnAction.text.stop", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"action.AnAction.description.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(0);
            }
            RunContentExecutor.this.myStopAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(RunContentExecutor.this.myStopAction != null);
            e.getPresentation().setEnabled(RunContentExecutor.this.myStopEnabled != null && (Boolean)RunContentExecutor.this.myStopEnabled.compute() != false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/RunContentExecutor$StopAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RerunAction
    extends AnAction {
        RerunAction(JComponent consolePanel) {
            super(CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), AllIcons.Actions.Restart);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consolePanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            RunContentExecutor.this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(RunContentExecutor.this.myRerunAction != null);
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/RunContentExecutor$RerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

