/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.impl.RunConfigurationInArbitraryFileScanner;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.indexing.roots.kind.ProjectFileOrDirOrigin;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/impl/RunConfigurationInArbitraryFileScanner;", "Lcom/intellij/util/indexing/roots/IndexableFileScanner;", "()V", "startSession", "Lcom/intellij/util/indexing/roots/IndexableFileScanner$ScanSession;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.execution.impl"})
public final class RunConfigurationInArbitraryFileScanner
implements IndexableFileScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public IndexableFileScanner.ScanSession startSession(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(project);
        return new IndexableFileScanner.ScanSession(runManagerImpl){
            final /* synthetic */ RunManagerImpl $runManagerImpl;

            @Nullable
            public final IndexableFileScanner.IndexableFileVisitor createVisitor(@NotNull IndexableSetOrigin it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof ModuleRootOrigin || it instanceof ProjectFileOrDirOrigin ? (IndexableFileScanner.IndexableFileVisitor)new IndexableFileScanner.IndexableFileVisitor(this){
                    final /* synthetic */ startSession.1 this$0;

                    public final void visitFile(@NotNull VirtualFile fileOrDir) {
                        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                        if (RunConfigurationInArbitraryFileScanner.Companion.isFileWithRunConfigs(fileOrDir)) {
                            this.this$0.$runManagerImpl.updateRunConfigsFromArbitraryFiles$intellij_platform_execution_impl(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)fileOrDir.getPath()));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                } : null;
            }
            {
                this.$runManagerImpl = runManagerImpl;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/impl/RunConfigurationInArbitraryFileScanner$Companion;", "", "()V", "isFileWithRunConfigs", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "intellij.platform.execution.impl"})
    public static final class Companion {
        public final boolean isFileWithRunConfigs(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (!file2.isInLocalFileSystem() || !StringUtil.endsWith((CharSequence)file2.getNameSequence(), (CharSequence)".run.xml")) {
                return false;
            }
            for (VirtualFile parent = file2.getParent(); parent != null; parent = parent.getParent()) {
                if (!StringUtil.equals((CharSequence)parent.getNameSequence(), (CharSequence)".idea")) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFileWithRunConfigs(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (StringsKt.contains$default((CharSequence)path2, (CharSequence)"/.idea/", (boolean)false, (int)2, null)) return false;
            String string = PathUtil.getFileName((String)path2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(path)");
            if (!StringsKt.endsWith$default((String)string, (String)".run.xml", (boolean)false, (int)2, null)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

